/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.collections.IConverter;
import kd.bos.olapServer.collections.ILongConverter;
import kd.bos.olapServer.common.NotSupportedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00022\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u00052\b\u0012\u0004\u0012\u00020\b0\t:\u0001\u001eB\u0015\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\bH\u0002J\u0019\u0010\u0019\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u00060\u0006j\u0002`\u0007H\u0016R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/LongConverter;", "T", "", "", "Lkd/bos/olapServer/common/int;", "Lkd/bos/olapServer/collections/IConverter;", "", "Lkd/bos/olapServer/common/long;", "", "Lkd/bos/olapServer/collections/ILongConverter;", "dimensionInfo", "", "([Ljava/util/Collection;)V", "_fixedMembers", "_mappings", "Lkd/bos/olapServer/memoryMappedFiles/LongConverter$MemberMap;", "[Lkd/bos/olapServer/memoryMappedFiles/LongConverter$MemberMap;", "max", "getMax", "()J", "maxValue", "Ljava/math/BigInteger;", "getMaxValue", "()Ljava/math/BigInteger;", "createDimensionKeys", "toX", "y", "([I)Ljava/lang/Long;", "toY", "x", "MemberMap", "bos-olap-core"})
public final class LongConverter<T extends Collection<? extends Integer>>
implements IConverter<Long, int[]>,
ILongConverter<int[]> {
    @NotNull
    private final int[] _fixedMembers;
    @NotNull
    private final MemberMap[] _mappings;

    public LongConverter(@NotNull T[] dimensionInfo) {
        Intrinsics.checkNotNullParameter(dimensionInfo, (String)"dimensionInfo");
        this._fixedMembers = new int[dimensionInfo.length];
        boolean bl = false;
        List list = new ArrayList();
        T[] TArray = dimensionInfo;
        int n = TArray.length;
        block4: for (int i = 0; i < n; ++i) {
            int i2 = i;
            T dim = TArray[i];
            int n2 = dim.size();
            switch (n2) {
                case 0: {
                    throw new NotSupportedException();
                }
                case 1: {
                    this._fixedMembers[i2] = ((Number)CollectionsKt.first((Iterable)((Iterable)dim))).intValue();
                    continue block4;
                }
            }
            list.add(new MemberMap(i2, (Collection<Integer>)dim));
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MemberMap[] memberMapArray = thisCollection$iv.toArray(new MemberMap[0]);
        if (memberMapArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this._mappings = memberMapArray;
        long carry = 1L;
        MemberMap[] memberMapArray2 = this._mappings;
        int n3 = 0;
        int n4 = memberMapArray2.length;
        while (n3 < n4) {
            MemberMap mapping = memberMapArray2[n3];
            ++n3;
            mapping.setCarry(carry);
            carry *= (long)mapping.getMaxValue();
        }
    }

    @NotNull
    public final BigInteger getMaxValue() {
        BigInteger carry = BigInteger.ONE;
        for (MemberMap mapping : this._mappings) {
            BigInteger bigInteger = carry;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"carry");
            BigInteger bigInteger2 = BigInteger.valueOf(mapping.getMaxValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(mapping.maxValue.toLong())");
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger.multiply(bigInteger2), (String)"this.multiply(other)");
        }
        BigInteger bigInteger = carry;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"carry");
        return bigInteger;
    }

    private final int[] createDimensionKeys() {
        int[] nArray = this._fixedMembers;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return nArray2;
    }

    @Override
    public long getMax() {
        return this.getMaxValue().longValueExact();
    }

    @Override
    @NotNull
    public Long toX(@NotNull int[] y) {
        MemberMap[] m;
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        long result = 0L;
        MemberMap[] memberMapArray = m = this._mappings;
        int n = 0;
        MemberMap[] memberMapArray2 = memberMapArray;
        boolean bl = false;
        if (!(memberMapArray2.length == 0)) {
            MemberMap mapping = m[0];
            result = y[mapping.getDimensionPosition()];
            n = 1;
            int n2 = m.length;
            if (n < n2) {
                do {
                    int i = n++;
                    mapping = m[i];
                    long value2 = y[mapping.getDimensionPosition()];
                    result += mapping.getCarry() * value2;
                } while (n < n2);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public int[] toY(long x) {
        MemberMap[] m;
        long pre = 0L;
        long carry = 0L;
        int[] data = this.createDimensionKeys();
        MemberMap[] memberMapArray = m = this._mappings;
        boolean bl = false;
        MemberMap[] memberMapArray2 = memberMapArray;
        boolean bl2 = false;
        if (!(memberMapArray2.length == 0)) {
            MemberMap mapping = m[m.length - 1];
            int value2 = 0;
            pre = mapping.getCarry();
            data[mapping.getDimensionPosition()] = value2 = (int)(x / pre);
            int n = m.length - 2;
            if (0 <= n) {
                do {
                    int i = n--;
                    mapping = m[i];
                    carry = mapping.getCarry();
                    data[mapping.getDimensionPosition()] = value2 = (int)(x % pre / carry);
                    pre = carry;
                } while (0 <= n);
            }
        }
        return data;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/LongConverter$MemberMap;", "", "dimensionPosition", "", "Lkd/bos/olapServer/common/int;", "members", "", "(ILjava/util/Collection;)V", "carry", "", "getCarry", "()J", "setCarry", "(J)V", "getDimensionPosition", "()I", "maxValue", "getMaxValue", "toString", "", "bos-olap-core"})
    private static final class MemberMap {
        private final int dimensionPosition;
        private final int maxValue;
        private long carry;

        public MemberMap(int dimensionPosition, @NotNull Collection<Integer> members2) {
            Intrinsics.checkNotNullParameter(members2, (String)"members");
            this.dimensionPosition = dimensionPosition;
            this.carry = 1L;
            Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)members2);
            int max = n == null ? 0 : n;
            this.maxValue = max + 1;
        }

        public final int getDimensionPosition() {
            return this.dimensionPosition;
        }

        public final int getMaxValue() {
            return this.maxValue;
        }

        public final long getCarry() {
            return this.carry;
        }

        public final void setCarry(long l) {
            this.carry = l;
        }

        @NotNull
        public String toString() {
            return "{pos:" + this.dimensionPosition + ", max:" + this.maxValue;
        }
    }
}

