/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles;

import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IMutableListInt;
import kd.bos.olapServer.dataEntities.DynamicSizeRange;
import kd.bos.olapServer.memoryMappedFiles.DynamicIntMetadata;
import kd.bos.olapServer.memoryMappedFiles.ImmutableListDynamicInt;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.runLengthEncodingV2.RunLengthMutableListInt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00060\nj\u0002`\r2\n\u0010\u000e\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u00112\n\u0010\u000e\u001a\u00060\nj\u0002`\u000bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/MutableListDynamicInt;", "Lkd/bos/olapServer/memoryMappedFiles/ImmutableListDynamicInt;", "Lkd/bos/olapServer/collections/IMutableListInt;", "Lkd/bos/olapServer/collections/IDataContainer;", "metadata", "Lkd/bos/olapServer/memoryMappedFiles/DynamicIntMetadata;", "(Lkd/bos/olapServer/memoryMappedFiles/DynamicIntMetadata;)V", "_lastRange", "Lkd/bos/olapServer/dataEntities/DynamicSizeRange;", "_maxValue", "", "Lkd/bos/olapServer/common/int;", "add", "Lkd/bos/olapServer/common/idx;", "value", "clone", "close", "", "force", "resize", "resizeBytes", "bos-olap-core"})
public class MutableListDynamicInt
extends ImmutableListDynamicInt
implements IMutableListInt,
IDataContainer {
    @NotNull
    private DynamicSizeRange _lastRange;
    private int _maxValue;

    public MutableListDynamicInt(@NotNull DynamicIntMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(metadata);
        if (this.get_count() == 0) {
            this._maxValue = -1;
            this._lastRange = new DynamicSizeRange(0, 1, 99, 0L);
        } else {
            int n;
            this._lastRange = this.getRanges().get(this.getRanges().getCount() - 1);
            int n2 = this._lastRange.getElementByteSize();
            switch (n2) {
                case 1: {
                    n = 256;
                    break;
                }
                case 2: {
                    n = 65536;
                    break;
                }
                case 3: {
                    n = 0x1000000;
                    break;
                }
                case 4: {
                    n = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    String string = Res.INSTANCE.getCommonException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_4");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
            }
            this._maxValue = n;
        }
    }

    @Override
    public int add(int value2) {
        IByteBuffer buffer;
        boolean bl = value2 >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (value2 >= this._maxValue) {
            this.resizeBytes(value2);
        }
        int index2 = this.get_count();
        byte[] bytes = this.get_bytes();
        long pos = this._lastRange.getElementPosition(index2);
        if (pos + (long)4 > (buffer = this.get_buffer()).getCapacity()) {
            this.resize();
            buffer = this.get_buffer();
        }
        int n = this._lastRange.getElementByteSize();
        switch (n) {
            case 1: {
                buffer.putByte(pos, (byte)value2);
                break;
            }
            case 2: {
                buffer.putShort(pos, Bits.INSTANCE.reverseBytes((short)value2));
                break;
            }
            case 3: {
                bytes[0] = (byte)value2;
                bytes[1] = (byte)(value2 >> 8);
                bytes[2] = (byte)(value2 >> 16);
                buffer.putByteArray(pos, bytes, 0, 3);
                break;
            }
            case 4: {
                bytes[0] = (byte)value2;
                bytes[1] = (byte)(value2 >> 8);
                bytes[2] = (byte)(value2 >> 16);
                bytes[3] = (byte)(value2 >> 24);
                buffer.putInt(pos, Integer.reverseBytes(value2));
                break;
            }
            default: {
                String string = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_4");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
        this.set_count(index2 + 1);
        return index2;
    }

    private final void resize() {
        long oneSegmentMaxBytes;
        long minCapacity;
        long capacity = this.get_buffer().getCapacity();
        if (capacity < (minCapacity = capacity + (oneSegmentMaxBytes = 262144L))) {
            long newSize = RunLengthMutableListInt.Companion.getNextCapacity(minCapacity);
            this.set_buffer(this.getMetadata().resize(newSize));
        }
    }

    private final void resizeBytes(int value2) {
        int n;
        int n2 = value2;
        boolean bl = 0 <= n2 ? n2 < 256 : false;
        if (bl) {
            n = 1;
        } else {
            boolean bl2 = 256 <= n2 ? n2 < 65536 : false;
            if (bl2) {
                n = 2;
            } else {
                boolean bl3 = 65536 <= n2 ? n2 < 0x1000000 : false;
                if (bl3) {
                    n = 3;
                } else {
                    boolean bl4 = 0x1000000 <= n2 ? n2 <= Integer.MAX_VALUE : false;
                    if (bl4) {
                        n = 4;
                    } else {
                        Object[] objectArray = Res.INSTANCE.getCommonException_5();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_5");
                        Object[] objectArray2 = objectArray;
                        objectArray = new Object[]{value2};
                        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                    }
                }
            }
        }
        int elementSize = n;
        if (elementSize == this._lastRange.getElementByteSize()) {
            return;
        }
        this.getRanges().add(this.get_count(), elementSize);
        this._lastRange = this.getRanges().get(this.getRanges().getCount() - 1);
        n2 = this._lastRange.getElementByteSize();
        switch (n2) {
            case 1: {
                this._maxValue = 256;
                break;
            }
            case 2: {
                this._maxValue = 65536;
                this.getMetadata().setTwoByteStart(this.get_count());
                break;
            }
            case 3: {
                this._maxValue = 0x1000000;
                this.getMetadata().setThreeByteStart(this.get_count());
                break;
            }
            case 4: {
                this._maxValue = Integer.MAX_VALUE;
                this.getMetadata().setFourByteStart(this.get_count());
                break;
            }
            default: {
                String string = Res.INSTANCE.getCommonException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CommonException_4");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
    }

    @Override
    public void force() {
        this.getMetadata().setCount(this.get_count());
        this.getMetadata().force();
    }

    @Override
    public void close() {
        this.getMetadata().close();
    }

    @Override
    @NotNull
    public MutableListDynamicInt clone() {
        return new MutableListDynamicInt(this.getMetadata());
    }
}

