/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles;

import java.util.Arrays;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.dataEntities.DimensionKeysBase;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.ZipIntArraySerializerBuilder;
import kd.bos.olapServer.dataEntities.ZipIntSerializer;
import kd.bos.olapServer.memoryMappedFiles.AbstractMutableList;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.metadata.Cube;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004:\u0002&'B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB#\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0014\u0010 \u001a\u00020\u00022\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u001eH\u0014J\u001c\u0010!\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0002H\u0002J\u0014\u0010#\u001a\u00020\u00132\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u001eH\u0002J\u001c\u0010$\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u001e2\u0006\u0010%\u001a\u00020\u0013H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lkd/bos/olapServer/memoryMappedFiles/ZipIntDimensionKeysList;", "Lkd/bos/olapServer/memoryMappedFiles/AbstractMutableList;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer/collections/IMutableList;", "Lkd/bos/olapServer/collections/IDataContainer;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "metadata", "Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "(Lkd/bos/olapServer/metadata/Cube;Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;)V", "_cube", "_serializers", "", "Lkd/bos/olapServer/dataEntities/ZipIntSerializer;", "(Lkd/bos/olapServer/metadata/Cube;[Lkd/bos/olapServer/dataEntities/ZipIntSerializer;Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;)V", "_defaultKeys", "Lkd/bos/olapServer/memoryMappedFiles/ZipIntDimensionKeysList$SimpleDimensionKeys;", "[Lkd/bos/olapServer/dataEntities/ZipIntSerializer;", "_zipData", "", "_zipIntArraySize", "", "Lkd/bos/olapServer/common/int;", "entryBytes", "", "getEntryBytes", "()J", "AddValue", "", "pos", "Lkd/bos/olapServer/common/long;", "value", "ReadValue", "UpdateValue", "getZipData", "readZipData", "updateZipData", "data", "Companion", "SimpleDimensionKeys", "bos-olap-core"})
public final class ZipIntDimensionKeysList
extends AbstractMutableList<IDimensionKeys>
implements IMutableList<IDimensionKeys>,
IDataContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZipIntSerializer[] _serializers;
    private final int _zipIntArraySize;
    @NotNull
    private final int[] _zipData;
    @NotNull
    private final SimpleDimensionKeys _defaultKeys;

    public ZipIntDimensionKeysList(@NotNull Cube _cube, @NotNull ZipIntSerializer[] _serializers, @NotNull ListMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)_cube, (String)"_cube");
        Intrinsics.checkNotNullParameter((Object)_serializers, (String)"_serializers");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(metadata);
        this._serializers = _serializers;
        this._zipIntArraySize = ZipIntArraySerializerBuilder.Companion.getZipIntArraySize(this._serializers);
        this._zipData = new int[this._zipIntArraySize];
        this._defaultKeys = new SimpleDimensionKeys(_cube, this._zipData, this._serializers);
    }

    public ZipIntDimensionKeysList(@NotNull Cube cube, @NotNull ListMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this(cube, ZipIntArraySerializerBuilder.Companion.createSerializer(cube), metadata);
    }

    @Override
    protected long getEntryBytes() {
        return (long)this._zipIntArraySize * 4L;
    }

    @Override
    protected void AddValue(long pos, @NotNull IDimensionKeys value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.updateZipData(pos, this.getZipData(value2));
    }

    private final int[] getZipData(IDimensionKeys value2) {
        int[] result = this._zipData;
        Arrays.fill(result, 0);
        ZipIntSerializer[] serializers = this._serializers;
        int n = 0;
        int n2 = serializers.length;
        if (n < n2) {
            do {
                int i = n++;
                ZipIntSerializer serializer = serializers[i];
                serializer.encode(result, value2.get(i));
            } while (n < n2);
        }
        return result;
    }

    private final void updateZipData(long pos, int[] data) {
        IByteBuffer writer = this.getBuffer();
        int n = data.length;
        switch (n) {
            case 1: {
                writer.putInt(pos, data[0]);
                break;
            }
            case 2: {
                writer.putLong(pos, ZipIntDimensionKeysList.Companion.combineInt2Long(data[0], data[1]));
                break;
            }
            case 3: {
                writer.putLong(pos, ZipIntDimensionKeysList.Companion.combineInt2Long(data[0], data[1]));
                writer.putInt(pos + (long)8, data[2]);
                break;
            }
            case 4: {
                writer.putLong(pos, ZipIntDimensionKeysList.Companion.combineInt2Long(data[0], data[1]));
                writer.putLong(pos + (long)8, ZipIntDimensionKeysList.Companion.combineInt2Long(data[2], data[3]));
                break;
            }
            default: {
                int n2 = 0;
                int n3 = data.length;
                if (n2 >= n3) break;
                do {
                    int i = n2++;
                    writer.putInt(pos + (long)(i * 4), data[i]);
                } while (n2 < n3);
            }
        }
    }

    @Override
    @NotNull
    protected IDimensionKeys ReadValue(long pos) {
        this.readZipData(pos);
        return this._defaultKeys;
    }

    private final int[] readZipData(long pos) {
        int[] data = this._zipData;
        Arrays.fill(data, 0);
        IByteBuffer reader = this.getBuffer();
        int n = data.length;
        switch (n) {
            case 1: {
                data[0] = reader.getInt(pos);
                break;
            }
            case 2: {
                long temp = reader.getLong(pos);
                data[0] = (int)(temp >> 32);
                data[1] = (int)temp;
                break;
            }
            case 3: {
                long temp = reader.getLong(pos);
                data[0] = (int)(temp >> 32);
                data[1] = (int)temp;
                data[2] = reader.getInt(pos + (long)8);
                break;
            }
            case 4: {
                long temp = reader.getLong(pos);
                data[0] = (int)(temp >> 32);
                data[1] = (int)temp;
                temp = reader.getLong(pos + (long)8);
                data[2] = (int)(temp >> 32);
                data[3] = (int)temp;
                break;
            }
            default: {
                int n2 = 0;
                int n3 = data.length;
                if (n2 >= n3) break;
                do {
                    int i = n2++;
                    data[i] = reader.getInt(pos + (long)(i * 4));
                } while (n2 < n3);
            }
        }
        return data;
    }

    @Override
    protected void UpdateValue(long pos, @NotNull IDimensionKeys value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.AddValue(pos, value2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u000b\u001a\u00060\fj\u0002`\r2\n\u0010\u000e\u001a\u00060\fj\u0002`\rH\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/ZipIntDimensionKeysList$SimpleDimensionKeys;", "Lkd/bos/olapServer/dataEntities/DimensionKeysBase;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "data", "", "serializers", "", "Lkd/bos/olapServer/dataEntities/ZipIntSerializer;", "(Lkd/bos/olapServer/metadata/Cube;[I[Lkd/bos/olapServer/dataEntities/ZipIntSerializer;)V", "[Lkd/bos/olapServer/dataEntities/ZipIntSerializer;", "get", "", "Lkd/bos/olapServer/common/int;", "dimensionIndex", "bos-olap-core"})
    private static final class SimpleDimensionKeys
    extends DimensionKeysBase {
        @NotNull
        private final int[] data;
        @NotNull
        private final ZipIntSerializer[] serializers;

        public SimpleDimensionKeys(@NotNull Cube cube, @NotNull int[] data, @NotNull ZipIntSerializer[] serializers) {
            Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            super(cube);
            this.data = data;
            this.serializers = serializers;
        }

        @Override
        public int get(int dimensionIndex) {
            return this.serializers[dimensionIndex].decode(this.data);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007H\u0002\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/ZipIntDimensionKeysList$Companion;", "", "()V", "combineInt2Long", "", "high", "", "Lkd/bos/olapServer/common/int;", "low", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final long combineInt2Long(int high, int low) {
            return (long)low & 0xFFFFFFFFL | (long)high << 32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

