/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.lang.reflect.Field;
import java.nio.ReadOnlyBufferException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.MappedDatabase;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b \u0018\u0000 52\u00020\u0001:\u00015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bJ,\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001c\u001a\u00060\u0005j\u0002`\u0006H\u0002J$\u0010\u001d\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001e\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001f\u001a\u00060\u0005j\u0002`\u0006H\u0004J\u0006\u0010 \u001a\u00020\u0019J\u001e\u0010 \u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001c\u001a\u00060\u0005j\u0002`\u0006J\u0006\u0010\"\u001a\u00020\u0019J\u001c\u0010#\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020%H\u0016J4\u0010#\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020%2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\n\u0010&\u001a\u00060\u0005j\u0002`\u0006H\u0016J*\u0010'\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001c\u001a\u00060\u0005j\u0002`\u00062\n\u0010$\u001a\u00060(j\u0002`)J\b\u0010*\u001a\u00020\u0019H\u0016J\u001a\u0010+\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020,J2\u0010+\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020,2\n\u0010\u0004\u001a\u00060-j\u0002`.2\n\u0010&\u001a\u00060-j\u0002`.J\u0014\u0010/\u001a\u00020\u00052\n\u0010\u001e\u001a\u00060\u0005j\u0002`\u0006H\u0004J\u001c\u00100\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020,H\u0016J4\u00100\u001a\u00020\u00192\n\u0010!\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010$\u001a\u00020,2\n\u0010\u0004\u001a\u00060-j\u0002`.2\n\u0010&\u001a\u00060-j\u0002`.H\u0016J\b\u00101\u001a\u000202H\u0016J\r\u00103\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b4R\u0014\u0010\t\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0005j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer;", "", "db", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "offset", "", "Lkd/bos/olapServer/common/long;", "capacity", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedDatabase;JJ)V", "address", "getAddress", "()J", "getCapacity", "getDb", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "isClosed", "", "limit", "getLimit", "getOffset", "unsafe", "Lsun/misc/Unsafe;", "getUnsafe", "()Lsun/misc/Unsafe;", "checkBounds", "", "off", "len", "size", "checkIndex", "i", "nb", "clearData", "position", "close", "copy", "value", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "length", "fill", "", "Lkd/bos/olapServer/common/byte;", "force", "getByteArray", "", "", "Lkd/bos/olapServer/common/int;", "ix", "putByteArray", "toString", "", "updateDatabase", "updateDatabase$bos_olap_core", "Companion", "bos-olap-core"})
public abstract class AbstractByteBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MappedDatabase db;
    private final long offset;
    private final long capacity;
    private final long address;
    @NotNull
    private final Unsafe unsafe;
    private final long limit;
    private boolean isClosed;
    @NotNull
    private static final Field addressField;
    @NotNull
    private static final Field limitField;

    public AbstractByteBuffer(@NotNull MappedDatabase db, long offset, long capacity) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
        this.offset = offset;
        this.capacity = capacity;
        if (this.offset < 0L || this.capacity < 0L || this.db.getCapacity() < this.offset + this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.db.register(this);
        this.address = this.db.getAddress() + this.offset;
        this.unsafe = Bits.INSTANCE.getUnsafe();
        this.limit = this.capacity;
    }

    @NotNull
    public final MappedDatabase getDb() {
        return this.db;
    }

    protected final long getOffset() {
        return this.offset;
    }

    public final long getCapacity() {
        return this.capacity;
    }

    protected final long getAddress() {
        return this.address;
    }

    @NotNull
    protected final Unsafe getUnsafe() {
        return this.unsafe;
    }

    public final void updateDatabase$bos_olap_core() {
        AbstractByteBuffer.Companion.setAddress(this, this.db.getAddress() + this.offset);
    }

    protected final long getLimit() {
        return this.limit;
    }

    protected final long checkIndex(long i, long nb) {
        if (i < 0L || nb > this.limit - i) {
            if (this.isClosed) {
                String string = Res.INSTANCE.getAbstractByteBufferException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.AbstractByteBufferException_3");
                throw Res.INSTANCE.getIndexOutOfBoundsException(string, new Object[0]);
            }
            Object[] objectArray = Res.INSTANCE.getAbstractByteBufferException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractByteBufferException_2");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{i, nb, this.limit, this.capacity};
            throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
        }
        return i;
    }

    protected final long ix(long i) {
        return this.address + i;
    }

    private final void checkBounds(long off, long len, long size) {
        if ((off | len | off + len | size - (off + len)) < 0L) {
            Object[] objectArray = Res.INSTANCE.getAbstractByteBufferException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractByteBufferException_2");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{off, len, size, size};
            throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
        }
    }

    public final void getByteArray(long position, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getByteArray(position, value2, 0, value2.length);
    }

    public final void getByteArray(long position, @NotNull byte[] value2, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkIndex(position, length);
        if (length == 0) {
            return;
        }
        this.checkBounds(offset, length, value2.length);
        if (length > 6) {
            long copySize = 0L;
            long srcStart = position;
            long dstStart = (long)Bits.INSTANCE.getBYTE_ARRAY_OFFSET() + (long)offset;
            for (long copyLength = (long)length; copyLength > 0L; copyLength -= copySize) {
                copySize = copyLength > 0x100000L ? 0x100000L : copyLength;
                this.unsafe.copyMemory(null, this.ix(srcStart), value2, dstStart, copySize);
                srcStart += copySize;
                dstStart += copySize;
            }
        } else {
            long realPosition = this.address + position;
            int n = offset;
            int n2 = offset + length;
            if (n < n2) {
                do {
                    int i = n++;
                    long l = realPosition;
                    realPosition = l + 1L;
                    value2[i] = this.unsafe.getByte(l);
                } while (n < n2);
            }
        }
    }

    public void putByteArray(long position, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.putByteArray(position, value2, 0, value2.length);
    }

    public void putByteArray(long position, @NotNull byte[] value2, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkIndex(position, length);
        if (length == 0) {
            return;
        }
        this.checkBounds(offset, length, value2.length);
        if (length > 6) {
            long copySize = 0L;
            long srcStart = (long)Bits.INSTANCE.getBYTE_ARRAY_OFFSET() + (long)offset;
            long dstStart = position;
            for (long copyLength = (long)length; copyLength > 0L; copyLength -= copySize) {
                copySize = copyLength > 0x100000L ? 0x100000L : copyLength;
                this.unsafe.copyMemory(value2, srcStart, null, this.ix(dstStart), copySize);
                srcStart += copySize;
                dstStart += copySize;
            }
        } else {
            long realPosition = this.address + position;
            int n = offset;
            int n2 = offset + length;
            if (n < n2) {
                do {
                    int i = n++;
                    long l = realPosition;
                    realPosition = l + 1L;
                    this.unsafe.putByte(l, value2[i]);
                } while (n < n2);
            }
        }
    }

    public void copy(long position, @NotNull IByteBuffer value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.copy(position, value2, 0L, value2.getCapacity());
    }

    public void copy(long position, @NotNull IByteBuffer value2, long offset, long length) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        boolean bl = value2 instanceof AbstractByteBuffer;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.checkIndex(position, length);
        if (length == 0L) {
            return;
        }
        this.checkBounds(offset, length, value2.getCapacity());
        this.unsafe.copyMemory(((AbstractByteBuffer)((Object)value2)).ix(offset), this.ix(position), length);
    }

    public void force() {
        this.db.force();
    }

    public final void close() {
        if (!this.isClosed) {
            this.db.unRegister(this);
            AbstractByteBuffer.Companion.clearLimit(this);
            this.isClosed = true;
        }
    }

    public final void clearData() {
        this.fill(0L, this.capacity, (byte)0);
    }

    public final void clearData(long position, long size) {
        this.fill(position, size, (byte)0);
    }

    public final void fill(long position, long size, byte value2) {
        if (this.db.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(position, size);
        this.unsafe.setMemory(this.address + position, size, value2);
    }

    @NotNull
    public String toString() {
        return "offset: " + this.offset + ", capacity: " + this.capacity;
    }

    static {
        Field field = AbstractByteBuffer.class.getDeclaredField("address");
        boolean bl = false;
        boolean bl2 = false;
        Field $this$addressField_u24lambda_u2d0 = field;
        boolean bl3 = false;
        $this$addressField_u24lambda_u2d0.setAccessible(true);
        Field field2 = field;
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"AbstractByteBuffer::class.java.getDeclaredField(\"address\").apply {\n            isAccessible = true\n        }");
        addressField = field2;
        field = AbstractByteBuffer.class.getDeclaredField("limit");
        bl = false;
        bl2 = false;
        Field $this$limitField_u24lambda_u2d1 = field;
        boolean bl4 = false;
        $this$limitField_u24lambda_u2d1.setAccessible(true);
        field2 = field;
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"AbstractByteBuffer::class.java.getDeclaredField(\"limit\").apply {\n            isAccessible = true\n        }");
        limitField = field2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer$Companion;", "", "()V", "addressField", "Ljava/lang/reflect/Field;", "limitField", "clearLimit", "", "obj", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer;", "setAddress", "value", "", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void setAddress(AbstractByteBuffer obj, long value2) {
            addressField.setLong(obj, value2);
        }

        private final void clearLimit(AbstractByteBuffer obj) {
            limitField.setLong(obj, 0L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

