/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.io.Closeable;
import java.io.File;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.FileInfo;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBufferResource;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.MappedFile;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0016\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tB\u0019\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060\u0011j\u0002`\u00122\n\u0010 \u001a\u00060\u0011j\u0002`\u0012H\u0002J\n\u0010!\u001a\u00060\u0007j\u0002`\bJ\b\u0010\"\u001a\u00020\u001cH\u0016J \u0010#\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060\u0011j\u0002`\u00122\n\u0010$\u001a\u00060\u0011j\u0002`\u0012H\u0016JH\u0010%\u001a\u00020\u001e2\n\u0010&\u001a\u00060\u0011j\u0002`\u00122\n\u0010'\u001a\u00060\u0004j\u0002`\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001c0)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001c0)H\u0016J\b\u0010+\u001a\u00020\u0016H\u0002J\u001c\u0010,\u001a\u00020\u001c2\b\u0010-\u001a\u0004\u0018\u00010\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010/\u001a\u00020\u0004H\u0016R\u0018\u0010\r\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResource;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBufferResource;", "Ljava/io/Closeable;", "fileName", "", "Lkd/bos/olapServer/common/string;", "isReadonly", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Z)V", "fileInfo", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/FileInfo;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/FileInfo;Z)V", "IsReadonly", "getIsReadonly", "()Z", "Length", "", "Lkd/bos/olapServer/common/long;", "getLength", "()J", "_mappedFile", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "close", "", "createCore", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "position", "size", "exists", "force", "mapContentBuffer", "minSize", "open", "headSize", "fileType", "initAction", "Lkotlin/Function1;", "checkAction", "openFile", "releaseBuffer", "fileHeadBuffer", "contentBuffer", "toString", "bos-olap-core"})
public final class ByteBufferResource
implements IByteBufferResource,
Closeable {
    @NotNull
    private final FileInfo fileInfo;
    private final boolean isReadonly;
    @NotNull
    private final File file;
    @Nullable
    private MappedFile _mappedFile;

    public ByteBufferResource(@NotNull FileInfo fileInfo, boolean isReadonly) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        this.fileInfo = fileInfo;
        this.isReadonly = isReadonly;
        this.file = this.fileInfo.getFile();
    }

    public ByteBufferResource(@NotNull String fileName, boolean isReadonly) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this(new FileInfo(new File(fileName)), isReadonly);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean exists() {
        return this.fileInfo.exists();
    }

    @Override
    public boolean getIsReadonly() {
        return this.isReadonly;
    }

    @Override
    public long getLength() {
        return this.fileInfo.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MappedFile openFile() {
        MappedFile mappedFile;
        MappedFile mappedFile2 = this._mappedFile;
        if (mappedFile2 != null) {
            return mappedFile2;
        }
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            MappedFile mappedFile22 = this._mappedFile;
            if (mappedFile22 == null) {
                boolean readonly = this.fileInfo.isInited() && this.isReadonly;
                String string = this.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                this._mappedFile = mappedFile22 = new MappedFile(string, readonly);
            }
            mappedFile = mappedFile22;
        }
        return mappedFile;
    }

    @Override
    @NotNull
    public IByteBuffer open(long headSize, @NotNull String fileType, @NotNull Function1<? super IByteBuffer, Unit> initAction, @NotNull Function1<? super IByteBuffer, Unit> checkAction) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(initAction, (String)"initAction");
        Intrinsics.checkNotNullParameter(checkAction, (String)"checkAction");
        IByteBuffer buffer = this.createCore(0L, headSize);
        try {
            if (!this.fileInfo.isInited()) {
                this.fileInfo.init(initAction, buffer);
            } else {
                if (this.getLength() < headSize) {
                    Object[] objectArray = Res.INSTANCE.getAbstractMetadataException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.AbstractMetadataException_1");
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{fileType};
                    throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
                }
                checkAction.invoke((Object)buffer);
            }
        }
        catch (Exception ex) {
            buffer.close();
            throw ex;
        }
        return buffer;
    }

    @Override
    @NotNull
    public IByteBuffer mapContentBuffer(long position, long minSize) {
        return this.createCore(position, minSize);
    }

    private final IByteBuffer createCore(long position, long size) {
        boolean bl = position >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = size >= 0L;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        MappedFile mappedFile = this.openFile();
        long oldCapacity = mappedFile.getMaxMappedCapacity();
        IByteBuffer result = IMappedResource.DefaultImpls.map$default(mappedFile, position, size, null, 4, null);
        if (!this.isReadonly && oldCapacity != mappedFile.getMaxMappedCapacity()) {
            this.fileInfo.clearLengthCache();
        }
        return result;
    }

    @Override
    public void releaseBuffer(@Nullable IByteBuffer fileHeadBuffer, @Nullable IByteBuffer contentBuffer) {
        IByteBuffer iByteBuffer = fileHeadBuffer;
        if (iByteBuffer != null) {
            iByteBuffer.close();
        }
        iByteBuffer = contentBuffer;
        if (iByteBuffer != null) {
            iByteBuffer.close();
        }
    }

    @Override
    public void close() {
        MappedFile mappedFile = this._mappedFile;
        if (mappedFile != null) {
            mappedFile.close();
        }
        this._mappedFile = null;
    }

    @Override
    public void force() {
        if (this.isReadonly) {
            throw new NotSupportedException();
        }
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"ByteBufferResource : ", (Object)this.file);
    }
}

