/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer.collections.LockFreeStack;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.MappedMemory;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.ResourceCacheItem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u00020\u000b2\n\u0010\u001a\u001a\u00060\bj\u0002`\tJ\u0010\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\n\u0010\u001a\u001a\u00060\bj\u0002`\tH\u0002J\u0014\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R$\u0010\u0006\u001a\u0018\u0012\b\u0012\u00060\bj\u0002`\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool;", "", "tempFolder", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "_cachedResourcesMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer/common/long;", "Lkd/bos/olapServer/collections/LockFreeStack;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ResourceCacheItem;", "_garbageCollecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cachedCount", "", "getCachedCount", "()I", "getTempFolder", "()Ljava/lang/String;", "close", "", "create", "gc", "gcCore", "getOrCreate", "headSize", "release", "item", "tryGet", "tryRelease", "", "Lkd/bos/olapServer/common/bool;", "Companion", "bos-olap-core"})
public final class ByteBufferResourcePool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tempFolder;
    @NotNull
    private final ConcurrentHashMap<Long, LockFreeStack<ResourceCacheItem>> _cachedResourcesMap;
    @NotNull
    private final AtomicBoolean _garbageCollecting;
    private static final int OneCommandResourcesCount = CommonTypesKt.getAvailableProcessors() * 11 * 2;
    private static final int MinCachedResourcesCount = OneCommandResourcesCount * 2;
    public static final int MaxBytesCount = 0x800000;
    private static int ResourceTimeout = 20;
    private static int maxSkipCount = 60;

    public ByteBufferResourcePool(@NotNull String tempFolder) {
        Intrinsics.checkNotNullParameter((Object)tempFolder, (String)"tempFolder");
        this.tempFolder = tempFolder;
        this._cachedResourcesMap = new ConcurrentHashMap();
        this._garbageCollecting = new AtomicBoolean();
    }

    @NotNull
    public final String getTempFolder() {
        return this.tempFolder;
    }

    @NotNull
    public final ResourceCacheItem getOrCreate(long headSize) {
        ResourceCacheItem resourceCacheItem = this.tryGet(headSize);
        return resourceCacheItem == null ? this.create() : resourceCacheItem;
    }

    private final ResourceCacheItem tryGet(long headSize) {
        LockFreeStack<ResourceCacheItem> lockFreeStack;
        LockFreeStack<ResourceCacheItem> lockFreeStack2 = this._cachedResourcesMap.get(headSize);
        if (lockFreeStack2 == null) {
            return null;
        }
        LockFreeStack<ResourceCacheItem> res = lockFreeStack = lockFreeStack2;
        return res.tryPop();
    }

    private final ResourceCacheItem create() {
        return new ResourceCacheItem(new MappedMemory(false));
    }

    public final void release(@Nullable ResourceCacheItem item) {
        if (!(item == null || item.getContentBufferSize() < 0x800000L && this.tryRelease(item))) {
            item.closeAndDelete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryRelease(ResourceCacheItem item) {
        boolean bl;
        long key = item.getHeadBufferSize();
        if (key > 0L) {
            void $this$getOrPut$iv;
            ConcurrentMap concurrentMap = this._cachedResourcesMap;
            Long key$iv = key;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                LockFreeStack lockFreeStack = new LockFreeStack();
                boolean bl3 = false;
                boolean bl4 = false;
                LockFreeStack default$iv = lockFreeStack;
                boolean bl5 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            LockFreeStack res = (LockFreeStack)object;
            item.setReleaseTime(System.nanoTime());
            item.resetBeforeReuse();
            res.push(item);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void close() {
        Object object = this._cachedResourcesMap.values();
        Intrinsics.checkNotNullExpressionValue(object, (String)"_cachedResourcesMap.values");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LockFreeStack stack = (LockFreeStack)element$iv;
            boolean bl = false;
            ResourceCacheItem item = (ResourceCacheItem)stack.tryPop();
            while (item != null) {
                item.closeAndDelete();
                item = (ResourceCacheItem)stack.tryPop();
            }
        }
        this._cachedResourcesMap.clear();
        object = this.tempFolder;
        boolean bl = false;
        if (object.length() > 0) {
            new File(this.tempFolder).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void gc() {
        if (this._garbageCollecting.compareAndSet(false, true)) {
            try {
                this.gcCore();
            }
            finally {
                this._garbageCollecting.set(false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getCachedCount() {
        void var3_3;
        Collection<LockFreeStack<ResourceCacheItem>> collection = this._cachedResourcesMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_cachedResourcesMap.values");
        Iterable $this$sumBy$iv = collection;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            LockFreeStack lockFreeStack = (LockFreeStack)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getSize();
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    private final void gcCore() {
        Ref.IntRef diff = new Ref.IntRef();
        diff.element = MinCachedResourcesCount - this.getCachedCount();
        if (diff.element >= 0) {
            return;
        }
        long min = System.nanoTime() - (long)ResourceTimeout * 1000000000L;
        long veryMin = System.nanoTime() - (long)ResourceTimeout * 1000000000L * (long)3;
        Collection<LockFreeStack<ResourceCacheItem>> collection = this._cachedResourcesMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_cachedResourcesMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LockFreeStack stack = (LockFreeStack)element$iv;
            boolean bl = false;
            stack.gc((Function1)new Function1<ResourceCacheItem, Boolean>(diff, min, veryMin){
                final /* synthetic */ Ref.IntRef $diff;
                final /* synthetic */ long $min;
                final /* synthetic */ long $veryMin;
                {
                    this.$diff = $diff;
                    this.$min = $min;
                    this.$veryMin = $veryMin;
                    super(1);
                }

                public final boolean invoke(@NotNull ResourceCacheItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$diff.element < 0 && it.getReleaseTime() < this.$min || it.getReleaseTime() < this.$veryMin;
                }
            }, (Function1)new Function1<ResourceCacheItem, Unit>(diff){
                final /* synthetic */ Ref.IntRef $diff;
                {
                    this.$diff = $diff;
                    super(1);
                }

                public final void invoke(@NotNull ResourceCacheItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.$diff.element;
                    this.$diff.element = n + 1;
                    it.closeAndDelete();
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/ByteBufferResourcePool$Companion;", "", "()V", "MaxBytesCount", "", "MinCachedResourcesCount", "getMinCachedResourcesCount", "()I", "OneCommandResourcesCount", "ResourceTimeout", "getResourceTimeout", "setResourceTimeout", "(I)V", "maxSkipCount", "getMaxSkipCount", "setMaxSkipCount", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMinCachedResourcesCount() {
            return MinCachedResourcesCount;
        }

        public final int getResourceTimeout() {
            return ResourceTimeout;
        }

        public final void setResourceTimeout(int n) {
            ResourceTimeout = n;
        }

        public final int getMaxSkipCount() {
            return maxSkipCount;
        }

        public final void setMaxSkipCount(int n) {
            maxSkipCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

