/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\n\u0010\u0013\u001a\u00060\u000bj\u0002`\u0014J\"\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0019\u001a\u00020\u0018J\n\u0010\u001a\u001a\u00060\u000bj\u0002`\u0014R\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/FileInfo;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "Length", "", "Lkd/bos/olapServer/common/long;", "getLength", "()J", "_fileExists", "", "_lengthCache", "getFile", "()Ljava/io/File;", "inited", "Ljava/util/concurrent/atomic/AtomicBoolean;", "clearLengthCache", "", "exists", "Lkd/bos/olapServer/common/bool;", "init", "initAction", "Lkotlin/Function1;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "buffer", "isInited", "bos-olap-core"})
public final class FileInfo {
    @NotNull
    private final File file;
    @NotNull
    private final AtomicBoolean inited;
    private volatile long _lengthCache;
    private volatile boolean _fileExists;

    public FileInfo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.inited = new AtomicBoolean();
        this._lengthCache = -1L;
        long len = this.getLength();
        if (len > 0L) {
            this.inited.set(true);
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean exists() {
        if (this._fileExists) {
            return true;
        }
        boolean result = this.file.exists();
        if (result) {
            this._fileExists = true;
            return true;
        }
        return false;
    }

    public final long getLength() {
        if (!this.exists()) {
            return 0L;
        }
        long len = this._lengthCache;
        if (len < 0L) {
            this._lengthCache = len = this.file.length();
        }
        return len;
    }

    public final boolean isInited() {
        return this.inited.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(@NotNull Function1<? super IByteBuffer, Unit> initAction, @NotNull IByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(initAction, (String)"initAction");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.inited.get()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            if (this.inited.get()) {
                return;
            }
            this._fileExists = true;
            initAction.invoke((Object)buffer);
            this.clearLengthCache();
            this.inited.set(true);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void clearLengthCache() {
        this._lengthCache = -1L;
    }
}

