/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.AbstractByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IMappedResource;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.MappedDatabase;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002&'B\u001d\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J(\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u0010j\u0002`\u00162\n\u0010\u001f\u001a\u00060\u0010j\u0002`\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00060\u000eR\u00020\u00002\n\u0010\u001f\u001a\u00060\u0010j\u0002`\u0016H\u0002J\b\u0010#\u001a\u00020\u0004H\u0016J\u0014\u0010$\u001a\u00020\u001a2\n\u0010%\u001a\u00060\u000eR\u00020\u0000H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0015\u0010\u0015\u001a\u00060\u0010j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IMappedResource;", "Ljava/io/Closeable;", "filePath", "", "Lkd/bos/olapServer/common/string;", "isReadOnly", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Z)V", "_accessFile", "Ljava/io/RandomAccessFile;", "_databases", "", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile$MappedFileDatabase;", "_maxMappedCapacity", "", "getFilePath", "()Ljava/lang/String;", "isFree", "()Z", "maxMappedCapacity", "Lkd/bos/olapServer/common/long;", "getMaxMappedCapacity", "()J", "close", "", "delete", "map", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "position", "size", "byteOrder", "Ljava/nio/ByteOrder;", "mapCore", "toString", "unloadDatabase", "database", "MapMode", "MappedFileDatabase", "bos-olap-core"})
public final class MappedFile
implements IMappedResource,
Closeable {
    @NotNull
    private final String filePath;
    private final boolean isReadOnly;
    @Nullable
    private RandomAccessFile _accessFile;
    @NotNull
    private final List<MappedFileDatabase> _databases;
    private volatile long _maxMappedCapacity;

    public MappedFile(@NotNull String filePath, boolean isReadOnly) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.isReadOnly = isReadOnly;
        if (!Bits.INSTANCE.getUnaligned() && !Intrinsics.areEqual((Object)System.getProperty("EnableMddOtherCpu"), (Object)"true")) {
            throw new NotSupportedException();
        }
        boolean bl = false;
        this._databases = new ArrayList();
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public IByteBuffer map(long position, long size, @NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        boolean bl = position >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = size >= 0L;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<MappedFileDatabase> list = this._databases;
        bl2 = false;
        bl3 = false;
        synchronized (list) {
            MappedFileDatabase lastItem;
            boolean bl7 = false;
            long capacity = position + size;
            Collection collection = this._databases;
            boolean bl8 = false;
            MappedFileDatabase mappedFileDatabase = lastItem = !collection.isEmpty() ? this._databases.get(CollectionsKt.getLastIndex(this._databases)) : null;
            if (lastItem != null && capacity <= lastItem.getCapacity()) {
                boolean bl9 = false;
                bl8 = false;
                synchronized (lastItem) {
                    boolean bl10 = false;
                    if (!lastItem.isClosed()) {
                        IByteBuffer iByteBuffer = lastItem.create(position, size, byteOrder);
                        return iByteBuffer;
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            MappedFileDatabase mappedDB = this.mapCore(position + size);
            this._databases.add(mappedDB);
            return mappedDB.create(position, size, byteOrder);
        }
    }

    private final MappedFileDatabase mapCore(long size) {
        boolean bl;
        RandomAccessFile randomAccessFile;
        boolean bl2 = size >= 0L;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String accMode = this.isReadOnly ? "r" : "rw";
        RandomAccessFile randomAccessFile2 = this._accessFile;
        if (randomAccessFile2 == null) {
            RandomAccessFile randomAccessFile3 = new RandomAccessFile(this.filePath, accMode);
            boolean bl7 = false;
            boolean bl8 = false;
            RandomAccessFile it = randomAccessFile3;
            boolean bl9 = false;
            this._accessFile = it;
            randomAccessFile = randomAccessFile3;
        } else {
            randomAccessFile = randomAccessFile2;
        }
        RandomAccessFile backingFile = randomAccessFile;
        long fileLength = backingFile.length();
        long capacity = 0L;
        int mode = 0;
        if (this.isReadOnly) {
            if (size > fileLength) {
                Object[] bl9 = Res.INSTANCE.getMappedFileException_1();
                Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"Res.MappedFileException_1");
                Object[] objectArray = bl9;
                bl9 = new Object[]{this.filePath, size, fileLength};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray, bl9);
            }
            mode = MapMode.READ_ONLY.getValue();
            capacity = fileLength;
        } else {
            mode = MapMode.READ_WRITE.getValue();
            long bl9 = Bits.INSTANCE.roundTo4096(size);
            bl = false;
            capacity = Math.max(bl9, fileLength);
            if (capacity > fileLength) {
                backingFile.setLength(capacity);
            }
        }
        long bl9 = this._maxMappedCapacity;
        bl = false;
        this._maxMappedCapacity = Math.max(capacity, bl9);
        Object[] objectArray = new Object[]{mode, 0, capacity};
        Object object = Bits.INSTANCE.getMapMethod().invoke((Object)backingFile.getChannel(), objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
        }
        long address = (Long)object;
        object = backingFile.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"backingFile.channel");
        return new MappedFileDatabase(this.isReadOnly, address, capacity, (FileChannel)object);
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"filePath: ", (Object)this.filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unloadDatabase(MappedFileDatabase database) {
        List<MappedFileDatabase> list = this._databases;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            RandomAccessFile accessFile;
            boolean bl3 = false;
            this._databases.remove(database);
            if (this._databases.isEmpty() && (accessFile = this._accessFile) != null) {
                accessFile.close();
                this._accessFile = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final long getMaxMappedCapacity() {
        return this._maxMappedCapacity;
    }

    @Override
    public void delete() {
        new File(this.filePath).delete();
    }

    @Override
    public void close() {
        RandomAccessFile randomAccessFile = this._accessFile;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }

    @Override
    public boolean isFree() {
        return this._accessFile == null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile$MapMode;", "", "value", "", "Lkd/bos/olapServer/common/int;", "(Ljava/lang/String;II)V", "getValue", "()I", "READ_ONLY", "READ_WRITE", "PRIVATE", "bos-olap-core"})
    private static final class MapMode
    extends Enum<MapMode> {
        private final int value;
        public static final /* enum */ MapMode READ_ONLY = new MapMode(0);
        public static final /* enum */ MapMode READ_WRITE = new MapMode(1);
        public static final /* enum */ MapMode PRIVATE = new MapMode(2);
        private static final /* synthetic */ MapMode[] $VALUES;

        private MapMode(int value2) {
            this.value = value2;
        }

        public final int getValue() {
            return this.value;
        }

        public static MapMode[] values() {
            return (MapMode[])$VALUES.clone();
        }

        public static MapMode valueOf(String value2) {
            return Enum.valueOf(MapMode.class, value2);
        }

        static {
            $VALUES = mapModeArray = new MapMode[]{MapMode.READ_ONLY, MapMode.READ_WRITE, MapMode.PRIVATE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\b\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile$MappedFileDatabase;", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedDatabase;", "isReadOnly", "", "Lkd/bos/olapServer/common/bool;", "address", "", "Lkd/bos/olapServer/common/long;", "capacity", "fileChannel", "Ljava/nio/channels/FileChannel;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/MappedFile;ZJJLjava/nio/channels/FileChannel;)V", "_bufferCounter", "", "_isClosed", "getAddress", "()J", "getCapacity", "isClosed", "()Z", "closeDatabase", "", "force", "register", "byteBuffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/AbstractByteBuffer;", "unRegister", "bos-olap-core"})
    private final class MappedFileDatabase
    extends MappedDatabase {
        private final long address;
        private final long capacity;
        @NotNull
        private final FileChannel fileChannel;
        private volatile int _bufferCounter;
        private volatile boolean _isClosed;

        public MappedFileDatabase(boolean isReadOnly, long address, @NotNull long capacity, FileChannel fileChannel) {
            Intrinsics.checkNotNullParameter((Object)MappedFile.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
            super(isReadOnly);
            this.address = address;
            this.capacity = capacity;
            this.fileChannel = fileChannel;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(@NotNull AbstractByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            boolean bl = false;
            int n = 0;
            synchronized (this) {
                boolean bl2 = false;
                boolean bl3 = !this.isClosed();
                int n2 = 0;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl3) {
                    boolean bl6 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                MappedFileDatabase mappedFileDatabase = this;
                n2 = mappedFileDatabase._bufferCounter;
                mappedFileDatabase._bufferCounter = n2 + 1;
                n = n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unRegister(@NotNull AbstractByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            boolean needClose = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                MappedFileDatabase mappedFileDatabase = this;
                mappedFileDatabase._bufferCounter += -1;
                int current = mappedFileDatabase._bufferCounter;
                if (current == 0 && !this._isClosed) {
                    this._isClosed = true;
                    needClose = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (needClose) {
                this.closeDatabase();
            }
        }

        public final boolean isClosed() {
            return this._isClosed;
        }

        private final void closeDatabase() {
            Object[] objectArray = new Object[]{this.getAddress(), this.getCapacity()};
            Bits.INSTANCE.getUnmapMethod().invoke(null, objectArray);
            MappedFile.this.unloadDatabase(this);
        }

        @Override
        public void force() {
            this.fileChannel.force(false);
        }
    }
}

