/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.byteBufferProviders;

import java.nio.MappedByteBuffer;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u00020\u00032\n\u0010\u000e\u001a\u00060\u0006j\u0002`\u000fJ\u001c\u0010\u0010\u001a\u00060\u000bj\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/SharedMappedByteBuffer;", "", "realBuffer", "Ljava/nio/MappedByteBuffer;", "(Ljava/nio/MappedByteBuffer;)V", "activeCount", "", "capacity", "getCapacity", "()I", "isActive", "", "()Z", "create", "size", "Lkd/bos/olapServer/common/int;", "tryRelease", "Lkd/bos/olapServer/common/bool;", "buffer", "createBy", "bos-olap-core"})
public final class SharedMappedByteBuffer {
    @NotNull
    private final MappedByteBuffer realBuffer;
    private int activeCount;

    public SharedMappedByteBuffer(@NotNull MappedByteBuffer realBuffer) {
        Intrinsics.checkNotNullParameter((Object)realBuffer, (String)"realBuffer");
        this.realBuffer = realBuffer;
    }

    public final int getCapacity() {
        return this.realBuffer.capacity();
    }

    @NotNull
    public final MappedByteBuffer create(int size) {
        if (!(0 <= size ? size <= this.realBuffer.capacity() : false)) {
            Object[] objectArray = Res.INSTANCE.getCommonException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_2");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{size, this.realBuffer.capacity()};
            throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
        }
        this.realBuffer.clear();
        this.realBuffer.position(0);
        this.realBuffer.limit(size);
        Object object = this.realBuffer.slice();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.MappedByteBuffer");
        }
        MappedByteBuffer result = (MappedByteBuffer)object;
        object = this;
        int n = ((SharedMappedByteBuffer)object).activeCount;
        ((SharedMappedByteBuffer)object).activeCount = n + 1;
        return result;
    }

    public final boolean tryRelease(@NotNull MappedByteBuffer buffer, @Nullable Object createBy) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (createBy == this.realBuffer) {
            buffer.limit(buffer.capacity());
            SharedMappedByteBuffer sharedMappedByteBuffer = this;
            int n = sharedMappedByteBuffer.activeCount;
            sharedMappedByteBuffer.activeCount = n + -1;
            return true;
        }
        return false;
    }

    public final boolean isActive() {
        return this.activeCount > 0;
    }
}

