/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.dynamicData;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.UUID;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.Bits;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.BytesTransform;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.EncodeContext;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.IBoxedOutputStream;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.IEncoding;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.IntArrayInputStream;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.RealScale;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u001e\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/dynamicData/Encoding;", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/IEncoding;", "()V", "decode", "", "zipInt", "", "Lkd/bos/olapServer/common/int;", "byteArray", "", "len", "encode", "value", "ctx", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/EncodeContext;", "Companion", "bos-olap-core"})
public final class Encoding
implements IEncoding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Unsafe unsafe;
    private static final long intValOffset;
    private static final long intCompactOffset;
    @NotNull
    private static final Long[] powerDecimals;
    @NotNull
    private static final Integer[] decimalDotMarks;
    @NotNull
    private static final BigDecimal LongMaxValue;
    @NotNull
    private static final BigDecimal LongMinValue;
    private static final int MaxDecimalScale = 15;
    private static final long INFLATED = Long.MIN_VALUE;

    @Override
    @NotNull
    public Object decode(int zipInt) {
        Integer n;
        int dotLen = zipInt >> 29;
        int realValue = zipInt & 0x1FFFFFFF;
        int n2 = dotLen;
        if (n2 == 0) {
            n = realValue;
        } else {
            boolean bl = 1 <= n2 ? n2 <= 3 : false;
            if (bl) {
                n = Decimal6f.valueOfUnscaled((long)realValue, (int)dotLen);
            } else {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                String string = Intrinsics.stringPlus((String)"zipInt = ", (Object)zipInt);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        Integer n3 = n;
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"when (dotLen) {\n            0 -> { //\u6b63\u6574\u657000\n                realValue\n            }\n            in 1..3 -> {  //\u6b63\u76841..3\u4f4d\u5c0f\u6570\n                decimal.valueOfUnscaled(realValue.toLong(), dotLen)\n            }\n            else -> {\n                require(false) { \"zipInt = $zipInt\" }\n                -1\n            }\n        }");
        return n3;
    }

    @Override
    public int encode(@Nullable Object value2, @NotNull EncodeContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = value2;
        if (object instanceof BigDecimal) {
            return Encoding.Companion.encodeBigDecimal((BigDecimal)value2, ctx);
        }
        if (object instanceof Integer) {
            return Encoding.Companion.encodeInt(((Number)value2).intValue(), ctx);
        }
        if (object instanceof Long) {
            return Encoding.Companion.encodeLong(((Number)value2).longValue(), ctx);
        }
        if (object instanceof Decimal6f) {
            return Encoding.Companion.encodeDecimal((Decimal6f)value2, ctx);
        }
        if (object instanceof Boolean) {
            return Encoding.Companion.encodeBool((Boolean)value2, ctx);
        }
        if (object instanceof String) {
            return Encoding.Companion.encodeString((String)value2, ctx);
        }
        if (object instanceof UUID) {
            return Encoding.Companion.encodeUUID((UUID)value2, ctx);
        }
        if (object instanceof IBoxedOutputStream) {
            return Encoding.Companion.encodeStream((IBoxedOutputStream)value2, ctx);
        }
        if (object instanceof byte[]) {
            return Encoding.Companion.encodeByteArray((byte[])value2, ctx);
        }
        throw new NotSupportedException("encode in heap error,notSupported");
    }

    @Override
    @NotNull
    public Object decode(@NotNull byte[] byteArray, int len) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        byte value2 = byteArray[0];
        int n = value2 >> 4;
        switch (n) {
            case 0: {
                return Encoding.Companion.decodeDecimal(byteArray, value2, false);
            }
            case 1: {
                return Encoding.Companion.decodeDecimal(byteArray, value2, true);
            }
            case 2: {
                return byteArray[1] == 1;
            }
            case 3: {
                String string;
                byte by = 48 <= value2 ? (value2 <= 50 ? (byte)1 : 0) : (byte)0;
                int n2 = 0;
                int n3 = 0;
                n3 = 0;
                boolean bl = false;
                if (by == 0) {
                    boolean bl2 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                by = value2;
                switch (by) {
                    case 50: {
                        n2 = 1;
                        n3 = len - 1;
                        Charset charset = Charsets.UTF_8;
                        boolean bl3 = false;
                        string = new String(byteArray, n2, n3, charset);
                        break;
                    }
                    case 48: {
                        string = "";
                        break;
                    }
                    default: {
                        string = String.valueOf((char)byteArray[1]);
                    }
                }
                return string;
            }
            case 4: {
                return Encoding.Companion.decodeUUID(byteArray);
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                return Encoding.Companion.decodeByteArray(byteArray, len);
            }
        }
        throw new NotSupportedException("decode in heap error,notSupported");
    }

    static {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Object object = unsafeField.get(null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type sun.misc.Unsafe");
        }
        unsafe = (Unsafe)object;
        intValOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intVal"));
        intCompactOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intCompact"));
        Number[] numberArray = new Long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
        powerDecimals = numberArray;
        numberArray = new Integer[]{0, 0x20000000, 0x40000000, 0x60000000};
        decimalDotMarks = numberArray;
        LongMaxValue = new BigDecimal(Long.MAX_VALUE);
        LongMinValue = new BigDecimal(Long.MIN_VALUE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\tj\u0002`\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0019\u001a\u00060\tj\u0002`\u00172\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u001c\u0010 \u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00060\tj\u0002`\u00172\n\u0010!\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010%\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J \u0010&\u001a\u00060\tj\u0002`\u00172\n\u0010!\u001a\u00060'j\u0002`(2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010)\u001a\u00020\t2\n\u0010!\u001a\u00060\tj\u0002`\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010*\u001a\u00020\t2\n\u0010!\u001a\u00060\u0004j\u0002`+2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010,\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010.\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020/2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u00100\u001a\u00060\tj\u0002`\u00172\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J,\u00101\u001a\u00060\tj\u0002`\u00172\n\u00102\u001a\u00060\u0004j\u0002`+2\n\u00103\u001a\u00060\tj\u0002`\u00172\u0006\u0010\"\u001a\u00020#H\u0002J(\u00104\u001a\n\u0018\u00010'j\u0004\u0018\u0001`(2\n\u00105\u001a\u00060\u0004j\u0002`+2\n\u00106\u001a\u00060\tj\u0002`\u0017H\u0002J\f\u00107\u001a\u00020\u0004*\u00020\u0006H\u0002J\u000e\u00108\u001a\u0004\u0018\u000109*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/dynamicData/Encoding$Companion;", "", "()V", "INFLATED", "", "LongMaxValue", "Ljava/math/BigDecimal;", "LongMinValue", "MaxDecimalScale", "", "decimalDotMarks", "", "[Ljava/lang/Integer;", "intCompactOffset", "intValOffset", "powerDecimals", "[Ljava/lang/Long;", "unsafe", "Lsun/misc/Unsafe;", "decodeByteArray", "byteArray", "", "bytesSize", "Lkd/bos/olapServer/common/int;", "decodeDecimal", "firstMark", "sign", "", "Lkd/bos/olapServer/common/bool;", "decodeUUID", "Ljava/util/UUID;", "bytes", "encodeBigDecimal", "value", "ctx", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/EncodeContext;", "encodeBool", "encodeByteArray", "encodeDecimal", "Lorg/decimal4j/immutable/Decimal6f;", "Lkd/bos/olapServer/common/decimal;", "encodeInt", "encodeLong", "Lkd/bos/olapServer/common/long;", "encodeStream", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/IBoxedOutputStream;", "encodeString", "", "encodeUUID", "simpleEncodeBigDecimal", "intCompact", "scale", "tryConvertToDecimal", "uValue", "dotLen", "getIntCompact", "getIntVal", "Ljava/math/BigInteger;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final BigInteger getIntVal(BigDecimal $this$getIntVal) {
            Object object = unsafe.getObjectVolatile($this$getIntVal, intValOffset);
            return object instanceof BigInteger ? (BigInteger)object : null;
        }

        private final long getIntCompact(BigDecimal $this$getIntCompact) {
            return unsafe.getLongVolatile($this$getIntCompact, intCompactOffset);
        }

        private final int encodeBigDecimal(BigDecimal value2, EncodeContext ctx) {
            int scale = value2.scale();
            long intCompact = this.getIntCompact(value2);
            boolean bl = 0 <= scale ? scale <= 15 : false;
            if (bl && intCompact != Long.MIN_VALUE) {
                return this.simpleEncodeBigDecimal(intCompact, scale, ctx);
            }
            Object[] objectArray = LongMinValue;
            if (!(value2.compareTo((Object)LongMaxValue) <= 0 ? 0 <= value2.compareTo(objectArray) : false)) {
                objectArray = Res.INSTANCE.getArrayJsonReaderException_8();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ArrayJsonReaderException_8");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{LongMinValue, LongMaxValue, value2};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
            }
            BigDecimal newValue = scale > 15 ? value2.setScale(15, 4) : value2;
            scale = (newValue = newValue.stripTrailingZeros()).scale();
            if (scale < 0) {
                newValue = new BigDecimal(newValue.toPlainString());
                scale = newValue.scale();
            }
            BigDecimal bigDecimal = newValue;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"newValue");
            intCompact = this.getIntCompact(bigDecimal);
            if (intCompact != Long.MIN_VALUE) {
                boolean bl2 = 0 <= scale ? scale <= 15 : false;
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return this.simpleEncodeBigDecimal(intCompact, scale, ctx);
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMask = 0;
            BigDecimal bigDecimal2 = newValue;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"newValue");
            BigInteger bigInteger = this.getIntVal(bigDecimal2);
            if (bigInteger == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
            }
            BigInteger intVal = bigInteger;
            if (intVal.compareTo(BigInteger.ZERO) >= 0) {
                firstMask = 0;
            } else {
                firstMask = 16;
                bigInteger = intVal;
                boolean bl7 = false;
                BigInteger bigInteger2 = bigInteger.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                intVal = bigInteger2;
            }
            boolean bl8 = scale >= 0;
            boolean bl9 = false;
            boolean bl10 = false;
            bl10 = false;
            boolean bl11 = false;
            if (!bl8) {
                boolean bl12 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            byteArray[0] = (byte)(firstMask | scale);
            int len = BytesTransform.INSTANCE.write7BitEncodedBigInteger(intVal, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int simpleEncodeBigDecimal(long intCompact, int scale, EncodeContext ctx) {
            int realScale;
            long intCompact2 = intCompact;
            if (scale <= 3) {
                boolean bl = 0L <= intCompact2 ? intCompact2 <= 0x1FFFFFFFL : false;
                if (bl) {
                    return (int)intCompact2 | decimalDotMarks[scale];
                }
            }
            if ((realScale = RealScale.INSTANCE.getLen(intCompact2, scale)) != scale) {
                intCompact2 /= powerDecimals[scale - realScale - 1].longValue();
                if (realScale <= 3) {
                    boolean bl = 0L <= intCompact2 ? intCompact2 <= 0x1FFFFFFFL : false;
                    if (bl) {
                        return (int)intCompact2 | decimalDotMarks[realScale];
                    }
                }
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMask = 0;
            if (intCompact2 >= 0L) {
                firstMask = 0;
            } else {
                firstMask = 16;
                intCompact2 = -intCompact2;
            }
            byteArray[0] = (byte)(firstMask | realScale);
            int len = BytesTransform.INSTANCE.write7BitEncodedLong(intCompact2, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeString(String value2, EncodeContext ctx) {
            String string = value2;
            Charset charset = Charsets.UTF_8;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            int len = bytes.length + 1;
            byte[] byteArray = ctx.getByteArray(len);
            System.arraycopy(bytes, 0, byteArray, 1, bytes.length);
            n = bytes.length;
            switch (n) {
                case 0: {
                    byteArray[0] = 48;
                    break;
                }
                case 1: {
                    byteArray[0] = 49;
                    break;
                }
                default: {
                    byteArray[0] = 50;
                }
            }
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeBool(boolean value2, EncodeContext ctx) {
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = 32;
            byteArray[1] = value2 ? 1 : 10;
            ctx.setLen(3);
            return -1;
        }

        private final int encodeDecimal(Decimal6f value2, EncodeContext ctx) {
            long uValue = value2.unscaledValue();
            int dotLen = RealScale.INSTANCE.getLenAs6Scale(uValue);
            if (uValue >= 0L && dotLen <= 3) {
                long result = uValue / powerDecimals[5 - dotLen];
                boolean bl = 0L <= result ? result <= 0x1FFFFFFFL : false;
                if (bl) {
                    return (int)result | decimalDotMarks[dotLen];
                }
            }
            byte[] byteArray = ctx.getByteArray();
            int firstMark = 0;
            boolean bl = 0 <= dotLen ? dotLen <= 6 : false;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (uValue >= 0L) {
                firstMark = 0;
            } else {
                firstMark = 16;
                uValue = uValue == Long.MIN_VALUE ? 0L : -uValue;
            }
            byteArray[0] = (byte)(firstMark | dotLen);
            long result = dotLen == 6 ? uValue : uValue / powerDecimals[5 - dotLen];
            int len = BytesTransform.INSTANCE.write7BitEncodedLong(result, byteArray, 1) + 1;
            ctx.setLen(len < 3 ? 3 : len);
            return -1;
        }

        private final int encodeUUID(UUID value2, EncodeContext ctx) {
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = 64;
            Bits.INSTANCE.putLongB(value2.getMostSignificantBits(), byteArray, 1);
            Bits.INSTANCE.putLongB(value2.getLeastSignificantBits(), byteArray, 9);
            ctx.setLen(17);
            return -1;
        }

        private final int encodeByteArray(byte[] value2, EncodeContext ctx) {
            OutputStream stream = ctx.createStream(value2.length + 3);
            byte[] byArray = new byte[]{112, 0, 1};
            stream.write(byArray);
            stream.write(value2);
            return -1;
        }

        private final int encodeStream(IBoxedOutputStream value2, EncodeContext ctx) {
            OutputStream stream = ctx.createStream(value2.getMinCapacity() + 3);
            short v = value2.getDataTypeFlag();
            byte[] byArray = new byte[]{112, (byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
            stream.write(byArray);
            value2.write(stream);
            return -1;
        }

        private final int encodeLong(long value2, EncodeContext ctx) {
            int len;
            boolean bl = 0L <= value2 ? value2 <= 0x1FFFFFFFL : false;
            if (bl) {
                return (int)value2;
            }
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = value2 >= 0L ? 0 : 16;
            long realValue = value2;
            if (realValue < 0L) {
                realValue = realValue == Long.MIN_VALUE ? 0L : -value2;
            }
            ctx.setLen((len = BytesTransform.INSTANCE.write7BitEncodedLong(realValue, byteArray, 1) + 1) < 3 ? 3 : len);
            return -1;
        }

        private final int encodeInt(int value2, EncodeContext ctx) {
            int len;
            boolean bl = 0 <= value2 ? value2 <= 0x1FFFFFFF : false;
            if (bl) {
                return value2;
            }
            byte[] byteArray = ctx.getByteArray();
            byteArray[0] = value2 >= 0 ? 0 : 16;
            long realValue = value2;
            if (realValue < 0L) {
                realValue = -realValue;
            }
            ctx.setLen((len = BytesTransform.INSTANCE.write7BitEncodedLong(realValue, byteArray, 1) + 1) < 3 ? 3 : len);
            return -1;
        }

        private final Object decodeDecimal(byte[] byteArray, int firstMark, boolean sign) {
            long uValue = BytesTransform.INSTANCE.Read7BitEncodedLong(byteArray, 1);
            if (uValue >= 0L) {
                Decimal6f decimal6f;
                int dotLen;
                if (sign) {
                    long l = uValue = uValue == 0L ? Long.MIN_VALUE : -uValue;
                }
                Number number = (dotLen = firstMark & 0xF) == 0 ? ((Integer.MIN_VALUE <= uValue ? uValue <= Integer.MAX_VALUE : false) ? (Number)((int)uValue) : (Number)uValue) : (dotLen <= 6 ? ((decimal6f = this.tryConvertToDecimal(uValue, dotLen)) == null ? BigDecimal.valueOf(uValue, dotLen) : decimal6f) : BigDecimal.valueOf(uValue, dotLen));
                BigDecimal bigDecimal = number;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"if (dotLen == 0) {\n                    if (uValue in (int.MIN_VALUE..int.MAX_VALUE)) uValue.toInt() else uValue\n                } else if (dotLen <= 6) {\n                    //\u5c0f\u6570\u4f4d\u6570\u5c0f\u4e8e\u7b49\u4e8e 6 \u65f6\uff0c\u5c06\u5176\u8f6c\u6362\u6210 decimal6f \u7c7b\u578b\u9700\u8981\u5c06 uValue \u8865\u5c3e 0 \u76f4\u5230 6 \u4f4d\u5c0f\u6570\uff0c\n                    //\u800c uValue \u5f80\u540e\u6dfb\u52a0 0 \u53ef\u80fd\u4f1a\u4f7f\u5176\u8303\u56f4\u8d85\u8fc7 long \u7684\u6570\u503c\u8303\u56f4\uff0c\u5bfc\u81f4\u8f6c\u6362\u5931\u8d25\n                    //\u4f8b\u5982 uValue = 9223372036854775807\uff0cdotLen = 1\n                    //\u8f6c\u6362\u65f6 decimal.valueOfUnscaled(9223372036854775807, 1) \u76f8\u5f53\u4e8e decimal.valueOfUnscaled(922337203685477580700000)\uff0c\u8f6c\u6362\u5931\u8d25\n                    //\u56e0\u6b64\u9700\u8981\u5148\u6839\u636e\u5c0f\u6570\u4f4d\u6570\u5bf9 uValue \u8fdb\u884c\u6570\u503c\u5224\u65ad\uff0c\u4ee5\u786e\u5b9a\u5176\u662f\u5426\u80fd\u8f6c\u6362\u4e3a decimal6f \u7c7b\u578b\n                    tryConvertToDecimal(uValue, dotLen) ?: BigDecimal.valueOf(uValue, dotLen)\n                } else {\n                    BigDecimal.valueOf(uValue, dotLen)\n                }");
                return bigDecimal;
            }
            BigInteger firstUnScaleVal = BigInteger.valueOf(uValue & Long.MAX_VALUE);
            BigInteger bigInteger = BigInteger.valueOf(BytesTransform.INSTANCE.Read7BitEncodedLong(byteArray, 10));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(BytesTransform.Read7BitEncodedLong(byteArray, 10))");
            int n = 63;
            boolean bl = false;
            BigInteger bigInteger2 = bigInteger.shiftLeft(n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.shiftLeft(n)");
            BigInteger nextUnScaleVal = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)firstUnScaleVal, (String)"firstUnScaleVal");
            BigInteger bigInteger3 = firstUnScaleVal;
            bl = false;
            BigInteger bigInteger4 = bigInteger3.or(nextUnScaleVal);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.or(other)");
            BigInteger resultUnScaleVal = bigInteger4;
            if (sign) {
                bigInteger3 = resultUnScaleVal;
                bl = false;
                BigInteger bigInteger5 = bigInteger3.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.negate()");
                resultUnScaleVal = bigInteger5;
            }
            int dotLen = firstMark & 0xF;
            return new BigDecimal(resultUnScaleVal, dotLen);
        }

        private final Decimal6f tryConvertToDecimal(long uValue, int dotLen) {
            int n = dotLen;
            switch (n) {
                case 6: {
                    if (Long.MIN_VALUE <= uValue ? uValue <= Long.MAX_VALUE : false) break;
                    return null;
                }
                case 5: {
                    if (-922337203685477580L <= uValue ? uValue <= 0xCCCCCCCCCCCCCCCL : false) break;
                    return null;
                }
                case 4: {
                    if (-92233720368547758L <= uValue ? uValue <= 92233720368547758L : false) break;
                    return null;
                }
                case 3: {
                    if (-9223372036854775L <= uValue ? uValue <= 9223372036854775L : false) break;
                    return null;
                }
                case 2: {
                    if (-922337203685477L <= uValue ? uValue <= 922337203685477L : false) break;
                    return null;
                }
                case 1: {
                    if (-92233720368547L <= uValue ? uValue <= 92233720368547L : false) break;
                    return null;
                }
            }
            return Decimal6f.valueOfUnscaled((long)uValue, (int)dotLen);
        }

        private final UUID decodeUUID(byte[] bytes) {
            long mostSigBits = Bits.INSTANCE.getLongB(bytes, 1);
            long leastSigBits = Bits.INSTANCE.getLongB(bytes, 9);
            return new UUID(mostSigBits, leastSigBits);
        }

        private final Object decodeByteArray(byte[] byteArray, int bytesSize) {
            Object[] objectArray;
            int dataTypeFlags;
            int n = dataTypeFlags = (byteArray[1] << 8) + byteArray[2];
            switch (n) {
                case 1: {
                    byte[] byArray = byteArray;
                    int n2 = 3;
                    boolean bl = false;
                    objectArray = ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)bytesSize);
                    break;
                }
                case 2: {
                    objectArray = new IntArrayInputStream(new ByteArrayInputStream(byteArray, 3, bytesSize)).toIntArray();
                    break;
                }
                default: {
                    throw new NotSupportedException(Intrinsics.stringPlus((String)"decode in heap error,not supported flag:", (Object)dataTypeFlags));
                }
            }
            return objectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

