/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.collections.IIndexValueIterator;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinInvArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.RoaringArraySegment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u001b\u001a\u00060\bj\u0002`\t2\n\u0010\u001c\u001a\u00060\bj\u0002`\t2\n\u0010\u001d\u001a\u00060\bj\u0002`\t2\n\u0010\u001e\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J\u0019\u0010$\u001a\u00060\u0005j\u0002`\u00062\n\u0010%\u001a\u00060\bj\u0002`\tH\u0096\u0002J\u0014\u0010&\u001a\u00020\b2\n\u0010'\u001a\u00060\bj\u0002`\tH\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00060\u0005j\u0002`\u00062\n\u0010'\u001a\u00060\bj\u0002`\tH\u0002J\b\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\u00012\n\u0010%\u001a\u00060\bj\u0002`\t2\n\u0010.\u001a\u00060\u0005j\u0002`\u0006H\u0016R\u0018\u0010\u000b\u001a\u00060\bj\u0002`\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\r\u00a8\u00061"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinArraySegment;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer/common/long;", "_arrayCount", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;JI)V", "LastIndex", "getLastIndex", "()I", "NextSegmentOffset", "getNextSegmentOffset", "()J", "Offset", "getOffset", "_cachedRangeInnerIndex", "_cachedRangeMax", "_cachedRangeMin", "_indexOffset", "_lastIndex", "_valueOffset", "arrayCount", "getArrayCount", "binarySearch", "lo", "hi", "key", "fillSegmentEntry", "", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "force", "get", "index", "getIndex", "i", "getIndexValueIterator", "Lkd/bos/olapServer/collections/IIndexValueIterator;", "getValue", "switchToBitmap", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegment;", "update", "value", "Companion", "IndexValueIterator", "bos-olap-core"})
public final class MinArraySegment
implements IMinBitmapSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IByteBuffer _buffer;
    private int _arrayCount;
    private final long _indexOffset;
    private final long _valueOffset;
    private int _lastIndex;
    private int _cachedRangeMin;
    private int _cachedRangeMax;
    private int _cachedRangeInnerIndex;
    @NotNull
    private static final AtomicReference<int[]> indexesArrayRef = new AtomicReference();
    @NotNull
    private static final AtomicReference<long[]> valuesArrayRef = new AtomicReference();
    public static final int SwitchSize = 127;

    public MinArraySegment(@NotNull IByteBuffer _buffer, long offset, int _arrayCount) {
        Intrinsics.checkNotNullParameter((Object)_buffer, (String)"_buffer");
        this._buffer = _buffer;
        this._arrayCount = _arrayCount;
        this._indexOffset = offset + 1L;
        this._valueOffset = offset + (long)2;
        this._lastIndex = -1;
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
    }

    private final long getOffset() {
        return this._indexOffset - 1L;
    }

    public final int getArrayCount() {
        return this._arrayCount;
    }

    private final int getIndex(int i) {
        return this._buffer.getByte(this._indexOffset + (long)(i * 9)) & 0xFF;
    }

    private final long getValue(int i) {
        return this._buffer.getLong(this._valueOffset + (long)(i * 9));
    }

    private final int getLastIndex() {
        if (this._lastIndex < 0 && this._arrayCount > 0) {
            this._lastIndex = this.getIndex(this._arrayCount - 1);
        }
        return this._lastIndex;
    }

    @Override
    @NotNull
    public IMinBitmapSegment update(int index2, long value2) {
        int lastIndex = this.getLastIndex();
        if (lastIndex < index2) {
            if (this._arrayCount == 127) {
                MinBitmapSegment bitmap = this.switchToBitmap();
                return bitmap.update(index2, value2);
            }
            long position = this._indexOffset + (long)(this._arrayCount * 9);
            this._buffer.putByte(position, (byte)index2);
            this._buffer.putLong(position + 1L, value2);
            MinArraySegment minArraySegment = this;
            int n = minArraySegment._arrayCount;
            minArraySegment._arrayCount = n + 1;
            this._lastIndex = index2;
        } else if (lastIndex == index2) {
            long position = this._valueOffset + (long)((this._arrayCount - 1) * 9);
            this._buffer.putLong(position, value2);
        } else if (lastIndex > index2) {
            throw new NotSupportedException();
        }
        return this;
    }

    private final MinBitmapSegment switchToBitmap() {
        int[] indexes = MinArraySegment.Companion.getIndexesArrayCache();
        long[] values = MinArraySegment.Companion.getValuesArrayCache();
        IIndexValueIterator iter = this.getIndexValueIterator();
        int y = 0;
        while (iter.next()) {
            indexes[y] = iter.getIndex();
            values[y] = iter.getValue();
            int n = y;
            y = n + 1;
        }
        MinBitmapSegment bitmap = new MinBitmapSegment(this._buffer, this.getOffset(), 0, 0);
        bitmap.addFromArray(indexes, values, this._arrayCount);
        MinArraySegment.Companion.releaseIndexesArrayCache(indexes);
        MinArraySegment.Companion.releaseValuesArrayCache(values);
        return bitmap;
    }

    @Override
    public long get(int index2) {
        if (this._arrayCount <= 0 || index2 > this.getLastIndex()) {
            return 0L;
        }
        int realIndex = this._cachedRangeMin < 0 ? this.binarySearch(0, this._arrayCount - 1, index2) : (index2 >= this._cachedRangeMin ? (index2 < this._cachedRangeMax ? -(this._cachedRangeInnerIndex + 1) : (index2 == this._cachedRangeMax ? this._cachedRangeInnerIndex : this.binarySearch(this._cachedRangeInnerIndex + 1, this._arrayCount - 1, index2))) : this.binarySearch(0, this._cachedRangeInnerIndex - 1, index2));
        return realIndex < 0 ? 0L : this.getValue(realIndex);
    }

    private final int binarySearch(int lo, int hi, int key) {
        int x;
        int low = lo;
        int high = hi;
        this._cachedRangeMin = key;
        while (low + 7 <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = this.getIndex(middleIndex);
            if (middleValue < key) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > key) {
                high = middleIndex - 1;
                continue;
            }
            this._cachedRangeMax = this._cachedRangeMin;
            this._cachedRangeInnerIndex = middleIndex;
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int value2 = this.getIndex(x);
            if (value2 < key) continue;
            this._cachedRangeMax = value2;
            if (value2 != key) break;
            this._cachedRangeInnerIndex = x;
            return x;
        }
        if (x > high) {
            this._cachedRangeMax = x < this._arrayCount ? this.getIndex(x) : Integer.MAX_VALUE;
        }
        this._cachedRangeInnerIndex = x;
        return -(x + 1);
    }

    @Override
    public void force() {
        this._buffer.putByte(this.getOffset(), (byte)this._arrayCount);
    }

    @Override
    public void fillSegmentEntry(@NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        boolean bl = this._arrayCount > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int front = this.getIndex(0);
        bl2 = false;
        bl3 = false;
        MinBitmapSegmentEntry $this$fillSegmentEntry_u24lambda_u2d0 = entry;
        boolean bl6 = false;
        $this$fillSegmentEntry_u24lambda_u2d0.setPosition(this.getOffset());
        $this$fillSegmentEntry_u24lambda_u2d0.setBitmap(false);
        $this$fillSegmentEntry_u24lambda_u2d0.setFrontEmptyCount(front);
        $this$fillSegmentEntry_u24lambda_u2d0.setValidCount(this.getLastIndex() - $this$fillSegmentEntry_u24lambda_u2d0.getFrontEmptyCount() + 1);
    }

    @Override
    public long getNextSegmentOffset() {
        return this._indexOffset + (long)(this._arrayCount * 9);
    }

    private final IIndexValueIterator getIndexValueIterator() {
        return new IndexValueIterator();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinArraySegment$Companion;", "", "()V", "SwitchSize", "", "indexesArrayRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "valuesArrayRef", "", "create", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer/common/long;", "getIndexesArrayCache", "getValuesArrayCache", "releaseIndexesArrayCache", "", "indexesArray", "releaseValuesArrayCache", "valuesArray", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] getIndexesArrayCache() {
            int[] indexesArray = indexesArrayRef.getAndSet(null);
            if (indexesArray == null) {
                indexesArray = new int[127];
            }
            int[] nArray = indexesArray;
            return nArray;
        }

        private final void releaseIndexesArrayCache(int[] indexesArray) {
            indexesArrayRef.compareAndSet(null, indexesArray);
        }

        private final long[] getValuesArrayCache() {
            long[] valuesArray = valuesArrayRef.getAndSet(null);
            if (valuesArray == null) {
                valuesArray = new long[127];
            }
            long[] lArray = valuesArray;
            return lArray;
        }

        private final void releaseValuesArrayCache(long[] valuesArray) {
            valuesArrayRef.compareAndSet(null, valuesArray);
        }

        @NotNull
        public final IMinBitmapSegment create(@NotNull IByteBuffer buffer, long offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int arrayCount = buffer.getByte(offset) & 0xFF;
            return arrayCount == 0 ? (IMinBitmapSegment)new RoaringArraySegment(buffer, offset, (buffer.getByte(offset + 1L) & 0xFF) + 1) : (CommonTypesKt.getBit(arrayCount, 7) ? (IMinBitmapSegment)new MinInvArraySegment(buffer, offset, arrayCount & 0x7F) : (IMinBitmapSegment)new MinArraySegment(buffer, offset, arrayCount));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinArraySegment$IndexValueIterator;", "Lkd/bos/olapServer/collections/IIndexValueIterator;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinArraySegment;)V", "Index", "", "Lkd/bos/olapServer/common/idx;", "getIndex", "()I", "Value", "", "Lkd/bos/olapServer/common/long;", "getValue", "()J", "_i", "next", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    private final class IndexValueIterator
    implements IIndexValueIterator {
        private int _i;

        public IndexValueIterator() {
            Intrinsics.checkNotNullParameter((Object)MinArraySegment.this, (String)"this$0");
            this._i = -1;
        }

        @Override
        public boolean next() {
            IndexValueIterator indexValueIterator = this;
            int n = indexValueIterator._i;
            indexValueIterator._i = n + 1;
            return this._i < MinArraySegment.this._arrayCount;
        }

        @Override
        public int getIndex() {
            return MinArraySegment.this.getIndex(this._i);
        }

        @Override
        public long getValue() {
            return MinArraySegment.this.getValue(this._i);
        }
    }
}

