/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinMutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinImmutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinInvArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.RoaringArraySegment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u001a\u0010\u0014\u001a\u0014\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\t2\n\u0010\u0017\u001a\u00060\u000bj\u0002`\fH\u0002J\u0014\u0010\u0018\u001a\u00020\t2\n\u0010\u0017\u001a\u00060\u000bj\u0002`\fH\u0014J\u0014\u0010\u0019\u001a\u00020\u00102\n\u0010\u0017\u001a\u00060\u000bj\u0002`\fH\u0014J\u0014\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J \u0010\u001e\u001a\u00020\u00122\n\u0010\u001f\u001a\u00060\u000bj\u0002`\f2\n\u0010 \u001a\u00060\u001cj\u0002`\u001dH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmap;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinImmutableBitmap;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinMutableBitmap;", "Lkd/bos/olapServer/collections/IDataContainer;", "indexMetadata", "Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "dataMetadata", "(Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;)V", "_currentSegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_currentSegmentIndex", "", "Lkd/bos/olapServer/common/int;", "_dirty", "", "_tempSegmentEntry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "force", "", "forceCurrentSegment", "getLastSegment", "Lkotlin/Pair;", "getOrCreateSegment", "segmentIndex", "getSegment", "getSegmentEntry", "resize", "nextSegmentOffset", "", "Lkd/bos/olapServer/common/long;", "update", "index", "value", "bos-olap-core"})
public final class MinBitmap
extends MinImmutableBitmap
implements IMinMutableBitmap,
IDataContainer {
    private boolean _dirty;
    private int _currentSegmentIndex;
    @Nullable
    private IMinBitmapSegment _currentSegment;
    @NotNull
    private final MinBitmapSegmentEntry _tempSegmentEntry;

    public MinBitmap(@NotNull ListMetadata indexMetadata, @NotNull ListMetadata dataMetadata) {
        Intrinsics.checkNotNullParameter((Object)indexMetadata, (String)"indexMetadata");
        Intrinsics.checkNotNullParameter((Object)dataMetadata, (String)"dataMetadata");
        super(indexMetadata, dataMetadata);
        this._currentSegmentIndex = -1;
        this._tempSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
    }

    @Override
    @NotNull
    protected MinBitmapSegmentEntry getSegmentEntry(int segmentIndex) {
        MinBitmapSegmentEntry minBitmapSegmentEntry;
        IMinBitmapSegment currentSegment = this._currentSegment;
        if (segmentIndex == this._currentSegmentIndex && currentSegment != null) {
            currentSegment.fillSegmentEntry(this._tempSegmentEntry);
            minBitmapSegmentEntry = this._tempSegmentEntry;
        } else {
            minBitmapSegmentEntry = super.getSegmentEntry(segmentIndex);
        }
        return minBitmapSegmentEntry;
    }

    @Override
    @NotNull
    protected IMinBitmapSegment getSegment(int segmentIndex) {
        IMinBitmapSegment currentSegment = this._currentSegment;
        return segmentIndex == this._currentSegmentIndex && currentSegment != null ? currentSegment : super.getSegment(segmentIndex);
    }

    @Override
    public void update(int index2, long value2) {
        boolean bl = value2 != 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int segmentIndex = index2 / 256;
        IMinBitmapSegment currentSegment = this._currentSegment;
        if (segmentIndex != this._currentSegmentIndex || currentSegment == null) {
            this.forceCurrentSegment();
            this._currentSegment = currentSegment = this.getOrCreateSegment(segmentIndex);
            this._currentSegmentIndex = segmentIndex;
        }
        this._currentSegment = currentSegment.update(index2 % 256, value2);
        this._dirty = true;
    }

    private final void forceCurrentSegment() {
        IMinBitmapSegment segment = this._currentSegment;
        if (segment != null) {
            segment.fillSegmentEntry(this._tempSegmentEntry);
            this.get_indexes().update(this._currentSegmentIndex, this._tempSegmentEntry);
            segment.force();
        }
    }

    private final IMinBitmapSegment getOrCreateSegment(int segmentIndex) {
        IMinBitmapSegment iMinBitmapSegment;
        Pair<Integer, IMinBitmapSegment> pair = this.getLastSegment();
        int lastSegmentIndex = ((Number)pair.component1()).intValue();
        IMinBitmapSegment lastSegment = (IMinBitmapSegment)pair.component2();
        if (lastSegmentIndex == segmentIndex) {
            IMinBitmapSegment iMinBitmapSegment2 = lastSegment;
            iMinBitmapSegment = iMinBitmapSegment2;
            Intrinsics.checkNotNull((Object)iMinBitmapSegment2);
        } else if (lastSegmentIndex < segmentIndex) {
            long l;
            IMinBitmapSegment iMinBitmapSegment3;
            if (lastSegment != null) {
                RoaringArraySegment roaringArraySegment;
                IMinBitmapSegment iMinBitmapSegment4 = lastSegment;
                if (iMinBitmapSegment4 instanceof MinBitmapSegment) {
                    MinInvArraySegment invArraySegment = MinInvArraySegment.Companion.trySwitchInvArraySegment(this.get_buffer(), this._tempSegmentEntry);
                    if (invArraySegment != null) {
                        lastSegment = invArraySegment;
                        this.get_indexes().update(lastSegmentIndex, this._tempSegmentEntry);
                    } else {
                        RoaringArraySegment roaringArraySegment2 = RoaringArraySegment.Companion.trySwitchRoaringArrayFromMinBitmap(this.get_buffer(), this._tempSegmentEntry);
                        if (roaringArraySegment2 != null) {
                            lastSegment = roaringArraySegment2;
                            this.get_indexes().update(lastSegmentIndex, this._tempSegmentEntry);
                        }
                    }
                } else if (iMinBitmapSegment4 instanceof MinArraySegment && (roaringArraySegment = RoaringArraySegment.Companion.trySwitchRoaringArrayFromMinArray(this.get_buffer(), this._tempSegmentEntry)) != null) {
                    lastSegment = roaringArraySegment;
                }
            }
            long nextSegmentOffset = (iMinBitmapSegment3 = lastSegment) == null ? 0L : (l = iMinBitmapSegment3.getNextSegmentOffset());
            this.resize(nextSegmentOffset);
            this.clearCache();
            iMinBitmapSegment = new MinArraySegment(this.get_buffer(), nextSegmentOffset, 0);
        } else {
            throw new NotSupportedException();
        }
        return iMinBitmapSegment;
    }

    private final void resize(long nextSegmentOffset) {
        long minCapacity;
        long capacity = this.get_buffer().getCapacity();
        if (capacity < (minCapacity = nextSegmentOffset + (long)2048)) {
            long newSize = capacity * (long)2;
            if (newSize < 65536L) {
                newSize = 65536L;
            } else if (newSize >= Integer.MAX_VALUE) {
                newSize = Integer.MAX_VALUE;
            }
            if (newSize < minCapacity) {
                throw new RuntimeException("\u8d85\u8fc7\u6700\u5927\u7684\u6587\u4ef6\u5927\u5c0f.");
            }
            this.set_buffer(this.get_dataMetadata().resize(newSize));
        }
    }

    private final Pair<Integer, IMinBitmapSegment> getLastSegment() {
        IMinBitmapSegment segment = this._currentSegment;
        if (segment != null) {
            return new Pair((Object)this._currentSegmentIndex, (Object)segment);
        }
        Pair<Integer, MinBitmapSegmentEntry> pair = this.get_indexes().getLastSegmentEntry();
        int lastSegmentIndex = ((Number)pair.component1()).intValue();
        MinBitmapSegmentEntry lastSegmentEntry = (MinBitmapSegmentEntry)pair.component2();
        return lastSegmentIndex < 0 ? new Pair((Object)-1, null) : new Pair((Object)lastSegmentIndex, (Object)this.buildSegment(lastSegmentEntry));
    }

    @Override
    public void force() {
        if (this._dirty) {
            ListMetadata listMetadata = this.get_dataMetadata();
            long l = listMetadata.getVersion();
            listMetadata.setVersion(l + 1L);
            this.forceCurrentSegment();
            this.get_dataMetadata().force();
            this.get_indexes().force();
            this._dirty = false;
        }
    }
}

