/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import java.io.Closeable;
import java.util.BitSet;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IListEqualEx;
import kd.bos.olapServer.collections.IMutableList;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.dataEntities.DimensionKeysBase;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinMutableBitmap;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004:\u00014B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010%\u001a\u00060\bj\u0002`\u00112\u0006\u0010&\u001a\u00020\u0002H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0015\u0010*\u001a\u00020\u00022\n\u0010+\u001a\u00060\bj\u0002`\u0011H\u0096\u0002J\u0014\u0010,\u001a\u00020\u000e2\n\u0010+\u001a\u00060\bj\u0002`\tH\u0002J$\u0010-\u001a\u00060\bj\u0002`\t2\n\u0010+\u001a\u00060\bj\u0002`\u00112\n\u0010.\u001a\u00060\bj\u0002`\tH\u0002J \u0010/\u001a\u00060!j\u0002`\"2\n\u0010+\u001a\u00060\bj\u0002`\u00112\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0018\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0002H\u0002J\b\u00102\u001a\u00020(H\u0002J\b\u00103\u001a\u00020(H\u0002R\u0018\u0010\u0010\u001a\u00060\bj\u0002`\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0012\u0010 \u001a\u00060!j\u0002`\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00060!j\u0002`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinDimensionKeysList;", "Lkd/bos/olapServer/collections/IMutableList;", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "Lkd/bos/olapServer/collections/IListEqualEx;", "Lkd/bos/olapServer/collections/IDataContainer;", "_cube", "Lkd/bos/olapServer/metadata/Cube;", "_count", "", "Lkd/bos/olapServer/common/int;", "_getBitmap", "Lkotlin/Function2;", "Lkd/bos/olapServer/metadata/Dimension;", "Lkd/bos/olapServer/metadata/Member;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinMutableBitmap;", "(Lkd/bos/olapServer/metadata/Cube;ILkotlin/jvm/functions/Function2;)V", "Count", "Lkd/bos/olapServer/common/idx;", "getCount", "()I", "_dimStartIndex", "", "_dirtyMembers", "_dirtySize", "_dirtyStart", "_forceMembersSet", "Ljava/util/BitSet;", "_lastValues", "", "_memberBitmaps", "", "[Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinMutableBitmap;", "_needReadLastValue", "", "Lkd/bos/olapServer/common/bool;", "_remCount", "_smallMembersUpdateMode", "add", "value", "close", "", "force", "get", "index", "getBitmap", "getDimensionValue", "dimensionIndex", "isValueAtIndex", "isValueAtLastValues", "bitIndex", "putAndResetLastValues", "updateLastValues", "SimpleDimensionKeys", "bos-olap-core"})
public class MinDimensionKeysList
implements IMutableList<IDimensionKeys>,
IListEqualEx<IDimensionKeys>,
IDataContainer {
    @NotNull
    private final Cube _cube;
    private int _count;
    @NotNull
    private final Function2<Dimension, Member, IMinMutableBitmap> _getBitmap;
    @NotNull
    private final long[] _lastValues;
    private boolean _needReadLastValue;
    @NotNull
    private final int[] _dimStartIndex;
    private int _remCount;
    @NotNull
    private final IMinMutableBitmap[] _memberBitmaps;
    @NotNull
    private final int[] _dirtyMembers;
    private int _dirtyStart;
    private int _dirtySize;
    @NotNull
    private final BitSet _forceMembersSet;
    private final boolean _smallMembersUpdateMode;

    public MinDimensionKeysList(@NotNull Cube _cube, int _count, @NotNull Function2<? super Dimension, ? super Member, ? extends IMinMutableBitmap> _getBitmap) {
        Intrinsics.checkNotNullParameter((Object)_cube, (String)"_cube");
        Intrinsics.checkNotNullParameter(_getBitmap, (String)"_getBitmap");
        this._cube = _cube;
        this._count = _count;
        this._getBitmap = _getBitmap;
        this._needReadLastValue = this._count % 64 != 0;
        this._dimStartIndex = new int[this._cube.getDimensions().getCount()];
        this._remCount = this._count % 64;
        int membersCount = 0;
        int n = 0;
        int n2 = this._dimStartIndex.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                Dimension dim = (Dimension)this._cube.getDimensions().get(i);
                this._dimStartIndex[i] = membersCount;
                membersCount += dim.getMembers().getCount();
            } while (n <= n2);
        }
        this._lastValues = new long[membersCount];
        this._memberBitmaps = new IMinMutableBitmap[membersCount];
        boolean bl = this._smallMembersUpdateMode = membersCount < this._dimStartIndex.length * 64 * 4;
        if (this._smallMembersUpdateMode) {
            this._dirtyMembers = new int[0];
            this._forceMembersSet = new BitSet();
        } else {
            this._dirtyMembers = new int[this._dimStartIndex.length * 64];
            this._forceMembersSet = new BitSet(membersCount);
        }
    }

    @Override
    public int add(@NotNull IDimensionKeys value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        long[] lastValues = this._lastValues;
        int n = 0;
        int n2 = value2.getCount();
        if (n < n2) {
            do {
                int i = n++;
                int memberIndex = this._dimStartIndex[i] + value2.get(i);
                lastValues[memberIndex] = lastValues[memberIndex] | 1L << this._remCount;
                if (this._smallMembersUpdateMode) continue;
                MinDimensionKeysList minDimensionKeysList = this;
                int n3 = minDimensionKeysList._dirtySize;
                minDimensionKeysList._dirtySize = n3 + 1;
                this._dirtyMembers[n3] = memberIndex;
            } while (n < n2);
        }
        MinDimensionKeysList minDimensionKeysList = this;
        ++minDimensionKeysList._remCount;
        if (minDimensionKeysList._remCount == 64) {
            this.putAndResetLastValues();
        }
        minDimensionKeysList = this;
        n2 = minDimensionKeysList._count;
        minDimensionKeysList._count = n2 + 1;
        return n2;
    }

    @Override
    public int getCount() {
        return this._count;
    }

    private final IMinMutableBitmap getBitmap(int index2) {
        IMinMutableBitmap bitmap = this._memberBitmaps[index2];
        if (bitmap == null) {
            Dimension dim = null;
            Member member = null;
            int i = this._dimStartIndex.length - 1;
            while (i >= 0) {
                if (index2 >= this._dimStartIndex[i]) {
                    dim = (Dimension)this._cube.getDimensions().get(i);
                    member = (Member)dim.getMembers().get(index2 - this._dimStartIndex[i]);
                    break;
                }
                int n = i;
                i = n + -1;
            }
            if (dim == null || member == null) {
                Object[] objectArray = Res.INSTANCE.getMinDimensionKeysListException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MinDimensionKeysListException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{index2};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            this._memberBitmaps[index2] = bitmap = (IMinMutableBitmap)this._getBitmap.invoke(dim, member);
            int longIndex = this._count / 64;
            if (this._needReadLastValue) {
                this._lastValues[index2] = this._lastValues[index2] | bitmap.get(longIndex);
            }
        }
        return bitmap;
    }

    private final void putAndResetLastValues() {
        int longIndex = this._count / 64;
        long[] lastValues = this._lastValues;
        IMinMutableBitmap[] memberBitmaps = this._memberBitmaps;
        if (this._smallMembersUpdateMode) {
            int n = 0;
            int n2 = lastValues.length + -1;
            if (n <= n2) {
                do {
                    int i;
                    if (lastValues[i = n++] == 0L) continue;
                    IMinMutableBitmap iMinMutableBitmap = memberBitmaps[i];
                    IMinMutableBitmap bitmap = iMinMutableBitmap == null ? this.getBitmap(i) : iMinMutableBitmap;
                    bitmap.update(longIndex, lastValues[i]);
                    lastValues[i] = 0L;
                } while (n <= n2);
            }
        } else {
            int n;
            int dimSize = this._dimStartIndex.length;
            int[] dirtyMembers = this._dirtyMembers;
            int dirtyArraySize = this._dirtySize;
            int n3 = 0;
            if (n3 < dimSize) {
                do {
                    int j;
                    int dimIndex = n3++;
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(this._dirtyStart + dimIndex), (int)dirtyArraySize)), (int)dimSize);
                    int n4 = intProgression.getFirst();
                    int n5 = intProgression.getLast();
                    int n6 = intProgression.getStep();
                    if ((n6 <= 0 || n4 > n5) && (n6 >= 0 || n5 > n4)) continue;
                    do {
                        j = n4;
                        n4 += n6;
                        int i = dirtyMembers[j];
                        if (lastValues[i] == 0L) continue;
                        IMinMutableBitmap iMinMutableBitmap = memberBitmaps[i];
                        IMinMutableBitmap bitmap = iMinMutableBitmap == null ? this.getBitmap(i) : iMinMutableBitmap;
                        bitmap.update(longIndex, lastValues[i]);
                        this._forceMembersSet.set(i);
                        lastValues[i] = 0L;
                    } while (j != n5);
                } while (n3 < dimSize);
            }
            if ((n3 = 0) < (n = this._dirtyStart)) {
                do {
                    int i = n3++;
                    lastValues[dirtyMembers[i]] = 0L;
                } while (n3 < n);
            }
            this._dirtyStart = 0;
            this._dirtySize = 0;
        }
        this._needReadLastValue = false;
        this._remCount = 0;
    }

    private final void updateLastValues() {
        if (this._remCount > 0) {
            if (this._remCount >= 64) {
                Object[] objectArray = Res.INSTANCE.getMinDimensionKeysListException_2();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MinDimensionKeysListException_2");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this._remCount};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            int longIndex = this._count / 64;
            long[] lastValues = this._lastValues;
            if (this._smallMembersUpdateMode) {
                int n = 0;
                int n2 = lastValues.length + -1;
                if (n <= n2) {
                    do {
                        int i;
                        if (lastValues[i = n++] == 0L) continue;
                        IMinMutableBitmap iMinMutableBitmap = this._memberBitmaps[i];
                        IMinMutableBitmap bitmap = iMinMutableBitmap == null ? this.getBitmap(i) : iMinMutableBitmap;
                        bitmap.update(longIndex, lastValues[i]);
                    } while (n <= n2);
                }
            } else {
                int dimSize = this._dimStartIndex.length;
                int lastUpdateMemberIndex = -1;
                int n = 0;
                if (n < dimSize) {
                    do {
                        int j;
                        int dimIndex = n++;
                        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(this._dirtyStart + dimIndex), (int)this._dirtySize)), (int)dimSize);
                        int n3 = intProgression.getFirst();
                        int n4 = intProgression.getLast();
                        int n5 = intProgression.getStep();
                        if ((n5 <= 0 || n3 > n4) && (n5 >= 0 || n4 > n3)) continue;
                        do {
                            j = n3;
                            n3 += n5;
                            int i = this._dirtyMembers[j];
                            if (i == lastUpdateMemberIndex || lastValues[i] == 0L) continue;
                            IMinMutableBitmap iMinMutableBitmap = this._memberBitmaps[i];
                            IMinMutableBitmap bitmap = iMinMutableBitmap == null ? this.getBitmap(i) : iMinMutableBitmap;
                            bitmap.update(longIndex, lastValues[i]);
                            this._forceMembersSet.set(i);
                            lastUpdateMemberIndex = i;
                        } while (j != n4);
                    } while (n < dimSize);
                }
                this._dirtyStart = this._dirtySize;
            }
        }
    }

    @Override
    public boolean isValueAtIndex(int index2, @NotNull IDimensionKeys value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        int longIndex = index2 / 64;
        int bitIndex = index2 % 64;
        if (longIndex == this._count / 64) {
            if (bitIndex < this._remCount) {
                return this.isValueAtLastValues(bitIndex, value2);
            }
            Object[] objectArray = Res.INSTANCE.getMinDimensionKeysListException_3();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MinDimensionKeysListException_3");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{index2, this.getCount()};
            throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
        }
        int n = 0;
        int n2 = value2.getCount();
        if (n < n2) {
            do {
                int i;
                long longValue;
                if ((longValue = this.getBitmap(this._dimStartIndex[i = n++] + value2.get(i)).get(longIndex)) != 0L && CommonTypesKt.getBit(longValue, bitIndex)) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    private final boolean isValueAtLastValues(int bitIndex, IDimensionKeys value2) {
        int n = 0;
        int n2 = value2.getCount();
        if (n < n2) {
            do {
                long longValue;
                int i = n++;
                int memberIndex = this._dimStartIndex[i] + value2.get(i);
                if (this._needReadLastValue) {
                    this.getBitmap(memberIndex);
                }
                if ((longValue = this._lastValues[memberIndex]) != 0L && CommonTypesKt.getBit(longValue, bitIndex)) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    @Override
    @NotNull
    public IDimensionKeys get(int index2) {
        return new SimpleDimensionKeys(index2, this);
    }

    private final int getDimensionValue(int index2, int dimensionIndex) {
        int end;
        int longIndex = index2 / 64;
        int bitIndex = index2 % 64;
        int start = this._dimStartIndex[dimensionIndex];
        int n = end = dimensionIndex < this._dimStartIndex.length - 1 ? this._dimStartIndex[dimensionIndex + 1] : this._memberBitmaps.length;
        if (longIndex == this._count / 64) {
            if (bitIndex < this._remCount) {
                int n2 = start;
                if (n2 < end) {
                    do {
                        long longValue;
                        int i = n2++;
                        if (this._needReadLastValue) {
                            this.getBitmap(i);
                        }
                        if ((longValue = this._lastValues[i]) == 0L || !CommonTypesKt.getBit(longValue, bitIndex)) continue;
                        return i - start;
                    } while (n2 < end);
                }
                Object[] objectArray = Res.INSTANCE.getCommonException_6();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_6");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{index2};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            Object[] objectArray = Res.INSTANCE.getMinDimensionKeysListException_3();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MinDimensionKeysListException_3");
            Object[] objectArray3 = objectArray;
            objectArray = new Object[]{index2, this.getCount()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
        }
        int n3 = start;
        if (n3 < end) {
            do {
                int i;
                long longValue;
                if ((longValue = this.getBitmap(i = n3++).get(longIndex)) == 0L || !CommonTypesKt.getBit(longValue, bitIndex)) continue;
                return i - start;
            } while (n3 < end);
        }
        Object[] objectArray = Res.INSTANCE.getCommonException_6();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_6");
        Object[] objectArray4 = objectArray;
        objectArray = new Object[]{index2};
        throw Res.INSTANCE.getRuntimeException((String)objectArray4, objectArray);
    }

    @Override
    public void force() {
        this.updateLastValues();
        if (this._smallMembersUpdateMode) {
            for (IMinMutableBitmap memberBitMap : this._memberBitmaps) {
                IDataContainer iDataContainer;
                IDataContainer iDataContainer2 = iDataContainer = memberBitMap instanceof IDataContainer ? (IDataContainer)((Object)memberBitMap) : null;
                if (iDataContainer == null) continue;
                iDataContainer.force();
            }
        } else {
            int i = this._forceMembersSet.nextSetBit(0);
            while (i >= 0) {
                IDataContainer iDataContainer;
                IMinMutableBitmap iMinMutableBitmap = this._memberBitmaps[i];
                IDataContainer iDataContainer3 = iDataContainer = iMinMutableBitmap instanceof IDataContainer ? (IDataContainer)((Object)iMinMutableBitmap) : null;
                if (iDataContainer != null) {
                    iDataContainer.force();
                }
                i = this._forceMembersSet.nextSetBit(i + 1);
            }
            this._forceMembersSet.clear();
        }
    }

    @Override
    public void close() {
        for (IMinMutableBitmap memberBitMap : this._memberBitmaps) {
            Closeable closeable;
            Closeable closeable2 = closeable = memberBitMap instanceof Closeable ? (Closeable)((Object)memberBitMap) : null;
            if (closeable == null) continue;
            closeable.close();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0019\u0010\f\u001a\u00060\u0003j\u0002`\r2\n\u0010\u000e\u001a\u00060\u0003j\u0002`\rH\u0096\u0002R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinDimensionKeysList$SimpleDimensionKeys;", "Lkd/bos/olapServer/dataEntities/DimensionKeysBase;", "index", "", "Lkd/bos/olapServer/common/idx;", "owner", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinDimensionKeysList;", "(ILkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinDimensionKeysList;)V", "equals", "", "other", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "get", "Lkd/bos/olapServer/common/int;", "dimensionIndex", "bos-olap-core"})
    private static final class SimpleDimensionKeys
    extends DimensionKeysBase {
        private final int index;
        @NotNull
        private final MinDimensionKeysList owner;

        public SimpleDimensionKeys(int index2, @NotNull MinDimensionKeysList owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner._cube);
            this.index = index2;
            this.owner = owner;
        }

        @Override
        public int get(int dimensionIndex) {
            return this.owner.getDimensionValue(this.index, dimensionIndex);
        }

        @Override
        public boolean equals(@NotNull IDimensionKeys other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other.getCount() == this.getCount() && this.owner.isValueAtIndex(this.index, other);
        }
    }
}

