/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import java.io.Closeable;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.collections.IImmutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.ListMetadata;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapListSegmentFacade;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 /2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001/B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001bH\u0004J\b\u0010$\u001a\u00020%H\u0004J\b\u0010&\u001a\u00020\u0000H\u0016J\b\u0010'\u001a\u00020%H\u0016J\u0019\u0010(\u001a\u00060\u0016j\u0002`\u00172\n\u0010)\u001a\u00060\u001dj\u0002`*H\u0096\u0002J\u0014\u0010+\u001a\u00020\u00192\n\u0010,\u001a\u00060\u001dj\u0002`-H\u0014J\u0014\u0010.\u001a\u00020\u001b2\n\u0010,\u001a\u00060\u001dj\u0002`-H\u0014R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u00060"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinImmutableBitmap;", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/collections/ICloneable;", "_indexMetadata", "Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "_dataMetadata", "(Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;)V", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "get_buffer", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "set_buffer", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;)V", "get_dataMetadata", "()Lkd/bos/olapServer/memoryMappedFiles/ListMetadata;", "get_indexMetadata", "_indexes", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapListSegmentFacade;", "get_indexes", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapListSegmentFacade;", "_initVersion", "", "Lkd/bos/olapServer/common/long;", "_lastGetSegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_lastGetSegmentEntry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "_lastGetSegmentEntryIndex", "", "_lastGetSegmentIndex", "isDataChanged", "", "()Z", "buildSegment", "entry", "clearCache", "", "clone", "close", "get", "index", "Lkd/bos/olapServer/common/idx;", "getSegment", "segmentIndex", "Lkd/bos/olapServer/common/int;", "getSegmentEntry", "Companion", "bos-olap-core"})
public class MinImmutableBitmap
implements IImmutableBitmap,
Closeable,
ICloneable<MinImmutableBitmap> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListMetadata _indexMetadata;
    @NotNull
    private final ListMetadata _dataMetadata;
    @NotNull
    private final MinBitmapListSegmentFacade _indexes;
    @NotNull
    private IByteBuffer _buffer;
    private final long _initVersion;
    @Nullable
    private IMinBitmapSegment _lastGetSegment;
    private int _lastGetSegmentIndex;
    private int _lastGetSegmentEntryIndex;
    @NotNull
    private final MinBitmapSegmentEntry _lastGetSegmentEntry;
    public static final int segmentLength = 256;

    public MinImmutableBitmap(@NotNull ListMetadata _indexMetadata, @NotNull ListMetadata _dataMetadata) {
        Intrinsics.checkNotNullParameter((Object)_indexMetadata, (String)"_indexMetadata");
        Intrinsics.checkNotNullParameter((Object)_dataMetadata, (String)"_dataMetadata");
        this._indexMetadata = _indexMetadata;
        this._dataMetadata = _dataMetadata;
        this._indexes = new MinBitmapListSegmentFacade(this._indexMetadata);
        this._buffer = this._dataMetadata.getContentBuffer();
        this._initVersion = this._dataMetadata.getVersion();
        this._lastGetSegmentIndex = -1;
        this._lastGetSegmentEntryIndex = -1;
        this._lastGetSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
    }

    @NotNull
    protected final ListMetadata get_indexMetadata() {
        return this._indexMetadata;
    }

    @NotNull
    protected final ListMetadata get_dataMetadata() {
        return this._dataMetadata;
    }

    @NotNull
    protected final MinBitmapListSegmentFacade get_indexes() {
        return this._indexes;
    }

    @NotNull
    protected final IByteBuffer get_buffer() {
        return this._buffer;
    }

    protected final void set_buffer(@NotNull IByteBuffer iByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)iByteBuffer, (String)"<set-?>");
        this._buffer = iByteBuffer;
    }

    @Override
    public long get(int index2) {
        int remainder = index2 % 256;
        int segmentIndex = index2 / 256;
        MinBitmapSegmentEntry entry = this.getSegmentEntry(segmentIndex);
        if (remainder < entry.getFrontEmptyCount() || remainder >= entry.getFrontEmptyCount() + entry.getValidCount()) {
            return 0L;
        }
        return this.getSegment(segmentIndex).get(remainder);
    }

    @NotNull
    protected IMinBitmapSegment getSegment(int segmentIndex) {
        IMinBitmapSegment segment = this._lastGetSegment;
        if (this._lastGetSegmentIndex != segmentIndex || segment == null) {
            segment = this.buildSegment(this.getSegmentEntry(segmentIndex));
            this._lastGetSegmentIndex = segmentIndex;
            this._lastGetSegment = segment;
        }
        return segment;
    }

    @NotNull
    protected MinBitmapSegmentEntry getSegmentEntry(int segmentIndex) {
        MinBitmapSegmentEntry entry = this._lastGetSegmentEntry;
        if (this._lastGetSegmentEntryIndex != segmentIndex) {
            this._indexes.fillSegmentEntry(segmentIndex, entry);
            this._lastGetSegmentEntryIndex = segmentIndex;
        }
        return entry;
    }

    @NotNull
    protected final IMinBitmapSegment buildSegment(@NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return entry.isBitmap() ? (IMinBitmapSegment)new MinBitmapSegment(this._buffer, entry.getPosition(), entry.getFrontEmptyCount(), entry.getValidCount()) : MinArraySegment.Companion.create(this._buffer, entry.getPosition());
    }

    @Override
    public void close() {
        this._indexMetadata.close();
        this._dataMetadata.close();
    }

    protected final boolean isDataChanged() {
        return this._initVersion != this._dataMetadata.getVersion();
    }

    protected final void clearCache() {
        this._lastGetSegment = null;
        this._lastGetSegmentIndex = -1;
        this._lastGetSegmentEntryIndex = -1;
    }

    @Override
    @NotNull
    public MinImmutableBitmap clone() {
        return this.isDataChanged() ? new MinImmutableBitmap(this._indexMetadata, this._dataMetadata) : this;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinImmutableBitmap$Companion;", "", "()V", "segmentLength", "", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

