/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0019\u0010\u0017\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0018\u001a\u00060\bj\u0002`\tH\u0096\u0002J \u0010\u0019\u001a\u00020\u00012\n\u0010\u0018\u001a\u00060\bj\u0002`\t2\n\u0010\u001a\u001a\u00060\u0005j\u0002`\u0006H\u0016R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinInvArraySegment;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer/common/long;", "arrayCount", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;JI)V", "NextSegmentOffset", "getNextSegmentOffset", "()J", "_realSegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinArraySegment;", "getArrayCount", "()I", "fillSegmentEntry", "", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "force", "get", "index", "update", "value", "Companion", "bos-olap-core"})
public final class MinInvArraySegment
implements IMinBitmapSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinArraySegment _realSegment;
    @NotNull
    private static final AtomicReference<long[]> longArrayRef = new AtomicReference();

    public MinInvArraySegment(@NotNull IByteBuffer buffer, long offset, int arrayCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this._realSegment = new MinArraySegment(buffer, offset, arrayCount);
    }

    public final int getArrayCount() {
        return this._realSegment.getArrayCount();
    }

    @Override
    @NotNull
    public IMinBitmapSegment update(int index2, long value2) {
        if (value2 != -1L) {
            this._realSegment.update(index2, value2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    @Override
    public long get(int index2) {
        return this._realSegment.get(index2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void force() {
        throw new NotSupportedException();
    }

    @Override
    public void fillSegmentEntry(@NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        throw new NotSupportedException();
    }

    @Override
    public long getNextSegmentOffset() {
        return this._realSegment.getNextSegmentOffset();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\n\u0010\u000e\u001a\u00060\bj\u0002`\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinInvArraySegment$Companion;", "", "()V", "longArrayRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getLongArrayCache", "getNegativeOneCount", "", "buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "position", "", "Lkd/bos/olapServer/common/long;", "validCount", "Lkd/bos/olapServer/common/int;", "releaseLongArrayCache", "", "longArray", "switchMinInvArraySegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinInvArraySegment;", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "trySwitchInvArraySegment", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final long[] getLongArrayCache() {
            long[] longArray = longArrayRef.getAndSet(null);
            if (longArray == null) {
                longArray = new long[256];
            }
            long[] lArray = longArray;
            return lArray;
        }

        private final void releaseLongArrayCache(long[] longArray) {
            longArrayRef.compareAndSet(null, longArray);
        }

        @Nullable
        public final MinInvArraySegment trySwitchInvArraySegment(@NotNull IByteBuffer buffer, @NotNull MinBitmapSegmentEntry entry) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            int negativeOneCount = this.getNegativeOneCount(buffer, entry.getPosition(), entry.getValidCount());
            int bitmapSize = entry.getValidCount() * 8;
            int invArraySize = (256 - negativeOneCount) * 9 + 1;
            int n = 256 - negativeOneCount;
            return (0 <= n ? n <= 127 : false) && bitmapSize > invArraySize ? this.switchMinInvArraySegment(buffer, entry) : (MinInvArraySegment)null;
        }

        private final MinInvArraySegment switchMinInvArraySegment(IByteBuffer buffer, MinBitmapSegmentEntry entry) {
            long end;
            int it;
            int element$iv;
            int validCount = entry.getValidCount();
            long position = entry.getPosition();
            int frontEmptyCount = entry.getFrontEmptyCount();
            MinInvArraySegment invArraySegment = new MinInvArraySegment(buffer, position, 0);
            long[] arrayLong = this.getLongArrayCache();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)validCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                arrayLong[it] = buffer.getLong(position + (long)(it * 8));
            }
            $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)frontEmptyCount);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                invArraySegment.update(it, 0L);
            }
            $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)validCount);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                invArraySegment.update(it + frontEmptyCount, arrayLong[it]);
            }
            this.releaseLongArrayCache(arrayLong);
            $this$forEach$iv = (Iterable)RangesKt.until((int)(frontEmptyCount + validCount), (int)256);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                invArraySegment.update(it, 0L);
            }
            long start = invArraySegment.getNextSegmentOffset();
            if (start <= (end = position + (long)(validCount * 8))) {
                buffer.clearData(start, end - start);
            }
            entry.setBitmap(false);
            int arrayCount = invArraySegment.getArrayCount();
            boolean bl = 0 <= arrayCount ? arrayCount <= 127 : false;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            buffer.putByte(position, (byte)(arrayCount | 0x80));
            return invArraySegment;
        }

        private final int getNegativeOneCount(IByteBuffer buffer, long position, int validCount) {
            int negativeOneCount = 0;
            Iterable $this$forEach$iv = (Iterable)RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)position, (long)(position + (long)(validCount * 8)))), (long)8L);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                long element$iv;
                long i = element$iv = ((LongIterator)iterator).nextLong();
                boolean bl = false;
                long v = buffer.getLong(i);
                if (v != -1L) continue;
                int n = negativeOneCount;
                negativeOneCount = n + 1;
            }
            return negativeOneCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

