/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmaps;

import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u0016\u001a\u00060\bj\u0002`\t2\n\u0010\u0017\u001a\u00060\bj\u0002`\t2\n\u0010\u0018\u001a\u00060\bj\u0002`\t2\n\u0010\u0019\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0019\u0010\u001f\u001a\u00060\u0005j\u0002`\u00062\n\u0010 \u001a\u00060\bj\u0002`\tH\u0096\u0002J\u0018\u0010!\u001a\u00060\bj\u0002`\t2\n\u0010\"\u001a\u00060\bj\u0002`\tH\u0002J \u0010#\u001a\u00020\u00012\n\u0010 \u001a\u00060\bj\u0002`\t2\n\u0010$\u001a\u00060\u0005j\u0002`\u0006H\u0016R\u0018\u0010\u000b\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\bj\u0002`\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/RoaringArraySegment;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer/common/long;", "_arrayCount", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;JI)V", "NextSegmentOffset", "getNextSegmentOffset", "()J", "_cachedRangeInnerIndex", "_cachedRangeMax", "_cachedRangeMin", "_indexOffset", "_lastLongIndex", "lastLongIndex", "getLastLongIndex", "()I", "binarySearch", "lo", "hi", "key", "fillSegmentEntry", "", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "force", "get", "index", "getBitIndex", "i", "update", "value", "Companion", "bos-olap-core"})
public final class RoaringArraySegment
implements IMinBitmapSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IByteBuffer _buffer;
    private final long offset;
    private int _arrayCount;
    private final long _indexOffset;
    private int _lastLongIndex;
    private int _cachedRangeMin;
    private int _cachedRangeMax;
    private int _cachedRangeInnerIndex;
    @NotNull
    private static final AtomicReference<long[]> longArrayRef = new AtomicReference();
    @NotNull
    private static final AtomicReference<byte[]> byteArrayRef = new AtomicReference();

    public RoaringArraySegment(@NotNull IByteBuffer _buffer, long offset, int _arrayCount) {
        Intrinsics.checkNotNullParameter((Object)_buffer, (String)"_buffer");
        this._buffer = _buffer;
        this.offset = offset;
        this._arrayCount = _arrayCount;
        this._indexOffset = this.offset + 1L + 1L;
        this._lastLongIndex = -1;
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
    }

    private final int getLastLongIndex() {
        if (this._lastLongIndex < 0 && this._arrayCount > 0) {
            this._lastLongIndex = this.getBitIndex(this._arrayCount - 1) / 64;
        }
        return this._lastLongIndex;
    }

    @Override
    public long get(int index2) {
        int realIndex;
        boolean bl = 0 <= index2 ? index2 < 256 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this._arrayCount <= 0 || index2 > this.getLastLongIndex()) {
            return 0L;
        }
        int start = index2 << 6;
        int end = start + 64;
        int n = this._cachedRangeMin < 0 ? this.binarySearch(0, this._arrayCount - 1, start) : (start >= this._cachedRangeMin ? (start < this._cachedRangeMax ? -(this._cachedRangeInnerIndex + 1) : (start == this._cachedRangeMax ? this._cachedRangeInnerIndex : this.binarySearch(this._cachedRangeInnerIndex + 1, this._arrayCount - 1, start))) : (realIndex = this.binarySearch(0, this._cachedRangeInnerIndex - 1, start)));
        if (realIndex < 0) {
            realIndex = -realIndex - 1;
        }
        long bitmap = 0L;
        while (realIndex < this._arrayCount) {
            int n2 = realIndex;
            realIndex = n2 + 1;
            int bitIndex = this.getBitIndex(n2);
            if (bitIndex >= end) continue;
            bitmap |= 1L << bitIndex - start;
        }
        return bitmap;
    }

    @Override
    @NotNull
    public IMinBitmapSegment update(int index2, long value2) {
        boolean bl = 0 <= index2 ? index2 < 256 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = value2 != 0L;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int lastLong = this.getLastLongIndex();
        if (lastLong < index2) {
            long bitSet = value2;
            long position = this._indexOffset + (long)(this._arrayCount * 2);
            int realBitIndex = 0;
            while (bitSet != 0L) {
                int numberOfTrailingZero = Long.numberOfTrailingZeros(bitSet);
                this._buffer.putShort(position, (short)((index2 << 6) + realBitIndex + numberOfTrailingZero));
                RoaringArraySegment roaringArraySegment = this;
                int n = roaringArraySegment._arrayCount;
                roaringArraySegment._arrayCount = n + 1;
                position += (long)2;
                bitSet = bitSet >>> numberOfTrailingZero >>> 1;
                realBitIndex += numberOfTrailingZero + 1;
            }
        } else {
            throw new NotSupportedException();
        }
        this._lastLongIndex = index2;
        return this;
    }

    @Override
    public void force() {
        int n = this._arrayCount;
        n = 1 <= n ? (n <= 256 ? 1 : 0) : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._buffer.putShort(this.offset, (short)(this._arrayCount - 1));
    }

    @Override
    public void fillSegmentEntry(@NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        throw new NotSupportedException();
    }

    @Override
    public long getNextSegmentOffset() {
        return this._indexOffset + (long)(this._arrayCount * 2);
    }

    private final int getBitIndex(int i) {
        return this._buffer.getShort(this._indexOffset + (long)(i * 2));
    }

    private final int binarySearch(int lo, int hi, int key) {
        int x;
        int low = lo;
        int high = hi;
        this._cachedRangeMin = key;
        while (low + 32 <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = this.getBitIndex(middleIndex);
            if (middleValue < key) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > key) {
                high = middleIndex - 1;
                continue;
            }
            this._cachedRangeMax = this._cachedRangeMin;
            this._cachedRangeInnerIndex = middleIndex;
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int value2 = this.getBitIndex(x);
            if (value2 < key) continue;
            this._cachedRangeMax = value2;
            if (value2 != key) break;
            this._cachedRangeInnerIndex = x;
            return x;
        }
        if (x > high) {
            this._cachedRangeMax = x < this._arrayCount ? this.getBitIndex(x) : Integer.MAX_VALUE;
        }
        this._cachedRangeInnerIndex = x;
        return -(x + 1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/RoaringArraySegment$Companion;", "", "()V", "byteArrayRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "longArrayRef", "", "getByteArrayCache", "getLongArrayCache", "releaseByteArrayCache", "", "byteArray", "releaseLongArrayCache", "longArray", "trySwitchRoaringArrayFromMinArray", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/RoaringArraySegment;", "buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "trySwitchRoaringArrayFromMinBitmap", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final long[] getLongArrayCache() {
            long[] longArray = longArrayRef.getAndSet(null);
            if (longArray == null) {
                longArray = new long[256];
            }
            long[] lArray = longArray;
            return lArray;
        }

        private final void releaseLongArrayCache(long[] longArray) {
            longArrayRef.compareAndSet(null, longArray);
        }

        private final byte[] getByteArrayCache() {
            byte[] byteArray = byteArrayRef.getAndSet(null);
            if (byteArray == null) {
                byteArray = new byte[256];
            }
            byte[] byArray = byteArray;
            return byArray;
        }

        private final void releaseByteArrayCache(byte[] byteArray) {
            byteArrayRef.compareAndSet(null, byteArray);
        }

        @Nullable
        public final RoaringArraySegment trySwitchRoaringArrayFromMinArray(@NotNull IByteBuffer buffer, @NotNull MinBitmapSegmentEntry entry) {
            RoaringArraySegment roaringArraySegment;
            int index2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            long position = entry.getPosition();
            int arrayCount = buffer.getByte(position);
            int allBitCount = 0;
            int arraySegmentSpace = arrayCount * 9 + 1;
            int n = 0;
            int n2 = arrayCount;
            if (n < n2) {
                do {
                    long value2;
                    if ((allBitCount += Long.bitCount(value2 = buffer.getLong(position + (long)2 + (long)((index2 = n++) * 9)))) <= 256 && arraySegmentSpace > allBitCount * 2 + 2) continue;
                    return null;
                } while (n < n2);
            }
            if (allBitCount <= 256 && arraySegmentSpace > allBitCount * 2 + 2) {
                byte[] byteArray = this.getByteArrayCache();
                long[] longArray = this.getLongArrayCache();
                index2 = 0;
                int n3 = arrayCount;
                if (index2 < n3) {
                    do {
                        int index3 = index2++;
                        byteArray[index3] = buffer.getByte(position + 1L + (long)(index3 * 9));
                        longArray[index3] = buffer.getLong(position + (long)2 + (long)(index3 * 9));
                    } while (index2 < n3);
                }
                RoaringArraySegment roaringArraySegment2 = new RoaringArraySegment(buffer, position, 0);
                n3 = 0;
                int n4 = arrayCount;
                if (n3 < n4) {
                    do {
                        int index4 = n3++;
                        roaringArraySegment2.update(byteArray[index4] & 0xFF, longArray[index4]);
                    } while (n3 < n4);
                }
                roaringArraySegment2.force();
                this.releaseByteArrayCache(byteArray);
                this.releaseLongArrayCache(longArray);
                roaringArraySegment = roaringArraySegment2;
            } else {
                roaringArraySegment = null;
            }
            return roaringArraySegment;
        }

        @Nullable
        public final RoaringArraySegment trySwitchRoaringArrayFromMinBitmap(@NotNull IByteBuffer buffer, @NotNull MinBitmapSegmentEntry entry) {
            RoaringArraySegment roaringArraySegment;
            int index2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            long position = entry.getPosition();
            int validCount = entry.getValidCount();
            int allBitCount = 0;
            int bitmapSpace = validCount * 8;
            int n = 0;
            if (n < validCount) {
                do {
                    long value2;
                    if ((allBitCount += Long.bitCount(value2 = buffer.getLong(position + (long)((index2 = n++) * 8)))) <= 256 && bitmapSpace > allBitCount * 2 + 2) continue;
                    return null;
                } while (n < validCount);
            }
            if (allBitCount <= 256 && bitmapSpace > allBitCount * 2 + 2) {
                long[] longArray = this.getLongArrayCache();
                index2 = 0;
                if (index2 < validCount) {
                    do {
                        int index3 = index2++;
                        longArray[index3] = buffer.getLong(position + (long)(index3 * 8));
                    } while (index2 < validCount);
                }
                RoaringArraySegment roaringArraySegment2 = new RoaringArraySegment(buffer, position, 0);
                int frontEmptyCount = entry.getFrontEmptyCount();
                int n2 = 0;
                if (n2 < validCount) {
                    do {
                        int index4;
                        long value3;
                        if ((value3 = longArray[index4 = n2++]) == 0L) continue;
                        roaringArraySegment2.update(frontEmptyCount + index4, longArray[index4]);
                    } while (n2 < validCount);
                }
                roaringArraySegment2.force();
                this.releaseLongArrayCache(longArray);
                entry.setBitmap(false);
                roaringArraySegment = roaringArraySegment2;
            } else {
                roaringArraySegment = null;
            }
            return roaringArraySegment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

