/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import java.io.Closeable;
import kd.bos.olapServer.collections.IImmutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinBitmapData;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinImmutableListSegmentFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B!\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0015H\u0004J\b\u0010!\u001a\u00020\"H\u0004J\b\u0010#\u001a\u00020\"H\u0016J\u0019\u0010$\u001a\u00060%j\u0002`&2\n\u0010'\u001a\u00060\u0006j\u0002`(H\u0096\u0002J\u0014\u0010)\u001a\u00020\u00132\n\u0010*\u001a\u00060\u0006j\u0002`\u0007H\u0014J\u0014\u0010+\u001a\u00020\u00152\n\u0010*\u001a\u00060\u0006j\u0002`\u0007H\u0014R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\n\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/AbstractMinImmutableBitmap;", "TFacade", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "Ljava/io/Closeable;", "memberId", "", "Lkd/bos/olapServer/common/int;", "data", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "indexes", "(ILkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;)V", "_lastDataBuffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "get_lastDataBuffer", "()Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "set_lastDataBuffer", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;)V", "_lastGetSegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_lastGetSegmentEntry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "_lastGetSegmentEntryIndex", "_lastGetSegmentIndex", "getData", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "getIndexes", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;", "getMemberId", "()I", "buildSegment", "entry", "clearCache", "", "close", "get", "", "Lkd/bos/olapServer/common/long;", "index", "Lkd/bos/olapServer/common/idx;", "getSegment", "segmentIndex", "getSegmentEntry", "bos-olap-core"})
public class AbstractMinImmutableBitmap<TFacade extends MinImmutableListSegmentFacade>
implements IImmutableBitmap,
Closeable {
    private final int memberId;
    @NotNull
    private final MinBitmapData data;
    @NotNull
    private final TFacade indexes;
    @NotNull
    private IByteBuffer _lastDataBuffer;
    @Nullable
    private IMinBitmapSegment _lastGetSegment;
    private int _lastGetSegmentIndex;
    private int _lastGetSegmentEntryIndex;
    @NotNull
    private final MinBitmapSegmentEntry _lastGetSegmentEntry;

    public AbstractMinImmutableBitmap(int memberId, @NotNull MinBitmapData data, @NotNull TFacade indexes) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        this.memberId = memberId;
        this.data = data;
        this.indexes = indexes;
        this._lastDataBuffer = this.data.getLastDataBuffer(this.memberId);
        boolean bl = this.memberId >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._lastGetSegmentIndex = -1;
        this._lastGetSegmentEntryIndex = -1;
        this._lastGetSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
    }

    protected final int getMemberId() {
        return this.memberId;
    }

    @NotNull
    protected final MinBitmapData getData() {
        return this.data;
    }

    @NotNull
    protected final TFacade getIndexes() {
        return this.indexes;
    }

    @NotNull
    protected final IByteBuffer get_lastDataBuffer() {
        return this._lastDataBuffer;
    }

    protected final void set_lastDataBuffer(@NotNull IByteBuffer iByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)iByteBuffer, (String)"<set-?>");
        this._lastDataBuffer = iByteBuffer;
    }

    @Override
    public long get(int index2) {
        int remainder = index2 % 256;
        int segmentIndex = index2 / 256;
        MinBitmapSegmentEntry entry = this.getSegmentEntry(segmentIndex);
        if (remainder < entry.getFrontEmptyCount() || remainder >= entry.getFrontEmptyCount() + entry.getValidCount()) {
            return 0L;
        }
        return this.getSegment(segmentIndex).get(remainder);
    }

    @NotNull
    protected IMinBitmapSegment getSegment(int segmentIndex) {
        IMinBitmapSegment segment = this._lastGetSegment;
        if (this._lastGetSegmentIndex != segmentIndex || segment == null) {
            segment = this.buildSegment(this.getSegmentEntry(segmentIndex));
            this._lastGetSegmentIndex = segmentIndex;
            this._lastGetSegment = segment;
        }
        return segment;
    }

    @NotNull
    protected MinBitmapSegmentEntry getSegmentEntry(int segmentIndex) {
        MinBitmapSegmentEntry entry = this._lastGetSegmentEntry;
        if (this._lastGetSegmentEntryIndex != segmentIndex) {
            ((MinImmutableListSegmentFacade)this.indexes).fillSegmentEntry(segmentIndex, entry);
            this._lastGetSegmentEntryIndex = segmentIndex;
        }
        return entry;
    }

    @NotNull
    protected final IMinBitmapSegment buildSegment(@NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        long position = entry.getPosition();
        IByteBuffer buffer = null;
        long l = position;
        if (l == 0x7FFFFFFEL) {
            position = 0L;
            buffer = this._lastDataBuffer;
        } else if (l == Integer.MAX_VALUE) {
            position = 2048L;
            buffer = this._lastDataBuffer;
        } else {
            buffer = this.data.getMainDataBuffer();
        }
        entry.setPosition(position);
        return entry.isBitmap() ? (IMinBitmapSegment)new MinBitmapSegment(buffer, position, entry.getFrontEmptyCount(), entry.getValidCount()) : MinArraySegment.Companion.create(buffer, position);
    }

    protected final void clearCache() {
        this._lastGetSegment = null;
        this._lastGetSegmentIndex = -1;
        this._lastGetSegmentEntryIndex = -1;
    }

    @Override
    public void close() {
        this._lastDataBuffer.close();
        this.data.close();
        ((MinImmutableListSegmentFacade)this.indexes).close();
    }
}

