/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.LastDataMetadata;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MainDataMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u0006\u0010\u0013\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u0012\u0010\u0015\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ \u0010\u0016\u001a\u00020\u00172\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0006\u0010\u0018\u001a\u00020\bJ\u0014\u0010\u0019\u001a\u00020\u000b2\n\u0010\u001a\u001a\u00060\u0017j\u0002`\u001bH\u0002J.\u0010\u001c\u001a\u00060\u0017j\u0002`\u001b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u001d\u001a\u00060\u0017j\u0002`\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "Lkd/bos/olapServer/collections/ICloneable;", "mainData", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MainDataMetadata;", "lastData", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/LastDataMetadata;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MainDataMetadata;Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/LastDataMetadata;)V", "_lastDataBuffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_mainDataBuffer", "clearSegment", "", "memberId", "", "Lkd/bos/olapServer/common/int;", "firstSegment", "", "Lkd/bos/olapServer/common/bool;", "clone", "close", "force", "getLastDataBuffer", "getLastDataSegmentPosition", "", "getMainDataBuffer", "resize", "minCapacity", "Lkd/bos/olapServer/common/long;", "startCopySegment", "byteCount", "Companion", "bos-olap-core"})
public final class MinBitmapData
implements ICloneable<MinBitmapData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MainDataMetadata mainData;
    @NotNull
    private final LastDataMetadata lastData;
    @NotNull
    private IByteBuffer _mainDataBuffer;
    @NotNull
    private IByteBuffer _lastDataBuffer;
    public static final int segmentLength = 256;
    public static final long segmentBytesCount = 2048L;
    public static final long memberSegmentBytes = 4096L;
    public static final long firstSegmentPosition = 0x7FFFFFFEL;
    public static final long secondSegmentPosition = Integer.MAX_VALUE;
    @NotNull
    private static final byte[] EmptyData = new byte[2048];
    private static final long halfMB = 524288L;

    public MinBitmapData(@NotNull MainDataMetadata mainData, @NotNull LastDataMetadata lastData) {
        Intrinsics.checkNotNullParameter((Object)mainData, (String)"mainData");
        Intrinsics.checkNotNullParameter((Object)lastData, (String)"lastData");
        this.mainData = mainData;
        this.lastData = lastData;
        this._mainDataBuffer = this.mainData.getContentBuffer();
        this._lastDataBuffer = this.lastData.getContentBuffer();
    }

    @NotNull
    public final IByteBuffer getLastDataBuffer(int memberId) {
        long pos = (long)memberId * 4096L;
        long limit = pos + 4096L;
        if (this._lastDataBuffer.getCapacity() < limit) {
            long newSize = (long)this.lastData.getMinSize(memberId + 1, 4096L) * 4096L;
            this._lastDataBuffer = this.lastData.resize(newSize);
        }
        return this._lastDataBuffer.slice(pos, 4096L);
    }

    @NotNull
    public final IByteBuffer getMainDataBuffer() {
        return this._mainDataBuffer;
    }

    public final long startCopySegment(int memberId, boolean firstSegment, long byteCount) {
        long position = this.getLastDataSegmentPosition(memberId, firstSegment);
        long mainDataStartPosition = this.mainData.getCount();
        MainDataMetadata mainDataMetadata = this.mainData;
        mainDataMetadata.setCount(mainDataMetadata.getCount() + byteCount);
        this.resize(mainDataStartPosition + byteCount);
        this._mainDataBuffer.copy(mainDataStartPosition, this._lastDataBuffer, position, byteCount);
        mainDataMetadata = this.mainData;
        long l = mainDataMetadata.getVersion();
        mainDataMetadata.setVersion(l + 1L);
        return mainDataStartPosition;
    }

    private final long getLastDataSegmentPosition(int memberId, boolean firstSegment) {
        return (long)memberId * 4096L + (firstSegment ? 0L : 2048L);
    }

    public final void clearSegment(int memberId, boolean firstSegment) {
        long position = this.getLastDataSegmentPosition(memberId, firstSegment);
        this._lastDataBuffer.putByteArray(position, EmptyData);
    }

    private final void resize(long minCapacity) {
        long capacity = this._mainDataBuffer.getCapacity();
        long newSize = minCapacity;
        if (capacity < minCapacity) {
            if ((newSize = Companion.getNextCapacity(newSize)) >= 0x7FFFFFFEL && (newSize = 0x7FFFFFFDL) < minCapacity) {
                throw new NotSupportedException("\u8d85\u8fc7\u6700\u5927\u7684\u6587\u4ef6\u5927\u5c0f.");
            }
            this._mainDataBuffer = this.mainData.resize(newSize);
        }
    }

    @Override
    @NotNull
    public MinBitmapData clone() {
        return this.mainData.getIsReadonly() && this.mainData.getContentSize() == this._mainDataBuffer.getCapacity() ? this : new MinBitmapData(this.mainData, this.lastData);
    }

    public final void close() {
        this.mainData.close();
        this.lastData.close();
    }

    public final void force() {
        this.mainData.force();
        this.lastData.force();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData$Companion;", "", "()V", "EmptyData", "", "getEmptyData", "()[B", "firstSegmentPosition", "", "halfMB", "memberSegmentBytes", "secondSegmentPosition", "segmentBytesCount", "segmentLength", "", "getNextCapacity", "minCapacity", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getEmptyData() {
            return EmptyData;
        }

        public final long getNextCapacity(long minCapacity) {
            long newSize;
            long current = 524288L;
            int mB32 = 0x2000000;
            int i = 0;
            for (newSize = 0L; newSize < minCapacity; newSize += current) {
                if (i == 4 && current < (long)mB32) {
                    i = 0;
                    current *= (long)4;
                }
                int n = i;
                i = n + 1;
            }
            return newSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

