/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import java.io.Closeable;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IImmutableListSegmentInfo;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0013\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0015\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0016\u001a\u00060\u0007j\u0002`\bH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u001a\u0010\u001b\u001a\u00020\u00182\n\u0010\u001c\u001a\u00060\u0007j\u0002`\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00060\u0007j\u0002`\u000e2\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u000eH\u0014J\u0016\u0010 \u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u001e0!J\u0016\u0010\"\u001a\u00060\u0007j\u0002`\b2\n\u0010#\u001a\u00060\u0007j\u0002`\u000eJ\u0016\u0010$\u001a\u00060%R\u00020\u00002\n\u0010&\u001a\u00060\u0007j\u0002`\bJ\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010(\u001a\u00020\u00182\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0015\u0010\r\u001a\u00060\u0007j\u0002`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;", "Ljava/io/Closeable;", "Lkd/bos/olapServer/collections/ICloneable;", "list", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IImmutableListSegmentInfo;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IImmutableListSegmentInfo;)V", "LastSegmentIndex", "", "Lkd/bos/olapServer/common/int;", "getLastSegmentIndex", "()I", "SecondLastSegmentIndex", "getSecondLastSegmentIndex", "ValidCount", "Lkd/bos/olapServer/common/idx;", "getValidCount", "_cachedRangeInnerIndex", "_cachedRangeMax", "_cachedRangeMin", "binarySearch", "lo", "hi", "target", "clearCache", "", "clone", "close", "fillSegmentEntry", "segmentIndex", "entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "getInnerIndex", "getLastSegmentEntry", "Lkotlin/Pair;", "getPosition", "index", "getValidSegmentEntries", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade$MinBitmapSegmentEntryIterator;", "start", "parseEmptyEntry", "parseEntry", "value", "", "Lkd/bos/olapServer/common/long;", "MinBitmapSegmentEntryIterator", "bos-olap-core"})
public class MinImmutableListSegmentFacade
implements Closeable,
ICloneable<MinImmutableListSegmentFacade> {
    @NotNull
    private final IImmutableListSegmentInfo list;
    private int _cachedRangeMin;
    private int _cachedRangeMax;
    private int _cachedRangeInnerIndex;

    public MinImmutableListSegmentFacade(@NotNull IImmutableListSegmentInfo list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.list = list;
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
    }

    protected int getInnerIndex(int target) {
        if (this._cachedRangeMin < 0) {
            return this.binarySearch(0, this.list.getCount() - 1, target);
        }
        return target >= this._cachedRangeMin ? (target < this._cachedRangeMax ? -(this._cachedRangeInnerIndex + 1) : (target == this._cachedRangeMax ? this._cachedRangeInnerIndex : this.binarySearch(this._cachedRangeInnerIndex + 1, this.list.getCount() - 1, target))) : this.binarySearch(0, this._cachedRangeInnerIndex - 1, target);
    }

    private final int binarySearch(int lo, int hi, int target) {
        int x;
        int low = lo;
        int high = hi;
        this._cachedRangeMin = target;
        while (low + 8 <= high) {
            int mid = low + high >>> 1;
            int middleValue = this.list.getSegmentIndex(mid);
            if (middleValue < target) {
                low = mid + 1;
                continue;
            }
            if (middleValue > target) {
                high = mid - 1;
                continue;
            }
            this._cachedRangeMax = this._cachedRangeMin;
            this._cachedRangeInnerIndex = mid;
            return mid;
        }
        for (x = low; x <= high; ++x) {
            int value2 = this.list.getSegmentIndex(x);
            if (value2 < target) continue;
            this._cachedRangeMax = value2;
            if (value2 != target) break;
            this._cachedRangeInnerIndex = x;
            return x;
        }
        if (x > high) {
            this._cachedRangeMax = x < this.list.getCount() ? this.list.getSegmentIndex(x) : Integer.MAX_VALUE;
        }
        this._cachedRangeInnerIndex = x;
        return -(x + 1);
    }

    public final void fillSegmentEntry(int segmentIndex, @NotNull MinBitmapSegmentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int innerIndex = this.getInnerIndex(segmentIndex);
        if (innerIndex >= 0) {
            this.parseEntry(this.list.get(innerIndex), entry);
        } else {
            this.parseEmptyEntry(entry);
        }
    }

    private final void parseEntry(long value2, MinBitmapSegmentEntry entry) {
        long position = (value2 & 0xFFFFFFFF0000L) >> 16;
        entry.setBitmap(CommonTypesKt.getBit(position, 31));
        entry.setPosition(CommonTypesKt.setFalse(position, 31));
        entry.setFrontEmptyCount((int)((value2 & 0xFF00L) >> 8));
        entry.setValidCount((int)(value2 & 0xFFL) + 1);
    }

    private final void parseEmptyEntry(MinBitmapSegmentEntry entry) {
        entry.setPosition(-1L);
        entry.setBitmap(false);
        entry.setFrontEmptyCount(256);
        entry.setValidCount(0);
    }

    @NotNull
    public final Pair<Integer, MinBitmapSegmentEntry> getLastSegmentEntry() {
        Pair pair;
        MinBitmapSegmentEntry entry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
        if (this.list.getCount() > 0) {
            long value2 = this.list.get(this.list.getCount() - 1);
            this.parseEntry(value2, entry);
            pair = new Pair((Object)((int)(value2 >> 48 & 0xFFFFL)), (Object)entry);
        } else {
            pair = new Pair((Object)-1, (Object)entry);
        }
        return pair;
    }

    public final int getLastSegmentIndex() {
        return this.list.getCount() > 0 ? this.list.getSegmentIndex(this.list.getCount() - 1) : -1;
    }

    public final int getSecondLastSegmentIndex() {
        return this.list.getCount() > 1 ? this.list.getSegmentIndex(this.list.getCount() - 2) : -1;
    }

    public final int getPosition(int index2) {
        int innerIndex = this.getInnerIndex(index2);
        return innerIndex < 0 ? innerIndex : this.list.getPosition(innerIndex);
    }

    @NotNull
    public final MinBitmapSegmentEntryIterator getValidSegmentEntries(int start) {
        boolean bl = start >= 0;
        int n = 0;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int innerIndex = this.getInnerIndex(start);
        if (innerIndex < 0) {
            innerIndex = -innerIndex - 2;
        } else {
            n = innerIndex;
            innerIndex = n + -1;
        }
        return new MinBitmapSegmentEntryIterator(innerIndex);
    }

    protected final void clearCache() {
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
    }

    @Override
    @NotNull
    public MinImmutableListSegmentFacade clone() {
        MinImmutableListSegmentFacade minImmutableListSegmentFacade;
        Object object;
        IImmutableListSegmentInfo $this$clone$iv = this.list;
        boolean $i$f$clone = false;
        Object object2 = object = $this$clone$iv instanceof ICloneable ? (ICloneable)((Object)$this$clone$iv) : null;
        if (object == null) {
            throw new NotSupportedException($this$clone$iv + " not support ICloneable.");
        }
        Object instance$iv = object;
        Object t2 = instance$iv.clone();
        if (!(t2 instanceof IImmutableListSegmentInfo)) {
            t2 = null;
        }
        if ((object = (IImmutableListSegmentInfo)t2) == null) {
            throw new NotSupportedException($this$clone$iv + " clone() not override.");
        }
        Object newList = object;
        if (newList == this.list) {
            this._cachedRangeMin = -1;
            this._cachedRangeMax = -1;
            this._cachedRangeInnerIndex = -1;
            minImmutableListSegmentFacade = this;
        } else {
            minImmutableListSegmentFacade = new MinImmutableListSegmentFacade((IImmutableListSegmentInfo)newList);
        }
        return minImmutableListSegmentFacade;
    }

    @Override
    public void close() {
        Closeable closeable;
        IImmutableListSegmentInfo iImmutableListSegmentInfo = this.list;
        Closeable closeable2 = closeable = iImmutableListSegmentInfo instanceof Closeable ? (Closeable)((Object)iImmutableListSegmentInfo) : null;
        if (closeable != null) {
            closeable.close();
        }
    }

    public final int getValidCount() {
        return this.list.getCount();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade$MinBitmapSegmentEntryIterator;", "", "_innerIndex", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;I)V", "Entry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "getEntry", "()Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "SegmentIndex", "getSegmentIndex", "()I", "_entry", "_segmentIndex", "next", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
    public final class MinBitmapSegmentEntryIterator {
        private int _innerIndex;
        @NotNull
        private final MinBitmapSegmentEntry _entry;
        private int _segmentIndex;

        public MinBitmapSegmentEntryIterator(int _innerIndex) {
            Intrinsics.checkNotNullParameter((Object)MinImmutableListSegmentFacade.this, (String)"this$0");
            this._innerIndex = _innerIndex;
            this._entry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
            this._segmentIndex = -1;
        }

        public final boolean next() {
            boolean bl;
            MinBitmapSegmentEntryIterator minBitmapSegmentEntryIterator = this;
            int n = minBitmapSegmentEntryIterator._innerIndex;
            minBitmapSegmentEntryIterator._innerIndex = n + 1;
            if (this._innerIndex >= 0 && this._innerIndex < MinImmutableListSegmentFacade.this.list.getCount()) {
                long value2 = MinImmutableListSegmentFacade.this.list.get(this._innerIndex);
                MinImmutableListSegmentFacade.this.parseEntry(value2, this._entry);
                this._segmentIndex = (int)(value2 >> 48 & 0xFFFFL);
                bl = true;
            } else {
                this._entry.setPosition(-1L);
                this._entry.setBitmap(false);
                this._entry.setFrontEmptyCount(0);
                this._entry.setValidCount(0);
                this._segmentIndex = -1;
                bl = false;
            }
            return bl;
        }

        public final int getSegmentIndex() {
            return this._segmentIndex;
        }

        @NotNull
        public final MinBitmapSegmentEntry getEntry() {
            return this._entry;
        }
    }
}

