/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import kd.bos.olapServer.collections.IIndexScanner;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinImmutableListSegmentFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0016J$\u0010\f\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\t2\n\u0010\r\u001a\u00060\bj\u0002`\tH\u0016J$\u0010\u000e\u001a\u00060\bj\u0002`\u000f2\n\u0010\u0010\u001a\u00060\bj\u0002`\u000f2\n\u0010\u0011\u001a\u00060\bj\u0002`\tH\u0002J\u0018\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\n\u001a\u00060\bj\u0002`\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinIndexScanner;", "Lkd/bos/olapServer/collections/IIndexScanner;", "_indexes", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinImmutableListSegmentFacade;)V", "_tempSegmentEntry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "getNextEmptyCount", "", "Lkd/bos/olapServer/common/idx;", "index", "maxEmptyCount", "getNextValidCount", "minValidCount", "getToLastEmptyCount", "Lkd/bos/olapServer/common/int;", "startSegmentIndex", "count", "isEmptyValue", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
public final class MinIndexScanner
implements IIndexScanner {
    @NotNull
    private final MinImmutableListSegmentFacade _indexes;
    @NotNull
    private final MinBitmapSegmentEntry _tempSegmentEntry;

    public MinIndexScanner(@NotNull MinImmutableListSegmentFacade _indexes) {
        Intrinsics.checkNotNullParameter((Object)_indexes, (String)"_indexes");
        this._indexes = _indexes;
        this._tempSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
    }

    @Override
    public boolean isEmptyValue(int index2) {
        int segmentIndex = index2 / 256;
        MinBitmapSegmentEntry entry = this._tempSegmentEntry;
        this._indexes.fillSegmentEntry(segmentIndex, entry);
        int real = index2 % 256 - entry.getFrontEmptyCount();
        return real < 0 || real >= entry.getValidCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getNextEmptyCount(int index2, int maxEmptyCount) {
        int n;
        int segmentIndex = index2 / 256;
        int remainder = index2 % 256;
        MinImmutableListSegmentFacade.MinBitmapSegmentEntryIterator validEntries = this._indexes.getValidSegmentEntries(segmentIndex);
        int emptyCount = 0;
        if (!validEntries.next()) {
            emptyCount = 256 - remainder;
            return emptyCount + this.getToLastEmptyCount(segmentIndex + 1, index2 + maxEmptyCount);
        }
        if (validEntries.getSegmentIndex() != segmentIndex) {
            emptyCount = 256 - remainder;
            int endSegmentIndex = validEntries.getSegmentIndex();
            return (emptyCount += (endSegmentIndex - segmentIndex - 1) * 256) + validEntries.getEntry().getFrontEmptyCount();
        }
        int len = validEntries.getEntry().getFrontEmptyCount() - remainder;
        if (len > 0) {
            return len;
        }
        if (len + validEntries.getEntry().getValidCount() > 0) {
            return 0;
        }
        emptyCount = 256 - remainder;
        if (!validEntries.next()) {
            n = emptyCount + this.getToLastEmptyCount(segmentIndex + 1, index2 + maxEmptyCount);
            return n;
        }
        int endSegmentIndex = validEntries.getSegmentIndex();
        boolean bl = endSegmentIndex > segmentIndex;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = (emptyCount += (endSegmentIndex - segmentIndex - 1) * 256) + validEntries.getEntry().getFrontEmptyCount();
        return n;
    }

    private final int getToLastEmptyCount(int startSegmentIndex, int count) {
        return (count / 256 - startSegmentIndex) * 256 + count % 256;
    }

    @Override
    public int getNextValidCount(int index2, int minValidCount) {
        int segmentIndex = index2 / 256;
        int remainder = index2 % 256;
        MinImmutableListSegmentFacade.MinBitmapSegmentEntryIterator validEntries = this._indexes.getValidSegmentEntries(segmentIndex);
        int pre = segmentIndex - 1;
        int validCount = 0;
        while (validEntries.next() && validEntries.getSegmentIndex() == pre + 1) {
            MinBitmapSegmentEntry entry = validEntries.getEntry();
            int vf = entry.getValidCount() + entry.getFrontEmptyCount();
            if (remainder >= entry.getFrontEmptyCount() && remainder < vf) {
                validCount += vf - remainder;
            } else {
                return validCount;
            }
            if (vf < 256) {
                return validCount;
            }
            if (validCount >= minValidCount) {
                return minValidCount;
            }
            pre = validEntries.getSegmentIndex();
            remainder = 0;
        }
        return validCount;
    }

    @Override
    public int getNextValidCount(int index2) {
        return IIndexScanner.DefaultImpls.getNextValidCount(this, index2);
    }
}

