/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMinMutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinBitmapSegmentEntry;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.MinInvArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.RoaringArraySegment;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.AbstractMinImmutableBitmap;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinBitmapData;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinImmutableListSegmentFacade;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MinMutableListSegmentFacade;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B!\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0014\u0010\u001a\u001a\u00020\u00142\n\u0010\u001b\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0014\u0010\u001c\u001a\u00020\u00142\n\u0010\u001b\u001a\u00060\u0006j\u0002`\u0007H\u0014J\u0014\u0010\u001d\u001a\u00020\u000f2\n\u0010\u001b\u001a\u00060\u0006j\u0002`\u0007H\u0014J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J \u0010 \u001a\u00020\u00182\n\u0010!\u001a\u00060\u0006j\u0002`\u00072\n\u0010\"\u001a\u00060#j\u0002`$H\u0016J\b\u0010%\u001a\u00020\u0018H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableBitmap;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/AbstractMinImmutableBitmap;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableListSegmentFacade;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinMutableBitmap;", "Lkd/bos/olapServer/collections/IDataContainer;", "memberId", "", "Lkd/bos/olapServer/common/int;", "data", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;", "indexes", "(ILkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinBitmapData;Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinMutableListSegmentFacade;)V", "_copyingIsFirstSegment", "", "_copyingSegmentEntry", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/MinBitmapSegmentEntry;", "_copyingSegmentIndex", "_dirty", "_tempSegmentEntry", "_updatingSegment", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMinBitmapSegment;", "_updatingSegmentEntry", "_updatingSegmentIndex", "force", "", "forceCurrentSegment", "getOrCreateSegment", "segmentIndex", "getSegment", "getSegmentEntry", "reloadUpdatingSegment", "startCopySegment", "update", "index", "value", "", "Lkd/bos/olapServer/common/long;", "waitCopySegment", "bos-olap-core"})
public final class MinMutableBitmap
extends AbstractMinImmutableBitmap<MinMutableListSegmentFacade>
implements IMinMutableBitmap,
IDataContainer {
    private boolean _dirty;
    @NotNull
    private final MinBitmapSegmentEntry _tempSegmentEntry;
    private int _updatingSegmentIndex;
    @Nullable
    private IMinBitmapSegment _updatingSegment;
    @NotNull
    private MinBitmapSegmentEntry _updatingSegmentEntry;
    @Nullable
    private MinBitmapSegmentEntry _copyingSegmentEntry;
    private boolean _copyingIsFirstSegment;
    private int _copyingSegmentIndex;

    public MinMutableBitmap(int memberId, @NotNull MinBitmapData data, @NotNull MinMutableListSegmentFacade indexes) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        super(memberId, data, (MinImmutableListSegmentFacade)indexes);
        boolean bl = memberId >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._tempSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
        this._updatingSegmentIndex = -1;
        this._updatingSegmentEntry = new MinBitmapSegmentEntry(-1L, false, 0, 0);
        this._copyingSegmentIndex = -1;
    }

    @Override
    @NotNull
    protected MinBitmapSegmentEntry getSegmentEntry(int segmentIndex) {
        MinBitmapSegmentEntry minBitmapSegmentEntry;
        IMinBitmapSegment currentSegment = this._updatingSegment;
        if (segmentIndex == this._updatingSegmentIndex && currentSegment != null) {
            currentSegment.fillSegmentEntry(this._tempSegmentEntry);
            minBitmapSegmentEntry = this._tempSegmentEntry;
        } else {
            minBitmapSegmentEntry = super.getSegmentEntry(segmentIndex);
        }
        return minBitmapSegmentEntry;
    }

    @Override
    @NotNull
    protected IMinBitmapSegment getSegment(int segmentIndex) {
        IMinBitmapSegment currentSegment = this._updatingSegment;
        return segmentIndex == this._updatingSegmentIndex && currentSegment != null ? currentSegment : super.getSegment(segmentIndex);
    }

    @Override
    public void update(int index2, long value2) {
        boolean bl = value2 != 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int segmentIndex = index2 / 256;
        IMinBitmapSegment currentSegment = this._updatingSegment;
        if (segmentIndex != this._updatingSegmentIndex || currentSegment == null) {
            this.forceCurrentSegment();
            this._updatingSegment = currentSegment = this.getOrCreateSegment(segmentIndex);
            this._updatingSegmentIndex = segmentIndex;
        }
        this._updatingSegment = currentSegment.update(index2 % 256, value2);
        this._dirty = true;
    }

    private final void forceCurrentSegment() {
        IMinBitmapSegment segment = this._updatingSegment;
        if (segment != null) {
            long l;
            segment.fillSegmentEntry(this._updatingSegmentEntry);
            MinBitmapSegmentEntry entry = this._updatingSegmentEntry.clone();
            long l2 = entry.getPosition();
            if (l2 == 0L) {
                l = 0x7FFFFFFEL;
            } else if (l2 == 2048L) {
                l = Integer.MAX_VALUE;
            } else {
                throw new RuntimeException("error position(" + entry.getPosition() + ')');
            }
            entry.setPosition(l);
            ((MinMutableListSegmentFacade)this.getIndexes()).update(this._updatingSegmentIndex, entry);
            segment.force();
        } else {
            this.reloadUpdatingSegment();
        }
    }

    private final IMinBitmapSegment getOrCreateSegment(int segmentIndex) {
        IMinBitmapSegment iMinBitmapSegment;
        if (segmentIndex == this._updatingSegmentIndex) {
            IMinBitmapSegment iMinBitmapSegment2 = this._updatingSegment;
            iMinBitmapSegment = iMinBitmapSegment2;
            Intrinsics.checkNotNull((Object)iMinBitmapSegment2);
        } else if (segmentIndex > this._updatingSegmentIndex) {
            long l;
            RoaringArraySegment roaringArraySegment;
            IMinBitmapSegment iMinBitmapSegment3 = this._updatingSegment;
            if (iMinBitmapSegment3 instanceof MinBitmapSegment) {
                MinInvArraySegment invArraySegment = MinInvArraySegment.Companion.trySwitchInvArraySegment(this.get_lastDataBuffer(), this._updatingSegmentEntry);
                if (invArraySegment != null) {
                    this._updatingSegment = invArraySegment;
                    ((MinMutableListSegmentFacade)this.getIndexes()).update(this._updatingSegmentIndex, this._updatingSegmentEntry);
                } else {
                    RoaringArraySegment roaringArraySegment2 = RoaringArraySegment.Companion.trySwitchRoaringArrayFromMinBitmap(this.get_lastDataBuffer(), this._updatingSegmentEntry);
                    if (roaringArraySegment2 != null) {
                        this._updatingSegment = roaringArraySegment2;
                        ((MinMutableListSegmentFacade)this.getIndexes()).update(this._updatingSegmentIndex, this._updatingSegmentEntry);
                    }
                }
            } else if (iMinBitmapSegment3 instanceof MinArraySegment && (roaringArraySegment = RoaringArraySegment.Companion.trySwitchRoaringArrayFromMinArray(this.get_lastDataBuffer(), this._updatingSegmentEntry)) != null) {
                this._updatingSegment = roaringArraySegment;
            }
            this.waitCopySegment();
            this.startCopySegment();
            long secondSegmentPositionAtLastData = 2048L;
            if (this._updatingSegment == null) {
                l = 0L;
            } else if (this._updatingSegmentEntry.getPosition() == 0L) {
                l = secondSegmentPositionAtLastData;
            } else if (this._updatingSegmentEntry.getPosition() == secondSegmentPositionAtLastData) {
                l = 0L;
            } else {
                throw new NotSupportedException();
            }
            long nextSegmentOffset = l;
            iMinBitmapSegment = new MinArraySegment(this.get_lastDataBuffer(), nextSegmentOffset, 0);
        } else {
            throw new NotSupportedException();
        }
        return iMinBitmapSegment;
    }

    private final void waitCopySegment() {
        MinBitmapSegmentEntry copyingSegmentEntry = this._copyingSegmentEntry;
        if (this._copyingSegmentIndex >= 0 && copyingSegmentEntry != null) {
            ((MinMutableListSegmentFacade)this.getIndexes()).update(this._copyingSegmentIndex, copyingSegmentEntry);
            this.getData().clearSegment(this.getMemberId(), this._copyingIsFirstSegment);
            this._copyingSegmentIndex = -1;
        }
    }

    private final void startCopySegment() {
        boolean firstSegment;
        IMinBitmapSegment iMinBitmapSegment = this._updatingSegment;
        if (iMinBitmapSegment == null) {
            return;
        }
        IMinBitmapSegment updatingSegment = iMinBitmapSegment;
        MinBitmapSegmentEntry copyingSegmentEntry = this._updatingSegmentEntry.clone();
        this._copyingSegmentIndex = this._updatingSegmentIndex;
        this._copyingSegmentEntry = copyingSegmentEntry;
        long nextSegmentOffset = updatingSegment.getNextSegmentOffset();
        long byteCount = nextSegmentOffset - copyingSegmentEntry.getPosition();
        this._copyingIsFirstSegment = firstSegment = copyingSegmentEntry.getPosition() == 0L;
        copyingSegmentEntry.setPosition(this.getData().startCopySegment(this.getMemberId(), firstSegment, byteCount));
        this.clearCache();
    }

    private final void reloadUpdatingSegment() {
        IMinBitmapSegment segment = this._updatingSegment;
        if (segment == null) {
            Pair<Integer, MinBitmapSegmentEntry> pair = ((MinMutableListSegmentFacade)this.getIndexes()).getLastSegmentEntry();
            int lastSegmentIndex = ((Number)pair.component1()).intValue();
            MinBitmapSegmentEntry lastSegmentEntry = (MinBitmapSegmentEntry)pair.component2();
            if (lastSegmentIndex >= 0) {
                this._updatingSegmentIndex = lastSegmentIndex;
                this._updatingSegmentEntry = lastSegmentEntry;
                this._updatingSegment = this.buildSegment(lastSegmentEntry);
            }
        }
    }

    @Override
    public void force() {
        if (this._dirty) {
            this.forceCurrentSegment();
            this.waitCopySegment();
            this.getData().force();
            ((MinMutableListSegmentFacade)this.getIndexes()).force();
            this._dirty = false;
        }
    }
}

