/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import java.io.Closeable;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.IMutableArrayLong;
import kd.bos.olapServer.collections.Range;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmaps.IMutableListSegmentInfo;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.MutableListPage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 (2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001(B!\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00060\u0005j\u0002`\r2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0019\u0010\u001c\u001a\u00060\u0016j\u0002`\u00172\n\u0010\u001d\u001a\u00060\u0005j\u0002`\rH\u0096\u0002J\u0018\u0010\u001e\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001d\u001a\u00060\u0005j\u0002`\rH\u0016J\u0018\u0010\u001f\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001d\u001a\u00060\u0005j\u0002`\rH\u0016J\b\u0010 \u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u0011H\u0002J!\u0010%\u001a\u00020\u001a2\n\u0010\u001d\u001a\u00060\u0005j\u0002`\r2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0096\u0002J\n\u0010&\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010'\u001a\u00020\"H\u0002R\u0018\u0010\f\u001a\u00060\u0005j\u0002`\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0005j\u0002`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinSingleMutableListSegmentInfo;", "Lkd/bos/olapServer/memoryMappedFiles/minBitmaps/IMutableListSegmentInfo;", "Lkd/bos/olapServer/collections/IDataContainer;", "Lkd/bos/olapServer/collections/ICloneable;", "memberId", "", "Lkd/bos/olapServer/common/int;", "memberIndexes", "Lkd/bos/olapServer/collections/IMutableArrayLong;", "page", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MutableListPage;", "(ILkd/bos/olapServer/collections/IMutableArrayLong;Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MutableListPage;)V", "Count", "Lkd/bos/olapServer/common/idx;", "getCount", "()I", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_pageIndex", "_segmentCount", "add", "value", "", "Lkd/bos/olapServer/common/long;", "clone", "close", "", "force", "get", "index", "getPosition", "getSegmentIndex", "initMember", "pageInfo2PageRange", "Lkd/bos/olapServer/collections/Range;", "pageInfo", "resizePage", "set", "tryGetBuffer", "tryGetPageInfo", "Companion", "bos-olap-core"})
public class MinSingleMutableListSegmentInfo
implements IMutableListSegmentInfo,
IDataContainer,
ICloneable<MinSingleMutableListSegmentInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int memberId;
    @NotNull
    private final IMutableArrayLong memberIndexes;
    @NotNull
    private final MutableListPage page;
    @Nullable
    private IByteBuffer _buffer;
    private int _segmentCount;
    private int _pageIndex;
    private static final int PageSegmentSize = 4096;
    private static final long LongByte = 8L;

    public MinSingleMutableListSegmentInfo(int memberId, @NotNull IMutableArrayLong memberIndexes, @NotNull MutableListPage page) {
        Intrinsics.checkNotNullParameter((Object)memberIndexes, (String)"memberIndexes");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.memberId = memberId;
        this.memberIndexes = memberIndexes;
        this.page = page;
        int n = this.memberId;
        n = 0 <= n ? (n < 0x10000000 ? 1 : 0) : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._buffer = this.tryGetBuffer();
    }

    private final IByteBuffer tryGetBuffer() {
        Range info = this.tryGetPageInfo();
        this._segmentCount = info.getCount();
        this._pageIndex = info.getIndex();
        return this._segmentCount == 0 ? null : this.page.getBuffer(this.pageInfo2PageRange(info));
    }

    private final Range tryGetPageInfo() {
        return this.memberId >= this.memberIndexes.getLength() ? Range.Companion.getEmpty() : Range.Companion.parseFromInt64(this.memberIndexes.get(this.memberId));
    }

    private final Range pageInfo2PageRange(Range pageInfo) {
        int segmentCount = pageInfo.getCount();
        int pageCount = segmentCount == 0 ? 0 : (segmentCount - 1) / 4096 + 1;
        return new Range(pageInfo.getIndex(), pageCount);
    }

    @Override
    public void set(int index2, long value2) {
        IByteBuffer iByteBuffer = this._buffer;
        if (iByteBuffer == null) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        IByteBuffer buffer = iByteBuffer;
        if (index2 >= this.getCount()) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        buffer.putLong((long)index2 * 8L, value2);
    }

    @Override
    public int add(long value2) {
        int segmentCount = this._segmentCount;
        boolean bl = segmentCount < 0xFFFF000;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "add(" + value2 + "), segmentCount = " + segmentCount;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        IByteBuffer buffer = this._buffer;
        if (buffer == null) {
            buffer = this.initMember();
        } else if (segmentCount % 4096 == 0) {
            buffer = this.resizePage();
        }
        buffer.putLong((long)segmentCount * 8L, value2);
        MinSingleMutableListSegmentInfo minSingleMutableListSegmentInfo = this;
        n = minSingleMutableListSegmentInfo._segmentCount;
        minSingleMutableListSegmentInfo._segmentCount = n + 1;
        this.memberIndexes.set(this.memberId, new Range(this._pageIndex, this._segmentCount).toInt64());
        return segmentCount;
    }

    private final IByteBuffer resizePage() {
        Range range = MutableListPage.resize$default(this.page, this.pageInfo2PageRange(new Range(this._pageIndex, this._segmentCount)), 0, 2, null);
        if (range == null) {
            throw new NotSupportedException();
        }
        Range pageRange = range;
        IByteBuffer buffer = this.page.getBuffer(pageRange);
        IByteBuffer iByteBuffer = this._buffer;
        if (iByteBuffer != null) {
            iByteBuffer.close();
        }
        this._buffer = buffer;
        this._pageIndex = pageRange.getIndex();
        return buffer;
    }

    private final IByteBuffer initMember() {
        IByteBuffer buffer;
        Range range = this.page.allot();
        if (range == null) {
            throw new NotSupportedException();
        }
        Range pageRange = range;
        this._buffer = buffer = this.page.getBuffer(pageRange);
        this._pageIndex = pageRange.getIndex();
        if (this.memberId >= this.memberIndexes.getLength()) {
            this.memberIndexes.resize(this.memberId + 1);
        }
        return buffer;
    }

    @Override
    public long get(int index2) {
        IByteBuffer iByteBuffer = this._buffer;
        if (iByteBuffer == null) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        IByteBuffer buffer = iByteBuffer;
        if (index2 >= this.getCount()) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        return buffer.getLong((long)index2 * 8L);
    }

    @Override
    public int getSegmentIndex(int index2) {
        IByteBuffer iByteBuffer = this._buffer;
        if (iByteBuffer == null) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        IByteBuffer buffer = iByteBuffer;
        if (index2 >= this.getCount()) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        return CommonTypesKt.toIntNoNegative(buffer.getShort(index2 << 3));
    }

    @Override
    public int getPosition(int index2) {
        IByteBuffer iByteBuffer = this._buffer;
        if (iByteBuffer == null) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        IByteBuffer buffer = iByteBuffer;
        if (index2 >= this.getCount()) {
            throw new IndexOutOfBoundsException(index2 + " out of bounds(0, " + this.getCount() + ')');
        }
        return CommonTypesKt.setFalse(buffer.getInt((long)(index2 << 3) + 2L), 31);
    }

    @Override
    public int getCount() {
        return this._segmentCount;
    }

    @Override
    public void force() {
        IDataContainer iDataContainer;
        IMutableArrayLong iMutableArrayLong = this.memberIndexes;
        IDataContainer iDataContainer2 = iDataContainer = iMutableArrayLong instanceof IDataContainer ? (IDataContainer)((Object)iMutableArrayLong) : null;
        if (iDataContainer != null) {
            iDataContainer.force();
        }
        this.page.force();
    }

    @Override
    @NotNull
    public MinSingleMutableListSegmentInfo clone() {
        Object object;
        Range currentInfo;
        Range currentPageRange;
        Object newInfo;
        Range newPageRange;
        if (this._buffer != null && Intrinsics.areEqual((Object)(newPageRange = this.pageInfo2PageRange((Range)(newInfo = this.tryGetPageInfo()))), (Object)(currentPageRange = this.pageInfo2PageRange(currentInfo = new Range(this._pageIndex, this._segmentCount))))) {
            this._segmentCount = ((Range)newInfo).getCount();
            return this;
        }
        newInfo = this._buffer;
        if (newInfo != null) {
            newInfo.close();
        }
        IMutableArrayLong $this$clone$iv = this.memberIndexes;
        boolean $i$f$clone = false;
        Object object2 = object = $this$clone$iv instanceof ICloneable ? (ICloneable)((Object)$this$clone$iv) : null;
        if (object == null) {
            throw new NotSupportedException($this$clone$iv + " not support ICloneable.");
        }
        Object instance$iv = object;
        Object t2 = instance$iv.clone();
        if (!(t2 instanceof IMutableArrayLong)) {
            t2 = null;
        }
        if ((object = (IMutableArrayLong)t2) == null) {
            throw new NotSupportedException($this$clone$iv + " clone() not override.");
        }
        Object newMemberIndexes = object;
        MutableListPage newPages = this.page.clone();
        return new MinSingleMutableListSegmentInfo(this.memberId, (IMutableArrayLong)newMemberIndexes, newPages);
    }

    @Override
    public void close() {
        Closeable closeable = this._buffer;
        if (closeable != null) {
            closeable.close();
        }
        IMutableArrayLong iMutableArrayLong = this.memberIndexes;
        Closeable closeable2 = closeable = iMutableArrayLong instanceof Closeable ? (Closeable)((Object)iMutableArrayLong) : null;
        if (closeable != null) {
            closeable.close();
        }
        this.page.close();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MinSingleMutableListSegmentInfo$Companion;", "", "()V", "LongByte", "", "PageSegmentSize", "", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

