/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.minBitmapsV3;

import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.collections.IDataContainer;
import kd.bos.olapServer.collections.Range;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.minBitmapsV3.ListPageMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\n\u0010\u0019\u001a\u00060\u0011j\u0002`\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fJ\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\f\b\u0002\u0010\u001e\u001a\u00060\u0011j\u0002`\u0012J\u0014\u0010\u001f\u001a\u00020\u00162\n\u0010 \u001a\u00060\u0007j\u0002`\bH\u0002R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MutableListPage;", "Lkd/bos/olapServer/collections/ICloneable;", "Lkd/bos/olapServer/collections/IDataContainer;", "metadata", "Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/ListPageMetadata;", "(Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/ListPageMetadata;)V", "Capacity", "", "Lkd/bos/olapServer/common/long;", "getCapacity", "()J", "_buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "_capacity", "addPage", "Lkd/bos/olapServer/collections/Range;", "count", "", "Lkd/bos/olapServer/common/int;", "allot", "clone", "close", "", "copyPage", "pageRange", "targetPageIndex", "force", "getBuffer", "releasePage", "resize", "addCount", "resizeCapacity", "minSize", "Companion", "bos-olap-core"})
public final class MutableListPage
implements ICloneable<MutableListPage>,
IDataContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListPageMetadata metadata;
    @NotNull
    private IByteBuffer _buffer;
    private long _capacity;
    private static final long PageByteSize = 32768L;
    private static final long KB_256 = 262144L;
    private static final long MB_1 = 0x100000L;
    private static final long MB_4 = 0x400000L;
    private static final long MB_16 = 0x1000000L;

    public MutableListPage(@NotNull ListPageMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.metadata = metadata;
        this._buffer = this.metadata.getContentBuffer();
        this._capacity = -1L;
    }

    private final long getCapacity() {
        if (this._capacity < 0L) {
            this._capacity = this._buffer.getCapacity();
        }
        return this._capacity;
    }

    @Nullable
    public final Range allot() {
        return this.allot(1);
    }

    @Nullable
    public final Range allot(int count) {
        boolean bl = 1 <= count ? count <= 65535 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "allot(" + count + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int newPageIndex = this.metadata.tryGetContinuousFreePage(count);
        if (newPageIndex >= 0) {
            this.metadata.setUsingPage(newPageIndex, count);
            return new Range(newPageIndex, count);
        }
        return this.addPage(count);
    }

    @Nullable
    public final Range resize(@NotNull Range pageRange, int addCount) {
        Intrinsics.checkNotNullParameter((Object)pageRange, (String)"pageRange");
        int currentPageCount = pageRange.getCount();
        int newPageCount = currentPageCount + addCount;
        int reUsingPageIndex = pageRange.getIndex() + currentPageCount;
        if (reUsingPageIndex >= this.metadata.getCount() && this.addPage(addCount) != null) {
            return new Range(pageRange.getIndex(), newPageCount);
        }
        if (this.metadata.isFreePage(reUsingPageIndex, addCount)) {
            this.metadata.setUsingPage(reUsingPageIndex, addCount);
            return new Range(pageRange.getIndex(), newPageCount);
        }
        Range range = this.allot(newPageCount);
        if (range == null) {
            return null;
        }
        Range newPageRange = range;
        boolean bl = newPageRange.getCount() >= newPageCount;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.copyPage(pageRange, newPageRange.getIndex());
        this.metadata.setFreePage(pageRange.getIndex(), currentPageCount);
        return newPageRange;
    }

    public static /* synthetic */ Range resize$default(MutableListPage mutableListPage, Range range, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return mutableListPage.resize(range, n);
    }

    private final Range addPage(int count) {
        boolean bl = 1 <= count ? count <= 65536 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "addPage(" + count + ")}";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int newPageIndex = this.metadata.getCount();
        Range pageRange = new Range(newPageIndex, count);
        int newPageCount = this.metadata.getCount() + count;
        long minSize = (long)newPageCount * 32768L;
        if (minSize > this.getCapacity()) {
            if (minSize > Integer.MAX_VALUE) {
                return null;
            }
            this.resizeCapacity(minSize);
        }
        this.metadata.setCount(newPageCount);
        return pageRange;
    }

    private final void copyPage(Range pageRange, int targetPageIndex) {
        int sourcePageIndex = pageRange.getIndex();
        int sourcePageCount = pageRange.getCount();
        int n = this.metadata.getCount();
        int n2 = targetPageIndex + sourcePageCount;
        n = 1 <= n2 ? (n2 <= n ? 1 : 0) : 0;
        n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "copyPage(" + pageRange + ", " + targetPageIndex + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long pos = (long)targetPageIndex * 32768L;
        long count = (long)sourcePageCount * 32768L;
        this._buffer.copy(pos, this._buffer, (long)sourcePageIndex * 32768L, count);
    }

    private final void resizeCapacity(long minSize) {
        long newBytesSize = this.getCapacity();
        if (newBytesSize < minSize) {
            newBytesSize = minSize < 262144L ? 262144L : (minSize < 0x100000L ? 0x100000L : (minSize < 0x400000L ? 0x400000L : (minSize < 0x1000000L ? 0x1000000L : (minSize / 0x1000000L + 1L) * 0x1000000L)));
            this._buffer = this.metadata.resize(newBytesSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : newBytesSize);
            this._capacity = this._buffer.getCapacity();
        }
    }

    @NotNull
    public final IByteBuffer getBuffer(@NotNull Range pageRange) {
        Intrinsics.checkNotNullParameter((Object)pageRange, (String)"pageRange");
        int pageIndex = pageRange.getIndex();
        int pageCount = pageRange.getCount();
        int n = this.metadata.getCount();
        int n2 = pageIndex + pageCount;
        n = 1 <= n2 ? (n2 <= n ? 1 : 0) : 0;
        n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long pos = (long)pageIndex * 32768L;
        long count = (long)pageCount * 32768L;
        IByteBuffer iByteBuffer = this._buffer;
        boolean bl4 = false;
        boolean bl5 = false;
        IByteBuffer $this$getBuffer_u24lambda_u2d3 = iByteBuffer;
        boolean bl6 = false;
        return $this$getBuffer_u24lambda_u2d3.slice(pos, count);
    }

    public final void releasePage(@NotNull Range pageRange) {
        Intrinsics.checkNotNullParameter((Object)pageRange, (String)"pageRange");
        int pageIndex = pageRange.getIndex();
        int pageCount = pageRange.getCount();
        this.metadata.setFreePage(pageIndex, pageCount);
    }

    @Override
    @NotNull
    public MutableListPage clone() {
        return this.getCapacity() == this.metadata.getContentSize() ? this : new MutableListPage(this.metadata);
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    @Override
    public void force() {
        this.metadata.force();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/minBitmapsV3/MutableListPage$Companion;", "", "()V", "KB_256", "", "MB_1", "MB_16", "MB_4", "PageByteSize", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

