/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.memoryMappedFiles.runLengthEncoding;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.memoryMappedFiles.byteBufferProviders.IByteBuffer;
import kd.bos.olapServer.memoryMappedFiles.runLengthEncoding.DynamicIntAdapter;
import kd.bos.olapServer.memoryMappedFiles.runLengthEncoding.RunLengthSegment;
import kd.bos.olapServer.memoryMappedFiles.runLengthEncoding.RunLengthSimpleSegment;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 42\u00020\u0001:\u000245B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u001b\u001a\u00020\u00012\n\u0010\u001c\u001a\u00060\nj\u0002`\u000bH\u0016J4\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060\nj\u0002`\u000b2\n\u0010 \u001a\u00060\nj\u0002`\u000b2\u0006\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060\nj\u0002`\u000bH\u0016J0\u0010$\u001a\u00060\nj\u0002`\u000b2\n\u0010%\u001a\u00060\nj\u0002`\u000b2\n\u0010&\u001a\u00060\nj\u0002`\u000b2\n\u0010'\u001a\u00060\nj\u0002`\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\bH\u0014J\b\u0010*\u001a\u00020\u001eH\u0016J\u0019\u0010+\u001a\u00060\nj\u0002`\u000b2\n\u0010,\u001a\u00060\nj\u0002`\u000bH\u0096\u0002J\u0018\u0010-\u001a\u00060\nj\u0002`\u000b2\n\u0010,\u001a\u00060\nj\u0002`\u000bH\u0002J\t\u0010.\u001a\u00020/H\u0096\u0002J\u0018\u00100\u001a\u00060\nj\u0002`\u000b2\n\u00101\u001a\u00060\nj\u0002`\u000bH\u0002J\u0014\u00102\u001a\u00060\nj\u0002`\u000b2\u0006\u00101\u001a\u00020\nH\u0002J\b\u00103\u001a\u00020\u0001H\u0002R\u0018\u0010\r\u001a\u00060\nj\u0002`\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\nj\u0002`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment;", "Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/RunLengthSegment;", "buffer", "Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;", "offset", "", "Lkd/bos/olapServer/common/long;", "currentAdapter", "Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/DynamicIntAdapter;", "count", "", "Lkd/bos/olapServer/common/int;", "(Lkd/bos/olapServer/memoryMappedFiles/byteBufferProviders/IByteBuffer;JLkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/DynamicIntAdapter;I)V", "LastValue", "getLastValue", "()I", "NextSegmentOffset", "getNextSegmentOffset", "()J", "_L1Count", "_arrayCount", "_cachedRangeInnerIndex", "_cachedRangeMax", "_cachedRangeMin", "_intBytes", "_lastValue", "_maxArrayCount", "add", "value", "batchGet", "", "start", "end", "result", "", "destPos", "binarySearch", "lo", "hi", "target", "createInstance", "newAdapter", "force", "get", "index", "getArrayIndex", "iterator", "Lkotlin/collections/IntIterator;", "readIndex", "arrayIndex", "readValue", "switchToSimple", "Companion", "ValueIterator", "bos-olap-core"})
public final class RunLengthArraySegment
extends RunLengthSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int _arrayCount;
    private final int _intBytes;
    private final int _maxArrayCount;
    private int _cachedRangeMin;
    private int _cachedRangeMax;
    private int _cachedRangeInnerIndex;
    private final int _L1Count;
    private int _lastValue;
    @NotNull
    private static final AtomicReference<int[]> _valuesArrayCache = new AtomicReference();

    public RunLengthArraySegment(@NotNull IByteBuffer buffer, long offset, @NotNull DynamicIntAdapter currentAdapter, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)currentAdapter, (String)"currentAdapter");
        super(buffer, offset, currentAdapter, count);
        this._arrayCount = CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset()));
        this._intBytes = this.get_currentAdapter().getElementByteSize();
        this._maxArrayCount = 65536 * this._intBytes / (2 + this._intBytes) - 1;
        this._cachedRangeMin = -1;
        this._cachedRangeMax = -1;
        this._cachedRangeInnerIndex = -1;
        this._L1Count = 64 / (2 + this._intBytes);
        this._lastValue = -1;
    }

    @Override
    public int get(int index2) {
        return this.readValue(this.getArrayIndex(index2));
    }

    private final int getArrayIndex(int index2) {
        boolean bl = 0 <= index2 ? index2 < this.get_count() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int realIndex = this._cachedRangeMin < 0 ? this.binarySearch(0, this._arrayCount - 1, index2) : (index2 >= this._cachedRangeMin ? (index2 < this._cachedRangeMax ? -(this._cachedRangeInnerIndex + 1) : (index2 == this._cachedRangeMax ? this._cachedRangeInnerIndex : this.binarySearch(this._cachedRangeInnerIndex + 1, this._arrayCount - 1, index2))) : this.binarySearch(0, this._cachedRangeInnerIndex - 1, index2));
        return realIndex < 0 ? -realIndex - 2 : realIndex;
    }

    private final int binarySearch(int lo, int hi, int target) {
        int x;
        int low = lo;
        int high = hi;
        this._cachedRangeMin = target;
        while (low + this._L1Count <= high) {
            int mid = low + high >>> 1;
            int middleValue = this.readIndex(mid);
            if (middleValue < target) {
                low = mid + 1;
                continue;
            }
            if (middleValue > target) {
                high = mid - 1;
                continue;
            }
            this._cachedRangeMax = this._cachedRangeMin;
            this._cachedRangeInnerIndex = mid;
            return mid;
        }
        for (x = low; x <= high; ++x) {
            int value2 = this.readIndex(x);
            if (value2 < target) continue;
            this._cachedRangeMax = value2;
            if (value2 != target) break;
            this._cachedRangeInnerIndex = x;
            return x;
        }
        if (x > high) {
            this._cachedRangeMax = x < this._arrayCount ? this.readIndex(x) : Integer.MAX_VALUE;
        }
        this._cachedRangeInnerIndex = x;
        return -(x + 1);
    }

    private final int readIndex(int arrayIndex) {
        return arrayIndex == 0 ? 0 : CommonTypesKt.toIntNoNegative(this.get_buffer().getShort(this.get_offset() + (long)(arrayIndex * (2 + this._intBytes))));
    }

    private final int readValue(int arrayIndex) {
        return this.get_currentAdapter().read(this.get_buffer(), this.get_offset() + (long)(arrayIndex * (2 + this._intBytes)) + (long)2);
    }

    @Override
    @NotNull
    public RunLengthSegment add(int value2) {
        if (value2 != this.getLastValue()) {
            if (this._arrayCount > this._maxArrayCount) {
                RunLengthSegment newSegment = this.switchToSimple();
                return newSegment.add(value2);
            }
            long position = this.get_offset() + (long)(this._arrayCount * (2 + this._intBytes));
            if (this.get_count() > 0) {
                this.get_buffer().putShort(position, (short)this.get_count());
            }
            this.get_currentAdapter().write(this.get_buffer(), position + (long)2, value2);
            RunLengthArraySegment runLengthArraySegment = this;
            int n = runLengthArraySegment._arrayCount;
            runLengthArraySegment._arrayCount = n + 1;
            this._lastValue = value2;
            this._cachedRangeMin = -1;
        }
        RunLengthArraySegment runLengthArraySegment = this;
        int n = runLengthArraySegment.get_count();
        runLengthArraySegment.set_count(n + 1);
        return this;
    }

    private final int getLastValue() {
        if (this._lastValue < 0 && this._arrayCount > 0) {
            this._lastValue = this.readValue(this._arrayCount - 1);
        }
        return this._lastValue;
    }

    @Override
    public void force() {
        this.get_buffer().putShort(this.get_offset(), (short)this._arrayCount);
    }

    @Override
    public long getNextSegmentOffset() {
        return this.get_offset() + (long)(this._arrayCount * (2 + this._intBytes));
    }

    private final RunLengthSegment switchToSimple() {
        int[] values = RunLengthArraySegment.Companion.getValuesCache(this.get_count());
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int value2;
            int index2 = n++;
            values[index2] = value2 = ((Number)iterator.next()).intValue();
        }
        RunLengthSegment newSegment = new RunLengthSimpleSegment(this.get_buffer(), this.get_offset(), this.get_currentAdapter(), 0);
        n = 0;
        int n2 = this.get_count();
        if (n < n2) {
            do {
                int i = n++;
                newSegment = newSegment.add(values[i]);
            } while (n < n2);
        }
        RunLengthArraySegment.Companion.releaseValuesCache(values);
        return newSegment;
    }

    @NotNull
    public IntIterator iterator() {
        return new ValueIterator();
    }

    @Override
    @NotNull
    protected RunLengthSegment createInstance(@NotNull DynamicIntAdapter newAdapter) {
        Intrinsics.checkNotNullParameter((Object)newAdapter, (String)"newAdapter");
        return new RunLengthArraySegment(this.get_buffer(), this.get_offset(), newAdapter, 0);
    }

    @Override
    public void batchGet(int start, int end, @NotNull int[] result, int destPos) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int startArrayIndex = this.getArrayIndex(start);
        int rangMax = 0;
        int currentValue = 0;
        int index2 = start;
        while (index2 <= end) {
            int nextArrayIndex;
            currentValue = this.readValue(startArrayIndex);
            int n = startArrayIndex;
            rangMax = (startArrayIndex = n + 1) < this._arrayCount ? ((nextArrayIndex = this.readIndex(startArrayIndex)) <= end ? nextArrayIndex : end + 1) : end + 1;
            n = destPos + (index2 - start);
            int n2 = destPos + (rangMax - start);
            if (n < n2) {
                do {
                    int i = n++;
                    result[i] = currentValue;
                } while (n < n2);
            }
            index2 = rangMax;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment$Companion;", "", "()V", "_valuesArrayCache", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getValuesCache", "size", "", "Lkd/bos/olapServer/common/int;", "releaseValuesCache", "", "valuesArray", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] getValuesCache(int size) {
            int[] valuesArray = _valuesArrayCache.getAndSet(null);
            if (valuesArray == null || valuesArray.length < size) {
                valuesArray = new int[size];
            }
            int[] nArray = valuesArray;
            return nArray;
        }

        private final void releaseValuesCache(int[] valuesArray) {
            _valuesArrayCache.compareAndSet(null, valuesArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment$ValueIterator;", "Lkotlin/collections/IntIterator;", "(Lkd/bos/olapServer/memoryMappedFiles/runLengthEncoding/RunLengthArraySegment;)V", "_arrayI", "", "_currentValue", "_i", "_rangeMax", "hasNext", "", "nextInt", "nextRange", "", "bos-olap-core"})
    private final class ValueIterator
    extends IntIterator {
        private int _i;
        private int _arrayI;
        private int _rangeMax;
        private int _currentValue;

        public ValueIterator() {
            Intrinsics.checkNotNullParameter((Object)RunLengthArraySegment.this, (String)"this$0");
            this._rangeMax = -1;
            this._currentValue = -1;
        }

        public int nextInt() {
            int n = RunLengthArraySegment.this.get_count();
            int n2 = this._i;
            boolean bl = 0 <= n2 ? n2 < n : false;
            if (bl) {
                if (this._i >= this._rangeMax) {
                    this.nextRange();
                }
                ValueIterator valueIterator = this;
                n2 = valueIterator._i;
                valueIterator._i = n2 + 1;
                return this._currentValue;
            }
            throw new IndexOutOfBoundsException();
        }

        private final void nextRange() {
            this._currentValue = RunLengthArraySegment.this.readValue(this._arrayI);
            ValueIterator valueIterator = this;
            int n = valueIterator._arrayI;
            valueIterator._arrayI = n + 1;
            this._rangeMax = this._arrayI < RunLengthArraySegment.this._arrayCount ? RunLengthArraySegment.this.readIndex(this._arrayI) : RunLengthArraySegment.this.get_count();
        }

        public boolean hasNext() {
            int n = RunLengthArraySegment.this.get_count();
            int n2 = this._i;
            return 0 <= n2 ? n2 < n : false;
        }
    }
}

