/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.metadata;

import java.io.Closeable;
import java.io.File;
import java.util.Set;
import kd.bos.olapServer.collections.IAddOrUpdateStrategy;
import kd.bos.olapServer.common.CommandTypes;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IInputRow;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.dataEntities.InputRow;
import kd.bos.olapServer.metadata.AbstractMetadata;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.InvalidDataMinBitmapBuilder;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.query.QueryBuilder;
import kd.bos.olapServer.selects.IDimensionSelectField;
import kd.bos.olapServer.selects.IMeasureSelectField;
import kd.bos.olapServer.selects.IQueryReader;
import kd.bos.olapServer.selects.IQuerySession;
import kd.bos.olapServer.selects.ISelectFieldCollection;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.LongIterator;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001:\u0005FGHIJB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\u0005H\u0002J\b\u0010-\u001a\u00020\u001cH\u0014J\u0014\u0010.\u001a\u00060/j\u0002`02\u0006\u00101\u001a\u000202H\u0014J\u0016\u00103\u001a\u00060/j\u0002`02\b\u00104\u001a\u0004\u0018\u000105H\u0014J\u0014\u00106\u001a\u00020/2\n\u00107\u001a\u00060\bj\u0002`\tH\u0002J\u0014\u00108\u001a\u00020/2\n\u00107\u001a\u00060\bj\u0002`\tH\u0002J\u0014\u00109\u001a\u00020/2\n\u00107\u001a\u00060\bj\u0002`\tH\u0002J\b\u0010:\u001a\u00020\u001cH\u0002J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=H\u0014J\u0006\u0010>\u001a\u00020\u001cJ\b\u0010?\u001a\u00020\u001cH\u0014J\u0010\u0010@\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020\u000bH\u0014J\u0014\u0010B\u001a\u00020\u001c*\u00020C2\u0006\u0010D\u001a\u00020EH\u0014R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\bj\u0002`\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006K"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder;", "Ljava/io/Closeable;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "source", "Lkd/bos/olapServer/storages/CubeWorkspace;", "(Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/storages/CubeWorkspace;)V", "_tempPath", "", "Lkd/bos/olapServer/common/string;", "newMetadata", "Lkd/bos/olapServer/metadata/Cube;", "getNewMetadata", "()Lkd/bos/olapServer/metadata/Cube;", "setNewMetadata", "(Lkd/bos/olapServer/metadata/Cube;)V", "getOlapWorkspace", "()Lkd/bos/olapServer/storages/OlapWorkspace;", "getSource", "()Lkd/bos/olapServer/storages/CubeWorkspace;", "sourceCubeName", "getSourceCubeName", "()Ljava/lang/String;", "sourceMetadata", "getSourceMetadata", "target", "getTarget", "close", "", "createAddOrUpdateStrategy", "Lkd/bos/olapServer/collections/IAddOrUpdateStrategy;", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "createCopyDimensionValueMap", "Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DimensionValueMap;", "targetDimension", "Lkd/bos/olapServer/metadata/Dimension;", "sourceDimension", "createDimensionValueMap", "createMeasureValueMap", "Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$MeasureValueMap;", "targetMeasure", "Lkd/bos/olapServer/metadata/Measure;", "createSourceIndexSequence", "Lkotlin/collections/LongIterator;", "createTempWorkspace", "endRebuild", "ignoreKey", "", "Lkd/bos/olapServer/common/bool;", "key", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "ignoreValue", "value", "", "isOldCubeJson", "fileName", "isOldTransactionFile", "isTransactionFile", "moveFiles", "reBuildMetadata", "builder", "Lkd/bos/olapServer/metadata/builds/CubeBuilder;", "rebuild", "rebuildInvalidDataMinBitmap", "writeToTarget", "cube", "addFunc", "Lkd/bos/olapServer/storages/IInputRowWriter;", "row", "Lkd/bos/olapServer/dataEntities/IInputRow;", "CopyDimensionValueMap", "DimensionValueMap", "DirectCopyDimensionValueMap", "DirectCopyMeasureValueMap", "MeasureValueMap", "bos-olap-core"})
public class CubeWorkspaceRebuilder
implements Closeable {
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace source;
    @NotNull
    private String _tempPath;
    @NotNull
    private final CubeWorkspace target;
    protected Cube newMetadata;

    public CubeWorkspaceRebuilder(@NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace source2) {
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.olapWorkspace = olapWorkspace;
        this.source = source2;
        this._tempPath = "";
        this.target = this.createTempWorkspace();
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace() {
        return this.olapWorkspace;
    }

    @NotNull
    public final CubeWorkspace getSource() {
        return this.source;
    }

    @NotNull
    public final CubeWorkspace getTarget() {
        return this.target;
    }

    private final String getSourceCubeName() {
        return this.source.getMetadata().getName();
    }

    private final Cube getSourceMetadata() {
        return this.source.getMetadata();
    }

    @NotNull
    protected final Cube getNewMetadata() {
        Cube cube = this.newMetadata;
        if (cube != null) {
            return cube;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"newMetadata");
        throw null;
    }

    protected final void setNewMetadata(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"<set-?>");
        this.newMetadata = cube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rebuild() {
        Closeable closeable = this.target.getMetadataStorage().createWriterContext();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IMetadataWriterContext context = (IMetadataWriterContext)closeable;
            boolean bl3 = false;
            this.reBuildMetadata(context.getCubeBuilder());
            context.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.target.onMetadataUpdated();
        this.setNewMetadata(this.target.getMetadata());
        this.source.getMetadataLock().enterWrite((Function0)new Function0<Unit>(this){
            final /* synthetic */ CubeWorkspaceRebuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.writeToTarget(this.this$0.getNewMetadata());
                this.this$0.getTarget().close();
                this.this$0.getOlapWorkspace().updateMetadata(CommandTypes.alter, CubeWorkspaceRebuilder.access$getSourceCubeName(this.this$0));
                CubeWorkspaceRebuilder.access$moveFiles(this.this$0);
                this.this$0.getOlapWorkspace().updateMetadata(CommandTypes.alter, CubeWorkspaceRebuilder.access$getSourceCubeName(this.this$0));
                this.this$0.endRebuild();
            }
        });
    }

    private final void moveFiles() {
        String[] stringArray = new String[]{this.getSourceCubeName()};
        File sourcePath = Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), stringArray).toFile();
        String[] stringArray2 = new String[]{Intrinsics.stringPlus((String)"##", (Object)this.getSourceCubeName())};
        File sourcePath2 = Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), stringArray2).toFile();
        Object[] objectArray = new String[]{"transaction.log", "cube.json"};
        Set doNotMoveFile = SetsKt.mutableSetOf((Object[])objectArray);
        objectArray = sourcePath.listFiles();
        if (objectArray != null) {
            Object[] $this$forEach$iv = objectArray;
            boolean $i$f$forEach = false;
            Object[] objectArray2 = $this$forEach$iv;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object file = element$iv = objectArray2[i];
                boolean bl = false;
                String fileName = ((File)file).getName();
                if (!((File)file).isFile()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                if (!this.isTransactionFile(fileName) && !this.isOldTransactionFile(fileName) && !this.isOldCubeJson(fileName)) continue;
                doNotMoveFile.add(fileName);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullExpressionValue((Object)sourcePath2, (String)"sourcePath2");
        FileTools.INSTANCE.moveDir(sourcePath, sourcePath2, doNotMoveFile, true);
        File tempPath = new File(this._tempPath);
        FileTools.INSTANCE.moveDir(tempPath, sourcePath, doNotMoveFile, true);
        String string = sourcePath2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcePath2.toString()");
        this._tempPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeToTarget(@NotNull Cube cube) {
        AbstractMetadata it;
        int n;
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        int n2 = 0;
        int n3 = cube.getDimensions().getCount();
        DimensionValueMap[] dimensionValueMapArray = new DimensionValueMap[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dimensionValueMapArray[n4] = this.createDimensionValueMap((Dimension)cube.getDimensions().get(n4));
        }
        DimensionValueMap[] dimensionMaps = dimensionValueMapArray;
        n3 = 0;
        int n5 = cube.getMeasures().getCount();
        MeasureValueMap[] measureValueMapArray = new MeasureValueMap[n5];
        while (n3 < n5) {
            n = n3++;
            measureValueMapArray[n] = this.createMeasureValueMap((Measure)cube.getMeasures().get(n));
        }
        MeasureValueMap[] measureMaps = measureValueMapArray;
        Object object = new QueryBuilder(this.getSourceMetadata());
        boolean bl = false;
        n = 0;
        QueryBuilder $this$writeToTarget_u24lambda_u2d4 = object;
        boolean bl2 = false;
        Iterable $this$forEach$iv = cube.getDimensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Dimension)element$iv;
            boolean bl3 = false;
            $this$writeToTarget_u24lambda_u2d4.addSelectField(((Dimension)it).getName());
        }
        $this$forEach$iv = cube.getMeasures();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Measure)element$iv;
            boolean bl4 = false;
            $this$writeToTarget_u24lambda_u2d4.addSelectField(((Measure)it).getName());
        }
        Query query2 = ((QueryBuilder)object).getQuery();
        object = this.source.createQuerySession(query2, false);
        bl = false;
        n = 0;
        Throwable throwable = null;
        try {
            IQuerySession session = (IQuerySession)object;
            boolean bl5 = false;
            Closeable closeable = session.createReader();
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable2 = null;
            try {
                int n6;
                IQueryReader sourceReader = (IQueryReader)closeable;
                boolean bl8 = false;
                InputRow targetRow = new InputRow(cube);
                ISelectFieldCollection iSelectFieldCollection = sourceReader.getSelectFields();
                boolean bl9 = false;
                boolean bl10 = false;
                ISelectFieldCollection $this$writeToTarget_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d5 = iSelectFieldCollection;
                boolean bl11 = false;
                int n7 = 0;
                int n8 = cube.getDimensions().getCount();
                IDimensionSelectField[] iDimensionSelectFieldArray = new IDimensionSelectField[n8];
                while (n7 < n8) {
                    n6 = n7++;
                    iDimensionSelectFieldArray[n6] = (IDimensionSelectField)$this$writeToTarget_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d5.get(n6);
                }
                IDimensionSelectField[] dimField = iDimensionSelectFieldArray;
                Object object2 = sourceReader.getSelectFields();
                bl10 = false;
                boolean bl12 = false;
                ISelectFieldCollection $this$writeToTarget_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d6 = object2;
                boolean bl13 = false;
                int firstMeaIndex2 = cube.getDimensions().getCount();
                int n9 = 0;
                n6 = cube.getMeasures().getCount();
                IMeasureSelectField[] iMeasureSelectFieldArray = new IMeasureSelectField[n6];
                while (n9 < n6) {
                    int n10 = n9++;
                    iMeasureSelectFieldArray[n10] = (IMeasureSelectField)$this$writeToTarget_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d6.get(n10 + firstMeaIndex2);
                }
                IMeasureSelectField[] meaField = iMeasureSelectFieldArray;
                object2 = this.getTarget().createWriter(this.createAddOrUpdateStrategy());
                bl10 = false;
                bl12 = false;
                Throwable throwable3 = null;
                try {
                    IInputRowWriter targetWriter = (IInputRowWriter)object2;
                    boolean bl14 = false;
                    try {
                        block33: while (sourceReader.next()) {
                            DimensionValueMap[] firstMeaIndex2 = dimensionMaps;
                            n6 = firstMeaIndex2.length;
                            for (int i = 0; i < n6; ++i) {
                                int dimIndex = i;
                                DimensionValueMap dimMap = firstMeaIndex2[i];
                                int value2 = dimMap.map(dimField[dimIndex].getCurrent());
                                if (value2 < 0) continue block33;
                                Member member = (Member)dimMap.getTargetDimension().getMembers().get(value2);
                                targetRow.setDimensionValue(dimMap.getTargetDimension(), member);
                            }
                            if (this.ignoreKey(targetRow.getKeys())) continue;
                            boolean deleteIt = true;
                            MeasureValueMap[] measureValueMapArray2 = measureMaps;
                            int n11 = measureValueMapArray2.length;
                            for (n6 = 0; n6 < n11; ++n6) {
                                int meaIndex = n6;
                                MeasureValueMap meaMap = measureValueMapArray2[n6];
                                Object value3 = meaMap.map(meaField[meaIndex].getCurrent());
                                deleteIt = deleteIt && this.ignoreValue(value3);
                                targetRow.setMeasureValue(meaMap.getTargetMeasure(), value3);
                            }
                            if (deleteIt) continue;
                            targetWriter.addOrUpdate(targetRow);
                        }
                    }
                    finally {
                        ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                        Closeable closeable2 = ptm;
                        n6 = 0;
                        boolean bl15 = false;
                        Throwable throwable4 = null;
                        try {
                            ParallelTaskManager it2 = (ParallelTaskManager)closeable2;
                            boolean bl16 = false;
                            targetWriter.force();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable4);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final boolean isOldTransactionFile(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"transaction_", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)fileName, (String)".log.zip", (boolean)false, (int)2, null);
    }

    private final boolean isTransactionFile(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"commands", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)fileName, (String)".log", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".logz", (boolean)false, (int)2, null));
    }

    @Nullable
    protected IAddOrUpdateStrategy<IMeasureValues> createAddOrUpdateStrategy() {
        return null;
    }

    private final boolean isOldCubeJson(String fileName) {
        return StringsKt.startsWith$default((String)fileName, (String)"cube.json.old", (boolean)false, (int)2, null);
    }

    protected void addFunc(@NotNull IInputRowWriter $this$addFunc, @NotNull IInputRow row) {
        Intrinsics.checkNotNullParameter((Object)$this$addFunc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        $this$addFunc.addOrUpdate(row);
    }

    private final CubeWorkspace createTempWorkspace() {
        String tempPath;
        this._tempPath = tempPath = FileTools.INSTANCE.getTempPath$bos_olap_core(this.olapWorkspace.getRootPath());
        this.source.getMetadataStorage().copyTo(tempPath);
        return new CubeWorkspace(tempPath, 0, 2, null);
    }

    protected void reBuildMetadata(@NotNull CubeBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    protected boolean ignoreKey(@NotNull IDimensionKeys key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return false;
    }

    protected boolean ignoreValue(@Nullable Object value2) {
        return value2 == null;
    }

    protected void endRebuild() {
        this.rebuildInvalidDataMinBitmap();
    }

    protected void rebuildInvalidDataMinBitmap() {
        CubeWorkspace cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this.source.getMetadata().getName());
        long rowCount = cubeWorkspace.getRowCount();
        if (rowCount > 0L && cubeWorkspace.getMetadata().getValidDataRules().getCount() > 0) {
            new InvalidDataMinBitmapBuilder(cubeWorkspace).build();
        }
    }

    @NotNull
    protected DimensionValueMap createDimensionValueMap(@NotNull Dimension targetDimension) {
        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
        Dimension sourceDimension = (Dimension)this.getSourceMetadata().getDimensions().tryGet(targetDimension.getName());
        if (sourceDimension != null) {
            return this.createCopyDimensionValueMap(targetDimension, sourceDimension);
        }
        Object[] objectArray = Res.INSTANCE.getCubeWorkspaceRebuilderException_1();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeWorkspaceRebuilderException_1");
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{targetDimension.getName()};
        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
    }

    @NotNull
    protected MeasureValueMap createMeasureValueMap(@NotNull Measure targetMeasure) {
        Intrinsics.checkNotNullParameter((Object)targetMeasure, (String)"targetMeasure");
        Measure sourceMeasure = (Measure)this.getSourceMetadata().getMeasures().tryGet(targetMeasure.getName());
        if (sourceMeasure != null) {
            return new DirectCopyMeasureValueMap(targetMeasure);
        }
        Object[] objectArray = Res.INSTANCE.getCubeWorkspaceRebuilderException_1();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CubeWorkspaceRebuilderException_1");
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{targetMeasure.getName()};
        throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
    }

    @NotNull
    protected LongIterator createSourceIndexSequence() {
        return RangesKt.until((int)0, (long)this.source.getRowCount()).iterator();
    }

    private final DimensionValueMap createCopyDimensionValueMap(Dimension targetDimension, Dimension sourceDimension) {
        MemberCollection sourceMembers = sourceDimension.getMembers();
        MemberCollection targetMembers = targetDimension.getMembers();
        int n = sourceMembers.getCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i;
            Member member = (Member)targetMembers.tryGet(((Member)sourceMembers.get(n3)).getName());
            nArray[n3] = member == null ? -1 : (n2 = member.getPosition$bos_olap_core());
        }
        int[] sourceMapToTarget = nArray;
        boolean directCopy = true;
        n = 0;
        int n4 = sourceMapToTarget.length + -1;
        if (n <= n4) {
            do {
                int i;
                if ((i = n++) == sourceMapToTarget[i]) continue;
                directCopy = false;
                break;
            } while (n <= n4);
        }
        return directCopy ? (DimensionValueMap)new DirectCopyDimensionValueMap(targetDimension) : (DimensionValueMap)new CopyDimensionValueMap(targetDimension, sourceMapToTarget);
    }

    @Override
    public void close() {
        this.target.close();
        CharSequence charSequence = this._tempPath;
        boolean bl = false;
        if (charSequence.length() > 0) {
            boolean deleted = FilesKt.deleteRecursively((File)new File(this._tempPath));
            bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (!deleted) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public static final /* synthetic */ String access$getSourceCubeName(CubeWorkspaceRebuilder $this) {
        return $this.getSourceCubeName();
    }

    public static final /* synthetic */ void access$moveFiles(CubeWorkspaceRebuilder $this) {
        $this.moveFiles();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\tH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DimensionValueMap;", "", "targetDimension", "Lkd/bos/olapServer/metadata/Dimension;", "(Lkd/bos/olapServer/metadata/Dimension;)V", "getTargetDimension", "()Lkd/bos/olapServer/metadata/Dimension;", "map", "", "Lkd/bos/olapServer/common/int;", "sourceMemberPosition", "bos-olap-core"})
    public static abstract class DimensionValueMap {
        @NotNull
        private final Dimension targetDimension;

        public DimensionValueMap(@NotNull Dimension targetDimension) {
            Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
            this.targetDimension = targetDimension;
        }

        @NotNull
        public final Dimension getTargetDimension() {
            return this.targetDimension;
        }

        public abstract int map(int var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007H\u0016\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DirectCopyDimensionValueMap;", "Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DimensionValueMap;", "targetDimension", "Lkd/bos/olapServer/metadata/Dimension;", "(Lkd/bos/olapServer/metadata/Dimension;)V", "map", "", "Lkd/bos/olapServer/common/int;", "sourceMemberPosition", "bos-olap-core"})
    private static final class DirectCopyDimensionValueMap
    extends DimensionValueMap {
        public DirectCopyDimensionValueMap(@NotNull Dimension targetDimension) {
            Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
            super(targetDimension);
        }

        @Override
        public int map(int sourceMemberPosition) {
            return sourceMemberPosition;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$CopyDimensionValueMap;", "Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DimensionValueMap;", "targetDimension", "Lkd/bos/olapServer/metadata/Dimension;", "sourceMapToTarget", "", "(Lkd/bos/olapServer/metadata/Dimension;[I)V", "getSourceMapToTarget", "()[I", "map", "", "Lkd/bos/olapServer/common/int;", "sourceMemberPosition", "bos-olap-core"})
    private static final class CopyDimensionValueMap
    extends DimensionValueMap {
        @NotNull
        private final int[] sourceMapToTarget;

        public CopyDimensionValueMap(@NotNull Dimension targetDimension, @NotNull int[] sourceMapToTarget) {
            Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
            Intrinsics.checkNotNullParameter((Object)sourceMapToTarget, (String)"sourceMapToTarget");
            super(targetDimension);
            this.sourceMapToTarget = sourceMapToTarget;
        }

        @NotNull
        public final int[] getSourceMapToTarget() {
            return this.sourceMapToTarget;
        }

        @Override
        public int map(int sourceMemberPosition) {
            return this.sourceMapToTarget[sourceMemberPosition];
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$MeasureValueMap;", "", "targetMeasure", "Lkd/bos/olapServer/metadata/Measure;", "(Lkd/bos/olapServer/metadata/Measure;)V", "getTargetMeasure", "()Lkd/bos/olapServer/metadata/Measure;", "map", "meaValue", "bos-olap-core"})
    public static abstract class MeasureValueMap {
        @NotNull
        private final Measure targetMeasure;

        public MeasureValueMap(@NotNull Measure targetMeasure) {
            Intrinsics.checkNotNullParameter((Object)targetMeasure, (String)"targetMeasure");
            this.targetMeasure = targetMeasure;
        }

        @NotNull
        public final Measure getTargetMeasure() {
            return this.targetMeasure;
        }

        @Nullable
        public abstract Object map(@Nullable Object var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$DirectCopyMeasureValueMap;", "Lkd/bos/olapServer/metadata/CubeWorkspaceRebuilder$MeasureValueMap;", "targetMeasure", "Lkd/bos/olapServer/metadata/Measure;", "(Lkd/bos/olapServer/metadata/Measure;)V", "map", "", "meaValue", "bos-olap-core"})
    private static final class DirectCopyMeasureValueMap
    extends MeasureValueMap {
        public DirectCopyMeasureValueMap(@NotNull Measure targetMeasure) {
            Intrinsics.checkNotNullParameter((Object)targetMeasure, (String)"targetMeasure");
            super(targetMeasure);
        }

        @Override
        @Nullable
        public Object map(@Nullable Object meaValue) {
            return meaValue;
        }
    }
}

