/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.metadata;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import kd.bos.olapServer.common.CellSet;
import kd.bos.olapServer.common.CommandTypes;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataSources.MetadataCommandInfo;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.IPartitionItem;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.MeasureCollection;
import kd.bos.olapServer.metadata.MetadataTypes;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.metadata.builds.MeasureBuilder;
import kd.bos.olapServer.metadata.events.AlterMeasureEvent;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.Res;
import kd.bos.olapServer.tools.StringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u000e\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\rH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/metadata/MeasureMetadataCommand;", "", "metadataCmdInfo", "Lkd/bos/olapServer/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "(Lkd/bos/olapServer/dataSources/MetadataCommandInfo;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/storages/CubeWorkspace;)V", "alterMeasure", "", "uniqueName", "", "Lkd/bos/olapServer/common/string;", "createMeasure", "cubeName", "dropMeasure", "execute", "Lkd/bos/olapServer/common/CellSet;", "bos-olap-core"})
public final class MeasureMetadataCommand {
    @NotNull
    private final MetadataCommandInfo metadataCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;

    public MeasureMetadataCommand(@NotNull MetadataCommandInfo metadataCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)metadataCmdInfo, (String)"metadataCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.metadataCmdInfo = metadataCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
    }

    @Nullable
    public final CellSet execute() {
        boolean bl = this.metadataCmdInfo.getMetadataType() == MetadataTypes.Measure;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        int n = 0;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List<String> list = StringValidator.INSTANCE.validateOwnerUniqueName(this.cubeWorkspace.getMetadata(), this.metadataCmdInfo.getOwnerUniqueName(), MetadataTypes.Measure);
        Object object = list;
        n = 0;
        String cubeName = object.get(0);
        object = this.metadataCmdInfo.getAction();
        n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                this.createMeasure(cubeName);
                break;
            }
            case 2: {
                this.alterMeasure(cubeName);
                break;
            }
            case 3: {
                this.dropMeasure(cubeName);
                break;
            }
            default: {
                Object[] objectArray = Res.INSTANCE.getCommonException_7();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.CommonException_7");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.metadataCmdInfo.getAction()};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
        }
        return null;
    }

    private final void alterMeasure(String uniqueName) {
        MeasureCollection measures2 = this.cubeWorkspace.getMetadata().getMeasures();
        int n = 0;
        int n2 = measures2.getCount();
        Measure[] measureArray = new Measure[n2];
        while (n < n2) {
            int n3 = n++;
            measureArray[n3] = (Measure)measures2.get(n3);
        }
        Measure[] measureObj = measureArray;
        AlterMeasureEvent alterMeasureEvent = new AlterMeasureEvent(this.olapWorkspace, this.cubeWorkspace, uniqueName, measureObj, this.metadataCmdInfo.getDataType());
        this.cubeWorkspace.getMetadataStorage().invokeEvent(alterMeasureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createMeasure(String cubeName) {
        String measureName = this.metadataCmdInfo.getName();
        StringValidator.INSTANCE.validate(measureName);
        Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
            boolean bl3 = false;
            CubeBuilder cubeBuilder = writerContext.getCubeBuilder();
            if (cubeBuilder.getDimensions().contains(measureName)) {
                Object[] objectArray = Res.INSTANCE.getDimensionMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.DimensionMetadataCommandException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{measureName, cubeName};
                throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
            }
            if (cubeBuilder.getMeasures().contains(measureName)) {
                Object[] objectArray = Res.INSTANCE.getMeasureMetadataCommandException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MeasureMetadataCommandException_1");
                Object[] objectArray3 = objectArray;
                objectArray = new Object[]{measureName, cubeName};
                throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
            }
            long currentCount = this.cubeWorkspace.getRowCount();
            if (currentCount > 0L) {
                Object[] objectArray = Res.INSTANCE.getMeasureMetadataCommandException_4();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MeasureMetadataCommandException_4");
                Object[] objectArray4 = objectArray;
                objectArray = new Object[]{cubeName, measureName};
                throw Res.INSTANCE.getNotSupportedException((String)objectArray4, objectArray);
            }
            MeasureBuilder measureBuilder = (MeasureBuilder)cubeBuilder.getMeasures().add(measureName);
            measureBuilder.setDataType(this.metadataCmdInfo.getDataType());
            measureBuilder.setAllowNull(this.metadataCmdInfo.getAllowNull());
            writerContext.save();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.olapWorkspace.updateMetadata(CommandTypes.alter, cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dropMeasure(String cubeName) {
        String measureName = ((Measure)this.cubeWorkspace.getMetadata().getMeasures().get(this.metadataCmdInfo.getName())).getName();
        if (this.cubeWorkspace.getRowCount() == 0L) {
            Closeable closeable = this.cubeWorkspace.getMetadataStorage().createWriterContext();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                IMetadataWriterContext writerContext = (IMetadataWriterContext)closeable;
                boolean bl3 = false;
                writerContext.getCubeBuilder().getMeasures().remove(measureName);
                writerContext.save();
                writerContext = Unit.INSTANCE;
            }
            catch (Throwable writerContext) {
                throwable = writerContext;
                throw writerContext;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            Object[] objectArray = Res.INSTANCE.getMeasureMetadataCommandException_2();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.MeasureMetadataCommandException_2");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{cubeName, measureName};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
        this.olapWorkspace.updateMetadata(CommandTypes.alter, cubeName);
        Cube cube = this.cubeWorkspace.getMetadata();
        if (cube.getEnabledPartition()) {
            List<IPartitionItem> partitions = cube.getPartition().getAllPartitionItems();
            Iterable $this$forEach$iv = partitions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPartitionItem it = (IPartitionItem)element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{cubeName, it.getKey(), measureName};
                FileTools.INSTANCE.deleteDir(new File(((Object)Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), stringArray)).toString()));
            }
        } else {
            String[] stringArray = new String[]{cubeName, measureName};
            FileTools.INSTANCE.deleteDir(new File(((Object)Paths.INSTANCE.get(this.olapWorkspace.getRootPath(), stringArray)).toString()));
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandTypes.values().length];
            nArray[CommandTypes.create.ordinal()] = 1;
            nArray[CommandTypes.alter.ordinal()] = 2;
            nArray[CommandTypes.drop.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

