/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.metadata;

import java.nio.channels.ClosedChannelException;
import kd.bos.olapServer.common.CellSet;
import kd.bos.olapServer.common.CommandTypes;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.dataSources.MetadataCommandInfo;
import kd.bos.olapServer.metadata.AggFactorMetadataCommand;
import kd.bos.olapServer.metadata.AggShieldRuleMetadataCommand;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.CubeCreateMetadataCommand;
import kd.bos.olapServer.metadata.CubeMetadataCommand;
import kd.bos.olapServer.metadata.DimensionMetadataCommand;
import kd.bos.olapServer.metadata.MeasureMetadataCommand;
import kd.bos.olapServer.metadata.MemberMetadataCommand;
import kd.bos.olapServer.metadata.MetadataCommandExecutor;
import kd.bos.olapServer.metadata.MetadataTypes;
import kd.bos.olapServer.metadata.PartitionMetadataCommand;
import kd.bos.olapServer.metadata.ValidDataRuleMetadataCommand;
import kd.bos.olapServer.performanceStatistics.CommandContext;
import kd.bos.olapServer.replication.LocalRedo;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.transactions.ITransaction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkd/bos/olapServer/metadata/MetadataCommandExecutor;", "", "metaCmdInfo", "Lkd/bos/olapServer/dataSources/MetadataCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "(Lkd/bos/olapServer/dataSources/MetadataCommandInfo;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/storages/CubeWorkspace;)V", "cubeName", "", "Lkd/bos/olapServer/common/string;", "commandContext", "Lkd/bos/olapServer/performanceStatistics/CommandContext;", "(Lkd/bos/olapServer/dataSources/MetadataCommandInfo;Lkd/bos/olapServer/storages/OlapWorkspace;Ljava/lang/String;Lkd/bos/olapServer/performanceStatistics/CommandContext;)V", "_cubeWorkspace", "(Lkd/bos/olapServer/dataSources/MetadataCommandInfo;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/storages/CubeWorkspace;Ljava/lang/String;Lkd/bos/olapServer/performanceStatistics/CommandContext;)V", "run", "Lkd/bos/olapServer/common/CellSet;", "bos-olap-core"})
public final class MetadataCommandExecutor {
    @NotNull
    private final MetadataCommandInfo metaCmdInfo;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @Nullable
    private final CubeWorkspace _cubeWorkspace;
    @NotNull
    private final CommandContext commandContext;
    @NotNull
    private final String cubeName;

    private MetadataCommandExecutor(MetadataCommandInfo metaCmdInfo, OlapWorkspace olapWorkspace, CubeWorkspace _cubeWorkspace, String cubeName, CommandContext commandContext) {
        this.metaCmdInfo = metaCmdInfo;
        this.olapWorkspace = olapWorkspace;
        this._cubeWorkspace = _cubeWorkspace;
        this.commandContext = commandContext;
        CharSequence charSequence = cubeName;
        boolean bl = false;
        this.cubeName = charSequence.length() == 0 && this.metaCmdInfo.getMetadataType() == MetadataTypes.Cube && this.metaCmdInfo.getAction() == CommandTypes.create ? this.metaCmdInfo.getName() : cubeName;
    }

    /* synthetic */ MetadataCommandExecutor(MetadataCommandInfo metadataCommandInfo, OlapWorkspace olapWorkspace, CubeWorkspace cubeWorkspace, String string, CommandContext commandContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            commandContext = new CommandContext();
        }
        this(metadataCommandInfo, olapWorkspace, cubeWorkspace, string, commandContext);
    }

    public MetadataCommandExecutor(@NotNull MetadataCommandInfo metaCmdInfo, @NotNull OlapWorkspace olapWorkspace, @Nullable CubeWorkspace cubeWorkspace) {
        String string;
        Cube cube;
        Intrinsics.checkNotNullParameter((Object)metaCmdInfo, (String)"metaCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        CubeWorkspace cubeWorkspace2 = cubeWorkspace;
        this(metaCmdInfo, olapWorkspace, cubeWorkspace, cubeWorkspace2 == null ? "" : ((cube = cubeWorkspace2.getMetadata()) == null ? "" : ((string = cube.getName()) == null ? "" : string)), null, 16, null);
    }

    public MetadataCommandExecutor(@NotNull MetadataCommandInfo metaCmdInfo, @NotNull OlapWorkspace olapWorkspace, @NotNull String cubeName, @NotNull CommandContext commandContext) {
        Intrinsics.checkNotNullParameter((Object)metaCmdInfo, (String)"metaCmdInfo");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"commandContext");
        this(metaCmdInfo, olapWorkspace, null, cubeName, commandContext);
    }

    public /* synthetic */ MetadataCommandExecutor(MetadataCommandInfo metadataCommandInfo, OlapWorkspace olapWorkspace, String string, CommandContext commandContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            commandContext = new CommandContext();
        }
        this(metadataCommandInfo, olapWorkspace, string, commandContext);
    }

    @Nullable
    public final CellSet run() {
        CellSet cellSet;
        if (this.metaCmdInfo.getMetadataType() == MetadataTypes.Cube && this.metaCmdInfo.getAction() == CommandTypes.create) {
            boolean bl = Intrinsics.areEqual((Object)this.cubeName, (Object)this.metaCmdInfo.getName());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "cubeName in initialcatalog is different from cubeName in commandInfo";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            cellSet = new CubeCreateMetadataCommand(this.metaCmdInfo, this.olapWorkspace, this.commandContext).execute();
        } else {
            CubeWorkspace cubeWorkspace = this._cubeWorkspace;
            CubeWorkspace cubeWorkspace2 = cubeWorkspace == null ? this.olapWorkspace.getCubeWorkspace(this.cubeName) : cubeWorkspace;
            cellSet = (CellSet)cubeWorkspace2.getMetadataLock().enterWrite((Function0)new Function0<CellSet>(cubeWorkspace2, this){
                final /* synthetic */ CubeWorkspace $cubeWorkspace;
                final /* synthetic */ MetadataCommandExecutor this$0;
                {
                    this.$cubeWorkspace = $cubeWorkspace;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final CellSet invoke() {
                    Object object;
                    if (this.$cubeWorkspace.isClosed()) {
                        throw new ClosedChannelException();
                    }
                    ITransaction tran = this.$cubeWorkspace.getTransactionManager().beginTransaction();
                    try {
                        CellSet cellSet;
                        ReplicationManager.INSTANCE.disableCube(this.$cubeWorkspace.getCubeId());
                        object = MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0).getMetadataType();
                        int n = run.WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
                        switch (n) {
                            case 1: {
                                cellSet = new CubeMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace, MetadataCommandExecutor.access$getCommandContext$p(this.this$0)).execute();
                                break;
                            }
                            case 2: {
                                cellSet = new DimensionMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 3: {
                                cellSet = new MemberMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 4: {
                                cellSet = new MeasureMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 5: {
                                cellSet = new PartitionMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 6: {
                                cellSet = new AggFactorMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 7: {
                                cellSet = new AggShieldRuleMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            case 8: {
                                cellSet = new ValidDataRuleMetadataCommand(MetadataCommandExecutor.access$getMetaCmdInfo$p(this.this$0), MetadataCommandExecutor.access$getOlapWorkspace$p(this.this$0), this.$cubeWorkspace).execute();
                                break;
                            }
                            default: {
                                throw new NotSupportedException();
                            }
                        }
                        object = cellSet;
                        CubeWorkspace cubeWorkspace = this.$cubeWorkspace;
                        MetadataCommandExecutor metadataCommandExecutor = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object;
                        boolean bl3 = false;
                        if (ReplicationManager.INSTANCE.getEnableMaster()) {
                            LocalRedo localRedo = new LocalRedo(ReplicationManager.INSTANCE.getMaster());
                            localRedo.addDDLRecord(tran.getVersion().getId(), cubeWorkspace.getCubeId(), MetadataCommandExecutor.access$getMetaCmdInfo$p(metadataCommandExecutor).toString());
                            localRedo.flushSyncSlaves();
                        }
                        tran.commit();
                        MetadataCommandExecutor.access$getCommandContext$p(metadataCommandExecutor).updateTransactionVersion(tran.getVersion().getId());
                    }
                    catch (Exception e) {
                        tran.rollback();
                        throw e;
                    }
                    finally {
                        ReplicationManager.INSTANCE.enableCube(this.$cubeWorkspace.getCubeId());
                    }
                    return object;
                }
            });
        }
        return cellSet;
    }

    public static final /* synthetic */ MetadataCommandInfo access$getMetaCmdInfo$p(MetadataCommandExecutor $this) {
        return $this.metaCmdInfo;
    }

    public static final /* synthetic */ OlapWorkspace access$getOlapWorkspace$p(MetadataCommandExecutor $this) {
        return $this.olapWorkspace;
    }

    public static final /* synthetic */ CommandContext access$getCommandContext$p(MetadataCommandExecutor $this) {
        return $this.commandContext;
    }
}

