/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.metadata.builds;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.DimensionBuilder;
import kd.bos.olapServer.metadata.builds.MeasureBuilder;
import kd.bos.olapServer.storages.selectors.ExtensionTypes;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olapServer/metadata/builds/FileFormatChecker;", "", "path", "", "Lkd/bos/olapServer/common/string;", "cubeBuilder", "Lkd/bos/olapServer/metadata/builds/CubeBuilder;", "(Ljava/lang/String;Lkd/bos/olapServer/metadata/builds/CubeBuilder;)V", "repair", "", "repairDimensionDataFormat", "dimBuilder", "Lkd/bos/olapServer/metadata/builds/DimensionBuilder;", "repairDimensionIndexFormat", "repairMeasureFormat", "measureBuilder", "Lkd/bos/olapServer/metadata/builds/MeasureBuilder;", "Companion", "bos-olap-core"})
public final class FileFormatChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    private final CubeBuilder cubeBuilder;
    @NotNull
    public static final String DimensionDataFormat_RK2 = "rk2";
    @NotNull
    public static final String DimensionDataFormat_RK = "rk";
    @NotNull
    public static final String DimensionDataFormat_DK = "dk";
    @NotNull
    public static final String DimensionIndexFormat_MV2 = "mv2";
    @NotNull
    public static final String DimensionIndexFormat_MV3 = "mv3";
    @NotNull
    public static final String Current_DimensionIndexFormat = "mv3";
    @NotNull
    public static final String MeasureFormat_Decimal = "decimal";
    @NotNull
    public static final String MeasureFormat_Object = "object";

    public FileFormatChecker(@NotNull String path, @NotNull CubeBuilder cubeBuilder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)cubeBuilder, (String)"cubeBuilder");
        this.path = path;
        this.cubeBuilder = cubeBuilder;
    }

    public final void repair() {
        boolean bl;
        CharSequence charSequence;
        for (DimensionBuilder dimBuilder : this.cubeBuilder.getDimensions()) {
            charSequence = dimBuilder.getDataFormat();
            bl = false;
            if (charSequence.length() == 0) {
                this.repairDimensionDataFormat(dimBuilder);
            }
            charSequence = dimBuilder.getIndexFormat();
            bl = false;
            if (!(charSequence.length() == 0)) continue;
            this.repairDimensionIndexFormat(dimBuilder);
        }
        for (MeasureBuilder measureBuilder : this.cubeBuilder.getMeasures()) {
            charSequence = measureBuilder.getDataFormat();
            bl = false;
            if (!(charSequence.length() == 0)) continue;
            this.repairMeasureFormat(measureBuilder);
        }
    }

    private final void repairDimensionDataFormat(DimensionBuilder dimBuilder) {
        String[] stringArray = new String[]{dimBuilder.getName()};
        Path dimPath = Paths.INSTANCE.get(this.path, stringArray);
        if (Files.exists(dimPath, new LinkOption[0])) {
            String[] stringArray2 = new String[]{Intrinsics.stringPlus((String)dimBuilder.getName(), (Object)".rk2")};
            Path rk2DataPath = Paths.INSTANCE.get(((Object)dimPath).toString(), stringArray2);
            if (Files.exists(rk2DataPath, new LinkOption[0])) {
                dimBuilder.setDataFormat(DimensionDataFormat_RK2);
                return;
            }
            String[] stringArray3 = new String[]{Intrinsics.stringPlus((String)dimBuilder.getName(), (Object)".rk")};
            Path rkDataPath = Paths.INSTANCE.get(((Object)dimPath).toString(), stringArray3);
            if (Files.exists(rkDataPath, new LinkOption[0])) {
                dimBuilder.setDataFormat(DimensionDataFormat_RK);
                return;
            }
            String[] stringArray4 = new String[]{Intrinsics.stringPlus((String)dimBuilder.getName(), (Object)".dk")};
            Path dkDataPath = Paths.INSTANCE.get(((Object)dimPath).toString(), stringArray4);
            if (Files.exists(dkDataPath, new LinkOption[0])) {
                dimBuilder.setDataFormat(DimensionDataFormat_DK);
                return;
            }
        }
    }

    private final void repairDimensionIndexFormat(DimensionBuilder dimBuilder) {
        if (dimBuilder.getMembers().size() == 0) {
            return;
        }
        String[] stringArray = new String[]{dimBuilder.getName()};
        Path dimPath = Paths.INSTANCE.get(this.path, stringArray);
        if (Files.exists(dimPath, new LinkOption[0])) {
            Object[] objectArray = new String[]{"main.mv3dat"};
            Path mv3Path = Paths.INSTANCE.get(((Object)dimPath).toString(), (String[])objectArray);
            if (Files.exists(mv3Path, new LinkOption[0])) {
                dimBuilder.setIndexFormat("mv3");
                return;
            }
            objectArray = new File(((Object)dimPath).toString()).listFiles();
            if (objectArray != null) {
                Object[] $this$forEach$iv = objectArray;
                boolean $i$f$forEach = false;
                Object[] objectArray2 = $this$forEach$iv;
                int n = objectArray2.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object file = element$iv = objectArray2[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    String string = FilesKt.getExtension((File)file);
                    if (Intrinsics.areEqual((Object)string, (Object)ExtensionTypes.INSTANCE.getMinV2DataType())) {
                        dimBuilder.setIndexFormat(DimensionIndexFormat_MV2);
                        return;
                    }
                    if (!((Intrinsics.areEqual((Object)string, (Object)ExtensionTypes.INSTANCE.getMinDataType()) ? true : Intrinsics.areEqual((Object)string, (Object)ExtensionTypes.INSTANCE.getRoaringDataType())) ? true : Intrinsics.areEqual((Object)string, (Object)ExtensionTypes.INSTANCE.getBasicDataType()))) continue;
                    Object[] objectArray3 = Res.INSTANCE.getFileFormatCheckerException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"Res.FileFormatCheckerException_1");
                    Object[] objectArray4 = objectArray3;
                    objectArray3 = new Object[]{file};
                    throw Res.INSTANCE.getNotSupportedException((String)objectArray4, objectArray3);
                }
            }
        }
    }

    private final void repairMeasureFormat(MeasureBuilder measureBuilder) {
        String[] stringArray = new String[]{measureBuilder.getName()};
        Path measurePath = Paths.INSTANCE.get(this.path, stringArray);
        if (Files.exists(measurePath, new LinkOption[0])) {
            String[] stringArray2 = new String[]{"index.yxw"};
            Path objectPath = Paths.INSTANCE.get(((Object)measurePath).toString(), stringArray2);
            if (Files.exists(objectPath, new LinkOption[0])) {
                measureBuilder.setDataFormat(MeasureFormat_Object);
                return;
            }
            String[] stringArray3 = new String[]{"main.dat"};
            Path decimalPath = Paths.INSTANCE.get(((Object)measurePath).toString(), stringArray3);
            if (Files.exists(decimalPath, new LinkOption[0])) {
                measureBuilder.setDataFormat(MeasureFormat_Decimal);
                return;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/metadata/builds/FileFormatChecker$Companion;", "", "()V", "Current_DimensionIndexFormat", "", "DimensionDataFormat_DK", "DimensionDataFormat_RK", "DimensionDataFormat_RK2", "DimensionIndexFormat_MV2", "DimensionIndexFormat_MV3", "MeasureFormat_Decimal", "MeasureFormat_Object", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

