/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.metadata.builds;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.metadata.OlapMetadata;
import kd.bos.olapServer.metadata.builds.CubeBuilder;
import kd.bos.olapServer.metadata.builds.CubeEntry;
import kd.bos.olapServer.metadata.builds.IMetadataWriterContext;
import kd.bos.olapServer.metadata.builds.OlapMetadataBuilderOld;
import kd.bos.olapServer.metadata.builds.OlapMetadataBuilderV2;
import kd.bos.olapServer.metadata.builds.OlapMetadataBuilderV3;
import kd.bos.olapServer.metadata.builds.PropertyValueBuilder;
import kd.bos.olapServer.storages.IMetadataDatabase;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.JsonHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=OlapMetadataBuilderOld.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OlapMetadataBuilderOld.class, name="olap_metadata_old"), @JsonSubTypes.Type(value=OlapMetadataBuilderV2.class, name="olap_metadata.v2"), @JsonSubTypes.Type(value=OlapMetadataBuilderV3.class, name="olap_metadata.v3")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b!\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0013\u0012\f\b\u0001\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\b2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004J\b\u0010\u0012\u001a\u00020\u0013H&J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\b2\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004JF\u0010\u0015\u001a\u00020\u00132\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u000422\u0010\u0016\u001a.\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0017j\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u0004`\u0018J\b\u0010\u0019\u001a\u00020\u0000H\u0016R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkd/bos/olapServer/metadata/builds/OlapMetadataBuilder;", "", "path", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "cubes", "", "Lkd/bos/olapServer/metadata/builds/CubeEntry;", "getCubes", "()Ljava/util/List;", "build", "Lkd/bos/olapServer/metadata/OlapMetadata;", "indexOf", "", "Lkd/bos/olapServer/common/int;", "name", "remove", "save", "", "tryGetCubeEntry", "updateProperties", "propertyMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "upgrade", "Companion", "bos-olap-core"})
public abstract class OlapMetadataBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;

    public OlapMetadataBuilder(@JacksonInject(value="path") @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public abstract List<CubeEntry> getCubes();

    @Nullable
    public final CubeEntry tryGetCubeEntry(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int index2 = this.indexOf(name2);
        return index2 < 0 ? null : this.getCubes().get(index2);
    }

    @Nullable
    public final CubeEntry remove(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int index2 = this.indexOf(name2);
        return index2 < 0 ? null : this.getCubes().remove(index2);
    }

    private final int indexOf(String name2) {
        int n;
        block2: {
            List<CubeEntry> $this$indexOfFirst$iv = this.getCubes();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<CubeEntry> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                CubeEntry item$iv;
                CubeEntry it = item$iv = iterator.next();
                boolean bl = false;
                if (StringsKt.equals((String)name2, (String)it.getName(), (boolean)true)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final void updateProperties(@NotNull String name2, @NotNull HashMap<String, String> propertyMap) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(propertyMap, (String)"propertyMap");
        int index2 = this.indexOf(name2);
        CubeEntry cubeEntry = this.getCubes().get(index2);
        CubeEntry newCubeEntry = new CubeEntry(cubeEntry.getId(), cubeEntry.getName(), propertyMap);
        this.getCubes().set(index2, newCubeEntry);
    }

    @NotNull
    public final OlapMetadata build() {
        Collection $this$toTypedArray$iv = this.getCubes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CubeEntry[] cubeEntryArray = thisCollection$iv.toArray(new CubeEntry[0]);
        if (cubeEntryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new OlapMetadata(cubeEntryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public OlapMetadataBuilder upgrade() {
        OlapMetadataBuilderV3 builder = new OlapMetadataBuilderV3(this.path);
        Iterable $this$forEach$iv = this.getCubes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CubeEntry cubeEntry = (CubeEntry)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            Object object = new String[]{cubeEntry.getName()};
            File cubeDir = Paths.INSTANCE.get(this.path, (String)object).toFile();
            if (cubeDir.exists()) {
                try {
                    object = cubeDir.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cubeDir.absolutePath");
                    object = IMetadataDatabase.Companion.readFrom((String)object).createWriterContext();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Throwable throwable = null;
                    try {
                        IMetadataWriterContext writerContext = (IMetadataWriterContext)object;
                        boolean bl5 = false;
                        CubeBuilder.PropertyValueBuilderCollection properties2 = writerContext.getCubeBuilder().getProperties();
                        Iterable $this$forEach$iv2 = properties2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PropertyValueBuilder it = (PropertyValueBuilder)element$iv2;
                            boolean bl6 = false;
                            Map map = propertyMap;
                            String string = it.getName();
                            String string2 = it.getValue();
                            boolean bl7 = false;
                            map.put(string, string2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
                catch (Exception ex) {
                    String string = Intrinsics.stringPlus((String)cubeEntry.getName(), (Object)" upgrade failed\uff1a");
                    boolean bl8 = false;
                    System.out.println((Object)string);
                    ex.printStackTrace();
                }
            }
            builder.getCubes().add(new CubeEntry(cubeEntry.getId(), cubeEntry.getName(), propertyMap));
        }
        builder.save();
        return builder;
    }

    public abstract void save();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/metadata/builds/OlapMetadataBuilder$Companion;", "", "()V", "readFrom", "Lkd/bos/olapServer/metadata/builds/OlapMetadataBuilder;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapMetadataBuilder readFrom(@NotNull String rootPath) {
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            String[] stringArray = new String[]{"index.json"};
            String directoryFileNames = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
            if (FileTools.INSTANCE.isExist(directoryFileNames)) {
                OlapMetadataBuilder olapMetadataBuilder;
                ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
                InjectableValues.Std inject = new InjectableValues.Std().addValue("path", (Object)rootPath);
                OlapMetadataBuilder builder = (OlapMetadataBuilder)mapper.reader(OlapMetadataBuilder.class).with((InjectableValues)inject).readValue(new File(directoryFileNames));
                OlapMetadataBuilder olapMetadataBuilder2 = builder;
                if (olapMetadataBuilder2 instanceof OlapMetadataBuilderOld ? true : olapMetadataBuilder2 instanceof OlapMetadataBuilderV2) {
                    olapMetadataBuilder = builder.upgrade();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
                    olapMetadataBuilder = builder;
                }
                return olapMetadataBuilder;
            }
            return new OlapMetadataBuilderV3(rootPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

