/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.performanceStatistics;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataSources.AggExpression;
import kd.bos.olapServer.dataSources.ComputingCommandInfo;
import kd.bos.olapServer.dataSources.DimensionFilterItem;
import kd.bos.olapServer.dataSources.FelLambdaExpression;
import kd.bos.olapServer.dataSources.SelectCommandInfo;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.OlapMetadata;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.FileTools;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010B\u001a\u00020CH\u0016J9\u0010D\u001a\u00020\n2\n\u0010E\u001a\u00060\u0003j\u0002`\u00042\u0010\u0010F\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00112\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\tH\u0002\u00a2\u0006\u0002\u0010IJ:\u0010J\u001a\u00020\n2\n\u0010K\u001a\u00060\u0003j\u0002`\u00042\n\u0010L\u001a\u00060\u0003j\u0002`\u00042\n\u0010M\u001a\u00060\u0003j\u0002`\u00042\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\tH\u0002J\b\u0010N\u001a\u00020CH\u0002J#\u0010O\u001a\u00060\u0003j\u0002`\u00042\u0010\u0010P\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010QR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0013R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u001a\u0010\u0013R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0019\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b)\u0010\u0013R\u0019\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b+\u0010\u0013R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b-\u0010\u0013R\u0019\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b/\u0010\u0013R\u0019\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b1\u0010\u0013R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0019\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b7\u0010\u0013R\u0019\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b9\u0010\u0013R\u0019\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b;\u0010\u0013R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\t8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u001dR\u0019\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b?\u0010\u0013R\u0019\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\bA\u0010\u0013\u00a8\u0006R"}, d2={"Lkd/bos/olapServer/performanceStatistics/BenchmarkDataProvider;", "Ljava/io/Closeable;", "benchmarkPath", "", "Lkd/bos/olapServer/common/string;", "(Ljava/lang/String;)V", "_closeProvider", "", "_computingCommandInfos", "", "Lkd/bos/olapServer/dataSources/ComputingCommandInfo;", "_computingFelCommandInfos", "_cubeName", "_mainMeaName", "_selectCommandInfos", "Lkd/bos/olapServer/dataSources/SelectCommandInfo;", "accounts", "", "getAccounts", "()[Ljava/lang/String;", "[Ljava/lang/String;", "auditTrails", "getAuditTrails", "getBenchmarkPath", "()Ljava/lang/String;", "changeTypes", "getChangeTypes", "computingCommandInfos", "getComputingCommandInfos", "()Ljava/util/List;", "computingFelCommandInfos", "getComputingFelCommandInfos", "cube", "Lkd/bos/olapServer/metadata/Cube;", "getCube", "()Lkd/bos/olapServer/metadata/Cube;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "getCubeWorkspace", "()Lkd/bos/olapServer/storages/CubeWorkspace;", "currencies", "getCurrencies", "dataSorts", "getDataSorts", "entities", "getEntities", "internalCompanys", "getInternalCompanys", "multiGAAPs", "getMultiGAAPs", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "getOlapWorkspace", "()Lkd/bos/olapServer/storages/OlapWorkspace;", "periods", "getPeriods", "process", "getProcess", "scenarios", "getScenarios", "selectCommandInfos", "getSelectCommandInfos", "versions", "getVersions", "years", "getYears", "close", "", "createAggComputingCommand", "aggDimension", "memberArray", "filterList", "Lkd/bos/olapServer/dataSources/DimensionFilterItem;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/util/List;)Lkd/bos/olapServer/dataSources/ComputingCommandInfo;", "createFelComputingCommand", "mainDimension", "left", "expression", "deleteCubeData", "joinMembers", "names", "([Ljava/lang/String;)Ljava/lang/String;", "bos-olap-core"})
public final class BenchmarkDataProvider
implements Closeable {
    @NotNull
    private final String benchmarkPath;
    @NotNull
    private final String _cubeName;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Cube cube;
    @NotNull
    private final String[] accounts;
    @NotNull
    private final String[] entities;
    @NotNull
    private final String[] years;
    @NotNull
    private final String[] periods;
    @NotNull
    private final String[] scenarios;
    @NotNull
    private final String[] process;
    @NotNull
    private final String[] currencies;
    @NotNull
    private final String[] auditTrails;
    @NotNull
    private final String[] changeTypes;
    @NotNull
    private final String[] internalCompanys;
    @NotNull
    private final String[] multiGAAPs;
    @NotNull
    private final String[] dataSorts;
    @NotNull
    private final String[] versions;
    @NotNull
    private final String _mainMeaName;
    @NotNull
    private final List<SelectCommandInfo> _selectCommandInfos;
    @NotNull
    private final List<ComputingCommandInfo> _computingCommandInfos;
    @NotNull
    private final List<ComputingCommandInfo> _computingFelCommandInfos;
    private boolean _closeProvider;

    public BenchmarkDataProvider(@NotNull String benchmarkPath) {
        int n;
        Intrinsics.checkNotNullParameter((Object)benchmarkPath, (String)"benchmarkPath");
        this.benchmarkPath = benchmarkPath;
        this._cubeName = "cubeBenchmarkTest";
        int n2 = 0;
        String[] stringArray = new String[10000];
        BenchmarkDataProvider benchmarkDataProvider = this;
        while (n2 < 10000) {
            n = n2++;
            stringArray[n] = Intrinsics.stringPlus((String)"account", (Object)n);
        }
        benchmarkDataProvider.accounts = stringArray;
        n2 = 0;
        stringArray = new String[1000];
        benchmarkDataProvider = this;
        while (n2 < 1000) {
            n = n2++;
            stringArray[n] = Intrinsics.stringPlus((String)"entity", (Object)n);
        }
        benchmarkDataProvider.entities = stringArray;
        String[] stringArray2 = new String[]{"FY2018", "FY2019", "FY2020", "FY2021", "FY2022"};
        this.years = stringArray2;
        int n3 = 0;
        stringArray = new String[12];
        benchmarkDataProvider = this;
        while (n3 < 12) {
            n = n3++;
            stringArray[n] = Intrinsics.stringPlus((String)"M_M", (Object)n);
        }
        benchmarkDataProvider.periods = stringArray;
        String[] stringArray3 = new String[]{"QRpt", "FRpt"};
        this.scenarios = stringArray3;
        stringArray3 = new String[]{"CC", "EJE", "EICA", "EIT"};
        this.process = stringArray3;
        stringArray3 = new String[]{"EC", "PC", "CNY", "HKD", "USD"};
        this.currencies = stringArray3;
        stringArray3 = new String[]{"ATTotal", "DataCollection", "EntityInput", "ADJE", "CWP"};
        this.auditTrails = stringArray3;
        stringArray3 = new String[]{"EndingBalance", "YTD", "CurrentPeriod", "BBOY", "BFLY"};
        this.changeTypes = stringArray3;
        int n4 = 0;
        stringArray = new String[5000];
        benchmarkDataProvider = this;
        while (n4 < 5000) {
            n = n4++;
            stringArray[n] = Intrinsics.stringPlus((String)"internalCompany", (Object)n);
        }
        benchmarkDataProvider.internalCompanys = stringArray;
        String[] stringArray4 = new String[]{"PRCGAAP", "HKGAAP"};
        this.multiGAAPs = stringArray4;
        stringArray4 = new String[]{"Budget", "CRate"};
        this.dataSorts = stringArray4;
        stringArray4 = new String[]{"V1", "V2"};
        this.versions = stringArray4;
        String indexJson = "\n            {\n                \"cubes\":[\"" + this._cubeName + "\"]\n            }\n            ";
        String accountsJson = "{\n            \"name\": \"Account\",\n            \"defaultMemberName\": \"\",\n            \"continuousData\": false,\n            \"dataFormat\": \"dk\",\n            \"indexFormat\": \"mv3\",\n            \"allowNull\": false,\n            \"members\":[" + this.joinMembers(this.accounts) + "]\n        }";
        String entityJson = "{\n\t\t\"name\": \"Entity\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.entities) + "]\n\t}";
        String yearJson = "{\n\t\t\"name\": \"Year\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.years) + "]\n\t}";
        String periodJson = "{\n\t\t\"name\": \"Period\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.periods) + "]\n\t}";
        String scenarioJson = "{\n\t\t\"name\": \"Scenario\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.scenarios) + "]\n\t}";
        String processJson = "{\n\t\t\"name\": \"Process\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.process) + "]\n\t}";
        String currencyJson = "{\n\t\t\"name\": \"Currency\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": true,\n\t\t\"dataFormat\": \"rk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.currencies) + "]\n\t}";
        String auditTrailJson = "{\n\t\t\"name\": \"AuditTrail\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.auditTrails) + "]\n\t}";
        String changeTypeJson = "{\n\t\t\"name\": \"ChangeType\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.changeTypes) + "]\n\t}";
        String internalCompanyJson = "{\n\t\t\"name\": \"InternalCompany\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.internalCompanys) + "]\n\t}";
        String multiGAAPJson = "{\n\t\t\"name\": \"MultiGAAP\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.multiGAAPs) + "]\n\t}";
        String dataSortJson = "{\n\t\t\"name\": \"DataSort\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.dataSorts) + "]\n\t}";
        String versionJson = "{\n\t\t\"name\": \"Version\",\n\t\t\"defaultMemberName\": \"\",\n\t\t\"continuousData\": false,\n\t\t\"dataFormat\": \"dk\",\n\t\t\"indexFormat\": \"mv3\",\n\t\t\"allowNull\": false,\n\t\t\"members\":[" + this.joinMembers(this.versions) + "]\n\t}";
        String measureJson = "\n       \"measures\": [{\n\t\t\"name\": \"FMONEY\",\n\t\t\"dataType\": \"object\",\n\t\t\"allowNull\": true,\n\t\t\"dataFormat\": \"object\",\n\t\t\"isList\": false\n\t}]";
        String partitionsJson = ",\n            \"partition\":{\n            \"type\" : \"dimensionPartition.v1\",\n            \"dimensions\" : [\"Year\", \"Period\"]\n        }\n        ";
        String[] stringArray5 = new StringBuilder();
        stringArray5.append("\n\t\t   {\n\t\t\t\"name\": \"").append(this._cubeName).append("\",\n\t\t\t\"dimensions\":[").append(accountsJson).append(",\n\t\t\t").append(entityJson).append(",\n\t\t\t").append(yearJson).append(",\n\t\t\t").append(periodJson).append(",\n\t\t\t").append(scenarioJson).append(",\n\t\t\t").append(processJson).append(",\n\t\t\t").append(currencyJson).append(",\n\t\t\t").append(auditTrailJson).append(",\n\t\t\t").append(changeTypeJson).append(",\n\t\t\t").append(internalCompanyJson).append(",\n\t\t\t");
        stringArray5.append(multiGAAPJson).append(",\n\t\t\t").append(dataSortJson).append(",\n\t\t\t").append(versionJson).append("\n\t\t\t],\n\t\t\t").append(measureJson).append("\n            ").append(partitionsJson).append("\n\t\t   }\n\t\t");
        String totalJson = stringArray5.toString();
        stringArray5 = new String[]{"index.json"};
        Files.write(Paths.INSTANCE.get(this.benchmarkPath, stringArray5), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)indexJson), new OpenOption[0]);
        String[] stringArray6 = new String[]{this._cubeName};
        Path cubePaths = Paths.INSTANCE.get(this.benchmarkPath, stringArray6);
        cubePaths.toFile().mkdirs();
        stringArray6 = new String[]{"cube.json"};
        Files.write(Paths.INSTANCE.get(((Object)cubePaths).toString(), stringArray6), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)totalJson), new OpenOption[0]);
        OlapMetadata olapMetadata = OlapMetadata.Companion.ReadFrom(this.benchmarkPath);
        this.olapWorkspace = new OlapWorkspace(olapMetadata, this.benchmarkPath);
        this.cubeWorkspace = this.olapWorkspace.getCubeWorkspace(this._cubeName);
        this.cube = this.cubeWorkspace.getMetadata();
        this._mainMeaName = "FMONEY";
        boolean bl = false;
        this._selectCommandInfos = new ArrayList();
        bl = false;
        this._computingCommandInfos = new ArrayList();
        bl = false;
        this._computingFelCommandInfos = new ArrayList();
        this._closeProvider = true;
    }

    @NotNull
    public final String getBenchmarkPath() {
        return this.benchmarkPath;
    }

    @NotNull
    public final OlapWorkspace getOlapWorkspace() {
        return this.olapWorkspace;
    }

    @NotNull
    public final CubeWorkspace getCubeWorkspace() {
        return this.cubeWorkspace;
    }

    @NotNull
    public final Cube getCube() {
        return this.cube;
    }

    @NotNull
    public final String[] getAccounts() {
        return this.accounts;
    }

    @NotNull
    public final String[] getEntities() {
        return this.entities;
    }

    @NotNull
    public final String[] getYears() {
        return this.years;
    }

    @NotNull
    public final String[] getPeriods() {
        return this.periods;
    }

    @NotNull
    public final String[] getScenarios() {
        return this.scenarios;
    }

    @NotNull
    public final String[] getProcess() {
        return this.process;
    }

    @NotNull
    public final String[] getCurrencies() {
        return this.currencies;
    }

    @NotNull
    public final String[] getAuditTrails() {
        return this.auditTrails;
    }

    @NotNull
    public final String[] getChangeTypes() {
        return this.changeTypes;
    }

    @NotNull
    public final String[] getInternalCompanys() {
        return this.internalCompanys;
    }

    @NotNull
    public final String[] getMultiGAAPs() {
        return this.multiGAAPs;
    }

    @NotNull
    public final String[] getDataSorts() {
        return this.dataSorts;
    }

    @NotNull
    public final String[] getVersions() {
        return this.versions;
    }

    private final String joinMembers(String[] names) {
        StringBuilder sb = new StringBuilder();
        Object object = names;
        int n = 0;
        int n2 = ((String[])object).length;
        while (n < n2) {
            String name2 = object[n];
            ++n;
            CharSequence charSequence = sb;
            boolean bl = false;
            if (charSequence.length() > 0) {
                sb.append(",");
            }
            sb.append("{\"name\": \"" + name2 + "\",\"id\": \"" + UUID.randomUUID() + "\"}");
        }
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public final List<SelectCommandInfo> getSelectCommandInfos() {
        if (this._selectCommandInfos.isEmpty()) {
            String measureName = ((Measure)this.cube.getMeasures().get(0)).getName();
            String[] stringArray = (String[])ArraysKt.sliceArray((Object[])this.entities, (IntRange)RangesKt.until((int)0, (int)50));
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String entityMember = stringArray[n];
                ++n;
                SelectCommandInfo selectCommand = new SelectCommandInfo();
                Object object = new String[]{"Process", "Account", "InternalCompany"};
                selectCommand.addDims((String[])object);
                for (Dimension dim : this.cube.getDimensions()) {
                    if (Intrinsics.areEqual((Object)dim.getName(), (Object)"Account") || Intrinsics.areEqual((Object)dim.getName(), (Object)"Process") || Intrinsics.areEqual((Object)dim.getName(), (Object)"Entity") || Intrinsics.areEqual((Object)dim.getName(), (Object)"InternalCompany")) continue;
                    String[] stringArray2 = new String[]{((Member)dim.getMembers().get(0)).getName()};
                    selectCommand.addFilter(dim.getName(), stringArray2);
                }
                object = (String[])ArraysKt.sliceArray((Object[])this.accounts, (IntRange)RangesKt.until((int)100, (int)200));
                selectCommand.addFilter("Account", (String[])Arrays.copyOf(object, ((Object)object).length));
                object = new String[]{entityMember};
                selectCommand.addFilter("Entity", (String[])object);
                object = new String[]{measureName};
                selectCommand.addMeasures((String[])object);
                this._selectCommandInfos.add(selectCommand);
            }
        }
        return this._selectCommandInfos;
    }

    @NotNull
    public final List<ComputingCommandInfo> getComputingCommandInfos() {
        if (this._computingCommandInfos.isEmpty()) {
            boolean bl = false;
            List filter1 = new ArrayList();
            Object object = DimensionFilterItem.Companion;
            boolean bl2 = false;
            boolean bl3 = false;
            DimensionFilterItem.Companion $this$_get_computingCommandInfos__u24lambda_u2d0 = object;
            boolean bl4 = false;
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Entity", (String[])ArraysKt.sliceArray((Object[])this.getEntities(), (IntRange)RangesKt.until((int)0, (int)10)));
            String[] stringArray = new String[]{this.getYears()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Year", stringArray);
            stringArray = new String[]{this.getPeriods()[0], this.getPeriods()[1]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Period", stringArray);
            stringArray = new String[]{this.getScenarios()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Scenario", stringArray);
            stringArray = new String[]{this.getCurrencies()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Currency", stringArray);
            stringArray = new String[]{this.getAuditTrails()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "AuditTrail", stringArray);
            stringArray = new String[]{this.getChangeTypes()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "ChangeType", stringArray);
            stringArray = new String[]{this.getMultiGAAPs()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "MultiGAAP", stringArray);
            stringArray = new String[]{this.getDataSorts()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "DataSort", stringArray);
            stringArray = new String[]{this.getVersions()[0]};
            $this$_get_computingCommandInfos__u24lambda_u2d0.addFilter$bos_olap_core(filter1, "Version", stringArray);
            object = this._computingCommandInfos;
            bl2 = false;
            bl3 = false;
            Object $this$_get_computingCommandInfos__u24lambda_u2d1 = object;
            boolean bl5 = false;
            $this$_get_computingCommandInfos__u24lambda_u2d1.add(this.createAggComputingCommand("Account", (String[])ArraysKt.sliceArray((Object[])this.getAccounts(), (IntRange)RangesKt.until((int)0, (int)21)), filter1));
            $this$_get_computingCommandInfos__u24lambda_u2d1.add(this.createAggComputingCommand("Account", (String[])ArraysKt.sliceArray((Object[])this.getAccounts(), (IntRange)RangesKt.until((int)1000, (int)1021)), filter1));
            $this$_get_computingCommandInfos__u24lambda_u2d1.add(this.createAggComputingCommand("Account", (String[])ArraysKt.sliceArray((Object[])this.getAccounts(), (IntRange)RangesKt.until((int)2000, (int)2021)), filter1));
            $this$_get_computingCommandInfos__u24lambda_u2d1.add(this.createAggComputingCommand("Account", (String[])ArraysKt.sliceArray((Object[])this.getAccounts(), (IntRange)RangesKt.until((int)3000, (int)3021)), filter1));
            $this$_get_computingCommandInfos__u24lambda_u2d1.add(this.createAggComputingCommand("Account", (String[])ArraysKt.sliceArray((Object[])this.getAccounts(), (IntRange)RangesKt.until((int)4000, (int)4021)), filter1));
        }
        return this._computingCommandInfos;
    }

    @NotNull
    public final List<ComputingCommandInfo> getComputingFelCommandInfos() {
        if (this._computingFelCommandInfos.isEmpty()) {
            boolean bl = false;
            List filter = new ArrayList();
            Object object = DimensionFilterItem.Companion;
            boolean bl2 = false;
            boolean bl3 = false;
            DimensionFilterItem.Companion $this$_get_computingFelCommandInfos__u24lambda_u2d2 = object;
            boolean bl4 = false;
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "Entity", (String[])ArraysKt.sliceArray((Object[])this.getEntities(), (IntRange)RangesKt.until((int)0, (int)20)));
            String[] stringArray = new String[]{this.getYears()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "Year", stringArray);
            stringArray = new String[]{this.getPeriods()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "Period", stringArray);
            stringArray = new String[]{this.getCurrencies()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "Currency", stringArray);
            stringArray = new String[]{this.getAuditTrails()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "AuditTrail", stringArray);
            stringArray = new String[]{this.getChangeTypes()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "ChangeType", stringArray);
            stringArray = new String[]{this.getMultiGAAPs()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "MultiGAAP", stringArray);
            stringArray = new String[]{this.getDataSorts()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "DataSort", stringArray);
            stringArray = new String[]{this.getVersions()[0]};
            $this$_get_computingFelCommandInfos__u24lambda_u2d2.addFilter$bos_olap_core(filter, "Version", stringArray);
            object = this._computingFelCommandInfos;
            bl2 = false;
            bl3 = false;
            Object $this$_get_computingFelCommandInfos__u24lambda_u2d3 = object;
            boolean bl5 = false;
            $this$_get_computingFelCommandInfos__u24lambda_u2d3.add(this.createFelComputingCommand("Account", this.getAccounts()[10], "v('Account." + this.getAccounts()[11] + "')==0?0:v('Account." + this.getAccounts()[12] + "')/v('Account." + this.getAccounts()[11] + "')", filter));
            $this$_get_computingFelCommandInfos__u24lambda_u2d3.add(this.createFelComputingCommand("Account", this.getAccounts()[20], "v('Account." + this.getAccounts()[21] + "')==0?0:v('Account." + this.getAccounts()[22] + "')/v('Account." + this.getAccounts()[21] + "')", filter));
            $this$_get_computingFelCommandInfos__u24lambda_u2d3.add(this.createFelComputingCommand("Account", this.getAccounts()[30], "v('Account." + this.getAccounts()[31] + "')==0?0:v('Account." + this.getAccounts()[32] + "')/v('Account." + this.getAccounts()[31] + "')", filter));
        }
        return this._computingFelCommandInfos;
    }

    private final ComputingCommandInfo createFelComputingCommand(String mainDimension, String left, String expression, List<DimensionFilterItem> filterList) {
        ComputingCommandInfo cmd = new ComputingCommandInfo();
        cmd.setMainDimName(mainDimension);
        cmd.setMainMeaName(this._mainMeaName);
        cmd.setFilter(filterList);
        FelLambdaExpression exp = new FelLambdaExpression();
        exp.setExpressLeft(left);
        exp.setExpression(expression);
        cmd.addExpression(exp);
        return cmd;
    }

    private final ComputingCommandInfo createAggComputingCommand(String aggDimension, String[] memberArray, List<DimensionFilterItem> filterList) {
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setMainDimName(aggDimension);
        command.setMainMeaName(this._mainMeaName);
        command.setFilter(filterList);
        AggExpression expressionItem = new AggExpression();
        expressionItem.setExpressLeft(memberArray[0]);
        int n = 1;
        int n2 = memberArray.length;
        if (n < n2) {
            do {
                int i = n++;
                expressionItem.add(memberArray[i]);
            } while (n < n2);
        }
        command.getExpressionItems().add(expressionItem);
        return command;
    }

    private final void deleteCubeData() {
        String[] stringArray = new String[]{this._cubeName};
        FileTools.INSTANCE.deleteDir(new File(((Object)Paths.INSTANCE.get(this.benchmarkPath, stringArray)).toString()));
        stringArray = new String[]{"index.json"};
        new File(((Object)Paths.INSTANCE.get(this.benchmarkPath, stringArray)).toString()).delete();
    }

    @Override
    public void close() {
        if (this._closeProvider) {
            this.cubeWorkspace.close();
            this.olapWorkspace.close();
            this.deleteCubeData();
            this._closeProvider = false;
        }
    }
}

