/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.performanceStatistics;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.ICancellable;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.OlapContext;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.dataSources.ComputingCommandInfo;
import kd.bos.olapServer.dataSources.SelectCommandInfo;
import kd.bos.olapServer.performanceStatistics.BenchmarkContext;
import kd.bos.olapServer.performanceStatistics.BenchmarkDataProvider;
import kd.bos.olapServer.performanceStatistics.BenchmarkTask;
import kd.bos.olapServer.performanceStatistics.BenchmarkTaskBuilder;
import kd.bos.olapServer.performanceStatistics.BenchmarkThroughput;
import kd.bos.olapServer.performanceStatistics.CommandExecuteState;
import kd.bos.olapServer.performanceStatistics.ComputingBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.CubeBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.IOBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.QueryBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.RunLengthBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.UpdateBenchmarkTask;
import kd.bos.olapServer.server.OlapSession;
import kd.bos.olapServer.tools.FileTools;
import kd.bos.olapServer.tools.JsonHelper;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0016J8\u0010\u001f\u001a\u00060\u0014j\u0002` \"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u0002H!\u0012\b\u0012\u00060\u0014j\u0002` 0%H\u0002J\u001e\u0010\u001f\u001a\u00060\u0014j\u0002` 2\u0010\u0010$\u001a\f\u0012\b\u0012\u00060\u0014j\u0002` 0#H\u0002J$\u0010&\u001a\u00060\u0014j\u0002` 2\n\u0010'\u001a\u00060\u0014j\u0002` 2\n\u0010\u0013\u001a\u00060\u0014j\u0002` H\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J\b\u0010)\u001a\u00020\u001dH\u0002J\b\u0010*\u001a\u00020\u001dH\u0002J<\u0010+\u001a\u00060\u0014j\u0002` 2\n\u0010,\u001a\u00060\u000ej\u0002`-2\n\u0010.\u001a\u00060\u000ej\u0002`-2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`-\u0012\u0004\u0012\u00020/0%H\u0002J \u0010+\u001a\u00060\u0014j\u0002` 2\u0006\u00100\u001a\u00020/2\n\u0010.\u001a\u00060\u000ej\u0002`-H\u0002J \u00101\u001a\u00060\u0014j\u0002` 2\u0006\u00100\u001a\u00020/2\n\u0010.\u001a\u00060\u000ej\u0002`-H\u0002J\b\u00102\u001a\u00020\u001dH\u0002J<\u00103\u001a\u00060\u0014j\u0002` 2\u0006\u00100\u001a\u0002042\n\u0010.\u001a\u00060\u000ej\u0002`-2\f\u00105\u001a\b\u0012\u0004\u0012\u000204062\f\b\u0002\u00107\u001a\u00060\u0007j\u0002`\bH\u0002J\b\u00108\u001a\u00020\u001dH\u0002J\u0010\u00109\u001a\u00020\u001d2\b\u0010:\u001a\u0004\u0018\u00010;J\b\u0010<\u001a\u00020\u001dH\u0002J\b\u0010=\u001a\u00020\u001dH\u0002J\b\u0010>\u001a\u00020\u001dH\u0002R\u0012\u0010\n\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lkd/bos/olapServer/performanceStatistics/BenchmarkTaskBuilder;", "Ljava/io/Closeable;", "rootPath", "", "Lkd/bos/olapServer/common/string;", "databasePath", "onlyUnitTest", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Ljava/lang/String;Z)V", "benchmarkRootPath", "benchmarkThroughput", "Lkd/bos/olapServer/performanceStatistics/BenchmarkThroughput;", "bigDataCount", "", "ctx", "Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;", "getCtx$bos_olap_core", "()Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;", "dataCount", "", "dataProvider", "Lkd/bos/olapServer/performanceStatistics/BenchmarkDataProvider;", "needSpaceSize", "getRootPath", "()Ljava/lang/String;", "smallDataCount", "updateCount", "aggComputingBenchmarkRunTask", "", "close", "commandMultiThread", "Lkd/bos/olapServer/common/long;", "T", "createTask", "Lkotlin/Function0;", "body", "Lkotlin/Function1;", "computingThroughput", "time", "cpuRunBenchmarkTask", "felComputingBenchmarkRunTask", "ioRunBenchmarkTask", "measureAverageThroughout", "taskCount", "Lkd/bos/olapServer/common/int;", "runCount", "Lkd/bos/olapServer/performanceStatistics/BenchmarkTask;", "task", "measureTaskThroughout", "memoryRunBenchmarkTask", "multiThread", "Lkd/bos/olapServer/performanceStatistics/RunLengthBenchmarkTask;", "taskList", "", "isRandom", "queryBenchmarkTask", "run", "session", "Lkd/bos/olapServer/server/OlapSession;", "saveResult", "updateBenchmarkTask", "writeBenchmarkTask", "Companion", "bos-olap-core"})
public final class BenchmarkTaskBuilder
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    private final boolean onlyUnitTest;
    @NotNull
    private final String benchmarkRootPath;
    private final long dataCount;
    private final long updateCount;
    private final int smallDataCount;
    private final int bigDataCount;
    private final long needSpaceSize;
    @NotNull
    private final BenchmarkDataProvider dataProvider;
    @NotNull
    private final BenchmarkContext ctx;
    @NotNull
    private final BenchmarkThroughput benchmarkThroughput;
    @NotNull
    private static final CommandExecuteState writeCube = new CommandExecuteState("writeCube", true, 1);
    @NotNull
    private static final CommandExecuteState updateCube = new CommandExecuteState("updateCube", true, 2);
    @NotNull
    private static final CommandExecuteState signThreadSelect = new CommandExecuteState("signThreadSelect", true, 3);
    @NotNull
    private static final CommandExecuteState multiThreadSelect = new CommandExecuteState("multiThreadSelect", true, 4);
    @NotNull
    private static final CommandExecuteState singleThreadAggComputing = new CommandExecuteState("singleThreadAggComputing", true, 5);
    @NotNull
    private static final CommandExecuteState multiThreadAggComputing = new CommandExecuteState("multiThreadAggComputing", true, 6);
    @NotNull
    private static final CommandExecuteState singleThreadFelComputing = new CommandExecuteState("singleThreadFelComputing", true, 7);
    @NotNull
    private static final CommandExecuteState multiThreadFelComputing = new CommandExecuteState("multiThreadFelComputing", true, 8);
    @NotNull
    private static final CommandExecuteState singleThreadCPU = new CommandExecuteState("singleThreadCPU", true, 9);
    @NotNull
    private static final CommandExecuteState multiThreadCPU = new CommandExecuteState("multiThreadCPU", true, 10);
    @NotNull
    private static final CommandExecuteState singleThreadRandomMemory = new CommandExecuteState("singleThreadRandomMemory", true, 11);
    @NotNull
    private static final CommandExecuteState multiThreadRandomMemory = new CommandExecuteState("multiThreadRandomMemory", true, 12);
    @NotNull
    private static final CommandExecuteState singleThreadOrderMemory = new CommandExecuteState("singleThreadOrderMemory", true, 13);
    @NotNull
    private static final CommandExecuteState multiThreadOrderMemory = new CommandExecuteState("multiThreadOrderMemory", true, 14);
    @NotNull
    private static final CommandExecuteState singleThreadIO = new CommandExecuteState("singleThreadIO", true, 15);
    @NotNull
    private static final CommandExecuteState multiThreadIO = new CommandExecuteState("multiThreadIO", true, 16);
    @NotNull
    private static final CommandExecuteState writeResult = new CommandExecuteState("writeResult", true, 17);
    @NotNull
    private static final CommandExecuteState endTask = new CommandExecuteState("end", true, 18);
    @NotNull
    private static final CommandExecuteState[] allBenchmarkStates;

    public BenchmarkTaskBuilder(@NotNull String rootPath, @NotNull String databasePath, boolean onlyUnitTest) {
        File rootFile;
        long freeSpace;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        this.rootPath = rootPath;
        this.onlyUnitTest = onlyUnitTest;
        this.dataCount = this.onlyUnitTest ? 500000L : 60000000L;
        this.updateCount = this.onlyUnitTest ? 100000L : 30000000L;
        this.smallDataCount = this.onlyUnitTest ? 36 : 360000;
        this.bigDataCount = this.onlyUnitTest ? 360 : 36000000;
        this.needSpaceSize = 0x800000000L;
        if (!this.onlyUnitTest && (freeSpace = (rootFile = Paths.INSTANCE.get(databasePath, new String[0]).toFile()).getFreeSpace()) < this.needSpaceSize) {
            Object[] objectArray = Res.INSTANCE.getNotEnoughDiskSpace();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.NotEnoughDiskSpace");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{freeSpace / (long)0x40000000 + "GB", this.needSpaceSize / (long)0x40000000 + "GB"};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
        this.benchmarkRootPath = FileTools.INSTANCE.getTempPath$bos_olap_core(databasePath);
        this.dataProvider = new BenchmarkDataProvider(this.benchmarkRootPath);
        this.ctx = new BenchmarkContext(this.dataProvider);
        this.benchmarkThroughput = this.ctx.getBenchmarkThroughput();
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    @NotNull
    public final BenchmarkContext getCtx$bos_olap_core() {
        return this.ctx;
    }

    public final void run(@Nullable OlapSession session) {
        OlapSession olapSession = session;
        if (olapSession != null) {
            olapSession.setContext(this.ctx);
        }
        this.writeBenchmarkTask();
        this.updateBenchmarkTask();
        this.queryBenchmarkTask();
        this.aggComputingBenchmarkRunTask();
        this.felComputingBenchmarkRunTask();
        this.dataProvider.close();
        this.cpuRunBenchmarkTask();
        this.memoryRunBenchmarkTask();
        this.ioRunBenchmarkTask();
        this.saveResult();
    }

    private final void saveResult() {
        this.ctx.setTimeState(writeResult);
        String[] stringArray = new String[]{"olaplogs", "profile"};
        String dirPath = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
        FileTools.INSTANCE.autoMakeDir(dirPath);
        stringArray = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)this.benchmarkThroughput);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"JsonHelper.mapper.writeValueAsString(benchmarkThroughput)");
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"benchmark.profile"};
        FileTools.INSTANCE.writeToFile((String)stringArray2, ((Object)Paths.INSTANCE.get(dirPath, stringArray)).toString());
    }

    private final void writeBenchmarkTask() {
        this.ctx.setTimeState(writeCube);
        String string = Res.INSTANCE.getCubeBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CubeBenchmarkTaskName");
        CubeBenchmarkTask cubeBenchmarkTask = new CubeBenchmarkTask(string, this.ctx, this.dataCount);
        this.benchmarkThroughput.setWriteTime(this.measureTaskThroughout(cubeBenchmarkTask, 1));
    }

    private final void updateBenchmarkTask() {
        this.ctx.setTimeState(updateCube);
        String string = Res.INSTANCE.getCubeBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.CubeBenchmarkTaskName");
        UpdateBenchmarkTask updateBenchmarkTask = new UpdateBenchmarkTask(string, this.ctx, this.updateCount);
        this.benchmarkThroughput.setUpdateTime(this.measureTaskThroughout(updateBenchmarkTask, 1));
    }

    private final void queryBenchmarkTask() {
        List<SelectCommandInfo> selectCommandInfos = this.dataProvider.getSelectCommandInfos();
        int taskCount = selectCommandInfos.size();
        int runCount = this.onlyUnitTest ? 10 : 200;
        this.ctx.setTimeState(signThreadSelect);
        this.benchmarkThroughput.setQueryThroughput(this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)((Function1)new Function1<Integer, BenchmarkTask>(selectCommandInfos, this){
            final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$selectCommandInfos = $selectCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final BenchmarkTask invoke(int it) {
                String string = Res.INSTANCE.getQueryBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.QueryBenchmarkTaskName");
                return new QueryBenchmarkTask(string, this.$selectCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
            }
        })));
        this.ctx.setTimeState(multiThreadSelect);
        this.benchmarkThroughput.setMultiQueryThroughput(this.commandMultiThread((Function0<Long>)((Function0)new Function0<Long>(this, taskCount, runCount, selectCommandInfos){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $taskCount;
            final /* synthetic */ int $runCount;
            final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
            {
                this.this$0 = $receiver;
                this.$taskCount = $taskCount;
                this.$runCount = $runCount;
                this.$selectCommandInfos = $selectCommandInfos;
                super(0);
            }

            public final long invoke() {
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, this.$taskCount, this.$runCount, (Function1)new Function1<Integer, BenchmarkTask>(this.$selectCommandInfos, this.this$0){
                    final /* synthetic */ List<SelectCommandInfo> $selectCommandInfos;
                    final /* synthetic */ BenchmarkTaskBuilder this$0;
                    {
                        this.$selectCommandInfos = $selectCommandInfos;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final BenchmarkTask invoke(int it) {
                        String string = Res.INSTANCE.getQueryBenchmarkTaskName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.QueryBenchmarkTaskName");
                        return new QueryBenchmarkTask(string, this.$selectCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
                    }
                });
            }
        })));
    }

    private final long measureAverageThroughout(int taskCount, int runCount, Function1<? super Integer, ? extends BenchmarkTask> createTask) {
        long throughput = 0L;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)taskCount);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            throughput += this.measureAverageThroughout((BenchmarkTask)createTask.invoke((Object)it), runCount);
        }
        return throughput / (long)taskCount;
    }

    private final <T> long commandMultiThread(Function0<? extends T> createTask, Function1<? super T, Long> body) {
        Thread it;
        boolean bl = false;
        List threadArray = new ArrayList();
        AtomicLong multiThroughout = new AtomicLong();
        Ref.ObjectRef exception = new Ref.ObjectRef();
        int n = 0;
        int n2 = CommonTypesKt.getAvailableProcessors();
        if (n < n2) {
            do {
                int i = n++;
                Object task = createTask.invoke();
                OlapContext olapContext = OlapContext.Companion.getCurrentContext$bos_olap_core();
                Thread t2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(olapContext, body, task, multiThroughout, this, (Ref.ObjectRef<Exception>)exception){
                    final /* synthetic */ OlapContext $olapContext;
                    final /* synthetic */ Function1<T, Long> $body;
                    final /* synthetic */ T $task;
                    final /* synthetic */ AtomicLong $multiThroughout;
                    final /* synthetic */ BenchmarkTaskBuilder this$0;
                    final /* synthetic */ Ref.ObjectRef<Exception> $exception;
                    {
                        this.$olapContext = $olapContext;
                        this.$body = $body;
                        this.$task = $task;
                        this.$multiThroughout = $multiThroughout;
                        this.this$0 = $receiver;
                        this.$exception = $exception;
                        super(0);
                    }

                    public final void invoke() {
                        OlapContext.Companion.newContext(this.$olapContext, (Function0)new Function0<Unit>(this.$body, this.$task, this.$multiThroughout){
                            final /* synthetic */ Function1<T, Long> $body;
                            final /* synthetic */ T $task;
                            final /* synthetic */ AtomicLong $multiThroughout;
                            {
                                this.$body = $body;
                                this.$task = $task;
                                this.$multiThroughout = $multiThroughout;
                                super(0);
                            }

                            public final void invoke() {
                                long throughout = ((Number)this.$body.invoke(this.$task)).longValue();
                                this.$multiThroughout.addAndGet(throughout);
                            }
                        }, (Function1)new Function1<Exception, Unit>(this.this$0, this.$exception){
                            final /* synthetic */ BenchmarkTaskBuilder this$0;
                            final /* synthetic */ Ref.ObjectRef<Exception> $exception;
                            {
                                this.this$0 = $receiver;
                                this.$exception = $exception;
                                super(1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke(@NotNull Exception e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                Object object = this.this$0;
                                Ref.ObjectRef<Exception> objectRef = this.$exception;
                                boolean bl = false;
                                boolean bl2 = false;
                                synchronized (object) {
                                    boolean bl3 = false;
                                    if (objectRef.element == null) {
                                        objectRef.element = e;
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                object = OlapContext.Companion.tryGetContext(ICancellable.class);
                                if (object != null) {
                                    object.cancel(e);
                                }
                            }
                        });
                    }
                }), (int)30, null);
                threadArray.add(t2);
            } while (n < n2);
        }
        Iterable $this$forEach$iv = threadArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Thread)element$iv;
            boolean bl2 = false;
            it.start();
        }
        $this$forEach$iv = threadArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Thread)element$iv;
            boolean bl3 = false;
            it.join();
        }
        Exception cex2 = (Exception)exception.element;
        if (cex2 != null) {
            throw cex2;
        }
        return multiThroughout.get();
    }

    private final long commandMultiThread(Function0<Long> body) {
        return this.commandMultiThread(commandMultiThread.3.INSTANCE, (Function1)new Function1<Object, Long>(body){
            final /* synthetic */ Function0<Long> $body;
            {
                this.$body = $body;
                super(1);
            }

            public final long invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ((Number)this.$body.invoke()).longValue();
            }
        });
    }

    private final void aggComputingBenchmarkRunTask() {
        List<ComputingCommandInfo> computingCommandInfos = this.dataProvider.getComputingCommandInfos();
        int taskCount = computingCommandInfos.size();
        int runCount = this.onlyUnitTest ? 10 : 200;
        this.ctx.setTimeState(singleThreadAggComputing);
        this.benchmarkThroughput.setAggComputingThroughput(this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)((Function1)new Function1<Integer, BenchmarkTask>(computingCommandInfos, this){
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$computingCommandInfos = $computingCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final BenchmarkTask invoke(int it) {
                String string = Res.INSTANCE.getComputingBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ComputingBenchmarkTaskName");
                return new ComputingBenchmarkTask(string, this.$computingCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
            }
        })));
        this.ctx.setTimeState(multiThreadAggComputing);
        this.benchmarkThroughput.setMultiAggComputingThroughput(this.commandMultiThread((Function0<Long>)((Function0)new Function0<Long>(this, taskCount, runCount, computingCommandInfos){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $taskCount;
            final /* synthetic */ int $runCount;
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            {
                this.this$0 = $receiver;
                this.$taskCount = $taskCount;
                this.$runCount = $runCount;
                this.$computingCommandInfos = $computingCommandInfos;
                super(0);
            }

            public final long invoke() {
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, this.$taskCount, this.$runCount, (Function1)new Function1<Integer, BenchmarkTask>(this.$computingCommandInfos, this.this$0){
                    final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
                    final /* synthetic */ BenchmarkTaskBuilder this$0;
                    {
                        this.$computingCommandInfos = $computingCommandInfos;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final BenchmarkTask invoke(int it) {
                        String string = Res.INSTANCE.getComputingBenchmarkTaskName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ComputingBenchmarkTaskName");
                        return new ComputingBenchmarkTask(string, this.$computingCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
                    }
                });
            }
        })));
    }

    private final void felComputingBenchmarkRunTask() {
        List<ComputingCommandInfo> computingCommandInfos = this.dataProvider.getComputingFelCommandInfos();
        int taskCount = computingCommandInfos.size();
        int runCount = this.onlyUnitTest ? 10 : 200;
        this.ctx.setTimeState(singleThreadFelComputing);
        this.benchmarkThroughput.setFelComputingThroughput(this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)((Function1)new Function1<Integer, BenchmarkTask>(computingCommandInfos, this){
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            {
                this.$computingCommandInfos = $computingCommandInfos;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final BenchmarkTask invoke(int it) {
                String string = Res.INSTANCE.getComputingBenchmarkTaskName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ComputingBenchmarkTaskName");
                return new ComputingBenchmarkTask(string, this.$computingCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
            }
        })));
        this.ctx.setTimeState(multiThreadFelComputing);
        this.benchmarkThroughput.setMultiFelComputingThroughput(this.commandMultiThread((Function0<Long>)((Function0)new Function0<Long>(this, taskCount, runCount, computingCommandInfos){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $taskCount;
            final /* synthetic */ int $runCount;
            final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
            {
                this.this$0 = $receiver;
                this.$taskCount = $taskCount;
                this.$runCount = $runCount;
                this.$computingCommandInfos = $computingCommandInfos;
                super(0);
            }

            public final long invoke() {
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, this.$taskCount, this.$runCount, (Function1)new Function1<Integer, BenchmarkTask>(this.$computingCommandInfos, this.this$0){
                    final /* synthetic */ List<ComputingCommandInfo> $computingCommandInfos;
                    final /* synthetic */ BenchmarkTaskBuilder this$0;
                    {
                        this.$computingCommandInfos = $computingCommandInfos;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final BenchmarkTask invoke(int it) {
                        String string = Res.INSTANCE.getComputingBenchmarkTaskName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.ComputingBenchmarkTaskName");
                        return new ComputingBenchmarkTask(string, this.$computingCommandInfos.get(it), this.this$0.getCtx$bos_olap_core());
                    }
                });
            }
        })));
    }

    private final void cpuRunBenchmarkTask() {
        String string = Res.INSTANCE.getMultiCPUBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.MultiCPUBenchmarkTaskName");
        RunLengthBenchmarkTask task = new RunLengthBenchmarkTask(string, this.ctx, this.smallDataCount, true, this.smallDataCount, false, 32, null);
        boolean bl = false;
        List taskList = new ArrayList();
        taskList.add(task);
        this.ctx.setTimeState(singleThreadCPU);
        this.benchmarkThroughput.setCpuThroughput(this.measureAverageThroughout(task, 1));
        this.ctx.setTimeState(multiThreadCPU);
        this.benchmarkThroughput.setMultiCPUThroughput(BenchmarkTaskBuilder.multiThread$default(this, task, 1, taskList, false, 8, null));
        Iterable $this$forEach$iv = taskList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunLengthBenchmarkTask it = (RunLengthBenchmarkTask)element$iv;
            boolean bl2 = false;
            it.close();
        }
    }

    private final long computingThroughput(long time, long dataCount) {
        return dataCount * 1000000000L / time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ioRunBenchmarkTask() {
        Object object = Res.INSTANCE.getMultiIOBenchmarkTaskName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Res.MultiIOBenchmarkTaskName");
        object = new IOBenchmarkTask((String)object, new AtomicInteger(), this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IOBenchmarkTask it = (IOBenchmarkTask)object;
            boolean bl3 = false;
            this.getCtx$bos_olap_core().setTimeState(singleThreadIO);
            this.benchmarkThroughput.setIoOrderThroughput(this.measureAverageThroughout(it, 1));
            this.getCtx$bos_olap_core().setTimeState(multiThreadIO);
            this.benchmarkThroughput.setMultiIoOrderThroughput(this.commandMultiThread((Function0)new Function0<IOBenchmarkTask>(it){
                final /* synthetic */ IOBenchmarkTask $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final IOBenchmarkTask invoke() {
                    return this.$it.clone();
                }
            }, (Function1)new Function1<IOBenchmarkTask, Long>(this){
                final /* synthetic */ BenchmarkTaskBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final long invoke(@NotNull IOBenchmarkTask newTask) {
                    Intrinsics.checkNotNullParameter((Object)newTask, (String)"newTask");
                    return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, newTask, 1);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void memoryRunBenchmarkTask() {
        String string = Res.INSTANCE.getMultiMemoryBenchmarkTaskNmae();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.MultiMemoryBenchmarkTaskNmae");
        RunLengthBenchmarkTask task = new RunLengthBenchmarkTask(string, this.ctx, this.bigDataCount, false, this.bigDataCount, true);
        boolean bl = false;
        List taskList = new ArrayList();
        taskList.add(task);
        try {
            this.ctx.setTimeState(singleThreadRandomMemory);
            this.benchmarkThroughput.setMemoryRandomThroughput(this.measureAverageThroughout(task, 1));
            this.ctx.setTimeState(multiThreadRandomMemory);
            this.benchmarkThroughput.setMultiMemoryRandomThroughput(BenchmarkTaskBuilder.multiThread$default(this, task, 1, taskList, false, 8, null));
            this.ctx.setTimeState(singleThreadOrderMemory);
            RunLengthBenchmarkTask orderTask = task.clone(false);
            taskList.add(orderTask);
            this.benchmarkThroughput.setMemoryOrderThroughput(this.measureAverageThroughout(orderTask, 1));
            this.ctx.setTimeState(multiThreadOrderMemory);
            this.benchmarkThroughput.setMultiMemoryOrderThroughput(this.multiThread(task, 1, taskList, false));
        }
        finally {
            Iterable $this$forEach$iv = taskList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RunLengthBenchmarkTask it = (RunLengthBenchmarkTask)element$iv;
                boolean bl2 = false;
                it.close();
            }
        }
    }

    private final long multiThread(RunLengthBenchmarkTask task, int runCount, List<RunLengthBenchmarkTask> taskList, boolean isRandom) {
        return this.commandMultiThread((Function0)new Function0<RunLengthBenchmarkTask>(task, isRandom, taskList){
            final /* synthetic */ RunLengthBenchmarkTask $task;
            final /* synthetic */ boolean $isRandom;
            final /* synthetic */ List<RunLengthBenchmarkTask> $taskList;
            {
                this.$task = $task;
                this.$isRandom = $isRandom;
                this.$taskList = $taskList;
                super(0);
            }

            @NotNull
            public final RunLengthBenchmarkTask invoke() {
                RunLengthBenchmarkTask newTask = this.$task.clone(this.$isRandom);
                this.$taskList.add(newTask);
                return newTask;
            }
        }, (Function1)new Function1<RunLengthBenchmarkTask, Long>(this, runCount){
            final /* synthetic */ BenchmarkTaskBuilder this$0;
            final /* synthetic */ int $runCount;
            {
                this.this$0 = $receiver;
                this.$runCount = $runCount;
                super(1);
            }

            public final long invoke(@NotNull RunLengthBenchmarkTask newTask) {
                Intrinsics.checkNotNullParameter((Object)newTask, (String)"newTask");
                return BenchmarkTaskBuilder.access$measureAverageThroughout(this.this$0, newTask, this.$runCount);
            }
        });
    }

    static /* synthetic */ long multiThread$default(BenchmarkTaskBuilder benchmarkTaskBuilder, RunLengthBenchmarkTask runLengthBenchmarkTask, int n, List list, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return benchmarkTaskBuilder.multiThread(runLengthBenchmarkTask, n, list, bl);
    }

    private final long measureAverageThroughout(BenchmarkTask task, int runCount) {
        int n = 0;
        long[] lArray = new long[6];
        while (n < 6) {
            int n2 = n++;
            lArray[n2] = this.measureTaskThroughout(task, runCount);
        }
        long[] dataArray = lArray;
        long maxValue = dataArray[0];
        long minValue = dataArray[0];
        long totalValue = dataArray[0];
        int n3 = 1;
        int n4 = dataArray.length;
        if (n3 < n4) {
            do {
                int index2 = n3++;
                long value2 = dataArray[index2];
                totalValue += value2;
                if (value2 > maxValue) {
                    maxValue = value2;
                    continue;
                }
                if (value2 >= minValue) continue;
                minValue = value2;
            } while (n3 < n4);
        }
        return (totalValue - maxValue - minValue) / (long)(dataArray.length - 2);
    }

    private final long measureTaskThroughout(BenchmarkTask task, int runCount) {
        long time = 0L;
        long statisticCount = 0L;
        IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
        if (continueToken.canContinue()) {
            task.init();
            boolean $i$f$measureNanoTime = false;
            boolean bl = false;
            long start$iv = System.nanoTime();
            boolean bl2 = false;
            int n = 0;
            if (n < runCount) {
                do {
                    int i = n++;
                    if (continueToken.canContinue()) {
                        task.execute();
                    }
                    statisticCount += task.getStatisticCount();
                } while (n < runCount);
            }
            time = System.nanoTime() - start$iv;
        }
        return this.computingThroughput(time, statisticCount);
    }

    @Override
    public void close() {
        this.dataProvider.close();
        FileTools.INSTANCE.deleteDir(new File(this.benchmarkRootPath));
        this.ctx.setTimeState(endTask);
    }

    public static final /* synthetic */ long access$measureAverageThroughout(BenchmarkTaskBuilder $this, int taskCount, int runCount, Function1 createTask) {
        return $this.measureAverageThroughout(taskCount, runCount, (Function1<? super Integer, ? extends BenchmarkTask>)createTask);
    }

    public static final /* synthetic */ long access$measureAverageThroughout(BenchmarkTaskBuilder $this, BenchmarkTask task, int runCount) {
        return $this.measureAverageThroughout(task, runCount);
    }

    static {
        CommandExecuteState[] commandExecuteStateArray = new CommandExecuteState[]{CommandExecuteState.Companion.getBegin(), writeCube, updateCube, signThreadSelect, multiThreadSelect, singleThreadAggComputing, multiThreadAggComputing, singleThreadFelComputing, multiThreadFelComputing, singleThreadCPU, multiThreadCPU, singleThreadRandomMemory, multiThreadRandomMemory, singleThreadOrderMemory, multiThreadOrderMemory, singleThreadIO, multiThreadIO, writeResult, endTask};
        allBenchmarkStates = commandExecuteStateArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b)\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000bR\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000bR\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000bR\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000bR\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000b\u00a8\u0006."}, d2={"Lkd/bos/olapServer/performanceStatistics/BenchmarkTaskBuilder$Companion;", "", "()V", "allBenchmarkStates", "", "Lkd/bos/olapServer/performanceStatistics/CommandExecuteState;", "getAllBenchmarkStates", "()[Lkd/bos/olapServer/performanceStatistics/CommandExecuteState;", "[Lkd/bos/olapServer/performanceStatistics/CommandExecuteState;", "endTask", "getEndTask", "()Lkd/bos/olapServer/performanceStatistics/CommandExecuteState;", "multiThreadAggComputing", "getMultiThreadAggComputing", "multiThreadCPU", "getMultiThreadCPU", "multiThreadFelComputing", "getMultiThreadFelComputing", "multiThreadIO", "getMultiThreadIO", "multiThreadOrderMemory", "getMultiThreadOrderMemory", "multiThreadRandomMemory", "getMultiThreadRandomMemory", "multiThreadSelect", "getMultiThreadSelect", "signThreadSelect", "getSignThreadSelect", "singleThreadAggComputing", "getSingleThreadAggComputing", "singleThreadCPU", "getSingleThreadCPU", "singleThreadFelComputing", "getSingleThreadFelComputing", "singleThreadIO", "getSingleThreadIO", "singleThreadOrderMemory", "getSingleThreadOrderMemory", "singleThreadRandomMemory", "getSingleThreadRandomMemory", "updateCube", "getUpdateCube", "writeCube", "getWriteCube", "writeResult", "getWriteResult", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommandExecuteState getWriteCube() {
            return writeCube;
        }

        @NotNull
        public final CommandExecuteState getUpdateCube() {
            return updateCube;
        }

        @NotNull
        public final CommandExecuteState getSignThreadSelect() {
            return signThreadSelect;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadSelect() {
            return multiThreadSelect;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadAggComputing() {
            return singleThreadAggComputing;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadAggComputing() {
            return multiThreadAggComputing;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadFelComputing() {
            return singleThreadFelComputing;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadFelComputing() {
            return multiThreadFelComputing;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadCPU() {
            return singleThreadCPU;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadCPU() {
            return multiThreadCPU;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadRandomMemory() {
            return singleThreadRandomMemory;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadRandomMemory() {
            return multiThreadRandomMemory;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadOrderMemory() {
            return singleThreadOrderMemory;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadOrderMemory() {
            return multiThreadOrderMemory;
        }

        @NotNull
        public final CommandExecuteState getSingleThreadIO() {
            return singleThreadIO;
        }

        @NotNull
        public final CommandExecuteState getMultiThreadIO() {
            return multiThreadIO;
        }

        @NotNull
        public final CommandExecuteState getWriteResult() {
            return writeResult;
        }

        @NotNull
        public final CommandExecuteState getEndTask() {
            return endTask;
        }

        @NotNull
        public final CommandExecuteState[] getAllBenchmarkStates() {
            return allBenchmarkStates;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

