/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.performanceStatistics;

import java.io.Closeable;
import java.util.Iterator;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.ParallelTaskManager;
import kd.bos.olapServer.computingEngine.IntArraySequenceBuilder;
import kd.bos.olapServer.computingEngine.SingleMeasureValues;
import kd.bos.olapServer.computingEngine.batchTasks.SimpleRowKey;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.performanceStatistics.BenchmarkContext;
import kd.bos.olapServer.performanceStatistics.BenchmarkDataProvider;
import kd.bos.olapServer.performanceStatistics.BenchmarkTask;
import kd.bos.olapServer.performanceStatistics.CubeBenchmarkTask;
import kd.bos.olapServer.performanceStatistics.DimGroupDataItr;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/performanceStatistics/CubeBenchmarkTask;", "Lkd/bos/olapServer/performanceStatistics/BenchmarkTask;", "name", "", "Lkd/bos/olapServer/common/string;", "ctx", "Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;", "dataCount", "", "Lkd/bos/olapServer/common/long;", "(Ljava/lang/String;Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;J)V", "cube", "Lkd/bos/olapServer/metadata/Cube;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "provider", "Lkd/bos/olapServer/performanceStatistics/BenchmarkDataProvider;", "statisticCount", "getStatisticCount", "()J", "execute", "", "getReverseSequenceBuilder", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder;", "intArray", "", "bos-olap-core"})
public final class CubeBenchmarkTask
extends BenchmarkTask {
    private final long dataCount;
    @NotNull
    private final BenchmarkDataProvider provider;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Cube cube;

    public CubeBenchmarkTask(@NotNull String name2, @NotNull BenchmarkContext ctx, long dataCount) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(name2, ctx);
        this.dataCount = dataCount;
        this.provider = ctx.getDataProvaider();
        this.cubeWorkspace = this.provider.getCubeWorkspace();
        this.cube = this.provider.getCube();
    }

    @Override
    public long getStatisticCount() {
        return this.dataCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        int n;
        Measure[] $this$toTypedArray$iv = (Measure[])CollectionsKt.toList((Iterable)this.cube.getDimensions());
        int $i$f$toTypedArray = 0;
        Measure[] thisCollection$iv = $this$toTypedArray$iv;
        Dimension[] dimensionArray = thisCollection$iv.toArray(new Dimension[0]);
        if (dimensionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Dimension[] dimArray = dimensionArray;
        $i$f$toTypedArray = 0;
        thisCollection$iv = new Measure[1];
        while ($i$f$toTypedArray < 1) {
            n = $i$f$toTypedArray++;
            thisCollection$iv[n] = (Measure)this.cube.getMeasures().get(0);
        }
        Measure[] measures2 = thisCollection$iv;
        int count = 0;
        n = 0;
        int n2 = this.cube.getDimensions().getCount();
        int[] nArray = new int[n2];
        CubeBenchmarkTask cubeBenchmarkTask = this;
        Measure[] measureArray = measures2;
        Dimension[] dimensionArray2 = dimArray;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n4 = 8;
        int n5 = 0;
        IntArraySequenceBuilder intArraySequenceBuilder = cubeBenchmarkTask.getReverseSequenceBuilder(nArray);
        Measure[] measureArray2 = measureArray;
        Dimension[] dimensionArray3 = dimensionArray2;
        DimGroupDataItr itr = new DimGroupDataItr(dimensionArray3, measureArray2, intArraySequenceBuilder, n5, n4, defaultConstructorMarker);
        Closeable closeable = CubeWorkspace.createWriter$default(this.cubeWorkspace, null, 1, null);
        n2 = 0;
        boolean bl = false;
        Throwable throwable = null;
        try {
            int n6;
            Object value2;
            IInputRowWriter writer = (IInputRowWriter)closeable;
            boolean bl2 = false;
            try {
                SimpleRowKey key = new SimpleRowKey(this.cube, itr.getResultIntArray());
                value2 = new SingleMeasureValues(this.cube.getMeasures().getCount(), 0, null, 4, null);
                IContinueToken continueToken = CancellableToken.INSTANCE.getContinueToken();
                while (itr.next() && (long)count < this.dataCount && continueToken.canContinue()) {
                    ((SingleMeasureValues)value2).setMainMeasureValue(itr.getCurrentRowMeasureValue()[0]);
                    writer.addOrUpdate(key, (IMeasureValues)value2);
                    n6 = count;
                    count = n6 + 1;
                }
            }
            finally {
                ParallelTaskManager ptm = ParallelTaskManager.Companion.begin();
                value2 = ptm;
                boolean bl3 = false;
                n6 = 0;
                Throwable throwable2 = null;
                try {
                    ParallelTaskManager it = (ParallelTaskManager)value2;
                    boolean bl4 = false;
                    writer.force();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)value2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final IntArraySequenceBuilder getReverseSequenceBuilder(int[] intArray) {
        IntArraySequenceBuilder sequenceBuilder = new IntArraySequenceBuilder(intArray);
        Iterator iterator = this.cube.getDimensions().iterator();
        int n = 0;
        block30: while (iterator.hasNext()) {
            int dimensionIndex = n++;
            Dimension dim = (Dimension)iterator.next();
            switch (dim.getName()) {
                case "Account": {
                    sequenceBuilder.setRangeValue(dimensionIndex, 0, 4999);
                    continue block30;
                }
                case "Entity": {
                    sequenceBuilder.setRangeValue(dimensionIndex, 0, 999);
                    continue block30;
                }
                case "Scenario": {
                    sequenceBuilder.setRangeValue(dimensionIndex, 0, 1);
                    continue block30;
                }
                case "Process": {
                    sequenceBuilder.setMapValue(0, dimensionIndex, 1, (Function2<? super Integer, ? super int[], Unit>)((Function2)getReverseSequenceBuilder.1.INSTANCE));
                    continue block30;
                }
                case "Currency": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "AuditTrail": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "ChangeType": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "InternalCompany": {
                    sequenceBuilder.setMapValue(1, dimensionIndex, 3, (Function2<? super Integer, ? super int[], Unit>)((Function2)getReverseSequenceBuilder.2.INSTANCE));
                    continue block30;
                }
                case "MultiGAAP": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "DataSort": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "Version": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "Year": {
                    sequenceBuilder.setFixedValue(dimensionIndex, 0);
                    continue block30;
                }
                case "Period": {
                    sequenceBuilder.setRangeValue(dimensionIndex, 0, 1);
                    continue block30;
                }
            }
            throw new RuntimeException(dim.getName());
        }
        return sequenceBuilder.reverse();
    }
}

