/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.performanceStatistics;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.performanceStatistics.BenchmarkContext;
import kd.bos.olapServer.performanceStatistics.BenchmarkTask;
import kd.bos.olapServer.tools.FileTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/performanceStatistics/IOBenchmarkTask;", "Lkd/bos/olapServer/performanceStatistics/BenchmarkTask;", "name", "", "Lkd/bos/olapServer/common/string;", "fileNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "ctx", "Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;", "(Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicInteger;Lkd/bos/olapServer/performanceStatistics/BenchmarkContext;)V", "fileName", "fileSize", "", "ioBenchmarkPath", "Ljava/nio/file/Path;", "sourceFile", "statisticCount", "", "Lkd/bos/olapServer/common/long;", "getStatisticCount", "()J", "clone", "close", "", "execute", "init", "bos-olap-core"})
public final class IOBenchmarkTask
extends BenchmarkTask {
    @NotNull
    private final AtomicInteger fileNumber;
    @NotNull
    private final Path ioBenchmarkPath;
    @NotNull
    private final String fileName;
    @Nullable
    private Path sourceFile;
    private final int fileSize;

    public IOBenchmarkTask(@NotNull String name2, @NotNull AtomicInteger fileNumber, @NotNull BenchmarkContext ctx) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileNumber, (String)"fileNumber");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(name2, ctx);
        this.fileNumber = fileNumber;
        String[] stringArray = new String[]{"hardware"};
        this.ioBenchmarkPath = Paths.INSTANCE.get(ctx.getDataProvaider().getBenchmarkPath(), stringArray);
        this.fileName = "IOBenchmark.profile";
        this.fileSize = 0x10000000;
    }

    @Override
    public long getStatisticCount() {
        return 256L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.sourceFile == null) {
            File file = this.ioBenchmarkPath.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            Object object = new String[]{this.fileName};
            this.sourceFile = Paths.INSTANCE.get(((Object)this.ioBenchmarkPath).toString(), (String)object);
            object = Files.newOutputStream(this.sourceFile, new OpenOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                int n;
                OutputStream out = (OutputStream)object;
                boolean bl3 = false;
                int n2 = 0;
                byte[] byArray = new byte[1024];
                while (n2 < 1024) {
                    n = n2++;
                    byArray[n] = (byte)(n % 2);
                }
                byte[] buffer = byArray;
                n2 = this.fileSize;
                int n3 = buffer.length;
                if (n3 <= 0) {
                    throw new IllegalArgumentException("Step must be positive, was: " + n3 + '.');
                }
                n = 0;
                int n4 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)n3);
                if (n <= n4) {
                    int i;
                    do {
                        i = n;
                        n += n3;
                        out.write(buffer);
                    } while (i != n4);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    @Override
    public void execute() {
        Object[] objectArray = new String[]{this.fileName + this.fileNumber.incrementAndGet() + ".copy.profile"};
        Path path = Paths.INSTANCE.get(((Object)this.ioBenchmarkPath).toString(), (String[])objectArray);
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path targetFile = Files.copy(this.sourceFile, path, (CopyOption[])objectArray);
        targetFile.toFile().delete();
    }

    @Override
    public void close() {
        File file = this.ioBenchmarkPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"ioBenchmarkPath.toFile()");
        FileTools.INSTANCE.deleteDir(file);
    }

    @NotNull
    public final IOBenchmarkTask clone() {
        IOBenchmarkTask iOBenchmarkTask = new IOBenchmarkTask(this.getName(), this.fileNumber, this.getCtx());
        boolean bl = false;
        boolean bl2 = false;
        IOBenchmarkTask it = iOBenchmarkTask;
        boolean bl3 = false;
        it.sourceFile = this.sourceFile;
        return iOBenchmarkTask;
    }
}

