/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query;

import kd.bos.olapServer.collections.IImmutableBitmap;
import kd.bos.olapServer.common.CommonTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\u0003j\u0002`\u0004H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/query/ImmutableValidDataBitmap;", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "rowCount", "", "Lkd/bos/olapServer/common/int;", "invalidBitmap", "(ILkd/bos/olapServer/collections/IImmutableBitmap;)V", "lastLongIndex", "remBitCount", "get", "", "Lkd/bos/olapServer/common/long;", "index", "bos-olap-core"})
public final class ImmutableValidDataBitmap
implements IImmutableBitmap {
    private final int rowCount;
    @NotNull
    private final IImmutableBitmap invalidBitmap;
    private final int remBitCount;
    private final int lastLongIndex;

    public ImmutableValidDataBitmap(int rowCount, @NotNull IImmutableBitmap invalidBitmap) {
        Intrinsics.checkNotNullParameter((Object)invalidBitmap, (String)"invalidBitmap");
        this.rowCount = rowCount;
        this.invalidBitmap = invalidBitmap;
        boolean bl = this.rowCount >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.remBitCount = this.rowCount % 64;
        this.lastLongIndex = CommonTypesKt.bitCountToLongCount(this.rowCount) - 1;
    }

    @Override
    public long get(int index2) {
        long l;
        if (this.rowCount == 0) {
            return 0L;
        }
        if (index2 < this.lastLongIndex) {
            l = this.invalidBitmap.get(index2) ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (index2 == this.lastLongIndex) {
            int n = this.remBitCount;
            long maskLong = n == 0 ? -1L : (1L << this.remBitCount) - 1L;
            l = maskLong & (this.invalidBitmap.get(index2) ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            l = 0L;
        }
        return l;
    }
}

