/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query;

import java.util.Arrays;
import java.util.List;
import kd.bos.olapServer.collections.objectModel.KeyedCollection;
import kd.bos.olapServer.computingEngine.DimensionFilterCollection;
import kd.bos.olapServer.dataSources.SelectCommandInfo;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.DimensionFilterKt;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\u0011J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0012\u0010\u001d\u001a\u00020\f2\n\u0010\u001e\u001a\u00060\u000ej\u0002`\u000fJ\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lkd/bos/olapServer/query/QueryBuilder;", "", "cubeMetadata", "Lkd/bos/olapServer/metadata/Cube;", "(Lkd/bos/olapServer/metadata/Cube;)V", "_query", "Lkd/bos/olapServer/selects/Query;", "(Lkd/bos/olapServer/metadata/Cube;Lkd/bos/olapServer/selects/Query;)V", "query", "getQuery", "()Lkd/bos/olapServer/selects/Query;", "addFilter", "", "dimensionName", "", "Lkd/bos/olapServer/common/string;", "memberNames", "", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "members", "", "Lkd/bos/olapServer/metadata/Member;", "(Lkd/bos/olapServer/metadata/Dimension;[Lkd/bos/olapServer/metadata/Member;)V", "filters", "", "Lkd/bos/olapServer/query/models/DimensionFilter;", "addFilterCore", "filter", "addSelectField", "fieldName", "check", "parseCommand", "command", "Lkd/bos/olapServer/dataSources/SelectCommandInfo;", "bos-olap-core"})
public final class QueryBuilder {
    @NotNull
    private final Cube cubeMetadata;
    @NotNull
    private final Query query;

    public QueryBuilder(@NotNull Cube cubeMetadata, @NotNull Query _query) {
        Intrinsics.checkNotNullParameter((Object)cubeMetadata, (String)"cubeMetadata");
        Intrinsics.checkNotNullParameter((Object)_query, (String)"_query");
        this.cubeMetadata = cubeMetadata;
        this.query = _query;
    }

    public QueryBuilder(@NotNull Cube cubeMetadata) {
        Intrinsics.checkNotNullParameter((Object)cubeMetadata, (String)"cubeMetadata");
        this(cubeMetadata, new Query());
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    private final void addFilterCore(DimensionFilter filter) {
        this.check(filter);
        Filter currentFilter = this.query.getFilter();
        this.query.setFilter(currentFilter == null ? (Filter)filter : currentFilter.and(filter));
    }

    private final void check(DimensionFilter filter) {
        if (filter.getMembers().isEmpty()) {
            Object[] objectArray = Res.INSTANCE.getQueryTaskBuilderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.QueryTaskBuilderException_1");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{filter.getDimension()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
    }

    public final void addFilter(@NotNull Dimension dimension, @NotNull Member[] members2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)members2, (String)"members");
        DimensionFilter newFilter = DimensionFilterKt.In(dimension, Arrays.copyOf(members2, members2.length));
        this.addFilterCore(newFilter);
    }

    public final void addFilter(@NotNull String dimensionName, @NotNull List<String> memberNames2) {
        Intrinsics.checkNotNullParameter((Object)dimensionName, (String)"dimensionName");
        Intrinsics.checkNotNullParameter(memberNames2, (String)"memberNames");
        Dimension dim = (Dimension)this.cubeMetadata.getDimensions().get(dimensionName);
        DimensionFilter newFilter = new DimensionFilter(dim);
        Iterable $this$forEach$iv = memberNames2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            newFilter.getMembers().add((Member)dim.getMembers().get(it));
        }
        this.addFilterCore(newFilter);
    }

    public final void addFilter(@NotNull Iterable<DimensionFilter> filters) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        AndFilter andFilter = new AndFilter();
        for (DimensionFilter filter : filters) {
            this.check(filter);
            andFilter.add(filter.clone());
        }
        if (andFilter.getHasChildren()) {
            Filter filter;
            Filter currentFilter = this.query.getFilter();
            Filter filter2 = currentFilter;
            if (filter2 == null) {
                filter = andFilter;
            } else if (filter2 instanceof DimensionFilter) {
                andFilter.add(currentFilter);
                filter = andFilter;
            } else {
                filter = currentFilter.and(andFilter);
            }
            this.query.setFilter(filter);
        }
    }

    public final void addSelectField(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Dimension dim = (Dimension)this.cubeMetadata.getDimensions().tryGet(fieldName);
        if (dim != null) {
            KeyedCollection<String, Dimension> keyedCollection = this.query.getDimensions();
            boolean bl = false;
            boolean bl2 = false;
            KeyedCollection<String, Dimension> $this$addSelectField_u24lambda_u2d1 = keyedCollection;
            boolean bl3 = false;
            if (!$this$addSelectField_u24lambda_u2d1.containsKey(fieldName)) {
                $this$addSelectField_u24lambda_u2d1.add(dim);
            }
            return;
        }
        Measure measure = (Measure)this.cubeMetadata.getMeasures().tryGet(fieldName);
        if (measure != null) {
            KeyedCollection<String, Measure> keyedCollection = this.query.getMeasures();
            boolean bl = false;
            boolean bl4 = false;
            KeyedCollection<String, Measure> $this$addSelectField_u24lambda_u2d2 = keyedCollection;
            boolean bl5 = false;
            if (!$this$addSelectField_u24lambda_u2d2.containsKey(fieldName)) {
                $this$addSelectField_u24lambda_u2d2.add(measure);
            }
            return;
        }
        Object[] objectArray = Res.INSTANCE.getQueryTaskBuilderException_2();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.QueryTaskBuilderException_2");
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{fieldName, this.cubeMetadata.getName()};
        throw Res.INSTANCE.getIndexOutOfBoundsException((String)objectArray2, objectArray);
    }

    public final void parseCommand(@NotNull SelectCommandInfo command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        List<String> dimensionNames = command.getDimensions();
        List<String> measureNames = command.getMeasures();
        Iterable $this$forEach$iv = DimensionFilterCollection.Companion.from(this.cubeMetadata.getDimensions(), command.getFilter());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DimensionFilter it = (DimensionFilter)element$iv;
            boolean bl = false;
            this.addFilterCore(it);
        }
        this.query.setTop(command.getTop());
        this.query.setExcludeDynamicCalcResult(command.getExcludeDynamicCalcResult());
        this.query.setIncludeDynamicMemberWhenNullFilter(command.getIncludeDynamicMemberWhenNullFilter());
        for (String dimName : dimensionNames) {
            this.addSelectField(dimName);
        }
        for (String measureName : measureNames) {
            this.addSelectField(measureName);
        }
    }
}

