/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.collections.IImmutableBitmap;
import kd.bos.olapServer.collections.IIndexScanner;
import kd.bos.olapServer.collections.IQueryBitmap;
import kd.bos.olapServer.collections.NumberSetFilter;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.AllRowIndexIterator;
import kd.bos.olapServer.query.AllRowParallelIndexIterator;
import kd.bos.olapServer.query.AllValidQueryBitmap;
import kd.bos.olapServer.query.AndIndexScanner;
import kd.bos.olapServer.query.EmptyQueryBitmap;
import kd.bos.olapServer.query.IRowIndexIterator;
import kd.bos.olapServer.query.ImmutableAndBitmap;
import kd.bos.olapServer.query.ImmutableAndBitmap2;
import kd.bos.olapServer.query.ImmutableOrBitmap;
import kd.bos.olapServer.query.ImmutableOrBitmap2;
import kd.bos.olapServer.query.ImmutableValidDataBitmap;
import kd.bos.olapServer.query.IndexIterator;
import kd.bos.olapServer.query.IntSpliterator;
import kd.bos.olapServer.query.OrIndexScanner;
import kd.bos.olapServer.query.ParallelRowIndexIterator;
import kd.bos.olapServer.query.QueryOperationKt;
import kd.bos.olapServer.query.RowIndexIterator;
import kd.bos.olapServer.query.ValidValueIterator;
import kd.bos.olapServer.query.VirtualImmutableListLong;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.query.models.OrFilter;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.pools.TaskResourceContainer;
import kd.bos.olapServer.storages.selectors.InvalidDataIndexSelector;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 $2\u00020\u0001:\u0006#$%&'(B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan;", "", "workspace", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "filter", "Lkd/bos/olapServer/query/models/Filter;", "(Lkd/bos/olapServer/storages/AbstractCubeWorkspace;Lkd/bos/olapServer/query/models/Filter;)V", "rowCount", "", "Lkd/bos/olapServer/common/int;", "(ILkd/bos/olapServer/query/models/Filter;)V", "_parallelSegmentLength", "_rootNode", "Lkd/bos/olapServer/query/QueryExecutionPlan$ITaskNode;", "_spliterator", "Lkd/bos/olapServer/query/IntSpliterator;", "get_spliterator", "()Lkd/bos/olapServer/query/IntSpliterator;", "_spliterator$delegate", "Lkotlin/Lazy;", "longCount", "value", "parallelSegmentLength", "getParallelSegmentLength", "()I", "setParallelSegmentLength", "(I)V", "build", "Lkd/bos/olapServer/query/IRowIndexIterator;", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "buildForParallel", "createTaskNode", "getValidQueryBitmap", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "AndTaskNode", "Companion", "DimensionTaskNode", "ITaskNode", "OrTaskNode", "TaskNode", "bos-olap-core"})
public final class QueryExecutionPlan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int rowCount;
    @Nullable
    private final Filter filter;
    private final int longCount;
    private int _parallelSegmentLength;
    @NotNull
    private final Lazy _spliterator$delegate;
    @Nullable
    private ITaskNode _rootNode;
    private static final int minMembersCount = 7;
    private static final int maxMembersCount = 1024;

    public QueryExecutionPlan(int rowCount, @Nullable Filter filter) {
        this.rowCount = rowCount;
        this.filter = filter;
        this.longCount = CommonTypesKt.bitCountToLongCount(this.rowCount);
        this._parallelSegmentLength = IntSpliterator.Companion.getDefaultSegmentLength();
        this._spliterator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntSpliterator>(this){
            final /* synthetic */ QueryExecutionPlan this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IntSpliterator invoke() {
                IntSpliterator intSpliterator;
                if (QueryExecutionPlan.access$getFilter$p(this.this$0) == null) {
                    intSpliterator = new IntSpliterator(QueryExecutionPlan.access$getRowCount$p(this.this$0), QueryExecutionPlan.access$get_parallelSegmentLength$p(this.this$0));
                } else {
                    ITaskNode iTaskNode = QueryExecutionPlan.access$createTaskNode(this.this$0, QueryExecutionPlan.access$getFilter$p(this.this$0));
                    QueryExecutionPlan queryExecutionPlan = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    ITaskNode it = iTaskNode;
                    boolean bl3 = false;
                    QueryExecutionPlan.access$set_rootNode$p(queryExecutionPlan, it);
                    intSpliterator = new IntSpliterator(QueryExecutionPlan.access$getLongCount$p(this.this$0), QueryExecutionPlan.access$get_parallelSegmentLength$p(this.this$0));
                }
                return intSpliterator;
            }
        }));
    }

    public QueryExecutionPlan(@NotNull AbstractCubeWorkspace workspace, @Nullable Filter filter) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this(workspace.getRowCount(), filter);
    }

    @NotNull
    public final IRowIndexIterator build(@NotNull TaskResourceContainer res) {
        IRowIndexIterator iRowIndexIterator;
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        if (this.rowCount == 0) {
            return IRowIndexIterator.Empty.INSTANCE;
        }
        IImmutableBitmap validQueryBitmap = this.getValidQueryBitmap(res, this.rowCount);
        IImmutableBitmap iImmutableBitmap = validQueryBitmap;
        if (iImmutableBitmap instanceof AllValidQueryBitmap) {
            if (this.filter == null) {
                iRowIndexIterator = new AllRowIndexIterator(this.rowCount);
            } else {
                ITaskNode rootTaskNode = this.createTaskNode(this.filter);
                IndexIterator rangeIndexes = new IndexIterator(rootTaskNode.createIndexScanner(res), 0, this.longCount);
                iRowIndexIterator = new RowIndexIterator(new ValidValueIterator(rootTaskNode.createBitmap(res), rangeIndexes));
            }
        } else {
            RowIndexIterator rowIndexIterator;
            if (this.filter == null) {
                rowIndexIterator = new RowIndexIterator(QueryOperationKt.getValidValues(validQueryBitmap, RangesKt.until((int)0, (int)this.longCount)));
            } else {
                ITaskNode rootTaskNode = this.createTaskNode(this.filter);
                IndexIterator rangeIndexes = new IndexIterator(rootTaskNode.createIndexScanner(res), 0, this.longCount);
                ImmutableAndBitmap2 andBitmap = new ImmutableAndBitmap2(rootTaskNode.createBitmap(res), validQueryBitmap);
                rowIndexIterator = new RowIndexIterator(new ValidValueIterator(andBitmap, rangeIndexes));
            }
            iRowIndexIterator = rowIndexIterator;
        }
        return iRowIndexIterator;
    }

    private final IntSpliterator get_spliterator() {
        Lazy lazy = this._spliterator$delegate;
        boolean bl = false;
        return (IntSpliterator)lazy.getValue();
    }

    public final int getParallelSegmentLength() {
        return this._parallelSegmentLength;
    }

    public final void setParallelSegmentLength(int value2) {
        boolean bl = value2 > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"value error ", (Object)value2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._parallelSegmentLength = value2;
    }

    @NotNull
    public final IRowIndexIterator buildForParallel(@NotNull TaskResourceContainer res) {
        IRowIndexIterator iRowIndexIterator;
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        if (this.rowCount == 0) {
            return IRowIndexIterator.Empty.INSTANCE;
        }
        IImmutableBitmap validQueryBitmap = this.getValidQueryBitmap(res, this.rowCount);
        IImmutableBitmap iImmutableBitmap = validQueryBitmap;
        if (iImmutableBitmap instanceof AllValidQueryBitmap) {
            if (this.filter == null) {
                iRowIndexIterator = new AllRowParallelIndexIterator(this.get_spliterator());
            } else {
                IntSpliterator intSpliterator = this.get_spliterator();
                ITaskNode iTaskNode = this._rootNode;
                Intrinsics.checkNotNull((Object)iTaskNode);
                iRowIndexIterator = new ParallelRowIndexIterator(res, intSpliterator, iTaskNode, null, 8, null);
            }
        } else {
            ParallelRowIndexIterator parallelRowIndexIterator;
            if (this.filter == null) {
                parallelRowIndexIterator = new ParallelRowIndexIterator(res, this.get_spliterator(), null, validQueryBitmap);
            } else {
                IntSpliterator intSpliterator = this.get_spliterator();
                ITaskNode iTaskNode = this._rootNode;
                Intrinsics.checkNotNull((Object)iTaskNode);
                parallelRowIndexIterator = new ParallelRowIndexIterator(res, intSpliterator, iTaskNode, validQueryBitmap);
            }
            iRowIndexIterator = parallelRowIndexIterator;
        }
        return iRowIndexIterator;
    }

    private final IImmutableBitmap getValidQueryBitmap(TaskResourceContainer res, int rowCount) {
        IQueryBitmap invalidBitMap = res.getInvalidDataQueryBitmaps(InvalidDataIndexSelector.Companion.getInvalidDataMemberId());
        IQueryBitmap iQueryBitmap = invalidBitMap;
        return iQueryBitmap instanceof EmptyQueryBitmap ? (IImmutableBitmap)AllValidQueryBitmap.Companion.getDefault() : (IImmutableBitmap)new ImmutableValidDataBitmap(rowCount, invalidBitMap);
    }

    private final ITaskNode createTaskNode(Filter filter) {
        ITaskNode iTaskNode;
        Filter filter2 = filter;
        if (filter2 instanceof OrFilter) {
            iTaskNode = new OrTaskNode((OrFilter)filter);
        } else if (filter2 instanceof AndFilter) {
            iTaskNode = new AndTaskNode((AndFilter)filter);
        } else if (filter2 instanceof DimensionFilter) {
            iTaskNode = new DimensionTaskNode((DimensionFilter)filter);
        } else {
            throw new NotSupportedException();
        }
        return iTaskNode;
    }

    public static final /* synthetic */ Filter access$getFilter$p(QueryExecutionPlan $this) {
        return $this.filter;
    }

    public static final /* synthetic */ int access$getRowCount$p(QueryExecutionPlan $this) {
        return $this.rowCount;
    }

    public static final /* synthetic */ int access$get_parallelSegmentLength$p(QueryExecutionPlan $this) {
        return $this._parallelSegmentLength;
    }

    public static final /* synthetic */ int access$getLongCount$p(QueryExecutionPlan $this) {
        return $this.longCount;
    }

    public static final /* synthetic */ void access$set_rootNode$p(QueryExecutionPlan $this, ITaskNode iTaskNode) {
        $this._rootNode = iTaskNode;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$Companion;", "", "()V", "maxMembersCount", "", "minMembersCount", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$ITaskNode;", "", "createBitmap", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer/collections/IIndexScanner;", "bos-olap-core"})
    public static interface ITaskNode {
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull TaskResourceContainer var1);

        @NotNull
        public IImmutableBitmap createBitmap(@NotNull TaskResourceContainer var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0004R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$TaskNode;", "T", "Lkd/bos/olapServer/query/models/Filter;", "Lkd/bos/olapServer/query/QueryExecutionPlan$ITaskNode;", "filter", "(Lkd/bos/olapServer/query/QueryExecutionPlan;Lkd/bos/olapServer/query/models/Filter;)V", "children", "", "getChildren", "()Ljava/util/List;", "getFilter", "()Lkd/bos/olapServer/query/models/Filter;", "Lkd/bos/olapServer/query/models/Filter;", "add", "", "bos-olap-core"})
    private static abstract class TaskNode<T extends Filter>
    implements ITaskNode {
        @NotNull
        private final T filter;
        @NotNull
        private final List<ITaskNode> children;
        final /* synthetic */ QueryExecutionPlan this$0;

        public TaskNode(T filter) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            this.this$0 = this$0;
            this.filter = filter;
            boolean bl = false;
            this.children = new ArrayList();
        }

        @NotNull
        public final T getFilter() {
            return this.filter;
        }

        @NotNull
        public final List<ITaskNode> getChildren() {
            return this.children;
        }

        protected final void add(@NotNull Filter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            this.children.add(this.this$0.createTaskNode(filter));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$OrTaskNode;", "Lkd/bos/olapServer/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer/query/models/OrFilter;", "Lkd/bos/olapServer/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer/query/QueryExecutionPlan;Lkd/bos/olapServer/query/models/OrFilter;)V", "createBitmap", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer/collections/IIndexScanner;", "bos-olap-core"})
    private final class OrTaskNode
    extends TaskNode<OrFilter> {
        public OrTaskNode(OrFilter filter) {
            Intrinsics.checkNotNullParameter((Object)QueryExecutionPlan.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter);
            Iterator<Filter> iterator = filter.getChildren();
            boolean bl = false;
            Iterator<Filter> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Filter child = iterator2.next();
                this.add(child);
            }
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull TaskResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            int n = 0;
            int n2 = this.getChildren().size();
            IIndexScanner[] iIndexScannerArray = new IIndexScanner[n2];
            while (n < n2) {
                int n3 = n++;
                iIndexScannerArray[n3] = this.getChildren().get(n3).createIndexScanner(res);
            }
            IIndexScanner[] iIndexScannerArray2 = iIndexScannerArray;
            return new OrIndexScanner(iIndexScannerArray2);
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull TaskResourceContainer res) {
            IImmutableBitmap iImmutableBitmap;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (this.getChildren().size() == 2) {
                iImmutableBitmap = new ImmutableOrBitmap2(this.getChildren().get(0).createBitmap(res), this.getChildren().get(1).createBitmap(res));
            } else {
                int n = 0;
                int n2 = this.getChildren().size();
                IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[n2];
                while (n < n2) {
                    int n3 = n++;
                    iImmutableBitmapArray[n3] = this.getChildren().get(n3).createBitmap(res);
                }
                IImmutableBitmap[] iImmutableBitmapArray2 = iImmutableBitmapArray;
                iImmutableBitmap = new ImmutableOrBitmap(iImmutableBitmapArray2);
            }
            return iImmutableBitmap;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$AndTaskNode;", "Lkd/bos/olapServer/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer/query/models/AndFilter;", "Lkd/bos/olapServer/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer/query/QueryExecutionPlan;Lkd/bos/olapServer/query/models/AndFilter;)V", "createBitmap", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer/collections/IIndexScanner;", "bos-olap-core"})
    private final class AndTaskNode
    extends TaskNode<AndFilter> {
        public AndTaskNode(AndFilter filter) {
            Intrinsics.checkNotNullParameter((Object)QueryExecutionPlan.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter);
            Iterator<Filter> iterator = filter.getChildren();
            boolean bl = false;
            Iterator<Filter> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Filter child = iterator2.next();
                this.add(child);
            }
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull TaskResourceContainer res) {
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            int n = 0;
            int n2 = this.getChildren().size();
            IIndexScanner[] iIndexScannerArray = new IIndexScanner[n2];
            while (n < n2) {
                int n3 = n++;
                iIndexScannerArray[n3] = this.getChildren().get(n3).createIndexScanner(res);
            }
            IIndexScanner[] iIndexScannerArray2 = iIndexScannerArray;
            return new AndIndexScanner(iIndexScannerArray2);
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull TaskResourceContainer res) {
            IImmutableBitmap iImmutableBitmap;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            if (this.getChildren().size() == 2) {
                iImmutableBitmap = new ImmutableAndBitmap2(this.getChildren().get(0).createBitmap(res), this.getChildren().get(1).createBitmap(res));
            } else {
                int n = 0;
                int n2 = this.getChildren().size();
                IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[n2];
                while (n < n2) {
                    int n3 = n++;
                    iImmutableBitmapArray[n3] = this.getChildren().get(n3).createBitmap(res);
                }
                IImmutableBitmap[] iImmutableBitmapArray2 = iImmutableBitmapArray;
                iImmutableBitmap = new ImmutableAndBitmap(iImmutableBitmapArray2);
            }
            return iImmutableBitmap;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lkd/bos/olapServer/query/QueryExecutionPlan$DimensionTaskNode;", "Lkd/bos/olapServer/query/QueryExecutionPlan$TaskNode;", "Lkd/bos/olapServer/query/models/DimensionFilter;", "Lkd/bos/olapServer/query/QueryExecutionPlan;", "filter", "(Lkd/bos/olapServer/query/QueryExecutionPlan;Lkd/bos/olapServer/query/models/DimensionFilter;)V", "createBitmap", "Lkd/bos/olapServer/collections/IImmutableBitmap;", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "createIndexScanner", "Lkd/bos/olapServer/collections/IIndexScanner;", "bos-olap-core"})
    private final class DimensionTaskNode
    extends TaskNode<DimensionFilter> {
        public DimensionTaskNode(DimensionFilter filter) {
            Intrinsics.checkNotNullParameter((Object)QueryExecutionPlan.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(QueryExecutionPlan.this, (Filter)filter);
        }

        @Override
        @NotNull
        public IIndexScanner createIndexScanner(@NotNull TaskResourceContainer res) {
            IIndexScanner iIndexScanner;
            int size;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Collection<Member> members2 = ((DimensionFilter)this.getFilter()).getMembers();
            Iterator<Member> membersItr = members2.iterator();
            int n = size = members2.size();
            switch (n) {
                case 0: {
                    iIndexScanner = EmptyQueryBitmap.Companion.getDefault().getIndexScanner();
                    break;
                }
                case 1: {
                    iIndexScanner = res.getQueryBitmap(((DimensionFilter)this.getFilter()).getDimension(), membersItr.next()).getIndexScanner();
                    break;
                }
                default: {
                    if (size < 1024) {
                        int n2 = 0;
                        int n3 = size;
                        IIndexScanner[] iIndexScannerArray = new IIndexScanner[n3];
                        while (n2 < n3) {
                            int n4 = n2++;
                            iIndexScannerArray[n4] = res.getQueryBitmap(((DimensionFilter)this.getFilter()).getDimension(), membersItr.next()).getIndexScanner();
                        }
                        IIndexScanner[] iIndexScannerArray2 = iIndexScannerArray;
                        iIndexScanner = new OrIndexScanner(iIndexScannerArray2);
                        break;
                    }
                    iIndexScanner = AllValidQueryBitmap.Companion.getDefault().getIndexScanner();
                }
            }
            return iIndexScanner;
        }

        @Override
        @NotNull
        public IImmutableBitmap createBitmap(@NotNull TaskResourceContainer res) {
            IImmutableBitmap iImmutableBitmap;
            int size;
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            Collection<Member> members2 = ((DimensionFilter)this.getFilter()).getMembers();
            Iterator<Member> membersItr = members2.iterator();
            int n = size = members2.size();
            switch (n) {
                case 0: {
                    iImmutableBitmap = EmptyQueryBitmap.Companion.getDefault();
                    break;
                }
                case 1: {
                    iImmutableBitmap = res.getQueryBitmap(((DimensionFilter)this.getFilter()).getDimension(), membersItr.next());
                    break;
                }
                default: {
                    if (size < 7) {
                        int n2 = 0;
                        int n3 = size;
                        IImmutableBitmap[] iImmutableBitmapArray = new IImmutableBitmap[n3];
                        while (n2 < n3) {
                            int n4 = n2++;
                            iImmutableBitmapArray[n4] = res.getQueryBitmap(((DimensionFilter)this.getFilter()).getDimension(), membersItr.next());
                        }
                        IImmutableBitmap[] iImmutableBitmapArray2 = iImmutableBitmapArray;
                        iImmutableBitmap = new ImmutableOrBitmap(iImmutableBitmapArray2);
                        break;
                    }
                    int staticCount = size > 10000 ? 0x100000 : 16384;
                    NumberSetFilter matcher = new NumberSetFilter(staticCount);
                    Iterator<Member> $this$forEach$iv = membersItr;
                    boolean $i$f$forEach = false;
                    Iterator<Member> iterator = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Member> iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Member element$iv;
                        Member it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        matcher.add(it.getPosition$bos_olap_core());
                    }
                    iImmutableBitmap = new VirtualImmutableListLong(res.getDimensionList(((DimensionFilter)this.getFilter()).getDimension()), matcher.getWhiteListFilter());
                }
            }
            return iImmutableBitmap;
        }
    }
}

