/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.olapServer.collections.IIntIterator;
import kd.bos.olapServer.computingEngine.batchTasks.IntBatchLockedResourceIterator;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.IRowIndexIterator;
import kd.bos.olapServer.query.ITaskResourceContainerProvider;
import kd.bos.olapServer.query.IntSpliterator;
import kd.bos.olapServer.query.QueryExecutionPlan;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.storages.AbstractCubeWorkspace;
import kd.bos.olapServer.storages.pools.TaskResourceContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010+\u001a\u00020\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u0010\u001a.\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0011j\u0016\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006,"}, d2={"Lkd/bos/olapServer/query/QuerySession;", "", "workspace", "Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "query", "Lkd/bos/olapServer/selects/Query;", "(Lkd/bos/olapServer/storages/AbstractCubeWorkspace;Lkd/bos/olapServer/selects/Query;)V", "filter", "Lkd/bos/olapServer/query/models/Filter;", "(Lkd/bos/olapServer/storages/AbstractCubeWorkspace;Lkd/bos/olapServer/selects/Query;Lkd/bos/olapServer/query/models/Filter;)V", "_parallelSegmentLength", "", "_sharedQueryExecutionPlan", "Lkd/bos/olapServer/query/QueryExecutionPlan;", "_sharedRowIndexItr", "Lkd/bos/olapServer/query/IRowIndexIterator;", "dimensionFilterMembersCache", "Ljava/util/HashMap;", "Lkd/bos/olapServer/metadata/Dimension;", "", "Lkd/bos/olapServer/metadata/Member;", "Lkotlin/collections/HashMap;", "value", "parallelSegmentLength", "getParallelSegmentLength", "()I", "setParallelSegmentLength", "(I)V", "getQuery", "()Lkd/bos/olapServer/selects/Query;", "top", "", "getWorkspace", "()Lkd/bos/olapServer/storages/AbstractCubeWorkspace;", "build", "res", "Lkd/bos/olapServer/storages/pools/TaskResourceContainer;", "buildForParallel", "resProvider", "Lkd/bos/olapServer/query/ITaskResourceContainerProvider;", "buildSelectFields", "", "getDimensionFilterMembers", "dimension", "bos-olap-core"})
public final class QuerySession {
    @NotNull
    private final AbstractCubeWorkspace workspace;
    @NotNull
    private final Query query;
    @Nullable
    private final Filter filter;
    private final long top;
    @NotNull
    private final HashMap<Dimension, Collection<Member>> dimensionFilterMembersCache;
    @Nullable
    private volatile QueryExecutionPlan _sharedQueryExecutionPlan;
    private int _parallelSegmentLength;
    @Nullable
    private volatile IRowIndexIterator _sharedRowIndexItr;

    public QuerySession(@NotNull AbstractCubeWorkspace workspace, @NotNull Query query2, @Nullable Filter filter) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.workspace = workspace;
        this.query = query2;
        this.filter = filter;
        this.top = this.query.getTop();
        this.dimensionFilterMembersCache = new HashMap();
        this._parallelSegmentLength = IntSpliterator.Companion.getDefaultSegmentLength();
    }

    @NotNull
    public final AbstractCubeWorkspace getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    public QuerySession(@NotNull AbstractCubeWorkspace workspace, @NotNull Query query2) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this(workspace, query2, query2.getFilter());
    }

    @NotNull
    public final IRowIndexIterator build(@NotNull TaskResourceContainer res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        QueryExecutionPlan plan = new QueryExecutionPlan(this.workspace.getRowCount(), this.filter);
        IRowIndexIterator result = plan.build(res);
        this.buildSelectFields();
        return result;
    }

    private final void buildSelectFields() {
        Filter currentFilter = this.filter;
        Filter filter = currentFilter;
        if (filter instanceof DimensionFilter) {
            Map map = this.dimensionFilterMembersCache;
            Dimension dimension = ((DimensionFilter)currentFilter).getDimension();
            Collection<Member> collection = ((DimensionFilter)currentFilter).getMembers();
            boolean bl = false;
            map.put(dimension, collection);
        } else if (filter instanceof AndFilter) {
            Iterator<Filter> iterator = ((AndFilter)currentFilter).getChildren();
            boolean bl = false;
            Iterator<Filter> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Filter child = iterator2.next();
                if (!(child instanceof DimensionFilter)) continue;
                Map map = this.dimensionFilterMembersCache;
                Dimension dimension = ((DimensionFilter)child).getDimension();
                Collection<Member> collection = ((DimensionFilter)child).getMembers();
                boolean bl2 = false;
                map.put(dimension, collection);
            }
        }
    }

    @Nullable
    public final Collection<Member> getDimensionFilterMembers(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.dimensionFilterMembersCache.get(dimension);
    }

    public final int getParallelSegmentLength() {
        return this._parallelSegmentLength;
    }

    public final void setParallelSegmentLength(int value2) {
        boolean bl = value2 > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"value error ", (Object)value2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._parallelSegmentLength = value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IRowIndexIterator buildForParallel(@NotNull ITaskResourceContainerProvider resProvider) {
        QueryExecutionPlan queryExecutionPlan;
        Intrinsics.checkNotNullParameter((Object)resProvider, (String)"resProvider");
        boolean bl = this.top == 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "top value must equals zero.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        QueryExecutionPlan queryExecutionPlan2 = this._sharedQueryExecutionPlan;
        if (queryExecutionPlan2 == null) {
            bl3 = false;
            boolean bl5 = false;
            synchronized (this) {
                boolean bl6 = false;
                QueryExecutionPlan qp2 = this._sharedQueryExecutionPlan;
                if (qp2 == null) {
                    qp2 = new QueryExecutionPlan(this.getWorkspace().getRowCount(), this.filter);
                    qp2.setParallelSegmentLength(this._parallelSegmentLength);
                    this.buildSelectFields();
                    if (this.getWorkspace().getRowCount() < 10000000) {
                        TaskResourceContainer queryResContainer = resProvider.getSharedResourceContainer();
                        this._sharedRowIndexItr = qp2.build(queryResContainer);
                    }
                    this._sharedQueryExecutionPlan = qp2;
                }
                QueryExecutionPlan queryExecutionPlan3 = qp2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl27 : MonitorExitStatement: MONITOREXIT : this
                queryExecutionPlan = queryExecutionPlan3;
            }
        } else {
            queryExecutionPlan = queryExecutionPlan2;
        }
        QueryExecutionPlan qp = queryExecutionPlan;
        IRowIndexIterator sharedRowIndexItr = this._sharedRowIndexItr;
        return sharedRowIndexItr == null ? qp.buildForParallel(resProvider.getCurrentThreadResourceContainer()) : (IRowIndexIterator)new IntBatchLockedResourceIterator<IIntIterator>(sharedRowIndexItr);
    }
}

