/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olapServer.common.CancellableToken;
import kd.bos.olapServer.common.IContinueToken;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.dynamicCalc.DynamicCalcQuerySessionBuilder;
import kd.bos.olapServer.dataSources.DistinctSelectCommandInfo;
import kd.bos.olapServer.dataSources.SelectCommandInfo;
import kd.bos.olapServer.dataSources.SelectCommandInfoV1;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Measure;
import kd.bos.olapServer.metadata.MeasureCollection;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.metadata.MemberCollection;
import kd.bos.olapServer.metadata.OlapDataTypes;
import kd.bos.olapServer.query.IQueryJsonWriter;
import kd.bos.olapServer.query.QueryBuilder;
import kd.bos.olapServer.query.QueryJsonWriter;
import kd.bos.olapServer.query.QueryJsonWriterV1;
import kd.bos.olapServer.query.TopRowQueryReaderKt;
import kd.bos.olapServer.selects.DistinctQueryReaderKt;
import kd.bos.olapServer.selects.IDimensionSelectField;
import kd.bos.olapServer.selects.IDimensionSelectFieldV1;
import kd.bos.olapServer.selects.IMeasureSelectField;
import kd.bos.olapServer.selects.IQueryReader;
import kd.bos.olapServer.selects.IQuerySession;
import kd.bos.olapServer.selects.ISelectField;
import kd.bos.olapServer.selects.ISelectFieldCollection;
import kd.bos.olapServer.selects.Query;
import kd.bos.olapServer.shrek.dataSources.DimensionItem;
import kd.bos.olapServer.shrek.dataSources.DimensionItemV1;
import kd.bos.olapServer.shrek.dataSources.MeasureItem;
import kd.bos.olapServer.shrek.dataSources.SelectMetaData;
import kd.bos.olapServer.shrek.dataSources.SelectMetaDataV1;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\u00102\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b\u0012\u0004\u0012\u00020\u00100\u001aJ.\u0010\u0018\u001a\u00020\u00102\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b\u0012\u0004\u0012\u00020\u00100\u001a2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eJ\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lkd/bos/olapServer/query/SelectCommandExecutor;", "", "command", "Lkd/bos/olapServer/dataSources/SelectCommandInfo;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cubeWorkspace", "Lkd/bos/olapServer/storages/CubeWorkspace;", "(Lkd/bos/olapServer/dataSources/SelectCommandInfo;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/storages/CubeWorkspace;)V", "cancelToken", "Lkd/bos/olapServer/common/IContinueToken;", "query", "Lkd/bos/olapServer/selects/Query;", "getQuery", "()Lkd/bos/olapServer/selects/Query;", "buildDistinctResult", "", "outputStream", "Ljava/io/OutputStream;", "buildJsonWriter", "jsonWriter", "Lkd/bos/olapServer/query/IQueryJsonWriter;", "queryReader", "Lkd/bos/olapServer/selects/IQueryReader;", "buildResult", "consumer", "Lkotlin/Function1;", "", "outputMemberName", "", "Lkd/bos/olapServer/common/bool;", "buildResultV1", "buildResultV3", "buildSelectMetadataV1", "Lkd/bos/olapServer/shrek/dataSources/SelectMetaDataV1;", "buildSelectMetadataV3", "Lkd/bos/olapServer/shrek/dataSources/SelectMetaData;", "createQuerySession", "Lkd/bos/olapServer/selects/IQuerySession;", "bos-olap-core"})
public final class SelectCommandExecutor {
    @NotNull
    private final SelectCommandInfo command;
    @NotNull
    private final OlapWorkspace olapWorkspace;
    @NotNull
    private final CubeWorkspace cubeWorkspace;
    @NotNull
    private final Query query;
    @NotNull
    private final IContinueToken cancelToken;

    public SelectCommandExecutor(@NotNull SelectCommandInfo command, @NotNull OlapWorkspace olapWorkspace, @NotNull CubeWorkspace cubeWorkspace) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)olapWorkspace, (String)"olapWorkspace");
        Intrinsics.checkNotNullParameter((Object)cubeWorkspace, (String)"cubeWorkspace");
        this.command = command;
        this.olapWorkspace = olapWorkspace;
        this.cubeWorkspace = cubeWorkspace;
        this.cancelToken = CancellableToken.INSTANCE.getContinueToken();
        QueryBuilder queryBuilder = new QueryBuilder(this.cubeWorkspace.getMetadata());
        queryBuilder.parseCommand(this.command);
        this.query = queryBuilder.getQuery();
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    public final void buildResult(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        SelectCommandInfo selectCommandInfo = this.command;
        if (selectCommandInfo instanceof SelectCommandInfoV1) {
            this.buildResultV1(outputStream);
        } else if (selectCommandInfo instanceof DistinctSelectCommandInfo) {
            this.buildDistinctResult(outputStream);
        } else if (selectCommandInfo instanceof SelectCommandInfo) {
            this.buildResultV3(outputStream);
        } else {
            Object[] objectArray = Res.INSTANCE.getUnsupportedCommandInfoException();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.UnsupportedCommandInfoException");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{this.command.toString()};
            throw Res.INSTANCE.getNotSupportedException((String)objectArray2, objectArray);
        }
    }

    public final void buildResult(@NotNull Function1<? super Object[], Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.buildResult(consumer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void buildResult(@NotNull Function1<? super Object[], Unit> consumer, boolean outputMemberName) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Closeable closeable = this.createQuerySession();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl3 = false;
            Closeable closeable2 = dynamicCalcSession.createReader();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl6 = false;
                Cube cube = this.cubeWorkspace.getMetadata();
                int dimSize = this.getQuery().getDimensions().getCount();
                int measureSize = this.getQuery().getMeasures().getCount();
                ISelectFieldCollection fields = dynamicCalcReader.getSelectFields();
                int n = 0;
                int n2 = dimSize;
                MemberCollection[] memberCollectionArray = new MemberCollection[n2];
                while (n < n2) {
                    int n3 = n++;
                    memberCollectionArray[n3] = ((Dimension)cube.getDimensions().get(((ISelectField)fields.get(n3)).getName())).getMembers();
                }
                MemberCollection[] dims = memberCollectionArray;
                Object[] values = new Object[fields.getCount()];
                while (dynamicCalcReader.next() && this.cancelToken.canContinue()) {
                    n2 = 0;
                    int n4 = values.length + -1;
                    if (n2 <= n4) {
                        do {
                            int i;
                            ISelectField field;
                            if ((field = (ISelectField)fields.get(i = n2++)) instanceof IDimensionSelectField) {
                                Member member = (Member)dims[i].get(((IDimensionSelectField)field).getCurrent());
                                values[i + measureSize] = outputMemberName ? member.getName() : member;
                                continue;
                            }
                            if (field instanceof IMeasureSelectField) {
                                values[i - dimSize] = ((IMeasureSelectField)field).getCurrent();
                                continue;
                            }
                            throw new NotSupportedException();
                        } while (n2 <= n4);
                    }
                    consumer.invoke((Object)values);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildResultV1(OutputStream outputStream) {
        Closeable closeable = this.createQuerySession();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl3 = false;
            Closeable closeable2 = dynamicCalcSession.createReader();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl6 = false;
                if (dynamicCalcReader.next()) {
                    QueryJsonWriterV1 jsonWriter = new QueryJsonWriterV1(this.buildSelectMetadataV1(dynamicCalcReader), outputStream);
                    this.buildJsonWriter(jsonWriter, dynamicCalcReader);
                    jsonWriter.writeHead();
                    do {
                        jsonWriter.writeRow();
                    } while (dynamicCalcReader.next() && this.cancelToken.canContinue());
                    jsonWriter.writeEnd();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildResultV3(OutputStream outputStream) {
        Closeable closeable = this.createQuerySession();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IQuerySession dynamicCalcSession = (IQuerySession)closeable;
            boolean bl3 = false;
            Closeable closeable2 = TopRowQueryReaderKt.top(dynamicCalcSession.createReader(), this.getQuery().getTop(), false);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                IQueryReader dynamicCalcReader = (IQueryReader)closeable2;
                boolean bl6 = false;
                QueryJsonWriter jsonWriter = new QueryJsonWriter(this.buildSelectMetadataV3(), outputStream);
                this.buildJsonWriter(jsonWriter, dynamicCalcReader);
                jsonWriter.writeHead();
                while (dynamicCalcReader.next() && this.cancelToken.canContinue()) {
                    jsonWriter.writeRow();
                }
                jsonWriter.writeEnd();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final IQuerySession createQuerySession() {
        return DynamicCalcQuerySessionBuilder.INSTANCE.createQuerySession(this.cubeWorkspace, this.olapWorkspace.getTempPool(), this.query, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildDistinctResult(OutputStream outputStream) {
        long top = this.query.getTop() <= 0L ? 1000000L : Math.min(this.query.getTop(), 1000000L);
        this.query.setTop(0L);
        Closeable closeable = this.cubeWorkspace.createQuerySession(this.query, false);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IQuerySession querySession = (IQuerySession)closeable;
            boolean bl3 = false;
            Closeable closeable2 = TopRowQueryReaderKt.top(DistinctQueryReaderKt.distinct(querySession.createReader(), this.olapWorkspace.getTempPool(), this.cubeWorkspace.getMetadata(), this.getQuery()), top, false);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                IQueryReader queryReader = (IQueryReader)closeable2;
                boolean bl6 = false;
                QueryJsonWriter jsonWriter = new QueryJsonWriter(this.buildSelectMetadataV3(), outputStream);
                for (String dimension : this.command.getDimensions()) {
                    jsonWriter.addDimensionField((IDimensionSelectField)queryReader.getSelectFields().get(dimension));
                }
                jsonWriter.writeHead();
                while (queryReader.next() && this.cancelToken.canContinue()) {
                    jsonWriter.writeRow();
                }
                jsonWriter.writeEnd();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void buildJsonWriter(IQueryJsonWriter jsonWriter, IQueryReader queryReader) {
        for (String dimension : this.command.getDimensions()) {
            jsonWriter.addDimensionField((IDimensionSelectField)queryReader.getSelectFields().get(dimension));
        }
        for (String measure : this.command.getMeasures()) {
            jsonWriter.addMeasureField((IMeasureSelectField)queryReader.getSelectFields().get(measure));
        }
    }

    private final SelectMetaDataV1 buildSelectMetadataV1(IQueryReader queryReader) {
        SelectMetaDataV1 selectMetadata = new SelectMetaDataV1();
        List<String> dimensions2 = this.command.getDimensions();
        for (String dimension : dimensions2) {
            IDimensionSelectFieldV1 dimField = (IDimensionSelectFieldV1)queryReader.getSelectFields().get(dimension);
            Member[] members2 = dimField.getOutMembers();
            int n = 0;
            int n2 = members2.length;
            Object[] objectArray = new String[n2];
            String string = dimension;
            SelectMetaDataV1 selectMetaDataV1 = selectMetadata;
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = members2[n3].getName();
            }
            ArrayList arrayList = (ArrayList)ArraysKt.toCollection((Object[])objectArray, (Collection)new ArrayList());
            String string2 = string;
            selectMetaDataV1.addDimensionItem(new DimensionItemV1(string2, arrayList));
        }
        for (String measure : this.command.getMeasures()) {
            selectMetadata.addMeasure(measure);
        }
        return selectMetadata;
    }

    private final SelectMetaData buildSelectMetadataV3() {
        Cube cube = this.cubeWorkspace.getMetadata();
        SelectMetaData selectMetadata = new SelectMetaData();
        List<String> dimensions2 = this.command.getDimensions();
        for (String dimension : dimensions2) {
            selectMetadata.addDimensionItem(new DimensionItem(dimension, OlapDataTypes.string));
        }
        MeasureCollection mes = cube.getMeasures();
        for (String measure : this.command.getMeasures()) {
            selectMetadata.addMeasure(new MeasureItem(measure, ((Measure)mes.get(measure)).getDataType()));
        }
        return selectMetadata;
    }
}

