/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query.match;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.olapServer.collections.IIterator;
import kd.bos.olapServer.collections.objectModel.IImmutableCollection;
import kd.bos.olapServer.collections.objectModel.ImmutableArray;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.IntArraySequenceBuilder;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.match.AbstractMatchBitmap;
import kd.bos.olapServer.query.match.AndFilterBitmapNode;
import kd.bos.olapServer.query.match.DimensionFilterBitmapNode;
import kd.bos.olapServer.query.match.FilterBitmapNode;
import kd.bos.olapServer.query.match.OrFilterBitmapNode;
import kd.bos.olapServer.query.match.PartitionFilterBitmapNode;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.query.models.OrFilter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0014\u0010\u0017\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\f\u0010\u0019\u001a\u00060\u000fj\u0002`\u0010H\u0002J\f\u0010\u001a\u001a\u00060\u000fj\u0002`\u0010H\u0002J$\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010#\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lkd/bos/olapServer/query/match/MatchBitmapFactory;", "", "dimensions", "", "Lkd/bos/olapServer/metadata/Dimension;", "([Lkd/bos/olapServer/metadata/Dimension;)V", "Lkd/bos/olapServer/collections/objectModel/IImmutableCollection;", "(Lkd/bos/olapServer/collections/objectModel/IImmutableCollection;)V", "assistArray", "", "dimensionMap", "positionArray", "positionBuilder", "Lkd/bos/olapServer/computingEngine/IntArraySequenceBuilder;", "size", "", "Lkd/bos/olapServer/common/int;", "getSize", "()I", "createMatchBitmap", "Lkd/bos/olapServer/query/match/FilterBitmapNode;", "filter", "Lkd/bos/olapServer/query/models/Filter;", "getDimensionIndex", "dimension", "init", "maxPosition", "setBitmap", "", "index", "Lkd/bos/olapServer/query/models/DimensionFilter;", "bitMap", "Ljava/util/BitSet;", "setKey", "position", "key", "bos-olap-core"})
public final class MatchBitmapFactory {
    @NotNull
    private final IImmutableCollection<Dimension> dimensions;
    @NotNull
    private final int[] dimensionMap;
    @NotNull
    private final int[] assistArray;
    private final int size;
    @NotNull
    private final int[] positionArray;
    @NotNull
    private final IntArraySequenceBuilder positionBuilder;

    public MatchBitmapFactory(@NotNull IImmutableCollection<? extends Dimension> dimensions2) {
        Intrinsics.checkNotNullParameter(dimensions2, (String)"dimensions");
        this.dimensions = dimensions2;
        int n = 0;
        int n2 = this.maxPosition();
        int[] nArray = new int[n2];
        MatchBitmapFactory matchBitmapFactory = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        matchBitmapFactory.dimensionMap = nArray;
        this.assistArray = new int[this.dimensions.getCount()];
        this.size = this.init();
        this.positionArray = new int[this.dimensions.getCount()];
        this.positionBuilder = new IntArraySequenceBuilder(this.positionArray);
    }

    public MatchBitmapFactory(@NotNull Dimension[] dimensions2) {
        Intrinsics.checkNotNullParameter((Object)dimensions2, (String)"dimensions");
        this((IImmutableCollection<? extends Dimension>)new ImmutableArray<Dimension>(dimensions2));
    }

    private final int maxPosition() {
        int result = -1;
        for (Dimension elem : this.dimensions) {
            int n = elem.getPosition();
            boolean bl = false;
            result = Math.max(result, n);
        }
        return result + 1;
    }

    public final int getSize() {
        return this.size;
    }

    private final int init() {
        long result = 1L;
        int n = this.dimensions.getCount() - 1;
        if (0 <= n) {
            do {
                int i;
                this.dimensionMap[this.dimensions.get((int)i).getPosition()] = i = n--;
                this.assistArray[i] = (int)result;
                result *= (long)this.dimensions.get(i).getMembers().getCount();
            } while (0 <= n);
        }
        n = result >= 0L && result <= Integer.MAX_VALUE ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "\u8d85\u51fa\u8303\u56f4";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (int)result;
    }

    @NotNull
    public final FilterBitmapNode createMatchBitmap(@Nullable Filter filter) {
        FilterBitmapNode filterBitmapNode;
        Filter filter2 = filter;
        if (filter2 == null) {
            filterBitmapNode = new PartitionFilterBitmapNode(AbstractMatchBitmap.FullBitmap.INSTANCE);
        } else if (filter2 instanceof DimensionFilter) {
            int index2 = this.getDimensionIndex(((DimensionFilter)filter).getDimension());
            if (index2 == -1) {
                filterBitmapNode = new DimensionFilterBitmapNode(AbstractMatchBitmap.FullBitmap.INSTANCE, (DimensionFilter)filter);
            } else {
                AbstractMatchBitmap abstractMatchBitmap;
                if (((DimensionFilter)filter).getMembers().isEmpty()) {
                    abstractMatchBitmap = AbstractMatchBitmap.EmptyBitmap.INSTANCE;
                } else {
                    BitSet bitMap = new BitSet(this.size);
                    this.setBitmap(index2, (DimensionFilter)filter, bitMap);
                    abstractMatchBitmap = AbstractMatchBitmap.Companion.create(bitMap);
                }
                filterBitmapNode = new PartitionFilterBitmapNode(abstractMatchBitmap);
            }
        } else if (filter2 instanceof AndFilter) {
            AbstractMatchBitmap result = AbstractMatchBitmap.FullBitmap.INSTANCE;
            ArrayList<FilterBitmapNode> nodes = new ArrayList<FilterBitmapNode>(((AndFilter)filter).getSize());
            Iterator<Filter> iterator = ((AndFilter)filter).getChildren();
            boolean bl = false;
            Object object = iterator;
            while (object.hasNext()) {
                Filter child = object.next();
                FilterBitmapNode node = this.createMatchBitmap(child);
                nodes.add(node);
                result = result.and(node.getBitmap());
            }
            object = new AndFilterBitmapNode(result);
            boolean child = false;
            boolean node = false;
            Object it = object;
            boolean bl2 = false;
            ((FilterBitmapNode)it).getChildren().addAll((Collection<FilterBitmapNode>)nodes);
            filterBitmapNode = (FilterBitmapNode)object;
        } else if (filter2 instanceof OrFilter) {
            AbstractMatchBitmap result = ((OrFilter)filter).getHasChildren() ? (AbstractMatchBitmap)AbstractMatchBitmap.EmptyBitmap.INSTANCE : (AbstractMatchBitmap)AbstractMatchBitmap.FullBitmap.INSTANCE;
            ArrayList<FilterBitmapNode> nodes = new ArrayList<FilterBitmapNode>(((OrFilter)filter).getSize());
            Object child = ((OrFilter)filter).getChildren();
            boolean node = false;
            Object object = child;
            while (object.hasNext()) {
                child = object.next();
                FilterBitmapNode node2 = this.createMatchBitmap((Filter)child);
                nodes.add(node2);
                result = result.or(node2.getBitmap());
            }
            object = new OrFilterBitmapNode(result);
            boolean bl = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            ((FilterBitmapNode)it).getChildren().addAll((Collection<FilterBitmapNode>)nodes);
            filterBitmapNode = (FilterBitmapNode)object;
        } else {
            throw new NotSupportedException(Intrinsics.stringPlus((String)"\u9519\u8bef\u7684\u6761\u4ef6:", (Object)filter));
        }
        return filterBitmapNode;
    }

    private final int getDimensionIndex(Dimension dimension) {
        if (dimension.getPosition() >= this.dimensionMap.length) {
            return -1;
        }
        return this.dimensionMap[dimension.getPosition()];
    }

    private final void setBitmap(int index2, DimensionFilter filter, BitSet bitMap) {
        int n;
        int n2 = 0;
        int n3 = this.dimensions.getCount();
        if (n2 < n3) {
            do {
                int i;
                if ((i = n2++) == index2) continue;
                this.positionBuilder.setRangeValue(i, 0, this.dimensions.get(i).getMembers().getCount() - 1);
            } while (n2 < n3);
        }
        if (!filter.getMembers().isEmpty()) {
            if (filter.getMembers().size() == 1) {
                this.positionBuilder.setFixedValue(index2, ((Member)CollectionsKt.first((Iterable)filter.getMembers())).getPosition$bos_olap_core());
            } else {
                int[] value2 = new int[filter.getMembers().size()];
                Iterator<Member> iterator = filter.getMembers().iterator();
                n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Member item = iterator.next();
                    value2[i] = item.getPosition$bos_olap_core();
                }
                this.positionBuilder.setArrayValue(index2, value2);
            }
        }
        IIterator positionItr = this.positionBuilder.build();
        int position = 0;
        while (positionItr.next()) {
            position = 0;
            n = 0;
            int n4 = this.dimensions.getCount();
            if (n < n4) {
                do {
                    int i = n++;
                    position += this.positionArray[i] * this.assistArray[i];
                } while (n < n4);
            }
            bitMap.set(position);
        }
    }

    public final void setKey(int position, @NotNull int[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int temp = position;
        int n = this.dimensions.getCount() - 1;
        if (0 <= n) {
            do {
                int i = n--;
                key[this.dimensions.get((int)i).getPosition()] = temp / this.assistArray[i];
                temp -= key[this.dimensions.get(i).getPosition()] * this.assistArray[i];
            } while (0 <= n);
        }
    }
}

