/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query.match;

import java.util.BitSet;
import kd.bos.olapServer.collections.objectModel.IImmutableCollection;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.computingEngine.batchTasks.SimpleRowKey;
import kd.bos.olapServer.metadata.Cube;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.query.match.AbstractMatchBitmap;
import kd.bos.olapServer.query.match.AndFilterBitmapNode;
import kd.bos.olapServer.query.match.DimensionFilterBitmapNode;
import kd.bos.olapServer.query.match.FilterBitmapNode;
import kd.bos.olapServer.query.match.MatchBitmapFactory;
import kd.bos.olapServer.query.match.MatchModelOptimizer;
import kd.bos.olapServer.query.match.OrFilterBitmapNode;
import kd.bos.olapServer.query.match.PartitionFilterBitmapNode;
import kd.bos.olapServer.query.models.AndFilter;
import kd.bos.olapServer.query.models.ContainerFilter;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.EmptyFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.query.models.FullFilter;
import kd.bos.olapServer.query.models.OrFilter;
import kd.bos.olapServer.storages.PartitionCubeWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00032\n\u0010\u001e\u001a\u00060\fj\u0002`\u001fH\u0002J\u001c\u0010\u001d\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\fj\u0002`\u001fH\u0002J\n\u0010!\u001a\u00060\"j\u0002`#R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u0006$"}, d2={"Lkd/bos/olapServer/query/match/MatchCubeWorkspaceIterator;", "", "filter", "Lkd/bos/olapServer/query/models/Filter;", "cube", "Lkd/bos/olapServer/metadata/Cube;", "subCubeWorkspaces", "", "Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "(Lkd/bos/olapServer/query/models/Filter;Lkd/bos/olapServer/metadata/Cube;[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;)V", "_cubeWorkspace", "_currentBitmapIndex", "", "_currentFilter", "curFilter", "getCurFilter", "()Lkd/bos/olapServer/query/models/Filter;", "curWorkspace", "getCurWorkspace", "()Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "factory", "Lkd/bos/olapServer/query/match/MatchBitmapFactory;", "key", "Lkd/bos/olapServer/computingEngine/batchTasks/SimpleRowKey;", "masterTree", "Lkd/bos/olapServer/query/match/FilterBitmapNode;", "returnFlg", "Ljava/util/BitSet;", "[Lkd/bos/olapServer/storages/PartitionCubeWorkspace;", "createFilter", "position", "Lkd/bos/olapServer/common/int;", "node", "next", "", "Lkd/bos/olapServer/common/bool;", "bos-olap-core"})
public final class MatchCubeWorkspaceIterator {
    @NotNull
    private final Cube cube;
    @NotNull
    private final PartitionCubeWorkspace[] subCubeWorkspaces;
    @Nullable
    private PartitionCubeWorkspace _cubeWorkspace;
    @NotNull
    private final SimpleRowKey key;
    @NotNull
    private final FilterBitmapNode masterTree;
    @NotNull
    private final MatchBitmapFactory factory;
    @Nullable
    private Filter _currentFilter;
    private int _currentBitmapIndex;
    @NotNull
    private final BitSet returnFlg;

    public MatchCubeWorkspaceIterator(@Nullable Filter filter, @NotNull Cube cube, @NotNull PartitionCubeWorkspace[] subCubeWorkspaces) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)subCubeWorkspaces, (String)"subCubeWorkspaces");
        this.cube = cube;
        this.subCubeWorkspaces = subCubeWorkspaces;
        this.key = new SimpleRowKey(this.cube, null, 2, null);
        IImmutableCollection<Dimension> partitionDimensions = this.cube.getPartition().getPartitionDimensions();
        this.factory = new MatchBitmapFactory(partitionDimensions);
        this.masterTree = this.factory.createMatchBitmap(filter);
        this._currentBitmapIndex = -1;
        this.returnFlg = new BitSet(this.subCubeWorkspaces.length);
    }

    @NotNull
    public final PartitionCubeWorkspace getCurWorkspace() {
        PartitionCubeWorkspace partitionCubeWorkspace = this._cubeWorkspace;
        Intrinsics.checkNotNull((Object)partitionCubeWorkspace);
        return partitionCubeWorkspace;
    }

    @Nullable
    public final Filter getCurFilter() {
        return this._currentFilter;
    }

    private final Filter createFilter(int position) {
        Filter filter = this.createFilter(this.masterTree, position);
        return new MatchModelOptimizer(filter).optimize();
    }

    private final Filter createFilter(FilterBitmapNode node, int position) {
        Filter filter;
        FilterBitmapNode filterBitmapNode = node;
        if (filterBitmapNode instanceof DimensionFilterBitmapNode) {
            DimensionFilter dimensionFilter = new DimensionFilter(((DimensionFilterBitmapNode)node).getFilter().getDimension());
            boolean bl = false;
            boolean bl2 = false;
            DimensionFilter $this$createFilter_u24lambda_u2d0 = dimensionFilter;
            boolean bl3 = false;
            $this$createFilter_u24lambda_u2d0.getMembers().addAll(((DimensionFilterBitmapNode)node).getFilter().getMembers());
            filter = dimensionFilter;
        } else if (filterBitmapNode instanceof PartitionFilterBitmapNode) {
            filter = node.getBitmap().isMark(this._currentBitmapIndex) ? (Filter)new FullFilter() : (Filter)new EmptyFilter();
        } else if (node.getBitmap().isMark(this._currentBitmapIndex)) {
            ContainerFilter containerFilter;
            FilterBitmapNode filterBitmapNode2 = node;
            if (filterBitmapNode2 instanceof AndFilterBitmapNode) {
                containerFilter = new AndFilter();
            } else if (filterBitmapNode2 instanceof OrFilterBitmapNode) {
                containerFilter = new OrFilter();
            } else {
                throw new NotSupportedException();
            }
            ContainerFilter cur = containerFilter;
            for (FilterBitmapNode child : node.getChildren()) {
                cur.add(this.createFilter(child, position));
            }
            filter = cur;
        } else {
            filter = new EmptyFilter();
        }
        return filter;
    }

    public final boolean next() {
        AbstractMatchBitmap matchResult = this.masterTree.getBitmap();
        this._currentBitmapIndex = matchResult.nextSetBit(this._currentBitmapIndex + 1);
        while (this._currentBitmapIndex >= 0 && this._currentBitmapIndex < this.factory.getSize()) {
            this.factory.setKey(this._currentBitmapIndex, this.key.getArray());
            int position = this.cube.getPartition().getPartitionPosition(this.key);
            if (!this.returnFlg.get(position)) {
                this.returnFlg.set(position);
                Filter newFilter = this.createFilter(this._currentBitmapIndex);
                if (!(newFilter instanceof EmptyFilter)) {
                    this._currentFilter = newFilter instanceof FullFilter ? null : newFilter;
                    this._cubeWorkspace = this.subCubeWorkspaces[position];
                    return true;
                }
            }
            this._currentBitmapIndex = matchResult.nextSetBit(this._currentBitmapIndex + 1);
        }
        return false;
    }
}

