/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.query.models;

import java.util.Collection;
import java.util.Iterator;
import kd.bos.olapServer.collections.ICloneable;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.metadata.Dimension;
import kd.bos.olapServer.metadata.Member;
import kd.bos.olapServer.query.models.BitSetFilterMemberCollection;
import kd.bos.olapServer.query.models.DimensionFilter;
import kd.bos.olapServer.query.models.Filter;
import kd.bos.olapServer.query.models.RoaringBitmapFilterMemberCollection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB)\b\u0002\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0014\u0010\u0017\u001a\u00020\u00002\n\u0010\u0018\u001a\u00060\rj\u0002`\u000eH\u0002J\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0016J\u0014\u0010\u001e\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u0004\u0018\u00010\bJ\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%\u00a2\u0006\u0002\u0010&R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\rj\u0002`\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lkd/bos/olapServer/query/models/DimensionFilter;", "Lkd/bos/olapServer/query/models/Filter;", "Lkd/bos/olapServer/collections/ICloneable;", "dimension", "Lkd/bos/olapServer/metadata/Dimension;", "(Lkd/bos/olapServer/metadata/Dimension;)V", "members", "", "Lkd/bos/olapServer/metadata/Member;", "(Lkd/bos/olapServer/metadata/Dimension;Ljava/util/Collection;)V", "Dimension", "Members", "isFrozen", "", "Lkd/bos/olapServer/common/bool;", "(Lkd/bos/olapServer/metadata/Dimension;Ljava/util/Collection;Z)V", "getDimension", "()Lkd/bos/olapServer/metadata/Dimension;", "HasChildren", "getHasChildren", "()Z", "getMembers", "()Ljava/util/Collection;", "clone", "newFilterIsFrozen", "cloneWithoutFrozen", "freeze", "", "getChildren", "", "match", "key", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "onlyOneMember", "toString", "", "toTypedArray", "", "()[Lkd/bos/olapServer/metadata/Member;", "bos-olap-core"})
public final class DimensionFilter
extends Filter
implements ICloneable<DimensionFilter> {
    @NotNull
    private final Dimension Dimension;
    @NotNull
    private final Collection<Member> Members;

    private DimensionFilter(Dimension Dimension2, Collection<Member> Members, boolean isFrozen) {
        super(isFrozen);
        this.Dimension = Dimension2;
        this.Members = Members;
    }

    @NotNull
    public final Dimension getDimension() {
        return this.Dimension;
    }

    @NotNull
    public final Collection<Member> getMembers() {
        return this.Members;
    }

    public DimensionFilter(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this(dimension, (Collection)(dimension.getMembers().getCount() < 4096 ? new BitSetFilterMemberCollection(dimension.getMembers()) : new RoaringBitmapFilterMemberCollection(dimension.getMembers())), false);
    }

    public DimensionFilter(@NotNull Dimension dimension, @NotNull Collection<Member> members2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter(members2, (String)"members");
        this(dimension, members2, true);
    }

    @Override
    public boolean getHasChildren() {
        return false;
    }

    @Override
    @NotNull
    public Iterator<Filter> getChildren() {
        throw new NotSupportedException();
    }

    @Override
    public void freeze() {
        super.freeze();
        Collection<Member> collection = this.Members;
        if (collection instanceof BitSetFilterMemberCollection) {
            ((BitSetFilterMemberCollection)this.Members).freeze();
        } else if (collection instanceof RoaringBitmapFilterMemberCollection) {
            ((RoaringBitmapFilterMemberCollection)this.Members).freeze();
        } else {
            throw new NotSupportedException();
        }
    }

    @Override
    @NotNull
    public DimensionFilter clone() {
        return this.clone(this.isFrozen());
    }

    @NotNull
    public final DimensionFilter cloneWithoutFrozen() {
        return this.clone(false);
    }

    private final DimensionFilter clone(boolean newFilterIsFrozen) {
        DimensionFilter dimensionFilter;
        if (newFilterIsFrozen) {
            boolean bl = this.isFrozen();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            dimensionFilter = new DimensionFilter(this.Dimension, this.Members, true);
        } else {
            Collection collection;
            Collection<Member> collection2 = this.Members;
            if (collection2 instanceof BitSetFilterMemberCollection) {
                collection = ((BitSetFilterMemberCollection)this.Members).cloneWithoutFrozen();
            } else if (collection2 instanceof RoaringBitmapFilterMemberCollection) {
                collection = ((RoaringBitmapFilterMemberCollection)this.Members).cloneWithoutFrozen();
            } else {
                throw new NotSupportedException();
            }
            Collection newMembers = collection;
            dimensionFilter = new DimensionFilter(this.Dimension, newMembers, false);
        }
        return dimensionFilter;
    }

    @NotNull
    public String toString() {
        String memberNames2 = ArraysKt.joinToString$default((Object[])this.toTypedArray(), null, null, null, (int)0, null, (Function1)toString.memberNames.1.INSTANCE, (int)31, null);
        return this.Dimension.getName() + " in [" + memberNames2 + ']';
    }

    @NotNull
    public final Member[] toTypedArray() {
        Collection<Member> $this$toTypedArray$iv = this.Members;
        boolean $i$f$toTypedArray = false;
        Collection<Member> thisCollection$iv = $this$toTypedArray$iv;
        Member[] memberArray = thisCollection$iv.toArray(new Member[0]);
        if (memberArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return memberArray;
    }

    @Override
    public boolean match(@NotNull IDimensionKeys key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Member member = (Member)this.Dimension.getMembers().get(key.get(this.Dimension.getPosition()));
        return this.Members.contains(member);
    }

    @Nullable
    public final Member onlyOneMember() {
        Iterator<Member> itr = this.Members.iterator();
        if (itr.hasNext()) {
            Member first = itr.next();
            if (!itr.hasNext()) {
                return first;
            }
        }
        return null;
    }
}

