/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.replication.BackupType;
import kd.bos.olapServer.replication.BackupUtil;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u00060\u000bj\u0002`\f2\n\u0010\u0017\u001a\u00060\u000bj\u0002`\f2\n\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004J\u0012\u0010\u0019\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002\u00a2\u0006\u0002\u0010\"J1\u0010#\u001a\u0004\u0018\u00010\u001e2%\u0010$\u001a!\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\b\u0012\u00060\u0006j\u0002`\u00070%H\u0002J\u001e\u0010)\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040*2\f\b\u0002\u0010+\u001a\u00060 j\u0002`!J\u0012\u0010,\u001a\u00020-2\n\u0010.\u001a\u00060\u0003j\u0002`\u0004J\b\u0010/\u001a\u000200H\u0002J\n\u00101\u001a\u00060\u000bj\u0002`\fJ\n\u00102\u001a\u00060\u0003j\u0002`\u0004J*\u00103\u001a\u00020\u00142\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u00104\u001a\u00060\u000bj\u0002`\f2\n\u00105\u001a\u00060\u000bj\u0002`\fR.\u0010\t\u001a\"\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\b\u0012\u00060\u000bj\u0002`\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lkd/bos/olapServer/replication/BackupUtil;", "Ljava/lang/AutoCloseable;", "backupPath", "", "Lkd/bos/olapServer/common/string;", "mustExist", "", "Lkd/bos/olapServer/common/bool;", "(Ljava/lang/String;Z)V", "_lastRecord", "Lkotlin/Triple;", "", "Lkd/bos/olapServer/common/LSN;", "csvFormat", "Lorg/apache/commons/csv/CSVFormat;", "kotlin.jvm.PlatformType", "csvPrinter", "Lorg/apache/commons/csv/CSVPrinter;", "recordFile", "close", "", "copyRedo", "replayStart", "replayEnd", "destPath", "createBackupDir", "type", "Lkd/bos/olapServer/replication/BackupType;", "findLastCountRecord", "", "Lorg/apache/commons/csv/CSVRecord;", "count", "", "Lkd/bos/olapServer/common/int;", "(I)[Lorg/apache/commons/csv/CSVRecord;", "findLastRecord", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "record", "getBackupRecords", "", "lastCount", "getControlConfig", "Lkd/bos/olapServer/replication/ControlConfig;", "dir", "getCsvParse", "Lorg/apache/commons/csv/CSVParser;", "getLastPoint", "getLastTotalBackup", "writeBackupRecord", "start", "end", "bos-olap-core"})
public final class BackupUtil
implements AutoCloseable {
    @NotNull
    private final String backupPath;
    @NotNull
    private final String recordFile;
    private final CSVFormat csvFormat;
    @NotNull
    private final CSVPrinter csvPrinter;
    @Nullable
    private Triple<String, Long, Long> _lastRecord;

    public BackupUtil(@NotNull String backupPath, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        this.backupPath = backupPath;
        this.csvFormat = CSVFormat.DEFAULT.withDelimiter('\t');
        Object[] objectArray = new String[]{"backup.record"};
        File filepath = Paths.INSTANCE.get(this.backupPath, (String[])objectArray).toFile();
        if (!filepath.exists()) {
            if (mustExist) {
                objectArray = Res.INSTANCE.getBackupUtilExcetion_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.BackupUtilExcetion_1");
                Object object = objectArray;
                objectArray = new Object[]{filepath};
                throw Res.INSTANCE.getRuntimeException((String)object, objectArray);
            }
            filepath.createNewFile();
        }
        objectArray = filepath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"filepath.path");
        this.recordFile = objectArray;
        this.csvPrinter = new CSVPrinter((Appendable)new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.recordFile, true))), this.csvFormat);
        CSVRecord csvRecord2 = this.findLastRecord((Function1<? super CSVRecord, Boolean>)((Function1)csvRecord.1.INSTANCE));
        if (csvRecord2 != null) {
            boolean bl = csvRecord2.size() == 3;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = csvRecord2.get(0);
            String string2 = csvRecord2.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"csvRecord[1]");
            bl2 = false;
            Long l = Long.parseLong(string2);
            string2 = csvRecord2.get(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"csvRecord[2]");
            bl2 = false;
            this._lastRecord = new Triple((Object)string, (Object)l, (Object)Long.parseLong(string2));
        }
    }

    private final CSVParser getCsvParse() {
        File file = new File(this.recordFile);
        boolean bl = false;
        CSVParser cSVParser = this.csvFormat.parse((Reader)new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(file)), Charsets.UTF_8)));
        Intrinsics.checkNotNullExpressionValue((Object)cSVParser, (String)"csvFormat.parse(BufferedReader(InputStreamReader(BOMInputStream(File(recordFile).inputStream()), Charsets.UTF_8)))");
        return cSVParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CSVRecord findLastRecord(Function1<? super CSVRecord, Boolean> condition) {
        Closeable closeable = (Closeable)this.getCsvParse();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            CSVParser csvParser = (CSVParser)closeable;
            boolean bl3 = false;
            Iterator iterator = csvParser.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"csvParser.iterator()");
            Iterator itr = iterator;
            CSVRecord csvRecord2 = null;
            CSVRecord lastRecord = null;
            while (itr.hasNext()) {
                csvRecord2 = (CSVRecord)itr.next();
                if (!((Boolean)condition.invoke((Object)csvRecord2)).booleanValue()) continue;
                lastRecord = csvRecord2;
            }
            CSVRecord cSVRecord = lastRecord;
            return cSVRecord;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CSVRecord[] findLastCountRecord(int count) {
        boolean bl = count > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Closeable closeable = (Closeable)this.getCsvParse();
        bl2 = false;
        bl3 = false;
        Throwable throwable = null;
        try {
            CSVRecord[] cSVRecordArray;
            Object[] thisCollection$iv2;
            void $this$toTypedArray$iv;
            boolean $i$f$toTypedArray;
            CSVRecord cSVRecord;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv;
            CSVParser csvParser = (CSVParser)closeable;
            boolean bl6 = false;
            Iterator iterator = csvParser.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"csvParser.iterator()");
            Iterator itr = iterator;
            Object[] lastCountRecords = new Pair[count];
            int recordCount = 0;
            CSVRecord csvRecord2 = null;
            while (itr.hasNext()) {
                csvRecord2 = (CSVRecord)itr.next();
                lastCountRecords[recordCount % count] = new Pair((Object)recordCount, (Object)csvRecord2);
                int n = recordCount;
                recordCount = n + 1;
            }
            if (recordCount <= count) {
                $this$map$iv = (Object[])ArraysKt.toMutableList((Object[])lastCountRecords).subList(0, recordCount);
                $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    void v0 = it;
                    Intrinsics.checkNotNull((Object)v0);
                    cSVRecord = (CSVRecord)v0.getSecond();
                    collection.add(cSVRecord);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv2 = $this$toTypedArray$iv;
                CSVRecord[] cSVRecordArray2 = thisCollection$iv2.toArray(new CSVRecord[0]);
                if (cSVRecordArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                cSVRecordArray = cSVRecordArray2;
            } else {
                Object[] $this$sortBy$iv = lastCountRecords;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.length > 1) {
                    boolean thisCollection$iv2 = false;
                    ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Pair it = (Pair)a;
                            boolean bl2 = false;
                            Pair pair = it;
                            Intrinsics.checkNotNull((Object)pair);
                            it = (Pair)b;
                            Comparable comparable = (Integer)pair.getFirst();
                            bl2 = false;
                            Pair pair2 = it;
                            Intrinsics.checkNotNull((Object)pair2);
                            Integer n = (Integer)pair2.getFirst();
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                        }
                    });
                }
                $this$map$iv = lastCountRecords;
                $i$f$map = false;
                thisCollection$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
                $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv;
                int n = ((Iterator<T>)iterator2).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    Iterator item$iv$iv;
                    Iterator iterator3 = item$iv$iv = iterator2[i];
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    void v3 = it;
                    Intrinsics.checkNotNull((Object)v3);
                    cSVRecord = (CSVRecord)v3.getSecond();
                    collection.add(cSVRecord);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv2 = $this$toTypedArray$iv;
                CSVRecord[] cSVRecordArray3 = thisCollection$iv2.toArray(new CSVRecord[0]);
                if (cSVRecordArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                cSVRecordArray = cSVRecordArray3;
            }
            CSVRecord[] cSVRecordArray4 = cSVRecordArray;
            return cSVRecordArray4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String createBackupDir(@NotNull BackupType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String suffix = "-total";
        if (type == BackupType.Increment) {
            suffix = "-increment";
        }
        String dirName = Intrinsics.stringPlus((String)new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), (Object)suffix);
        String[] stringArray = new String[]{dirName};
        File newDir = Paths.INSTANCE.get(this.backupPath, stringArray).toFile();
        boolean bl = !newDir.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "\u5907\u4efd\u76ee\u5f55" + newDir + "\u5df2\u5b58\u5728";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        newDir.mkdir();
        String string = newDir.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newDir.toString()");
        return string;
    }

    public final void writeBackupRecord(@NotNull String backupPath, long start, long end) {
        Object[] objectArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        int index2 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)backupPath), (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
        if (index2 == -1) {
            object = backupPath;
        } else {
            objectArray = backupPath;
            int n = index2 + 1;
            boolean bl = false;
            String string = objectArray.substring(n);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
        }
        Object[] filename = object;
        objectArray = new Object[]{filename, start, end};
        this.csvPrinter.printRecord(objectArray);
        this.csvPrinter.flush();
        this._lastRecord = new Triple((Object)filename, (Object)start, (Object)end);
    }

    public final long getLastPoint() {
        Triple<String, Long, Long> triple = this._lastRecord;
        if (triple == null) {
            return 0L;
        }
        return ((Number)triple.getThird()).longValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBackupRecords(int lastCount) {
        void $this$mapTo$iv$iv;
        CSVRecord[] $this$map$iv = this.findLastCountRecord(lastCount);
        boolean $i$f$map = false;
        CSVRecord[] cSVRecordArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.get(0);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getBackupRecords$default(BackupUtil backupUtil, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return backupUtil.getBackupRecords(n);
    }

    @NotNull
    public final String getLastTotalBackup() {
        CSVRecord cSVRecord = this.findLastRecord((Function1<? super CSVRecord, Boolean>)((Function1)getLastTotalBackup.1.INSTANCE));
        if (cSVRecord == null) {
            return "";
        }
        String string = cSVRecord.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(findLastRecord { it[1] == it[2] } ?: return \"\")[0]");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyRedo(long replayStart, long replayEnd, @NotNull String destPath) {
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Closeable closeable = (Closeable)this.getCsvParse();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            CSVParser csvParser = (CSVParser)closeable;
            boolean bl3 = false;
            Iterator iterator = csvParser.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"csvParser.iterator()");
            Iterator recordItr = iterator;
            CSVRecord csvRecord2 = null;
            boolean notFoundFlag = true;
            while (recordItr.hasNext()) {
                csvRecord2 = (CSVRecord)recordItr.next();
                String string = csvRecord2.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"csvRecord[1]");
                boolean bl4 = false;
                long start = Long.parseLong(string);
                String string2 = csvRecord2.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"csvRecord[2]");
                boolean bl5 = false;
                long end = Long.parseLong(string2);
                boolean bl6 = start <= replayStart ? replayStart <= end - 1L : false;
                if (!bl6 && notFoundFlag) continue;
                notFoundFlag = false;
                if (Intrinsics.areEqual((Object)csvRecord2.get(1), (Object)csvRecord2.get(2))) {
                    string2 = Res.INSTANCE.getBackupUtilExcetion_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Res.BackupUtilExcetion_3");
                    throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
                }
                String string3 = csvRecord2.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"csvRecord[1]");
                boolean bl7 = false;
                long l = Long.parseLong(string3);
                boolean bl8 = false;
                long copyFirst = Math.max(l, replayStart);
                long firstFile = LSNUtil.INSTANCE.fileLSN(copyFirst);
                String string4 = csvRecord2.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"csvRecord[2]");
                boolean bl9 = false;
                long lastFile = LSNUtil.INSTANCE.fileLSN(Long.parseLong(string4));
                long cur = firstFile;
                while (cur <= lastFile) {
                    String curName = LSNUtil.INSTANCE.getFileName(cur);
                    Object[] objectArray = new String[2];
                    String[] stringArray = csvRecord2.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"csvRecord[0]");
                    objectArray[0] = stringArray;
                    objectArray[1] = curName;
                    Path source2 = Paths.INSTANCE.get(this.backupPath, (String[])objectArray);
                    if (!source2.toFile().exists()) {
                        objectArray = Res.INSTANCE.getBackupUtilExcetion_4();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.BackupUtilExcetion_4");
                        Object object = objectArray;
                        objectArray = new Object[]{source2};
                        throw Res.INSTANCE.getRuntimeException((String)object, objectArray);
                    }
                    cur = LSNUtil.INSTANCE.nextFileLSN(cur);
                    if (source2.toFile().length() < 0x1000000L) {
                        objectArray = csvRecord2.get(2);
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"csvRecord[2]");
                        boolean bl10 = false;
                        if (Long.parseLong((String)objectArray) != replayEnd) continue;
                    }
                    stringArray = new String[]{curName};
                    Path dest = Paths.INSTANCE.get(destPath, stringArray);
                    Files.copy(source2, dest, new CopyOption[0]);
                }
            }
            if (notFoundFlag) {
                String string = Res.INSTANCE.getBackupUtilExcetion_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.BackupUtilExcetion_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final ControlConfig getControlConfig(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.findLastRecord((Function1<? super CSVRecord, Boolean>)((Function1)new Function1<CSVRecord, Boolean>(dir){
            final /* synthetic */ String $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            public final boolean invoke(@NotNull CSVRecord it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.get(0), (Object)this.$dir);
            }
        }));
        if (object == null) {
            Object[] objectArray = Res.INSTANCE.getBackupUtilExcetion_5();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.BackupUtilExcetion_5");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{dir};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
        CSVRecord record2 = object;
        object = record2.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record[1]");
        boolean bl = false;
        long l = Long.parseLong((String)object);
        object = record2.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record[2]");
        bl = false;
        return new ControlConfig(l, Long.parseLong((String)object));
    }

    @Override
    public void close() {
        this.csvPrinter.close();
    }
}

