/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.nio.ByteBuffer;
import java.util.Arrays;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.ICubeRecoverRecord;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.RedoRecordHead;
import kd.bos.olapServer.replication.RedoType;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lkd/bos/olapServer/replication/CubeRecoverRecord;", "Lkd/bos/olapServer/replication/ICubeRecoverRecord;", "head", "Lkd/bos/olapServer/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer/replication/RedoRecordHead;", "redoType", "Lkd/bos/olapServer/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer/replication/RedoType;", "tid", "", "Lkd/bos/olapServer/common/long;", "getTid", "()J", "getMd5", "", "replayCubeRecover", "", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "toString", "", "bos-olap-core"})
public final class CubeRecoverRecord
implements ICubeRecoverRecord {
    @NotNull
    private final RedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public CubeRecoverRecord(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final RedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final byte[] getMd5() {
        boolean bl = this.head.getType() == RedoType.CubeRecover;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = this.body.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body.array()");
        return byArray;
    }

    @Override
    public void replayCubeRecover(@NotNull OlapWorkspace olap) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        CubeWorkspace cubeWorkspace = olap.tryGetByCubeId(this.getCubeId());
        if (cubeWorkspace == null) {
            Object[] this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                Object[] objectArray = Res.INSTANCE.getReplayCoordinatorException_2();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ReplayCoordinatorException_2");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.getCubeId()};
                String message$iv = Res.INSTANCE.format((String)objectArray2, objectArray);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p((OlapLogger)this_$iv).error(message$iv);
            }
            this_$iv = Res.INSTANCE.getReplayCoordinatorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"Res.ReplayCoordinatorException_2");
            Object[] objectArray = this_$iv;
            this_$iv = new Object[]{this.getCubeId()};
            throw Res.INSTANCE.getRuntimeException(Res.INSTANCE.format((String)objectArray, this_$iv), new Object[0]);
        }
        byte[] expectmMd5 = cubeWorkspace.getMd5();
        byte[] actualMd5 = this.getMd5();
        byte[] $i$f$error = expectmMd5;
        boolean message$iv = false;
        if (!Arrays.equals($i$f$error, actualMd5)) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error2 = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                Object[] objectArray = Res.INSTANCE.getReplayCoordinatorException_3();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ReplayCoordinatorException_3");
                Object[] objectArray3 = objectArray;
                objectArray = new Object[]{this.getCubeId(), cubeWorkspace.getMetadata().getName()};
                String message$iv2 = Res.INSTANCE.format((String)objectArray3, objectArray);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv2, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv2);
            }
            Object[] objectArray = Res.INSTANCE.getReplayCoordinatorException_3();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ReplayCoordinatorException_3");
            Object[] objectArray4 = objectArray;
            objectArray = new Object[]{this.getCubeId(), cubeWorkspace.getMetadata().getName()};
            throw Res.INSTANCE.getRuntimeException(Res.INSTANCE.format((String)objectArray4, objectArray), new Object[0]);
        }
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", cubeRecover\n";
    }
}

