/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.nio.ByteBuffer;
import java.util.Arrays;
import kd.bos.olapServer.dataSources.MetadataCommandInfo;
import kd.bos.olapServer.metadata.MetadataCommandExecutor;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.IDDLRecord;
import kd.bos.olapServer.replication.IRedoRecord;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.RedoRecordHead;
import kd.bos.olapServer.replication.RedoType;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.JsonHelper;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\f\u0010!\u001a\u00060\u001fj\u0002` H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lkd/bos/olapServer/replication/DDLRecord;", "Lkd/bos/olapServer/replication/IDDLRecord;", "head", "Lkd/bos/olapServer/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer/replication/RedoRecordHead;", "redoType", "Lkd/bos/olapServer/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer/replication/RedoType;", "tid", "", "Lkd/bos/olapServer/common/long;", "getTid", "()J", "consolidate", "record", "Lkd/bos/olapServer/replication/IRedoRecord;", "getDDLCommand", "", "isEofCommand", "", "Lkd/bos/olapServer/common/bool;", "isEofDDL", "replayCubeDDL", "", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "cube", "Lkd/bos/olapServer/storages/CubeWorkspace;", "replayDDL", "replayOlapDDL", "toString", "bos-olap-core"})
public final class DDLRecord
implements IDDLRecord {
    @NotNull
    private final RedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public DDLRecord(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final RedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final boolean isEofCommand() {
        boolean bl = this.head.getType() == RedoType.METADATA;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.body.limit() >= this.head.getLength() && this.body.get(this.head.getLength() - 1) == 0;
    }

    @Override
    @NotNull
    public String getDDLCommand() {
        String string;
        boolean bl = this.head.getType() == RedoType.METADATA && this.body.capacity() >= this.head.getLength();
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "\u89e3\u6790DDL\u547d\u4ee4\u5931\u8d25," + (Object)((Object)this.getHead().getType()) + ':' + this.getHead().getLength() + ',' + this.getBody().capacity();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.isEofCommand()) {
            byte[] byArray = this.body.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body.array()");
            n = this.head.getLength() - 1;
            bl2 = false;
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            byArray = byArray2;
            n = 0;
            return new String(byArray, Charsets.UTF_8);
        }
        if (this.body.capacity() == this.head.getLength()) {
            byte[] byArray = this.body.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body.array()");
            n = 0;
            string = new String(byArray, Charsets.UTF_8);
        } else {
            byte[] byArray = this.body.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body.array()");
            n = this.head.getLength();
            bl2 = false;
            byte[] byArray3 = Arrays.copyOf(byArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
            byArray = byArray3;
            n = 0;
            string = new String(byArray, Charsets.UTF_8);
        }
        return string;
    }

    private final void replayOlapDDL(OlapWorkspace olap) {
        String cmd = this.getDDLCommand();
        try {
            Object object = JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JsonHelper.mapper.readValue(cmd, MetadataCommandInfo::class.java)");
            MetadataCommandInfo command = (MetadataCommandInfo)object;
            new MetadataCommandExecutor(command, olap, null).run();
        }
        catch (Exception e) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = Intrinsics.stringPlus((String)"olap \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: ", (Object)cmd);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                }
            }
            throw e;
        }
    }

    private final void replayCubeDDL(OlapWorkspace olap, CubeWorkspace cube) {
        String cmd = this.getDDLCommand();
        try {
            MetadataCommandInfo command = (MetadataCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(cmd, MetadataCommandInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)command, (String)"command");
            new MetadataCommandExecutor(command, olap, cube).run();
        }
        catch (Exception e) {
            e.printStackTrace();
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "cube: " + cube.getMetadata().getName() + '(' + cube.getCubeId() + "): \u91cd\u505aDDL redo\u65e5\u5fd7\u51fa\u9519, \u547d\u4ee4\u4e3a: " + cmd;
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                }
            }
            throw e;
        }
    }

    @Override
    public void replayDDL(@NotNull OlapWorkspace olap) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        if (this.getCubeId() == 0) {
            this.replayOlapDDL(olap);
            return;
        }
        CubeWorkspace cubeWorkspace = olap.getCubeWorkspaceByCubeId(this.getCubeId());
        this.replayCubeDDL(olap, cubeWorkspace);
    }

    @Override
    public boolean isEofDDL() {
        return this.isEofCommand();
    }

    @Override
    @NotNull
    public IDDLRecord consolidate(@NotNull IRedoRecord record2) {
        Intrinsics.checkNotNullParameter((Object)record2, (String)"record");
        boolean bl = record2 instanceof DDLRecord;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DDLRecord prevRecord = (DDLRecord)record2;
        ByteBuffer conBody = ByteBuffer.allocate(prevRecord.body.capacity() + this.body.capacity());
        prevRecord.body.clear();
        conBody.put(prevRecord.body);
        conBody.put(this.body);
        RedoRecordHead ddlRecordHead = new RedoRecordHead(RedoType.METADATA, conBody.capacity(), ((DDLRecord)record2).head.getCubeId(), ((DDLRecord)record2).head.getTid());
        Intrinsics.checkNotNullExpressionValue((Object)conBody, (String)"conBody");
        return new DDLRecord(ddlRecordHead, conBody);
    }

    @NotNull
    public String toString() {
        return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", " + this.getDDLCommand() + '\n';
    }
}

