/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.nio.ByteBuffer;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.dataEntities.InputRow;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.Encoding;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.IDMLRecord;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.RedoRecordHead;
import kd.bos.olapServer.replication.RedoRecordMeasureHead;
import kd.bos.olapServer.replication.RedoType;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.CubeWorkspace;
import kd.bos.olapServer.storages.IInputRowWriter;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00060\nj\u0002`\u000bH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010\"\u001a\u00060\nj\u0002`\u000bH\u0002J \u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lkd/bos/olapServer/replication/DMLRecord;", "Lkd/bos/olapServer/replication/IDMLRecord;", "head", "Lkd/bos/olapServer/replication/RedoRecordHead;", "body", "Ljava/nio/ByteBuffer;", "(Lkd/bos/olapServer/replication/RedoRecordHead;Ljava/nio/ByteBuffer;)V", "getBody", "()Ljava/nio/ByteBuffer;", "cubeId", "", "Lkd/bos/olapServer/common/int;", "getCubeId", "()I", "getHead", "()Lkd/bos/olapServer/replication/RedoRecordHead;", "redoType", "Lkd/bos/olapServer/replication/RedoType;", "getRedoType", "()Lkd/bos/olapServer/replication/RedoType;", "tid", "", "Lkd/bos/olapServer/common/long;", "getTid", "()J", "dmlRecordToString", "", "Lkd/bos/olapServer/common/string;", "getMeasures", "", "row", "Lkd/bos/olapServer/dataEntities/InputRow;", "getPartitionId", "getRow", "getRowIndex", "replayDML", "cube", "Lkd/bos/olapServer/storages/CubeWorkspace;", "writer", "Lkd/bos/olapServer/storages/IInputRowWriter;", "toString", "bos-olap-core"})
public final class DMLRecord
implements IDMLRecord {
    @NotNull
    private final RedoRecordHead head;
    @NotNull
    private final ByteBuffer body;

    public DMLRecord(@NotNull RedoRecordHead head, @NotNull ByteBuffer body) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.head = head;
        this.body = body;
    }

    @NotNull
    public final RedoRecordHead getHead() {
        return this.head;
    }

    @NotNull
    public final ByteBuffer getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public RedoType getRedoType() {
        return this.head.getType();
    }

    @Override
    public int getCubeId() {
        return this.head.getCubeId();
    }

    @Override
    public long getTid() {
        return this.head.getTid();
    }

    private final int getPartitionId() {
        boolean bl = this.head.getType() == RedoType.INSERT || this.head.getType() == RedoType.UPDATE;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.body.getInt(0);
    }

    private final int getRowIndex() {
        boolean bl = this.head.getType() == RedoType.UPDATE;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.body.getInt(4);
    }

    @Override
    public void getMeasures(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        boolean bl = this.head.getType() == RedoType.UPDATE;
        boolean bl2 = false;
        int n = 0;
        n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int pos = 8;
        this.body.position(pos);
        Encoding decoder = new Encoding();
        n = 0;
        n2 = row.getValues().getCount();
        if (n < n2) {
            do {
                int i = n++;
                if (pos >= this.head.getLength()) {
                    row.setMeasureValue(i, CommonTypesKt.getUndefined());
                    continue;
                }
                RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.body.getShort());
                if (measureHead.getIndex() != i) {
                    row.setMeasureValue(i, CommonTypesKt.getUndefined());
                    this.body.position(pos);
                    continue;
                }
                pos = pos + 2 + measureHead.getLength();
                if (measureHead.getDecodeType()) {
                    int intValue = this.body.getInt();
                    if (intValue == 0) {
                        row.setMeasureValue(measureHead.getIndex(), null);
                        continue;
                    }
                    row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                    continue;
                }
                byte[] byteArray = new byte[measureHead.getLength()];
                this.body.get(byteArray, 0, measureHead.getLength());
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
            } while (n < n2);
        }
        n = pos == this.head.getLength() ? 1 : 0;
        n2 = 0;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (n == 0) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void getRow(@NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        int n = this.head.getType() == RedoType.INSERT ? 1 : 0;
        int n2 = 0;
        int n3 = 0;
        n3 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.body.position(4);
        n = 0;
        n2 = row.getKeys().getCount();
        if (n < n2) {
            do {
                int i = n++;
                row.setDimensionValue(i, this.body.getInt());
            } while (n < n2);
        }
        Encoding decoder = new Encoding();
        n2 = 0;
        n3 = row.getValues().getCount();
        if (n2 < n3) {
            do {
                int i = n2++;
                RedoRecordMeasureHead measureHead = new RedoRecordMeasureHead(this.body.getShort());
                if (measureHead.getDecodeType()) {
                    int intValue = this.body.getInt();
                    if (intValue == 0) {
                        row.setMeasureValue(measureHead.getIndex(), null);
                        continue;
                    }
                    row.setMeasureValue(measureHead.getIndex(), decoder.decode(intValue & Integer.MAX_VALUE));
                    continue;
                }
                byte[] byteArray = new byte[measureHead.getLength()];
                this.body.get(byteArray, 0, measureHead.getLength());
                row.setMeasureValue(measureHead.getIndex(), decoder.decode(byteArray, measureHead.getLength()));
            } while (n2 < n3);
        }
    }

    @Override
    public void replayDML(@NotNull CubeWorkspace cube, @NotNull IInputRowWriter writer, @NotNull InputRow row) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        try {
            RedoType redoType = this.getRedoType();
            int n = WhenMappings.$EnumSwitchMapping$0[redoType.ordinal()];
            switch (n) {
                case 1: {
                    this.getRow(row);
                    writer.add(this.getPartitionId(), row.getKeys(), row.getValues());
                    break;
                }
                case 2: {
                    this.getMeasures(row);
                    writer.update(this.getPartitionId(), this.getRowIndex(), row.getValues());
                }
            }
        }
        catch (Exception e) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "cube: " + cube.getMetadata().getName() + '(' + cube.getCubeId() + "): \u91cd\u505aDML redo\u65e5\u5fd7\u51fa\u9519, row: " + row;
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                }
            }
            throw e;
        }
    }

    private final String dmlRecordToString() {
        RedoType redoType = this.getRedoType();
        int n = WhenMappings.$EnumSwitchMapping$0[redoType.ordinal()];
        switch (n) {
            case 1: {
                return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", insert\n";
            }
            case 2: {
                return "cubeID: " + this.head.getCubeId() + ", tid: " + this.head.getTid() + ", update, partitionID: " + this.getPartitionId() + ", rowIndex: " + this.getRowIndex() + '\n';
            }
        }
        throw new NotSupportedException(Intrinsics.stringPlus((String)"Don't support such type: ", (Object)this.head.getType().name()));
    }

    @NotNull
    public String toString() {
        return this.dmlRecordToString();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedoType.values().length];
            nArray[RedoType.INSERT.ordinal()] = 1;
            nArray[RedoType.UPDATE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

