/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kd.bos.olapServer.common.CommonTypesKt;
import kd.bos.olapServer.dataEntities.IDimensionKeys;
import kd.bos.olapServer.dataEntities.IMeasureValues;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.EncodeContext;
import kd.bos.olapServer.memoryMappedFiles.dynamicData.Encoding;
import kd.bos.olapServer.replication.IReplicationMaster;
import kd.bos.olapServer.replication.RedoType;
import kd.bos.olapServer.transactions.TransactionStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\rj\u0002`\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0011\u001a\u00060\rj\u0002`\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dJ>\u0010\u001e\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0011\u001a\u00060\rj\u0002`\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u001f\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J*\u0010$\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0011\u001a\u00060\rj\u0002`\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010%\u001a\u00020&JB\u0010'\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0011\u001a\u00060\rj\u0002`\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u001f\u001a\u00060\u0014j\u0002`\u00152\n\u0010(\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\"\u001a\u00020#J\n\u0010)\u001a\u00060\rj\u0002`\u000eJ\u0006\u0010*\u001a\u00020\u0010J\f\u0010+\u001a\u00060\u0019j\u0002`\u001aH\u0002J\u0018\u0010,\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010-\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\n\u0010\u001f\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010.\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002JH\u0010/\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\n\u00100\u001a\u00060\u0014j\u0002`\u00152\u0006\u00101\u001a\u0002022\n\u00103\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0011\u001a\u00060\rj\u0002`\u0012H\u0002J<\u0010/\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\u0006\u00101\u001a\u0002022\n\u00103\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0011\u001a\u00060\rj\u0002`\u0012H\u0002J4\u00104\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\n\u00105\u001a\u00060\u0019j\u0002`\u001a2\n\u0010(\u001a\u00060\u0014j\u0002`\u00152\n\u00103\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0018\u00106\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J0\u00107\u001a\u00060\u0014j\u0002`\u0015*\u00020\u00062\n\u0010\u001f\u001a\u00060\u0014j\u0002`\u00152\n\u0010(\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\"\u001a\u00020#H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lkd/bos/olapServer/replication/LocalRedo;", "", "master", "Lkd/bos/olapServer/replication/IReplicationMaster;", "(Lkd/bos/olapServer/replication/IReplicationMaster;)V", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "encodeContext", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/EncodeContext;", "encoder", "Lkd/bos/olapServer/memoryMappedFiles/dynamicData/Encoding;", "lastMergePageLSN", "", "Lkd/bos/olapServer/common/LSN;", "addCubeRecoverRecord", "", "tid", "Lkd/bos/olapServer/common/long;", "cubeId", "", "Lkd/bos/olapServer/common/int;", "md5", "", "addDDLRecord", "", "Lkd/bos/olapServer/common/bool;", "command", "", "Lkd/bos/olapServer/common/string;", "addInsertRecord", "partitionId", "key", "Lkd/bos/olapServer/dataEntities/IDimensionKeys;", "value", "Lkd/bos/olapServer/dataEntities/IMeasureValues;", "addTranStatusRecord", "staus", "Lkd/bos/olapServer/transactions/TransactionStatus;", "addUpdateRecord", "index", "flushSyncSlaves", "forceMerge", "tryMerge", "writeInsertMeasure", "writeInsertRecordContent", "writeKey", "writeRecordHead", "position", "redoType", "Lkd/bos/olapServer/replication/RedoType;", "length", "writeRecordMeasureHead", "decodeType", "writeUpdateMeasure", "writeUpdateRecordContent", "Companion", "bos-olap-core"})
public final class LocalRedo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IReplicationMaster master;
    private final ByteBuffer buffer;
    private long lastMergePageLSN;
    @NotNull
    private final Encoding encoder;
    @NotNull
    private final EncodeContext encodeContext;
    private static final int maxRecordLen = 4096;

    public LocalRedo(@NotNull IReplicationMaster master) {
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.master = master;
        this.buffer = ByteBuffer.allocate(8170);
        this.lastMergePageLSN = -1L;
        this.encoder = new Encoding();
        this.encodeContext = new EncodeContext();
    }

    private final int writeRecordHead(ByteBuffer $this$writeRecordHead, int position, RedoType redoType, int length, int cubeId, long tid) {
        boolean bl = 0 <= length ? length < 16384 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$writeRecordHead.putShort(position, (short)(redoType.getCode() << 13 | length));
        $this$writeRecordHead.putInt(position + 2, cubeId);
        $this$writeRecordHead.putLong(position + 6, tid);
        return 14;
    }

    private final int writeRecordHead(ByteBuffer $this$writeRecordHead, RedoType redoType, int length, int cubeId, long tid) {
        boolean bl = 0 <= length ? length < 16384 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$writeRecordHead.putShort((short)(redoType.getCode() << 13 | length));
        $this$writeRecordHead.putInt(cubeId);
        $this$writeRecordHead.putLong(tid);
        return 14;
    }

    private final int writeKey(ByteBuffer $this$writeKey, IDimensionKeys key) {
        int n = 0;
        int n2 = key.getCount();
        if (n < n2) {
            do {
                int i = n++;
                $this$writeKey.putInt(key.get(i));
            } while (n < n2);
        }
        return key.getCount() * 4;
    }

    /*
     * Unable to fully structure code
     */
    private final int writeRecordMeasureHead(ByteBuffer $this$writeRecordMeasureHead, boolean decodeType, int index, int length) {
        v0 = 0 <= index ? index <= 15 : false;
        if (!v0) ** GOTO lbl-1000
        v1 = 0 <= length ? length < 4096 : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        var5_5 = v2;
        var6_6 = false;
        var7_7 = false;
        var7_7 = false;
        var8_8 = false;
        if (!var5_5) {
            var9_10 = false;
            var8_9 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(var8_9.toString());
        }
        head = (short)(decodeType != false ? index << 11 | length | 32768 : index << 11 | length);
        $this$writeRecordMeasureHead.putShort(head);
        return 2;
    }

    private final int writeInsertMeasure(ByteBuffer $this$writeInsertMeasure, IMeasureValues value2) {
        int result = 0;
        int n = 0;
        int n2 = value2.getCount();
        if (n < n2) {
            do {
                int i;
                int intValue = value2.get(i = n++) == CommonTypesKt.getUndefined() || value2.get(i) == null ? 0 : this.encoder.encode(value2.get(i), this.encodeContext);
                int length = intValue < 0 ? this.encodeContext.getLen() : 4;
                result += this.writeRecordMeasureHead($this$writeInsertMeasure, intValue >= 0, i, length);
                if (intValue < 0) {
                    $this$writeInsertMeasure.put(this.encodeContext.getCurrent(), 0, length);
                } else if (value2.get(i) == CommonTypesKt.getUndefined() || value2.get(i) == null) {
                    $this$writeInsertMeasure.putInt(0);
                } else {
                    $this$writeInsertMeasure.putInt(CommonTypesKt.setTrue(intValue, 31));
                }
                result += length;
            } while (n < n2);
        }
        return result;
    }

    private final int writeUpdateMeasure(ByteBuffer $this$writeUpdateMeasure, IMeasureValues value2) {
        int result = 0;
        int n = 0;
        int n2 = value2.getCount();
        if (n < n2) {
            do {
                int i;
                if (value2.get(i = n++) == CommonTypesKt.getUndefined()) continue;
                int intValue = value2.get(i) == null ? 0 : this.encoder.encode(value2.get(i), this.encodeContext);
                int length = intValue < 0 ? this.encodeContext.getLen() : 4;
                result += this.writeRecordMeasureHead($this$writeUpdateMeasure, intValue >= 0, i, length);
                if (intValue < 0) {
                    $this$writeUpdateMeasure.put(this.encodeContext.getCurrent(), 0, length);
                } else if (value2.get(i) == null) {
                    $this$writeUpdateMeasure.putInt(0);
                } else {
                    $this$writeUpdateMeasure.putInt(CommonTypesKt.setTrue(intValue, 31));
                }
                result += length;
            } while (n < n2);
        }
        n = result > 0 ? 1 : 0;
        n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "all value is undefined";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return result;
    }

    private final int writeInsertRecordContent(ByteBuffer $this$writeInsertRecordContent, int partitionId, IDimensionKeys key, IMeasureValues value2) {
        $this$writeInsertRecordContent.putInt(partitionId);
        int result = 4;
        result += this.writeKey($this$writeInsertRecordContent, key);
        return result += this.writeInsertMeasure($this$writeInsertRecordContent, value2);
    }

    private final int writeUpdateRecordContent(ByteBuffer $this$writeUpdateRecordContent, int partitionId, int index2, IMeasureValues value2) {
        $this$writeUpdateRecordContent.putInt(partitionId);
        $this$writeUpdateRecordContent.putInt(index2);
        int result = 8;
        return result += this.writeUpdateMeasure($this$writeUpdateRecordContent, value2);
    }

    public final boolean addInsertRecord(long tid, int cubeId, int partitionId, @NotNull IDimensionKeys key, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        int startIndex = this.buffer.position();
        this.buffer.position(startIndex + 14);
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        int length = this.writeInsertRecordContent(byteBuffer, partitionId, key, value2);
        byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        this.writeRecordHead(byteBuffer, startIndex, RedoType.INSERT, length, cubeId, tid);
        if (this.buffer.remaining() <= 4096) {
            this.forceMerge();
            return true;
        }
        return this.tryMerge();
    }

    public final boolean addUpdateRecord(long tid, int cubeId, int partitionId, int index2, @NotNull IMeasureValues value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        int startIndex = this.buffer.position();
        this.buffer.position(startIndex + 14);
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        int length = this.writeUpdateRecordContent(byteBuffer, partitionId, index2, value2);
        byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        this.writeRecordHead(byteBuffer, startIndex, RedoType.UPDATE, length, cubeId, tid);
        if (this.buffer.remaining() <= 4096) {
            this.forceMerge();
            return true;
        }
        return this.tryMerge();
    }

    public final boolean addDDLRecord(long tid, int cubeId, @NotNull String command) {
        int length;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Object object = command + '\u0000';
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StringBuilder(command).append('\\u0000').toString()");
        Charset charset = Charsets.UTF_8;
        int n = 0;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] cmdBytes = byArray;
        if (this.buffer.remaining() - 14 > cmdBytes.length) {
            object = this.buffer;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buffer");
            this.writeRecordHead((ByteBuffer)object, RedoType.METADATA, cmdBytes.length, cubeId, tid);
            this.buffer.put(cmdBytes, 0, cmdBytes.length);
            if (this.buffer.remaining() <= 4096) {
                this.forceMerge();
                return true;
            }
            return this.tryMerge();
        }
        for (int offset = 0; offset < cmdBytes.length; offset += length) {
            n = this.buffer.remaining() - 14;
            int n2 = cmdBytes.length - offset;
            boolean bl = false;
            length = Math.min(n, n2);
            ByteBuffer byteBuffer = this.buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
            this.writeRecordHead(byteBuffer, RedoType.METADATA, length, cubeId, tid);
            this.buffer.put(cmdBytes, offset, length);
            this.forceMerge();
        }
        return true;
    }

    public final void addCubeRecoverRecord(long tid, int cubeId, @NotNull byte[] md5) {
        Intrinsics.checkNotNullParameter((Object)md5, (String)"md5");
        int startIndex = this.buffer.position();
        boolean bl = md5.length == 16;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        this.writeRecordHead(byteBuffer, startIndex, RedoType.CubeRecover, 16, cubeId, tid);
        this.buffer.position(startIndex + 14);
        this.buffer.put(md5);
        this.forceMerge();
    }

    public final boolean addTranStatusRecord(long tid, int cubeId, @NotNull TransactionStatus staus) {
        Intrinsics.checkNotNullParameter((Object)((Object)staus), (String)"staus");
        int startIndex = this.buffer.position();
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        this.writeRecordHead(byteBuffer, startIndex, RedoType.TranStatus, 1, cubeId, tid);
        this.buffer.position(startIndex + 14);
        this.buffer.put(staus.getCode());
        if (this.buffer.remaining() <= 4096) {
            this.forceMerge();
            return true;
        }
        return this.tryMerge();
    }

    private final boolean tryMerge() {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        long mergePage = this.master.tryMerge(byteBuffer);
        if (mergePage == -1L) {
            return false;
        }
        this.lastMergePageLSN = mergePage;
        this.buffer.clear();
        return true;
    }

    public final void forceMerge() {
        if (this.buffer.position() == 0) {
            return;
        }
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        long mergePage = this.master.tryMerge(byteBuffer);
        while (mergePage == -1L) {
            Thread.sleep(1L);
            byteBuffer = this.buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
            mergePage = this.master.tryMerge(byteBuffer);
        }
        this.lastMergePageLSN = mergePage;
        this.buffer.clear();
    }

    public final long flushSyncSlaves() {
        this.forceMerge();
        if (this.lastMergePageLSN != -1L) {
            this.master.syncSlaves(this.lastMergePageLSN);
        }
        return this.lastMergePageLSN;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olapServer/replication/LocalRedo$Companion;", "", "()V", "maxRecordLen", "", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

