/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import kd.bos.olapServer.common.Paths;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.BackupType;
import kd.bos.olapServer.replication.BackupUtil;
import kd.bos.olapServer.replication.ControlConfig;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010\f\u001a\u00020\b2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u0012\u0010\u0010\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/replication/OlapBackupRecover;", "", "olap", "Lkd/bos/olapServer/storages/OlapWorkspace;", "conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "(Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/ReplicationConf;)V", "incrementBackup", "", "backupPoint", "", "Lkd/bos/olapServer/common/LSN;", "recovery", "backupPath", "", "Lkd/bos/olapServer/common/string;", "totalBackup", "bos-olap-core"})
public final class OlapBackupRecover {
    @NotNull
    private final OlapWorkspace olap;
    @NotNull
    private final ReplicationConf conf;

    public OlapBackupRecover(@NotNull OlapWorkspace olap, @NotNull ReplicationConf conf) {
        Intrinsics.checkNotNullParameter((Object)olap, (String)"olap");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.olap = olap;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void totalBackup(long backupPoint) {
        try (BackupUtil backupUtil = new BackupUtil(this.conf.get_node().getBackupPath(), false);){
            String backupDir = backupUtil.createBackupDir(BackupType.Total);
            this.olap.backupOlap(backupDir);
            Object object = new String[]{"index.json"};
            File indexJsonFile = Paths.INSTANCE.get(this.olap.getRootPath(), (String)object).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)indexJsonFile, (String)"indexJsonFile");
            String[] stringArray = new String[1];
            String string = indexJsonFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexJsonFile.name");
            stringArray[0] = string;
            object = Paths.INSTANCE.get(backupDir, stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Paths.get(backupDir, indexJsonFile.name).toFile()");
            FilesKt.copyTo$default((File)indexJsonFile, (File)object, (boolean)false, (int)0, (int)6, null);
            stringArray = new String[]{"lsn.control"};
            String controlFile = ((Object)Paths.INSTANCE.get(backupDir, stringArray)).toString();
            new ControlConfig(backupPoint, backupPoint).save(controlFile);
            backupUtil.writeBackupRecord(backupDir, backupPoint, backupPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementBackup(long backupPoint) {
        try (BackupUtil backupUtil = new BackupUtil(this.conf.get_node().getBackupPath(), false);){
            long beginPage = backupUtil.getLastPoint();
            long endPage = backupPoint;
            if (beginPage == endPage) {
                return;
            }
            String backupDir = backupUtil.createBackupDir(BackupType.Increment);
            long beginFile = LSNUtil.INSTANCE.fileLSN(beginPage);
            long endFile = LSNUtil.INSTANCE.fileLSN(endPage);
            long cur = beginFile;
            while (cur <= endFile) {
                String curName = LSNUtil.INSTANCE.getFileName(cur);
                Object[] objectArray = new String[]{curName};
                Path source2 = Paths.INSTANCE.get(this.conf.get_node().getRedoPath(), (String[])objectArray);
                if (!source2.toFile().exists()) {
                    objectArray = Res.INSTANCE.getReplicationSlaveException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.ReplicationSlaveException_1");
                    Object object = objectArray;
                    objectArray = new Object[]{curName};
                    throw Res.INSTANCE.getRuntimeException((String)object, objectArray);
                }
                String[] stringArray = new String[]{curName};
                Path dest = Paths.INSTANCE.get(backupDir, stringArray);
                Files.copy(source2, dest, new CopyOption[0]);
                cur = LSNUtil.INSTANCE.nextFileLSN(cur);
            }
            String[] stringArray = new String[]{"lsn.control"};
            String controlFile = ((Object)Paths.INSTANCE.get(backupDir, stringArray)).toString();
            new ControlConfig(beginPage, endPage).save(controlFile);
            backupUtil.writeBackupRecord(backupDir, beginPage, endPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recovery(@NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        BackupUtil backupUtil = null;
        try {
            String lastTotal;
            ControlConfig controlConfig;
            backupUtil = new BackupUtil(backupPath, true);
            String[] stringArray = new String[]{"lsn.control"};
            Object controlFileName = ((Object)Paths.INSTANCE.get(this.olap.getRootPath(), stringArray)).toString();
            ControlConfig controlConfig2 = controlConfig = new File((String)controlFileName).exists() ? ControlConfig.Companion.readControlConfig((String)controlFileName) : new ControlConfig(0L, 0L);
            if (controlConfig.getRecoveryEndLSN() == 0L && !Intrinsics.areEqual((Object)(lastTotal = backupUtil.getLastTotalBackup()), (Object)"")) {
                String[] this_$iv = ReplicationManager.INSTANCE.getLogger();
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    Logger logger = OlapLogger.access$getLogger$p((OlapLogger)this_$iv);
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)"total recover path ", (Object)backupPath);
                    logger.info(string);
                }
                this_$iv = new String[]{lastTotal};
                this.olap.recoveryOlap(((Object)Paths.INSTANCE.get(backupPath, this_$iv)).toString());
                controlConfig = backupUtil.getControlConfig(lastTotal);
            }
            long replayStart = controlConfig.getRecoveryStartLSN();
            long replayEnd = backupUtil.getLastPoint();
            if (replayEnd > replayStart) {
                ControlConfig replayControl = new ControlConfig(replayStart, replayEnd);
                backupUtil.copyRedo(replayStart, replayEnd, this.conf.get_node().getRedoPath());
                ReplicationManager.INSTANCE.replayRedo(replayControl, this.conf.get_node().getRedoPath());
            }
            new ControlConfig(replayEnd, replayEnd).save((String)controlFileName);
            controlFileName = backupUtil;
            ((BackupUtil)controlFileName).close();
        }
        catch (Exception e) {
            try {
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder().append("\u6570\u636e\u6062\u590d\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f ").append(e).append('\uff1a');
                    StackTraceElement[] replayControl = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)replayControl, (String)"e.stackTrace");
                    String message$iv = stringBuilder.append(ArraysKt.joinToString$default((Object[])replayControl, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null)).toString();
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                }
                throw e;
            }
            catch (Throwable throwable) {
                BackupUtil backupUtil2 = backupUtil;
                if (backupUtil2 != null) {
                    backupUtil2.close();
                }
                throw throwable;
            }
        }
    }
}

