/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bH\u0086\b\u00f8\u0001\u0000J\u001e\u0010\u001a\u001a\u00020\u00172\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bH\u0086\b\u00f8\u0001\u0000J\u001e\u0010\u001f\u001a\u00020\u00172\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bH\u0086\b\u00f8\u0001\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lkd/bos/olapServer/replication/OlapLogger;", "", "logger", "Lorg/slf4j/Logger;", "olapWorkspace", "Lkd/bos/olapServer/storages/OlapWorkspace;", "status", "Lkd/bos/olapServer/replication/ReplicationStatus;", "(Lorg/slf4j/Logger;Lkd/bos/olapServer/storages/OlapWorkspace;Lkd/bos/olapServer/replication/ReplicationStatus;)V", "isErrorEnabled", "", "()Z", "isInfoEnabled", "isWarnEnabled", "getOlapWorkspace", "()Lkd/bos/olapServer/storages/OlapWorkspace;", "setOlapWorkspace", "(Lkd/bos/olapServer/storages/OlapWorkspace;)V", "getStatus", "()Lkd/bos/olapServer/replication/ReplicationStatus;", "setStatus", "(Lkd/bos/olapServer/replication/ReplicationStatus;)V", "error", "", "t", "", "info", "Lkotlin/Function0;", "", "Lkd/bos/olapServer/common/string;", "infoFunc", "warn", "bos-olap-core"})
public final class OlapLogger {
    @NotNull
    private final Logger logger;
    @Nullable
    private OlapWorkspace olapWorkspace;
    @NotNull
    private ReplicationStatus status;

    public OlapLogger(@NotNull Logger logger, @Nullable OlapWorkspace olapWorkspace, @NotNull ReplicationStatus status) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.logger = logger;
        this.olapWorkspace = olapWorkspace;
        this.status = status;
    }

    @Nullable
    public final OlapWorkspace getOlapWorkspace() {
        return this.olapWorkspace;
    }

    public final void setOlapWorkspace(@Nullable OlapWorkspace olapWorkspace) {
        this.olapWorkspace = olapWorkspace;
    }

    @NotNull
    public final ReplicationStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull ReplicationStatus replicationStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)replicationStatus), (String)"<set-?>");
        this.status = replicationStatus;
    }

    public final boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public final void info(@NotNull Function0<String> infoFunc) {
        Intrinsics.checkNotNullParameter(infoFunc, (String)"infoFunc");
        boolean $i$f$info = false;
        if (this.isInfoEnabled()) {
            this.logger.info((String)infoFunc.invoke());
        }
    }

    public final boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public final void warn(@NotNull Function0<String> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        boolean $i$f$warn = false;
        if (this.isWarnEnabled()) {
            String message2 = (String)info.invoke();
            OlapWorkspace olap = this.getOlapWorkspace();
            if (olap != null) {
                String reportId = this.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                HealthReport report = new HealthReport(reportId, null, this.getStatus().name() + "-ReplicationWarn: " + message2, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                olap.getHealthReports().commit(report);
            }
            this.logger.warn((String)info.invoke());
        }
    }

    public final boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public final void error(@Nullable Throwable t2, @NotNull Function0<String> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        boolean $i$f$error = false;
        if (this.isErrorEnabled()) {
            String message2 = (String)info.invoke();
            OlapWorkspace olap = this.getOlapWorkspace();
            if (olap != null) {
                String reportId = this.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                HealthReport report = new HealthReport(reportId, null, this.getStatus().name() + "-ReplicationError: " + message2, HealthReportLevel.Error, PrivilegeType.None.getCode());
                olap.getHealthReports().commit(report);
            }
            if (t2 == null) {
                this.logger.error(message2);
            } else {
                this.logger.error(message2, t2);
            }
        }
    }

    public static /* synthetic */ void error$default(OlapLogger this_, Throwable t2, Function0 info, int n, Object object) {
        if ((n & 1) != 0) {
            t2 = null;
        }
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean $i$f$error = false;
        if (this_.isErrorEnabled()) {
            String message2 = (String)info.invoke();
            OlapWorkspace olap = this_.getOlapWorkspace();
            if (olap != null) {
                String reportId = this_.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                HealthReport report = new HealthReport(reportId, null, this_.getStatus().name() + "-ReplicationError: " + message2, HealthReportLevel.Error, PrivilegeType.None.getCode());
                olap.getHealthReports().commit(report);
            }
            if (t2 == null) {
                this_.logger.error(message2);
            } else {
                this_.logger.error(message2, t2);
            }
        }
    }
}

