/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olapServer.common.NotSupportedException;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.RedoReceiver;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.replication.SignalType;
import kd.bos.olapServer.replication.SlaveLSNContext;
import kd.bos.olapServer.replication.TimeStatQueue;
import kd.bos.olapServer.replication.WritedRedoFile;
import kd.bos.olapServer.replication.WritedRedoPage;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020&H\u0002J\b\u0010,\u001a\u00020&H\u0002J\b\u0010-\u001a\u00020&H\u0002J\b\u0010.\u001a\u00020&H\u0002J\b\u0010/\u001a\u00020&H\u0002J\b\u00100\u001a\u00020&H\u0002J\b\u00101\u001a\u00020&H\u0002J\b\u00102\u001a\u00020&H\u0002J\b\u00103\u001a\u00020&H\u0016J\b\u00104\u001a\u00020&H\u0002J\b\u00105\u001a\u00020&H\u0002J\b\u00106\u001a\u00020&H\u0002J\u0014\u00107\u001a\u00020&2\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u001bH\u0002J\b\u00108\u001a\u00020&H\u0002J\b\u00109\u001a\u00020&H\u0002J\b\u0010:\u001a\u00020&H\u0002J\b\u0010;\u001a\u00020&H\u0016J\u0010\u0010<\u001a\u00060\u0014j\u0002`=*\u00020#H\u0002J\u0014\u0010>\u001a\u00020&*\u00020\r2\u0006\u0010?\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u0018j\u0002`\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u000e*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n \u000e*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n \u000e*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lkd/bos/olapServer/replication/RedoReceiver;", "Ljava/lang/Thread;", "Ljava/io/Closeable;", "conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "slaveLSNContext", "Lkd/bos/olapServer/replication/SlaveLSNContext;", "context", "Lkd/bos/olapServer/replication/ReplicationContext;", "delayTimeStat", "Lkd/bos/olapServer/replication/TimeStatQueue;", "(Lkd/bos/olapServer/replication/ReplicationConf;Lkd/bos/olapServer/replication/SlaveLSNContext;Lkd/bos/olapServer/replication/ReplicationContext;Lkd/bos/olapServer/replication/TimeStatQueue;)V", "controlChannel", "Ljava/nio/channels/SocketChannel;", "kotlin.jvm.PlatformType", "controlChannelKey", "Ljava/nio/channels/SelectionKey;", "dataChannel", "dataChannelKey", "isRunning", "", "isSwitching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastKeepAliveTime", "", "Lkd/bos/olapServer/common/long;", "lastPage", "Lkd/bos/olapServer/common/LSN;", "recvPage", "Lkd/bos/olapServer/replication/WritedRedoPage;", "redoFile", "Lkd/bos/olapServer/replication/WritedRedoFile;", "selector", "Ljava/nio/channels/Selector;", "signalReadBuffer", "Ljava/nio/ByteBuffer;", "signalSendBuffer", "checkVip", "", "close", "createThreadToSwitch", "dealAgree", "dealClose", "dealDisagree", "dealKeepAlive", "dealMasterClose", "dealNetworkException", "dealSignal", "dealTimeout", "readControlChannel", "readDataChannel", "run", "sendControlConnect", "sendDataConnect", "sendEndStream", "sendMasterCloseAck", "sendRedoAck", "sendStartStream", "sendSwitchToMaster", "start", "hasCompleteSignal", "Lkd/bos/olapServer/common/bool;", "writeBuffer", "buffer", "Companion", "bos-olap-core"})
public final class RedoReceiver
extends Thread
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final SlaveLSNContext slaveLSNContext;
    @NotNull
    private final ReplicationContext context;
    @Nullable
    private final TimeStatQueue delayTimeStat;
    private volatile boolean isRunning;
    private final ByteBuffer signalReadBuffer;
    private final ByteBuffer signalSendBuffer;
    @NotNull
    private final WritedRedoPage recvPage;
    @Nullable
    private WritedRedoFile redoFile;
    private SocketChannel controlChannel;
    private SocketChannel dataChannel;
    private final Selector selector;
    @Nullable
    private SelectionKey controlChannelKey;
    @Nullable
    private SelectionKey dataChannelKey;
    private long lastPage;
    private long lastKeepAliveTime;
    @NotNull
    private AtomicBoolean isSwitching;
    private static final int bufferSize = 1024;
    private static final long selectTimeoutMs = 1000L;
    private static final long keepAliveTimeoutNs = 10000000000L;
    private static final long maxWaitVipNs = 60000000000L;

    public RedoReceiver(@NotNull ReplicationConf conf, @NotNull SlaveLSNContext slaveLSNContext, @NotNull ReplicationContext context, @Nullable TimeStatQueue delayTimeStat) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)slaveLSNContext, (String)"slaveLSNContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(RedoReceiver.class.getName());
        this.conf = conf;
        this.slaveLSNContext = slaveLSNContext;
        this.context = context;
        this.delayTimeStat = delayTimeStat;
        this.signalReadBuffer = ByteBuffer.allocate(1024);
        this.signalSendBuffer = ByteBuffer.allocate(1024);
        this.recvPage = new WritedRedoPage();
        this.controlChannel = SocketChannel.open();
        this.dataChannel = SocketChannel.open();
        this.selector = Selector.open();
        this.lastPage = -1L;
        this.isSwitching = new AtomicBoolean(false);
    }

    public /* synthetic */ RedoReceiver(ReplicationConf replicationConf, SlaveLSNContext slaveLSNContext, ReplicationContext replicationContext, TimeStatQueue timeStatQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeStatQueue = null;
        }
        this(replicationConf, slaveLSNContext, replicationContext, timeStatQueue);
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                this.selector.select(1000L);
                Set<SelectionKey> keys = this.selector.selectedKeys();
                if (keys.isEmpty()) {
                    this.dealTimeout();
                }
                Iterator<SelectionKey> keyIter = keys.iterator();
                while (keyIter.hasNext()) {
                    SelectionKey key = keyIter.next();
                    keyIter.remove();
                    if (!key.isValid() || !key.isReadable()) continue;
                    SelectableChannel selectableChannel = key.channel();
                    if (selectableChannel == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.nio.channels.SocketChannel");
                    }
                    SocketChannel sc = (SocketChannel)selectableChannel;
                    if (Intrinsics.areEqual((Object)sc, (Object)this.controlChannel)) {
                        this.readControlChannel();
                        continue;
                    }
                    this.readDataChannel();
                }
                this.checkVip();
            }
            catch (Exception e) {
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) continue;
                boolean bl = false;
                String message$iv = "\u63a5\u6536\u7ebf\u7a0b\u5f02\u5e38\u3002";
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                    continue;
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
            }
        }
        this.controlChannel.close();
        this.dataChannel.close();
        WritedRedoFile writedRedoFile = this.redoFile;
        if (writedRedoFile != null) {
            writedRedoFile.close();
        }
    }

    private final void readControlChannel() {
        try {
            int readByte = this.controlChannel.read(this.signalReadBuffer);
            if (readByte == -1) {
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "\u8bfb\u53d6\u63a7\u5236\u6307\u4ee4\u9519\u8bef,readByte=-1";
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                }
                this.dealNetworkException();
                return;
            }
            this.signalReadBuffer.flip();
            while (true) {
                ByteBuffer this_$iv = this.signalReadBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"signalReadBuffer");
                if (!this.hasCompleteSignal(this_$iv)) break;
                this.dealSignal();
            }
            this.signalReadBuffer.compact();
        }
        catch (Exception e) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "\u8bfb\u53d6\u63a7\u5236\u6307\u4ee4\u53d1\u751f\u9519\u8bef\u3002";
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                }
            }
            this.dealNetworkException();
            return;
        }
    }

    private final void dealSignal() {
        byte len = this.signalReadBuffer.get();
        SignalType signal = SignalType.Companion.byteToSignalType(this.signalReadBuffer.get());
        if (signal != SignalType.KEEP_ALIVE) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"RedoReceiver \u63a5\u53d7\u5230\u63a7\u5236\u6307\u4ee4:", (Object)((Object)signal));
                logger.info(string);
            }
        }
        SignalType signalType = signal;
        int n = WhenMappings.$EnumSwitchMapping$0[signalType.ordinal()];
        switch (n) {
            case 1: {
                this.dealAgree();
                break;
            }
            case 2: {
                this.dealDisagree();
                break;
            }
            case 3: {
                this.dealKeepAlive();
                break;
            }
            case 4: {
                this.dealMasterClose();
                break;
            }
            default: {
                String string = Res.INSTANCE.getRedoReceiverException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RedoReceiverException_3");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
    }

    private final void dealAgree() {
        SignalType signalType = SignalType.Companion.byteToSignalType(this.signalReadBuffer.get());
        int n = WhenMappings.$EnumSwitchMapping$0[signalType.ordinal()];
        switch (n) {
            case 5: {
                this.sendDataConnect();
                break;
            }
            case 6: {
                this.sendStartStream();
                break;
            }
            case 7: {
                this.dataChannel.register(this.selector, 1);
                ReplicationManager.INSTANCE.setStatus(ReplicationStatus.Slave);
                break;
            }
            case 8: {
                this.isRunning = false;
                break;
            }
            case 9: {
                break;
            }
            default: {
                String string = Res.INSTANCE.getRedoReceiverException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RedoReceiverException_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
    }

    private final void dealDisagree() {
        SignalType signalType = SignalType.Companion.byteToSignalType(this.signalReadBuffer.get());
        int n = WhenMappings.$EnumSwitchMapping$0[signalType.ordinal()];
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                this.dealClose();
                break;
            }
            default: {
                String string = Res.INSTANCE.getRedoReceiverException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RedoReceiverException_2");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
    }

    private final void dealKeepAlive() {
        this.sendRedoAck();
        this.lastKeepAliveTime = System.nanoTime();
    }

    private final void dealMasterClose() {
        this.lastPage = this.signalReadBuffer.getLong();
        if (this.lastPage == LSNUtil.INSTANCE.prePageLSN(this.slaveLSNContext.getNextWritePage())) {
            this.sendMasterCloseAck(this.lastPage);
            this.createThreadToSwitch();
        }
    }

    private final void dealTimeout() {
        if (System.nanoTime() - this.lastKeepAliveTime < 10000000000L) {
            return;
        }
        if (System.nanoTime() - this.lastKeepAliveTime > 60000000000L) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "\u4ece\u7ed3\u70b9 " + this.conf.get_node().getServerID() + " \u4e3b\u52a8\u65ad\u5f00\uff0c\u5f85DBA\u5904\u7406";
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            this.dealClose();
            return;
        }
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$warn = false;
        if (this_$iv.isWarnEnabled()) {
            boolean bl = false;
            String message$iv = Intrinsics.stringPlus((String)"\u5df2\u8d85\u65f6,\u5f53\u524d\u72b6\u6001\uff1a", (Object)((Object)ReplicationManager.INSTANCE.getStatus()));
            OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
            if (olap$iv != null) {
                String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                olap$iv.getHealthReports().commit(report$iv);
            }
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            $i$a$-warn-RedoReceiver$dealTimeout$2 = false;
            String string = Intrinsics.stringPlus((String)"\u5df2\u8d85\u65f6,\u5f53\u524d\u72b6\u6001\uff1a", (Object)((Object)ReplicationManager.INSTANCE.getStatus()));
            logger.warn(string);
        }
        this.dealNetworkException();
    }

    private final void dealClose() {
        ReplicationStatus replicationStatus = ReplicationManager.INSTANCE.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$1[replicationStatus.ordinal()];
        if (n == 1) {
            try {
                this.sendEndStream();
            }
            catch (Exception e) {
                this.isRunning = false;
            }
        } else {
            this.isRunning = false;
        }
        ReplicationManager.INSTANCE.setStatus(ReplicationStatus.Unavailable);
    }

    private final void dealNetworkException() {
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$warn = false;
        if (this_$iv.isWarnEnabled()) {
            boolean bl = false;
            String message$iv = Intrinsics.stringPlus((String)"\u7f51\u7edc\u5f02\u5e38,\u5f53\u524d\u72b6\u6001\uff1a", (Object)((Object)ReplicationManager.INSTANCE.getStatus()));
            OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
            if (olap$iv != null) {
                String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                olap$iv.getHealthReports().commit(report$iv);
            }
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            $i$a$-warn-RedoReceiver$dealNetworkException$1 = false;
            String string = Intrinsics.stringPlus((String)"\u7f51\u7edc\u5f02\u5e38,\u5f53\u524d\u72b6\u6001\uff1a", (Object)((Object)ReplicationManager.INSTANCE.getStatus()));
            logger.warn(string);
        }
        Object object = this.controlChannelKey;
        if (object != null) {
            ((SelectionKey)object).cancel();
        }
        object = this.dataChannelKey;
        if (object != null) {
            ((SelectionKey)object).cancel();
        }
        object = ReplicationManager.INSTANCE.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()];
        switch (n) {
            case 2: {
                this.dealClose();
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                this.createThreadToSwitch();
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
    }

    private final void readDataChannel() {
        try {
            int readByte = this.dataChannel.read(this.recvPage.getBuffer());
            if (readByte == -1) {
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "\u8bfb\u53d6\u6570\u636e\u6307\u4ee4\u9519\u8bef,readByte=-1";
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                }
                this.dealNetworkException();
                return;
            }
            if (!this.recvPage.getBuffer().hasRemaining()) {
                if (this.recvPage.getPageLSN() != this.slaveLSNContext.getNextWritePage()) {
                    OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                    Object t$iv = null;
                    boolean $i$f$error = false;
                    if (this_$iv.isErrorEnabled()) {
                        boolean bl = false;
                        String message$iv = "slave\u671f\u5f85\u6536\u5230page:" + this.slaveLSNContext.getNextWritePage() + ",\u5374\u6536\u5230\u4e3apage:" + this.recvPage.getPageLSN();
                        OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                        if (olap$iv != null) {
                            String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                            HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                            olap$iv.getHealthReports().commit(report$iv);
                        }
                        OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                    }
                    this.dealClose();
                    return;
                }
                TimeStatQueue this_$iv = this.delayTimeStat;
                if (this_$iv != null) {
                    this_$iv.setBegin(this.slaveLSNContext.getNextWritePage());
                }
                WritedRedoFile writedRedoFile = this.redoFile;
                Intrinsics.checkNotNull((Object)writedRedoFile);
                writedRedoFile.writePage(this.recvPage);
                this.recvPage.getBuffer().clear();
                if (this.lastPage == this.slaveLSNContext.getNextWritePage()) {
                    this.sendMasterCloseAck(this.lastPage);
                    this.createThreadToSwitch();
                }
                this.slaveLSNContext.setNextWritePage(LSNUtil.INSTANCE.nextPageLSN(this.slaveLSNContext.getNextWritePage()));
                this.sendRedoAck();
            }
        }
        catch (Exception e) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "\u8bfb\u53d6\u6570\u636e\u6307\u4ee4\u53d1\u751f\u9519\u8bef\u3002";
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)e == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                }
            }
            this.dealNetworkException();
            return;
        }
    }

    private final void sendControlConnect() {
        this.signalSendBuffer.clear();
        byte len = 15;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.CONTROL_CONNECT.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        byte[] slaveConfigMd5 = this.context.getConfigMd5();
        this.signalSendBuffer.put(slaveConfigMd5);
        this.signalSendBuffer.putInt(this.context.getWebPort());
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendDataConnect() {
        this.signalSendBuffer.clear();
        byte len = 3;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.DATA_CONNECT.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        Object object = this.dataChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dataChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendStartStream() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.START_STREAM.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(this.slaveLSNContext.getNextWritePage());
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendEndStream() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.END_STREAM.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(0L);
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendRedoAck() {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.REDO_ACK.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(LSNUtil.INSTANCE.prePageLSN(this.slaveLSNContext.getNextWritePage()));
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendSwitchToMaster() {
        this.signalSendBuffer.clear();
        byte len = 3;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.SWITCH_TO_MASTER.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.put((byte)this.conf.get_node().getServerID());
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    private final void sendMasterCloseAck(long lastPage) {
        this.signalSendBuffer.clear();
        byte len = 10;
        this.signalSendBuffer.put(len);
        byte cmdType = SignalType.MASTER_CLOSE_ACK.getCode();
        this.signalSendBuffer.put(cmdType);
        this.signalSendBuffer.putLong(lastPage);
        Object object = this.controlChannel;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"controlChannel");
        SocketChannel socketChannel = object;
        object = this.signalSendBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signalSendBuffer");
        this.writeBuffer(socketChannel, (ByteBuffer)object);
    }

    @Override
    public void start() {
        try {
            if (!this.controlChannel.isOpen()) {
                this.controlChannel = SocketChannel.open();
            }
            this.controlChannel.connect(new InetSocketAddress(this.conf.get_slave().getHost(), this.conf.get_slave().getPort()));
            if (!this.dataChannel.isOpen()) {
                this.dataChannel = SocketChannel.open();
            }
            this.dataChannel.connect(new InetSocketAddress(this.conf.get_slave().getHost(), this.conf.get_slave().getPort()));
            this.redoFile = new WritedRedoFile(this.conf.get_node().getRedoPath(), this.slaveLSNContext, this.conf.get_node().getRedoKeepSegments());
        }
        catch (Exception ex) {
            this.close();
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                Object[] objectArray = Res.INSTANCE.getRedoReceiverException_1();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RedoReceiverException_1");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.conf.get_slave().getHost(), this.conf.get_slave().getPort()};
                String message$iv = Res.INSTANCE.format((String)objectArray2, objectArray);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if ((Throwable)ex == null) {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)ex);
                }
            }
            Object[] objectArray = Res.INSTANCE.getRedoReceiverException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RedoReceiverException_1");
            Object[] objectArray3 = objectArray;
            objectArray = new Object[]{this.conf.get_slave().getHost(), this.conf.get_slave().getPort()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray3, objectArray);
        }
        this.controlChannel.configureBlocking(false);
        this.dataChannel.configureBlocking(false);
        this.controlChannelKey = this.controlChannel.register(this.selector, 1);
        this.dataChannelKey = this.dataChannel.register(this.selector, 1);
        this.sendControlConnect();
        this.isRunning = true;
        this.lastKeepAliveTime = System.nanoTime();
        super.start();
    }

    @Override
    public void close() {
        this.dealClose();
        this.join();
        WritedRedoFile writedRedoFile = this.redoFile;
        if (writedRedoFile != null) {
            writedRedoFile.close();
        }
    }

    private final void checkVip() {
        if (ReplicationManager.INSTANCE.isVipHost() && ReplicationManager.INSTANCE.compareAndSetStatus(ReplicationStatus.Slave, ReplicationStatus.Transfering)) {
            this.sendSwitchToMaster();
        }
    }

    private final void createThreadToSwitch() {
        if (ReplicationManager.INSTANCE.getStatus() != ReplicationStatus.Transfering || !this.isSwitching.compareAndSet(false, true)) {
            return;
        }
        ReplicationManager.INSTANCE.setSwitchThread(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"SlaveToMaster", (int)0, (Function0)createThreadToSwitch.1.INSTANCE, (int)23, null));
    }

    private final boolean hasCompleteSignal(ByteBuffer $this$hasCompleteSignal) {
        if ($this$hasCompleteSignal.remaining() == 0) {
            return false;
        }
        return $this$hasCompleteSignal.remaining() >= $this$hasCompleteSignal.get($this$hasCompleteSignal.position());
    }

    private final void writeBuffer(SocketChannel $this$writeBuffer, ByteBuffer buffer) {
        buffer.flip();
        while (buffer.hasRemaining()) {
            try {
                $this$writeBuffer.write(buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
                OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "\u5199socket\u53d1\u751f\u9519\u8bef\u3002";
                    OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                    if (olap$iv != null) {
                        String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                    } else {
                        OlapLogger.access$getLogger$p(this_$iv).error(message$iv, (Throwable)e);
                    }
                }
                this.dealNetworkException();
                return;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/replication/RedoReceiver$Companion;", "", "()V", "bufferSize", "", "keepAliveTimeoutNs", "", "maxWaitVipNs", "selectTimeoutMs", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SignalType.values().length];
            nArray[SignalType.AGREE.ordinal()] = 1;
            nArray[SignalType.DISAGREE.ordinal()] = 2;
            nArray[SignalType.KEEP_ALIVE.ordinal()] = 3;
            nArray[SignalType.MASTER_CLOSE.ordinal()] = 4;
            nArray[SignalType.CONTROL_CONNECT.ordinal()] = 5;
            nArray[SignalType.DATA_CONNECT.ordinal()] = 6;
            nArray[SignalType.START_STREAM.ordinal()] = 7;
            nArray[SignalType.END_STREAM.ordinal()] = 8;
            nArray[SignalType.SWITCH_TO_MASTER.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReplicationStatus.values().length];
            nArray[ReplicationStatus.Slave.ordinal()] = 1;
            nArray[ReplicationStatus.Unavailable.ordinal()] = 2;
            nArray[ReplicationStatus.Backup.ordinal()] = 3;
            nArray[ReplicationStatus.Transfering.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

