/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.replication;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.olapServer.monitorReports.HealthReport;
import kd.bos.olapServer.monitorReports.HealthReportLevel;
import kd.bos.olapServer.replication.LSNUtil;
import kd.bos.olapServer.replication.MasterLSNContext;
import kd.bos.olapServer.replication.OlapLogger;
import kd.bos.olapServer.replication.RedoPage;
import kd.bos.olapServer.replication.RedoSender;
import kd.bos.olapServer.replication.ReplicationConf;
import kd.bos.olapServer.replication.ReplicationContext;
import kd.bos.olapServer.replication.ReplicationManager;
import kd.bos.olapServer.replication.ReplicationStatus;
import kd.bos.olapServer.replication.SignalType;
import kd.bos.olapServer.replication.SlaveNode;
import kd.bos.olapServer.replication.TimeStatQueue;
import kd.bos.olapServer.replication.TransferredRedoFile;
import kd.bos.olapServer.security.PrivilegeType;
import kd.bos.olapServer.storages.OlapWorkspace;
import kd.bos.olapServer.tools.CubeToolKt;
import kd.bos.olapServer.tools.Res;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u0006\u0010&\u001a\u00020\u001dJ\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\b\u0010)\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u001e\u00102\u001a\u001a\u0012\b\u0012\u00060!j\u0002`403j\f\u0012\b\u0012\u00060!j\u0002`4`5J\u0018\u00106\u001a\u00060\fj\u0002`72\n\u00108\u001a\u00060#j\u0002`9H\u0002J\b\u0010:\u001a\u00020\u001dH\u0002J\u0010\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020=H\u0002J\u000e\u0010>\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010?\u001a\u00020\u001dH\u0016J\u0018\u0010@\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010D\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010E\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\b\u0010G\u001a\u00020\u001dH\u0016J\u0010\u0010H\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u000e\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020KJ\u0016\u0010L\u001a\u0004\u0018\u00010\u001a2\n\u00108\u001a\u00060#j\u0002`9H\u0002J\u0010\u0010M\u001a\u00060\fj\u0002`7*\u00020=H\u0002J\u0014\u0010N\u001a\u00020\u001d*\u00020\u00192\u0006\u0010<\u001a\u00020=H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lkd/bos/olapServer/replication/RedoSender;", "Ljava/lang/Thread;", "conf", "Lkd/bos/olapServer/replication/ReplicationConf;", "masterLSNContext", "Lkd/bos/olapServer/replication/MasterLSNContext;", "context", "Lkd/bos/olapServer/replication/ReplicationContext;", "AckTimeStat", "Lkd/bos/olapServer/replication/TimeStatQueue;", "(Lkd/bos/olapServer/replication/ReplicationConf;Lkd/bos/olapServer/replication/MasterLSNContext;Lkd/bos/olapServer/replication/ReplicationContext;Lkd/bos/olapServer/replication/TimeStatQueue;)V", "isRunning", "", "isSwitching", "lastKeepAliveTime", "", "Lkd/bos/olapServer/common/long;", "lastVipTime", "selector", "Ljava/nio/channels/Selector;", "kotlin.jvm.PlatformType", "serverSocket", "Ljava/nio/channels/ServerSocketChannel;", "slaves", "Ljava/util/HashMap;", "Ljava/nio/channels/SocketChannel;", "Lkd/bos/olapServer/replication/SlaveNode;", "Lkotlin/collections/HashMap;", "accept", "", "key", "Ljava/nio/channels/SelectionKey;", "byteToHex", "", "b", "", "checkSwitch", "checkVip", "close", "closeSlave", "slave", "createThreadSwitchToSlave", "dealCmd", "dealControlConnect", "dealDataConnect", "dealEndStream", "dealMasterCloseAck", "dealRedoAck", "dealStartStream", "dealSwitchToMaster", "getReadySlaves", "Ljava/util/ArrayList;", "Lkd/bos/olapServer/common/string;", "Lkotlin/collections/ArrayList;", "isValidServerId", "Lkd/bos/olapServer/common/bool;", "serverId", "Lkd/bos/olapServer/common/byte;", "keepAlive", "printBuffer", "buffer", "Ljava/nio/ByteBuffer;", "read", "run", "sendAgree", "reqCmdType", "Lkd/bos/olapServer/replication/SignalType;", "sendDisAgree", "sendKeepAlive", "sendMasterClose", "sendSignal", "start", "startAsyncSlave", "sync", "redo", "Lkd/bos/olapServer/replication/RedoPage;", "tryGetControlSlave", "hasCompleteSignal", "writeBuffer", "Companion", "bos-olap-core"})
public final class RedoSender
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplicationConf conf;
    @NotNull
    private final MasterLSNContext masterLSNContext;
    @NotNull
    private final ReplicationContext context;
    @Nullable
    private final TimeStatQueue AckTimeStat;
    private final Selector selector;
    private final ServerSocketChannel serverSocket;
    private volatile boolean isRunning;
    @NotNull
    private final HashMap<SocketChannel, SlaveNode> slaves;
    private long lastKeepAliveTime;
    private boolean isSwitching;
    private long lastVipTime;
    private static final long selectTimeoutMs = 1000L;
    private static final long keepAliveIntervalNs = 1000000000L;
    private static final long keepAliveTimeoutNs = 5000000000L;
    private static final int maxTimeOutCount = 5;
    private static final long maxVipWaitTime = 10000000000L;

    public RedoSender(@NotNull ReplicationConf conf, @NotNull MasterLSNContext masterLSNContext, @NotNull ReplicationContext context, @Nullable TimeStatQueue AckTimeStat) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)masterLSNContext, (String)"masterLSNContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(RedoSender.class.getName());
        this.conf = conf;
        this.masterLSNContext = masterLSNContext;
        this.context = context;
        this.AckTimeStat = AckTimeStat;
        this.selector = Selector.open();
        this.serverSocket = ServerSocketChannel.open();
        this.slaves = new HashMap();
        this.serverSocket.configureBlocking(false);
    }

    public /* synthetic */ RedoSender(ReplicationConf replicationConf, MasterLSNContext masterLSNContext, ReplicationContext replicationContext, TimeStatQueue timeStatQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeStatQueue = null;
        }
        this(replicationConf, masterLSNContext, replicationContext, timeStatQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            boolean $i$f$error;
            Map map;
            try {
                while (this.isRunning) {
                    this.selector.select(1000L);
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    this.keepAlive();
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey key = (SelectionKey)iterator.next();
                        iterator.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            this.accept(key);
                        }
                        if (!key.isReadable()) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        this.read(key);
                    }
                    this.checkSwitch();
                    this.checkVip();
                }
                map = this.slaves;
                boolean key = false;
            }
            catch (Exception e) {
                OlapLogger olapLogger = ReplicationManager.INSTANCE.getLogger();
                $i$f$error = false;
                if (olapLogger.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "\u53d1\u9001\u7ebf\u7a0b \u5f02\u5e38\u9000\u51fa\u3002";
                    OlapWorkspace olap$iv = olapLogger.getOlapWorkspace();
                    if (olap$iv != null) {
                        String reportId$iv = olapLogger.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv = new HealthReport(reportId$iv, null, olapLogger.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv.getHealthReports().commit(report$iv);
                    }
                    if ((Throwable)e == null) {
                        OlapLogger.access$getLogger$p(olapLogger).error(message$iv);
                    } else {
                        OlapLogger.access$getLogger$p(olapLogger).error(message$iv, (Throwable)e);
                    }
                }
                break block14;
            }
            finally {
                Map map2 = this.slaves;
                $i$f$error = false;
                for (Map.Entry entry : map2.entrySet()) {
                    ((SlaveNode)entry.getValue()).close();
                }
                this.selector.close();
                this.serverSocket.close();
            }
            for (Map.Entry entry : map.entrySet()) {
                ((SlaveNode)entry.getValue()).close();
            }
            this.selector.close();
            this.serverSocket.close();
        }
    }

    public final void accept(@NotNull SelectionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SelectableChannel selectableChannel = key.channel();
        if (selectableChannel == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.channels.ServerSocketChannel");
        }
        ServerSocketChannel ssc = (ServerSocketChannel)selectableChannel;
        SocketChannel clientChannel = ssc.accept();
        Socket socket = clientChannel.socket();
        int port = socket.getPort();
        String ipAddress = socket.getInetAddress().getHostAddress();
        if (!Intrinsics.areEqual((Object)ipAddress, (Object)this.conf.get_slave().getHost())) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                boolean bl = false;
                String string = "\u4e0d\u5408\u6cd5\u7684\u8fde\u63a5\uff0cIP: " + ipAddress + ", Port: " + port + '\u3002';
                logger.info(string);
            }
            return;
        }
        clientChannel.configureBlocking(false);
        Intrinsics.checkNotNullExpressionValue((Object)clientChannel, (String)"clientChannel");
        SlaveNode slave = new SlaveNode(clientChannel);
        slave.setKey(clientChannel.register(this.selector, 1));
        Map map = this.slaves;
        SocketChannel socketChannel = clientChannel;
        boolean bl = false;
        map.put(socketChannel, slave);
    }

    public final void read(@NotNull SelectionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = key.channel();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.channels.SocketChannel");
        }
        SocketChannel sc = (SocketChannel)object;
        if (!this.slaves.containsKey(sc)) {
            object = Res.INSTANCE.getRedoSenderException_2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Res.RedoSenderException_2");
            throw Res.INSTANCE.getRuntimeException((String)object, new Object[0]);
        }
        SlaveNode slaveNode = this.slaves.get(sc);
        if (slaveNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type kd.bos.olapServer.replication.SlaveNode");
        }
        SlaveNode slave = slaveNode;
        try {
            int readByte = sc.read(slave.getReadBuffer());
            if (readByte == -1) {
                SlaveNode slaveNode2 = this.slaves.get(sc);
                if (slaveNode2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kd.bos.olapServer.replication.SlaveNode");
                }
                this.closeSlave(slaveNode2);
                return;
            }
            slave.getReadBuffer().flip();
            while (true) {
                ByteBuffer byteBuffer = slave.getReadBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slave.readBuffer");
                if (!this.hasCompleteSignal(byteBuffer)) break;
                this.dealCmd(slave);
            }
            slave.getReadBuffer().compact();
        }
        catch (Exception e) {
            SlaveNode slaveNode3 = this.slaves.get(sc);
            if (slaveNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kd.bos.olapServer.replication.SlaveNode");
            }
            this.closeSlave(slaveNode3);
            return;
        }
    }

    private final void checkVip() {
        String string;
        Logger logger;
        HealthReport report$iv;
        String reportId$iv;
        OlapWorkspace olap$iv;
        boolean $i$f$warn;
        OlapLogger this_$iv;
        if (ReplicationManager.INSTANCE.getStatus() != ReplicationStatus.Master) {
            return;
        }
        long now = System.nanoTime();
        if (now - this.lastVipTime > 10000000000L) {
            this_$iv = ReplicationManager.INSTANCE.getLogger();
            $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                boolean bl = false;
                String message$iv = "vip \u68c0\u6d4b\u95f4\u9694\u8d85\u8fc710s";
                olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                    report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                logger = OlapLogger.access$getLogger$p(this_$iv);
                $i$a$-warn-RedoSender$checkVip$1 = false;
                string = "vip \u68c0\u6d4b\u95f4\u9694\u8d85\u8fc710s";
                logger.warn(string);
            }
            if (!ReplicationManager.INSTANCE.isVipHost()) {
                this_$iv = ReplicationManager.INSTANCE.getLogger();
                Object t$iv = null;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    boolean bl = false;
                    String message$iv = "vip \u4e0d\u5728\u672c\u673a,\u4e0d\u80fd\u4f5c\u4e3aMaster";
                    OlapWorkspace olap$iv2 = this_$iv.getOlapWorkspace();
                    if (olap$iv2 != null) {
                        String reportId$iv2 = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                        HealthReport report$iv2 = new HealthReport(reportId$iv2, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                        olap$iv2.getHealthReports().commit(report$iv2);
                    }
                    OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                }
                ReplicationManager.INSTANCE.setStatus(ReplicationStatus.Unavailable);
                return;
            }
        }
        if (ReplicationManager.INSTANCE.isVipHost()) {
            this.lastVipTime = now;
        } else {
            this_$iv = ReplicationManager.INSTANCE.getLogger();
            $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                boolean bl = false;
                String message$iv = "\u68c0\u6d4bvip \u4e0d\u5728\u672c\u673a";
                olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                    report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                logger = OlapLogger.access$getLogger$p(this_$iv);
                $i$a$-warn-RedoSender$checkVip$3 = false;
                string = "\u68c0\u6d4bvip \u4e0d\u5728\u672c\u673a";
                logger.warn(string);
            }
        }
    }

    @Nullable
    public final String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = Intrinsics.stringPlus((String)"0", (Object)hex);
        }
        return hex;
    }

    private final void printBuffer(ByteBuffer buffer) {
        StringBuilder result = null;
        result = new StringBuilder("");
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        for (byte b : byArray) {
            result.append(Intrinsics.stringPlus((String)this.byteToHex(b), (Object)" "));
        }
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"readbuffer\u5185\u5bb9:", (Object)result);
            logger.info(string);
        }
    }

    private final void dealCmd(SlaveNode slave) {
        byte len = slave.getReadBuffer().get();
        try {
            int $i$f$info;
            Object this_$iv;
            SignalType signal = SignalType.Companion.byteToSignalType(slave.getReadBuffer().get());
            if (signal != SignalType.REDO_ACK) {
                this_$iv = ReplicationManager.INSTANCE.getLogger();
                $i$f$info = 0;
                if (((OlapLogger)this_$iv).isInfoEnabled()) {
                    Logger logger = OlapLogger.access$getLogger$p((OlapLogger)this_$iv);
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)"RedoSender \u63a5\u53d7\u5230\u63a7\u5236\u6307\u4ee4:", (Object)((Object)signal));
                    logger.info(string);
                }
            }
            this_$iv = signal;
            $i$f$info = WhenMappings.$EnumSwitchMapping$0[((Enum)this_$iv).ordinal()];
            switch ($i$f$info) {
                case 1: {
                    this.dealControlConnect(slave);
                    break;
                }
                case 2: {
                    this.dealDataConnect(slave);
                    break;
                }
                case 3: {
                    this.dealStartStream(slave);
                    break;
                }
                case 4: {
                    this.dealEndStream(slave);
                    break;
                }
                case 5: {
                    this.dealRedoAck(slave);
                    break;
                }
                case 6: {
                    this.dealSwitchToMaster(slave);
                    break;
                }
                case 7: {
                    this.dealMasterCloseAck(slave);
                    break;
                }
                default: {
                    String bl = Res.INSTANCE.getRedoReceiverException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"Res.RedoReceiverException_3");
                    throw Res.INSTANCE.getRuntimeException(bl, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = Intrinsics.stringPlus((String)"\u5f02\u5e38\u4fe1\u606f\uff1a", (Object)Arrays.toString(e.getStackTrace()));
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            this_$iv = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                Logger logger = OlapLogger.access$getLogger$p(this_$iv);
                boolean bl = false;
                ByteBuffer byteBuffer = slave.getReadBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slave.readBuffer");
                String string = Intrinsics.stringPlus((String)"buffer\u4fe1\u606f\uff1a", (Object)byteBuffer);
                logger.info(string);
            }
            ByteBuffer byteBuffer = slave.getReadBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slave.readBuffer");
            this.printBuffer(byteBuffer);
        }
    }

    private final void dealControlConnect(SlaveNode slave) {
        byte serverId = slave.getReadBuffer().get();
        if (!this.isValidServerId(serverId)) {
            this.sendDisAgree(slave, SignalType.CONTROL_CONNECT);
            this.closeSlave(slave);
            return;
        }
        slave.setSlaveId(serverId);
        byte[] masterConfigMd5 = this.context.getConfigMd5();
        byte[] slaveConfigMd5 = new byte[16];
        slave.getReadBuffer().get(slaveConfigMd5);
        slave.setWebPort(slave.getReadBuffer().getInt());
        byte[] byArray = masterConfigMd5;
        boolean bl = false;
        if (!Arrays.equals(byArray, slaveConfigMd5)) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl2 = false;
                String string = Res.INSTANCE.getRedoSenderException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RedoSenderException_4");
                String message$iv = string;
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            this.sendDisAgree(slave, SignalType.CONTROL_CONNECT);
            this.closeSlave(slave);
            return;
        }
        this.sendAgree(slave, SignalType.CONTROL_CONNECT);
    }

    private final void dealDataConnect(SlaveNode slave) {
        byte serverId = slave.getReadBuffer().get();
        SelectionKey selectionKey = slave.getKey();
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        this.slaves.remove(slave.getControlChannel());
        SlaveNode slaveNode = this.tryGetControlSlave(serverId);
        if (slaveNode == null) {
            String string = Res.INSTANCE.getRedoSenderException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Res.RedoSenderException_3");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        SlaveNode controlSlave = slaveNode;
        if (this.conf.get_master().getSynSlavesID().contains(serverId)) {
            controlSlave.setAsync(false);
        }
        controlSlave.setDataChannel(slave.getControlChannel());
        this.sendAgree(controlSlave, SignalType.DATA_CONNECT);
    }

    private final boolean isValidServerId(byte serverId) {
        if (serverId == (byte)this.conf.get_node().getServerID()) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                Object[] objectArray = Res.INSTANCE.getRedoSenderException_5();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RedoSenderException_5");
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{serverId};
                String message$iv = Res.INSTANCE.format((String)objectArray2, objectArray);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            return false;
        }
        SlaveNode controlSlave = this.tryGetControlSlave(serverId);
        if (controlSlave != null) {
            OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
            Object t$iv = null;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                Object[] report$iv = Res.INSTANCE.getRedoSenderException_6();
                Intrinsics.checkNotNullExpressionValue((Object)report$iv, (String)"Res.RedoSenderException_6");
                Object[] objectArray = report$iv;
                report$iv = new Object[]{serverId};
                String message$iv = Res.INSTANCE.format((String)objectArray, report$iv);
                OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv2 = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv2);
                }
                OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
            }
            return false;
        }
        return true;
    }

    private final void startAsyncSlave(SlaveNode slave) {
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"\u542f\u52a8\u5f02\u6b65\u590d\u5236\u7ed3\u70b9 slave", (Object)slave.getSlaveId());
            logger.info(string);
        }
        TransferredRedoFile transferFile = null;
        try {
            transferFile = new TransferredRedoFile(slave.getStartLSN(), this.conf.get_node().getRedoPath(), this.masterLSNContext);
        }
        catch (Throwable e) {
            OlapLogger this_$iv2 = ReplicationManager.INSTANCE.getLogger();
            boolean $i$f$error = false;
            if (this_$iv2.isErrorEnabled()) {
                boolean bl = false;
                String message$iv = "\u542f\u52a8\u5f02\u6b65\u590d\u5236\u7ed3\u70b9slave" + slave.getSlaveId() + "\u5931\u8d25\u3002";
                OlapWorkspace olap$iv = this_$iv2.getOlapWorkspace();
                if (olap$iv != null) {
                    String reportId$iv = this_$iv2.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                    HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv2.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                    olap$iv.getHealthReports().commit(report$iv);
                }
                if (e == null) {
                    OlapLogger.access$getLogger$p(this_$iv2).error(message$iv);
                } else {
                    OlapLogger.access$getLogger$p(this_$iv2).error(message$iv, e);
                }
            }
            this.closeSlave(slave);
            return;
        }
        slave.setAsyThread(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)Intrinsics.stringPlus((String)"Async slave ", (Object)slave.getSlaveId()), (int)0, (Function0)((Function0)new Function0<Unit>(slave, transferFile, this){
            final /* synthetic */ SlaveNode $slave;
            final /* synthetic */ TransferredRedoFile $transferFile;
            final /* synthetic */ RedoSender this$0;
            {
                this.$slave = $slave;
                this.$transferFile = $transferFile;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    while (this.$slave.getReady()) {
                        SocketChannel socketChannel = this.$slave.getDataChannel();
                        Intrinsics.checkNotNull((Object)socketChannel);
                        if (this.$transferFile.transferTo$bos_olap_core(socketChannel)) continue;
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable e) {
                    OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                    boolean $i$f$error = false;
                    if (this_$iv.isErrorEnabled()) {
                        boolean bl = false;
                        String message$iv = "\u5f02\u6b65\u53d1\u9001\u51fa\u73b0\u5f02\u5e38\u3002";
                        OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                        if (olap$iv != null) {
                            String reportId$iv = this_$iv.getStatus().name() + "-ReplicationError-" + CubeToolKt.getCurrentTime();
                            HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationError: " + message$iv, HealthReportLevel.Error, PrivilegeType.None.getCode());
                            olap$iv.getHealthReports().commit(report$iv);
                        }
                        if (e == null) {
                            OlapLogger.access$getLogger$p(this_$iv).error(message$iv);
                        } else {
                            OlapLogger.access$getLogger$p(this_$iv).error(message$iv, e);
                        }
                    }
                    this.$slave.setAsyThread(null);
                    RedoSender.access$closeSlave(this.this$0, this.$slave);
                }
                finally {
                    this.$transferFile.close();
                }
            }
        }), (int)23, null));
    }

    private final void dealStartStream(SlaveNode slave) {
        boolean isValidAsync;
        long startLSN = slave.getReadBuffer().getLong();
        boolean isValidSync = !slave.isAsync() && startLSN == this.masterLSNContext.getCurrentPage();
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = "slave.isAsync=" + slave.isAsync() + ",startLSN:" + startLSN + ", master.currentPage:" + this.masterLSNContext.getCurrentPage();
            logger.info(string);
        }
        boolean isRedoExist = this.conf.get_node().getRedoKeepSegments() == 0 || startLSN >= this.masterLSNContext.getCurrentPage() - (long)this.conf.get_node().getRedoKeepSegments() * (long)0x1000000;
        boolean bl = isValidAsync = slave.isAsync() && startLSN <= this.masterLSNContext.getCurrentPage() && isRedoExist;
        if (!isValidSync && !isValidAsync) {
            this.sendDisAgree(slave, SignalType.START_STREAM);
            this.closeSlave(slave);
            return;
        }
        this.sendAgree(slave, SignalType.START_STREAM);
        slave.setStartLSN(startLSN);
        slave.setReady(true);
        slave.setLastAckTime(System.nanoTime());
        if (slave.isAsync()) {
            this.startAsyncSlave(slave);
        }
    }

    private final void dealEndStream(SlaveNode slave) {
        long stopLSN = slave.getReadBuffer().getLong();
        slave.setStopLSN(stopLSN);
        this.sendAgree(slave, SignalType.END_STREAM);
        if (stopLSN == 0L) {
            slave.latch();
            this.closeSlave(slave);
            slave.unlatch();
        }
    }

    private final void dealRedoAck(SlaveNode slave) {
        long lastPageAck = slave.getReadBuffer().getLong();
        slave.setLastAckTime(System.nanoTime());
        slave.setLastAck(lastPageAck);
        slave.setTimeOutCount(0);
        if (lastPageAck > this.masterLSNContext.getLastACKLSN()) {
            this.masterLSNContext.setLastACKLSN(lastPageAck);
            TimeStatQueue timeStatQueue = this.AckTimeStat;
            if (timeStatQueue != null) {
                timeStatQueue.setEnd(lastPageAck);
            }
        }
    }

    private final void dealSwitchToMaster(SlaveNode slave) {
        byte serverId = slave.getReadBuffer().get();
        this.sendAgree(slave, SignalType.SWITCH_TO_MASTER);
        ReplicationManager.INSTANCE.setStatus(ReplicationStatus.Transfering);
    }

    private final void dealMasterCloseAck(SlaveNode slave) {
        long lastPage = slave.getReadBuffer().getLong();
        this.closeSlave(slave);
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"\u63a5\u6536\u5230master close ack,\u6b64\u65f6 slave\u4e2a\u6570", (Object)this.slaves.size());
            logger.info(string);
        }
        if (this.slaves.size() == 0) {
            this.createThreadSwitchToSlave();
        }
    }

    private final void createThreadSwitchToSlave() {
        ReplicationManager.INSTANCE.setSwitchThread(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"MaterToSlaveThread", (int)0, (Function0)createThreadSwitchToSlave.1.INSTANCE, (int)23, null));
    }

    private final void sendAgree(SlaveNode slave, SignalType reqCmdType) {
        slave.getSendBuffer().clear();
        byte len = 3;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.AGREE.getCode();
        slave.getSendBuffer().put(cmdType);
        slave.getSendBuffer().put(reqCmdType.getCode());
        this.sendSignal(slave);
    }

    private final void sendDisAgree(SlaveNode slave, SignalType reqCmdType) {
        slave.getSendBuffer().clear();
        byte len = 3;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.DISAGREE.getCode();
        slave.getSendBuffer().put(cmdType);
        slave.getSendBuffer().put(reqCmdType.getCode());
        this.sendSignal(slave);
    }

    private final void sendKeepAlive(SlaveNode slave) {
        slave.getSendBuffer().clear();
        byte len = 2;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.KEEP_ALIVE.getCode();
        slave.getSendBuffer().put(cmdType);
        this.sendSignal(slave);
    }

    private final void sendMasterClose(SlaveNode slave) {
        slave.getSendBuffer().clear();
        byte len = 10;
        slave.getSendBuffer().put(len);
        byte cmdType = SignalType.MASTER_CLOSE.getCode();
        slave.getSendBuffer().put(cmdType);
        long lastPage = LSNUtil.INSTANCE.prePageLSN(this.masterLSNContext.getCurrentPage());
        slave.getSendBuffer().putLong(lastPage);
        this.sendSignal(slave);
    }

    private final boolean hasCompleteSignal(ByteBuffer $this$hasCompleteSignal) {
        if ($this$hasCompleteSignal.remaining() == 0) {
            return false;
        }
        return $this$hasCompleteSignal.remaining() >= $this$hasCompleteSignal.get($this$hasCompleteSignal.position());
    }

    private final SlaveNode tryGetControlSlave(byte serverId) {
        Map map = this.slaves;
        boolean bl = false;
        for (Map.Entry slave : map.entrySet()) {
            if (((SlaveNode)slave.getValue()).getSlaveId() != serverId) continue;
            return (SlaveNode)slave.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync(@NotNull RedoPage redo) {
        Intrinsics.checkNotNullParameter((Object)redo, (String)"redo");
        if (!this.isRunning) {
            return;
        }
        int writeCount = 0;
        Map map = this.slaves;
        boolean bl = false;
        for (Map.Entry slave : map.entrySet()) {
            if (!((SlaveNode)slave.getValue()).getReady() || ((SlaveNode)slave.getValue()).isAsync()) continue;
            try {
                ((SlaveNode)slave.getValue()).latch();
                SocketChannel socketChannel = ((SlaveNode)slave.getValue()).getDataChannel();
                if (socketChannel != null) {
                    this.writeBuffer(socketChannel, redo.getBuffer());
                }
                int n = writeCount;
                writeCount = n + 1;
            }
            catch (Exception e) {
                this.closeSlave((SlaveNode)slave.getValue());
            }
            finally {
                ((SlaveNode)slave.getValue()).unlatch();
            }
        }
        if (writeCount == 0) {
            this.masterLSNContext.setLastACKLSN(this.masterLSNContext.getCurrentPage());
            return;
        }
        TimeStatQueue timeStatQueue = this.AckTimeStat;
        if (timeStatQueue != null) {
            timeStatQueue.setBegin(this.masterLSNContext.getCurrentPage());
        }
    }

    private final void keepAlive() {
        long now = System.nanoTime();
        if (now - this.lastKeepAliveTime > 1000000000L) {
            boolean bl = false;
            List closeSlavesList = new ArrayList();
            Map map = this.slaves;
            boolean bl2 = false;
            for (Map.Entry slave : map.entrySet()) {
                long interval;
                String string;
                Logger logger;
                if (!((SlaveNode)slave.getValue()).getReady()) continue;
                if (now - ((SlaveNode)slave.getValue()).getLastAckTime() > 5000000000L) {
                    SlaveNode slaveNode = (SlaveNode)slave.getValue();
                    int n = slaveNode.getTimeOutCount();
                    slaveNode.setTimeOutCount(n + 1);
                    OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        logger = OlapLogger.access$getLogger$p(this_$iv);
                        boolean bl3 = false;
                        string = "slave" + ((SlaveNode)slave.getValue()).getSlaveId() + "\u8fde\u63a5\u8d85\u65f6" + ((SlaveNode)slave.getValue()).getTimeOutCount() + '\u6b21';
                        logger.info(string);
                    }
                    if (((SlaveNode)slave.getValue()).getTimeOutCount() > 5) {
                        this_$iv = ReplicationManager.INSTANCE.getLogger();
                        boolean $i$f$warn = false;
                        if (this_$iv.isWarnEnabled()) {
                            boolean bl4 = false;
                            String message$iv = "slave" + ((SlaveNode)slave.getValue()).getSlaveId() + " \u786e\u5b9a\u4e3a\u8d85\u65f6";
                            OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                            if (olap$iv != null) {
                                String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                                HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                                olap$iv.getHealthReports().commit(report$iv);
                            }
                            logger = OlapLogger.access$getLogger$p(this_$iv);
                            $i$a$-warn-RedoSender$keepAlive$2 = false;
                            string = "slave" + ((SlaveNode)slave.getValue()).getSlaveId() + " \u786e\u5b9a\u4e3a\u8d85\u65f6";
                            logger.warn(string);
                        }
                        closeSlavesList.add(slave.getValue());
                        continue;
                    }
                }
                if ((interval = now - this.lastKeepAliveTime) > 2000000000L) {
                    OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
                    boolean $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        boolean bl5 = false;
                        String message$iv = Intrinsics.stringPlus((String)"send alive interval:", (Object)interval);
                        OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
                        if (olap$iv != null) {
                            String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                            HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                            olap$iv.getHealthReports().commit(report$iv);
                        }
                        logger = OlapLogger.access$getLogger$p(this_$iv);
                        $i$a$-warn-RedoSender$keepAlive$3 = false;
                        string = Intrinsics.stringPlus((String)"send alive interval:", (Object)interval);
                        logger.warn(string);
                    }
                }
                this.sendKeepAlive((SlaveNode)slave.getValue());
            }
            for (SlaveNode elem : closeSlavesList) {
                elem.latch();
                this.closeSlave(elem);
                elem.unlatch();
            }
            this.lastKeepAliveTime = now;
        }
    }

    private final void sendSignal(SlaveNode slave) {
        try {
            SocketChannel socketChannel = slave.getControlChannel();
            ByteBuffer byteBuffer = slave.getSendBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slave.sendBuffer");
            this.writeBuffer(socketChannel, byteBuffer);
        }
        catch (Exception e) {
            this.closeSlave(slave);
        }
    }

    private final void checkSwitch() {
        if (ReplicationManager.INSTANCE.getStatus() == ReplicationStatus.Transfering && !this.isSwitching && ReplicationManager.INSTANCE.canSwitch()) {
            this.isSwitching = true;
            Object object = this.slaves;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                SlaveNode slave = (SlaveNode)object2.getValue();
                this.sendMasterClose(slave);
            }
        }
    }

    @NotNull
    public final ArrayList<String> getReadySlaves() {
        ArrayList<String> readySlaves = new ArrayList<String>();
        Map map = this.slaves;
        boolean bl = false;
        for (Map.Entry slave : map.entrySet()) {
            if (!((SlaveNode)slave.getValue()).getReady()) continue;
            readySlaves.add(((SlaveNode)slave.getValue()).toString());
        }
        return readySlaves;
    }

    private final void writeBuffer(SocketChannel $this$writeBuffer, ByteBuffer buffer) {
        buffer.flip();
        while (buffer.hasRemaining()) {
            $this$writeBuffer.write(buffer);
        }
    }

    private final void closeSlave(SlaveNode slave) {
        OlapLogger this_$iv = ReplicationManager.INSTANCE.getLogger();
        boolean $i$f$warn = false;
        if (this_$iv.isWarnEnabled()) {
            boolean bl = false;
            String message$iv = "\u5173\u95ed slave" + slave.getSlaveId() + " \u8fde\u63a5";
            OlapWorkspace olap$iv = this_$iv.getOlapWorkspace();
            if (olap$iv != null) {
                String reportId$iv = this_$iv.getStatus().name() + "-ReplicationWarn-" + CubeToolKt.getCurrentTime();
                HealthReport report$iv = new HealthReport(reportId$iv, null, this_$iv.getStatus().name() + "-ReplicationWarn: " + message$iv, HealthReportLevel.Warning, PrivilegeType.None.getCode());
                olap$iv.getHealthReports().commit(report$iv);
            }
            Logger logger = OlapLogger.access$getLogger$p(this_$iv);
            $i$a$-warn-RedoSender$closeSlave$1 = false;
            String string = "\u5173\u95ed slave" + slave.getSlaveId() + " \u8fde\u63a5";
            logger.warn(string);
        }
        this.slaves.remove(slave.getControlChannel());
        slave.close();
    }

    @Override
    public void start() {
        try {
            this.serverSocket.bind(new InetSocketAddress(this.conf.get_master().getBindPort()));
        }
        catch (Exception ex) {
            Object[] objectArray = Res.INSTANCE.getRedoSenderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Res.RedoSenderException_1");
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{this.conf.get_master().getBindPort()};
            throw Res.INSTANCE.getRuntimeException((String)objectArray2, objectArray);
        }
        this.isRunning = true;
        this.serverSocket.register(this.selector, 16);
        this.lastVipTime = System.nanoTime();
        super.start();
    }

    public final void close() {
        this.isRunning = false;
        this.join();
    }

    public static final /* synthetic */ void access$closeSlave(RedoSender $this, SlaveNode slave) {
        $this.closeSlave(slave);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0004j\u0002`\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkd/bos/olapServer/replication/RedoSender$Companion;", "", "()V", "keepAliveIntervalNs", "", "keepAliveTimeoutNs", "maxTimeOutCount", "", "maxVipWaitTime", "selectTimeoutMs", "Lkd/bos/olapServer/common/long;", "bos-olap-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignalType.values().length];
            nArray[SignalType.CONTROL_CONNECT.ordinal()] = 1;
            nArray[SignalType.DATA_CONNECT.ordinal()] = 2;
            nArray[SignalType.START_STREAM.ordinal()] = 3;
            nArray[SignalType.END_STREAM.ordinal()] = 4;
            nArray[SignalType.REDO_ACK.ordinal()] = 5;
            nArray[SignalType.SWITCH_TO_MASTER.ordinal()] = 6;
            nArray[SignalType.MASTER_CLOSE_ACK.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

